/*
 * Decompiled with CFR 0.152.
 */
package org.jrobin.core.jrrd;

import java.io.IOException;
import org.jrobin.core.jrrd.RRDFile;

public class PDPStatusBlock {
    long offset;
    long size;
    String lastReading;
    int unknownSeconds;
    double value;

    PDPStatusBlock(RRDFile rRDFile) throws IOException {
        this.offset = rRDFile.getFilePointer();
        this.lastReading = rRDFile.readString(30);
        rRDFile.align(4);
        this.unknownSeconds = rRDFile.readInt();
        rRDFile.skipBytes(4);
        this.value = rRDFile.readDouble();
        rRDFile.skipBytes(64);
        this.size = rRDFile.getFilePointer() - this.offset;
    }

    public String getLastReading() {
        return this.lastReading;
    }

    public double getValue() {
        return this.value;
    }

    public int getUnknownSeconds() {
        return this.unknownSeconds;
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer("[PDPStatus: OFFSET=0x");
        stringBuffer.append(Long.toHexString(this.offset));
        stringBuffer.append(", SIZE=0x");
        stringBuffer.append(Long.toHexString(this.size));
        stringBuffer.append(", lastReading=");
        stringBuffer.append(this.lastReading);
        stringBuffer.append(", unknownSeconds=");
        stringBuffer.append(this.unknownSeconds);
        stringBuffer.append(", value=");
        stringBuffer.append(this.value);
        stringBuffer.append("]");
        return stringBuffer.toString();
    }
}

