/*
 * Decompiled with CFR 0.152.
 */
package org.videolan.vlma.daemon;

import java.net.UnknownHostException;
import java.rmi.RemoteException;
import java.util.List;
import java.util.concurrent.atomic.AtomicBoolean;
import org.apache.log4j.Logger;
import org.springframework.remoting.rmi.RmiServiceExporter;
import org.videolan.vlma.IpBank;
import org.videolan.vlma.dao.VLMaDao;
import org.videolan.vlma.monitor.Monitor;
import org.videolan.vlma.notifier.Notifier;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Daemon {
    private static final Logger logger = Logger.getLogger(Daemon.class);
    private IpBank ipBank;
    private List<Monitor> monitors;
    private List<Notifier> notifiers;
    private RmiServiceExporter rmiServiceExporter;
    private VLMaDao vlmaDao;
    private AtomicBoolean running = new AtomicBoolean(true);

    public boolean isRunning() {
        return this.running.get();
    }

    public void setRmiServiceExporter(RmiServiceExporter rmiServiceExporter) {
        this.rmiServiceExporter = rmiServiceExporter;
    }

    public void setIpBank(IpBank ipBank) {
        this.ipBank = ipBank;
    }

    public void setMonitors(List<Monitor> monitors) {
        this.monitors = monitors;
    }

    public void setNotifiers(List<Notifier> notifiers) {
        this.notifiers = notifiers;
    }

    public void setVlmaDao(VLMaDao vlmaDao) {
        this.vlmaDao = vlmaDao;
    }

    public synchronized void start() {
        this.vlmaDao.loadFromDisk();
        try {
            this.ipBank.initIps();
        }
        catch (UnknownHostException e) {
            logger.error((Object)e);
        }
        for (Notifier notifier : this.notifiers) {
            notifier.init();
        }
        for (Monitor monitor : this.monitors) {
            monitor.start();
        }
    }

    public synchronized void reload() {
        this.vlmaDao.loadFromDisk();
    }

    public synchronized void stop() {
        this.running.set(false);
        this.vlmaDao.saveToDisk();
        logger.info((Object)"Stopping monitors...");
        for (Monitor monitor : this.monitors) {
            monitor.stop();
        }
        logger.info((Object)"Stopping notifiers...");
        for (Notifier notifier : this.notifiers) {
            notifier.destroy();
        }
        try {
            this.rmiServiceExporter.destroy();
        }
        catch (RemoteException remoteException) {
            // empty catch block
        }
    }
}

