/*****************************************************************************
 * v4l.cpp : wxWindows plugin for vlc
 *****************************************************************************
 * Copyright (C) 2000-2003 VideoLAN
 * $Id: v4l.cpp,v 1.7 2004/01/25 03:29:02 hartman Exp $
 *
 * Authors: Mohammed Adnne Trojette <adn@via.ecp.fr>
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111, USA.
 *****************************************************************************/

/*****************************************************************************
 * Preamble
 *****************************************************************************/
#include <stdlib.h>                                      /* malloc(), free() */
#include <errno.h>                                                 /* ENOMEM */
#include <string.h>                                            /* strerror() */
#include <stdio.h>

#include <vlc/vlc.h>

#ifdef WIN32                                                 /* mingw32 hack */
#undef Yield
#undef CreateDialog
#endif

#include <wx/combobox.h>
#include <wx/statline.h>

#include <vlc/intf.h>

#include "wxwindows.h"

#ifndef wxRB_SINGLE
#   define wxRB_SINGLE 0
#endif

/*****************************************************************************
 * Event Table.
 *****************************************************************************/

/* IDs for the controls and the menu commands */
enum
{
    MRL_Event,

    Size_Event,
    Norm_Event,
    FrequencyEnable_Event,Frequency_Event,

    AudioDevice_Event, ADevLocation, AudioChannel_Event,

    BitrateEnable_Event, MaxBitrateEnable_Event,
    Bitrate_Event, MaxBitrate_Event
};

BEGIN_EVENT_TABLE(V4LDialog, wxDialog)
    /* Button events */
    EVT_BUTTON(wxID_OK, V4LDialog::OnOk)
    EVT_BUTTON(wxID_CANCEL, V4LDialog::OnCancel)

    /* Events generated by the common panel */
    EVT_CHECKBOX(Size_Event, V4LDialog::OnSizeEnable)
    EVT_COMBOBOX(Size_Event, V4LDialog::OnSize)
    EVT_CHECKBOX(Norm_Event, V4LDialog::OnNormEnable)
    EVT_COMBOBOX(Norm_Event, V4LDialog::OnNorm)
    EVT_CHECKBOX(FrequencyEnable_Event, V4LDialog::OnFrequencyEnable)
    EVT_SPINCTRL(Frequency_Event, V4LDialog::OnFrequency)

   /* Events generated by the audio panel */
    EVT_CHECKBOX(AudioDevice_Event, V4LDialog::OnAudioEnable)
    EVT_TEXT(ADevLocation, V4LDialog::OnAudioChange)
    EVT_SPINCTRL(AudioChannel_Event, V4LDialog::OnAudioChannel)

    /* Events generated by the bitrate panel */
    EVT_CHECKBOX(BitrateEnable_Event, V4LDialog::OnBitrateEnable)
    EVT_SPINCTRL(Bitrate_Event, V4LDialog::OnBitrate)
    EVT_CHECKBOX(MaxBitrateEnable_Event, V4LDialog::OnMaxBitrateEnable)
    EVT_SPINCTRL(MaxBitrate_Event, V4LDialog::OnMaxBitrate)

END_EVENT_TABLE()

/*****************************************************************************
 * Constructor.
 *****************************************************************************/
V4LDialog::V4LDialog( intf_thread_t *_p_intf, wxWindow* _p_parent ):
    wxDialog( _p_parent, -1, wxU(_("Advanced video device options")),
             wxDefaultPosition, wxDefaultSize, wxDEFAULT_FRAME_STYLE )
{
    /* Initializations */
    p_intf = _p_intf;
    p_parent = _p_parent;
    SetIcon( *p_intf->p_sys->p_icon );

    /* Create a panel to put everything in */
    wxPanel *panel = new wxPanel( this, -1 );
    panel->SetAutoLayout( TRUE );

    /* Create MRL combobox */
    wxBoxSizer *mrl_sizer_sizer = new wxBoxSizer( wxHORIZONTAL );
    wxStaticBox *mrl_box = new wxStaticBox( panel, -1,
                               wxU(_("Video device MRL")) );
    wxStaticBoxSizer *mrl_sizer = new wxStaticBoxSizer( mrl_box,
                                                        wxHORIZONTAL );
    wxStaticText *mrl_label = new wxStaticText( panel, -1,
                                                wxU(_("Destination target:")));
    mrl_combo = new wxComboBox( panel, MRL_Event, wxT(""),
                                wxPoint(20,25), wxSize(200, -1), 0, NULL );
    mrl_combo->SetToolTip( wxU(_("You can use this field directly by typing "
        "the full MRL you want to open.\n Alternatively, the field will be "
        "filled automatically when you use the controls below")) );

    mrl_sizer->Add( mrl_label, 0, wxALL | wxALIGN_CENTER, 5 );
    mrl_sizer->Add( mrl_combo, 1, wxALL | wxALIGN_CENTER, 5 );
    mrl_sizer_sizer->Add( mrl_sizer, 1, wxEXPAND | wxALL, 5 );

    /* Create the common panel */
    wxPanel *common_panel = CommonPanel( panel );

    /* Create the audio panel */
    wxPanel *audio_panel = AudioPanel( panel );

    /* Create the bitrate panel */
    wxPanel *bitrate_panel = BitratePanel( panel );

    /* Separation */
    wxStaticLine *static_line = new wxStaticLine( panel, wxID_OK );

    /* Create the buttons */
    wxButton *ok_button = new wxButton( panel, wxID_OK, wxU(_("OK")) );
    ok_button->SetDefault();
    wxButton *cancel_button = new wxButton( panel, wxID_CANCEL,
                                            wxU(_("Cancel")) );

    /* Place everything in sizers */
    wxBoxSizer *button_sizer = new wxBoxSizer( wxHORIZONTAL );
    button_sizer->Add( ok_button, 0, wxALL, 5 );
    button_sizer->Add( cancel_button, 0, wxALL, 5 );
    button_sizer->Layout();
    wxBoxSizer *main_sizer = new wxBoxSizer( wxVERTICAL );
    wxBoxSizer *panel_sizer = new wxBoxSizer( wxVERTICAL );
    panel_sizer->Add( mrl_sizer_sizer, 0, wxEXPAND, 5 );
    panel_sizer->Add( common_panel, 1, wxEXPAND | wxALL, 5 );
    panel_sizer->Add( audio_panel, 1, wxEXPAND | wxALL, 5 );
    panel_sizer->Add( bitrate_panel, 1, wxEXPAND | wxALL, 5 );
    panel_sizer->Add( static_line, 0, wxEXPAND | wxALL, 5 );
    panel_sizer->Add( button_sizer, 0, wxALIGN_LEFT | wxALIGN_BOTTOM |
                      wxALL, 5 );
    panel_sizer->Layout();
    panel->SetSizerAndFit( panel_sizer );
    main_sizer->Add( panel, 1, wxGROW, 0 );
    main_sizer->Layout();
    SetSizerAndFit( main_sizer );
}

V4LDialog::~V4LDialog()
{
}

wxArrayString V4LDialog::GetOptions()
{
   return SeparateEntries( mrl_combo->GetValue() );
}

/*****************************************************************************
 * Private methods.
 *****************************************************************************/
void V4LDialog::UpdateMRL()
{
    wxString audio;
    if( audio_checkbox->IsChecked() )
        {
            audio = wxT(":adev=")
                    + audio_device->GetLineText(0)
                    + wxString::Format( wxT(":audio=%d"),
                        audio_channel->GetValue() );
        }

    wxString common;
    {
        if( size_checkbox->IsChecked() )
        {
            common += wxT(":size=")
                + size_combo->GetValue();
        }

        if( norm_checkbox->IsChecked() )
        {
            common += wxT(":norm=")
                    + norm_combo->GetValue();
        }

        if( frequency_checkbox->IsChecked() )
        {
            common += wxString::Format( wxT(":frequency=%d"),
                                        frequency->GetValue() );
        }

    }

    wxString rate;
    {
        if( bitrate_checkbox->IsChecked() )
        {
            rate += wxString::Format( wxT(":bitrate=%d"),
                                      bitrate->GetValue() );
        }

        if( maxbitrate_checkbox->IsChecked() )
        {
            rate += wxString::Format( wxT(":maxbitrate=%d"),
                                      maxbitrate->GetValue() );
        }
    }

    if( !audio.IsEmpty() || !common.IsEmpty() || !rate.IsEmpty() )
        mrl_combo->SetValue( audio + common + rate);
    else
        mrl_combo->SetValue( wxT("") );
}

wxPanel *V4LDialog::CommonPanel( wxWindow* parent )
{
    wxPanel *panel = new wxPanel( parent, -1, wxDefaultPosition,
                                  wxSize(200, 200) );

    wxStaticBox *panel_box = new wxStaticBox( panel, -1,
                                   wxU(_("Common options")) );
    wxStaticBoxSizer *panel_sizer = new wxStaticBoxSizer( panel_box,
                                                          wxVERTICAL );

    wxFlexGridSizer *subpanel_sizer;

    common_subpanel = new wxPanel( panel, -1 );

    subpanel_sizer = new wxFlexGridSizer( 2, 3, 20 );

    static const wxString size_array[] =
    {
        wxT("subqcif"),
        wxT("qsif"),
        wxT("qcif"),
        wxT("sif"),
        wxT("cif"),
        wxT("vga"),
    };

    size_checkbox = new wxCheckBox( common_subpanel,
                                    Size_Event,
                                    wxU(_("Size")) );
    size_combo = new wxComboBox( common_subpanel, Size_Event, wxT(""),
                                 wxPoint(20,25), wxSize( 120, -1),
                                 WXSIZEOF(size_array), size_array,
                                 wxCB_READONLY );
    size_combo->SetSelection(5);

    subpanel_sizer->Add( size_checkbox, 0, wxALIGN_LEFT |
                         wxALIGN_CENTER_VERTICAL );
    subpanel_sizer->Add( size_combo, 0, wxALIGN_RIGHT |
                         wxALIGN_CENTER_VERTICAL );

    static const wxString norm_array[] =
    {
        wxT("pal"),
        wxT("secam"),
        wxT("ntsc")
    };

    norm_checkbox = new wxCheckBox( common_subpanel,
                                     Norm_Event,
                                     wxU(_("Norm")) );
    norm_combo = new wxComboBox( common_subpanel, Norm_Event, wxT(""),
                                 wxPoint(20,25), wxSize( 120, -1),
                                 WXSIZEOF(norm_array), norm_array,
                                 wxCB_READONLY );
    norm_combo->SetSelection(1);
    norm_combo->SetToolTip( wxU(_( "Standard of the analog signal" )) );
    subpanel_sizer->Add( norm_checkbox, 0, wxALIGN_LEFT |
                         wxALIGN_CENTER_VERTICAL );
    subpanel_sizer->Add( norm_combo, 0, wxALIGN_RIGHT |
                         wxALIGN_CENTER_VERTICAL );

    frequency_checkbox = new wxCheckBox( common_subpanel,
                                         FrequencyEnable_Event,
                                         wxU(_("Frequency (kHz)")) );
    frequency = new wxSpinCtrl( common_subpanel, Frequency_Event,
                                wxT("479250") );
    frequency->SetToolTip( wxU(_("The channel frequency in kHz" )) );

    subpanel_sizer->Add( frequency_checkbox, 0, wxALIGN_LEFT |
                         wxALIGN_CENTER_VERTICAL );
    subpanel_sizer->Add( frequency, 0, wxALIGN_RIGHT |
                         wxALIGN_CENTER_VERTICAL );

    common_subpanel->SetSizerAndFit( subpanel_sizer );

    /* Stuff everything into the main panel */
    panel_sizer->Add( common_subpanel, 1,
                      wxALIGN_LEFT | wxALIGN_CENTER_VERTICAL | wxALL, 5 );

    panel->SetSizerAndFit( panel_sizer );

    /* Update panel */
    size_combo->Disable();
    norm_combo->Disable();
    frequency->Disable();

    return panel;
}

wxPanel *V4LDialog::AudioPanel( wxWindow* parent )
{
    wxPanel *panel = new wxPanel( parent, -1, wxDefaultPosition,
                                  wxSize(200, 200) );

    wxStaticBox *panel_box = new wxStaticBox( panel, -1,
                                   wxU(_("Audio options")) );
    wxStaticBoxSizer *panel_sizer = new wxStaticBoxSizer( panel_box,
                                                          wxVERTICAL );

    wxStaticText *label;
    wxFlexGridSizer *subpanel_sizer;

    audio_subpanel = new wxPanel( panel, -1 );

    subpanel_sizer = new wxFlexGridSizer( 2, 2, 20 );

    audio_checkbox = new wxCheckBox( audio_subpanel,
                                     AudioDevice_Event,
                                     wxU(_("Audio device")) );
    audio_device = new wxTextCtrl( audio_subpanel, ADevLocation,
                                   wxT("/dev/dsp"),
                                   wxDefaultPosition, wxSize( 120, -1 ),
                                   wxTE_PROCESS_ENTER);
    audio_device->SetToolTip( wxU(_("Audio device")) );
    label = new wxStaticText( audio_subpanel, -1, wxU(_("Channel")) );
    audio_channel = new wxSpinCtrl( audio_subpanel, AudioChannel_Event,
                                    wxT("1") );
    audio_channel->SetToolTip( wxU(_("Usually 0 is for mono "
                                     "and 1 for stereo")) );
    subpanel_sizer->Add( audio_checkbox, 0, wxALIGN_RIGHT |
                                            wxALIGN_CENTER_VERTICAL );
    subpanel_sizer->Add( audio_device, 1, wxALIGN_RIGHT );
    subpanel_sizer->Add( label, 0, wxALIGN_LEFT | wxALIGN_CENTER_VERTICAL );
    subpanel_sizer->Add( audio_channel, 0, wxALIGN_RIGHT |
                         wxALIGN_CENTER_VERTICAL );

    audio_subpanel->SetSizerAndFit( subpanel_sizer );

    /* Stuff everything into the main panel */
    panel_sizer->Add( audio_subpanel, 1,
                      wxALIGN_LEFT | wxALIGN_CENTER_VERTICAL | wxALL, 5 );

    panel->SetSizerAndFit( panel_sizer );

    /* Update panel */
    audio_device->Disable();
    audio_channel->Disable();

    return panel;
}

wxPanel *V4LDialog::BitratePanel( wxWindow* parent )
{
    wxPanel *panel = new wxPanel( parent, -1, wxDefaultPosition,
                                  wxSize(200, 200) );

    wxStaticBox *panel_box = new wxStaticBox( panel, -1,
                                   wxU(_("Bitrate options")) );
    wxStaticBoxSizer *panel_sizer = new wxStaticBoxSizer( panel_box,
                                                          wxVERTICAL );

    wxFlexGridSizer *subpanel_sizer;

    bitrate_subpanel = new wxPanel( panel, -1 );

    subpanel_sizer = new wxFlexGridSizer( 2, 2, 20 );

    bitrate_checkbox = new wxCheckBox( bitrate_subpanel,
                                       BitrateEnable_Event,
                                       wxU(_("Bitrate")) );
    bitrate = new wxSpinCtrl( bitrate_subpanel, Bitrate_Event, wxT("3000") );
    bitrate->SetToolTip( wxU(_("The average bitrate of the stream")) );
    subpanel_sizer->Add( bitrate_checkbox, 0, wxALIGN_LEFT |
                         wxALIGN_CENTER_VERTICAL );
    subpanel_sizer->Add( bitrate, 0, wxALIGN_RIGHT |
                         wxALIGN_CENTER_VERTICAL );

    maxbitrate_checkbox = new wxCheckBox( bitrate_subpanel,
                                          MaxBitrateEnable_Event,
                                          wxU(_("Maximum bitrate")) );
    maxbitrate = new wxSpinCtrl( bitrate_subpanel, MaxBitrate_Event, wxT("3000") );
    maxbitrate->SetToolTip( wxU(_("The maximum bitrate of the stream")) );

    subpanel_sizer->Add( maxbitrate_checkbox, 0, wxALIGN_LEFT |
                         wxALIGN_CENTER_VERTICAL );
    subpanel_sizer->Add( maxbitrate, 0, wxALIGN_RIGHT |
                         wxALIGN_CENTER_VERTICAL );

    bitrate_subpanel->SetSizerAndFit( subpanel_sizer );

    /* Stuff everything into the main panel */
    panel_sizer->Add( bitrate_subpanel, 1,
                      wxALIGN_LEFT | wxALIGN_CENTER_VERTICAL | wxALL, 5 );

    panel->SetSizerAndFit( panel_sizer );

    /* Update panel */
    bitrate->Disable();
    maxbitrate->Disable();

    return panel;
}


/*****************************************************************************
 * Events methods.
 *****************************************************************************/
void V4LDialog::OnOk( wxCommandEvent& WXUNUSED(event) )
{
    mrl_combo->Append( mrl_combo->GetValue() );
    EndModal( wxID_OK );
}

void V4LDialog::OnCancel( wxCommandEvent& WXUNUSED(event) )
{
    EndModal( wxID_CANCEL );
}

void V4LDialog::OnMRLChange( wxCommandEvent& event )
{
    //mrl = event.GetString();
}

/******************************************************************************
 * Common panel event methods.
 ******************************************************************************/
void V4LDialog::OnSizeEnable( wxCommandEvent& event )
{
    UpdateMRL();
    size_combo->Enable( event.GetInt() );
}

void V4LDialog::OnSize( wxCommandEvent& event )
{
    UpdateMRL();
}

void V4LDialog::OnNormEnable( wxCommandEvent& event )
{
    norm_combo->Enable( event.GetInt() );
    UpdateMRL();
}

void V4LDialog::OnNorm( wxCommandEvent& event )
{
    UpdateMRL();
}

void V4LDialog::OnFrequencyEnable( wxCommandEvent& event )
{
    frequency->SetRange( 0, 1200000 );
    frequency->Enable( event.GetInt() );
    UpdateMRL();
}

void V4LDialog::OnFrequency( wxCommandEvent& event )
{
    UpdateMRL();
}

/*****************************************************************************
 * Audio panel event methods.
 *****************************************************************************/
void V4LDialog::OnAudioEnable( wxCommandEvent& event )
{
    audio_channel->SetRange( 0, 255 );

    audio_device->Enable( event.GetInt() );
    audio_channel->Enable( event.GetInt() );
    UpdateMRL();
}

void V4LDialog::OnAudioChange( wxCommandEvent& event )
{
    UpdateMRL();
}

void V4LDialog::OnAudioChannel( wxCommandEvent& event )
{
    UpdateMRL();
}

/******************************************************************************
 * Bitrate panel event methods.
 ******************************************************************************/
void V4LDialog::OnBitrateEnable( wxCommandEvent& event )
{
    bitrate->SetRange( 0, 10000 );
    bitrate->Enable( event.GetInt() );
    UpdateMRL();
}

void V4LDialog::OnBitrate( wxCommandEvent& event )
{
    UpdateMRL();
}

void V4LDialog::OnMaxBitrateEnable( wxCommandEvent& event )
{
    maxbitrate->SetRange( 0, 10000 );
    maxbitrate->Enable( event.GetInt() );
    UpdateMRL();
}

void V4LDialog::OnMaxBitrate( wxCommandEvent& event )
{
    UpdateMRL();
}
