Name:           libcdio
Summary:        CD-ROM access library
Summary(de):    CD-ROM Zugriffsbibliothek
Version:        0.67
Release:        1
Copyright:      GPL
Group:          Development/Libraries
URL:            http://savannah.nongnu.org/projects/libcdio/

Source0:        %{name}-%{version}.tar.gz

Buildroot:      %{_tmppath}/%{name}-%{version}-%{release}-root

%description
This library is to encapsulate CD-ROM reading and
control. Applications wishing to be oblivious of the OS- and
device-dependant properties of a CD-ROM can use this library.

%package devel
Summary:        libcdio development package
Summary(de):    libcdio Entwicklerpaket
Group:          Development/Libraries
Requires:       %{name} = %{version}-%{release}
# Packmandepends: libcdio

%description devel
libcdio development package

%description devel -l de
libcdio Entwicklerpaket

%package -n cdinfo
Summary:        cd-info
Summary(de):    cd-info
Group:          Applications/Multimedia
Requires:       %{name} = %{version}-%{release}
Requires:       libvcd >= 0.7.19
Requires:       libcddb
BuildRequires:  libcddb-devel
BuildRequires:  libvcd-devel >= 0.7.19

%description -n cdinfo

cd-info prints various information about a CD or CD image, analyzes
and gives information about each of the tracks, and tries to detect
the type of CD (e.g. VCD, Audio CD, PhotoCD, a bootable CD, etc.). For
audio CD's more information is given if libcddb is installed. For
Video CD's more information is given if the libvcdinfo library is
installed.

%prep
%setup -q

%build
%configure
%__make

%install
rm -rf $RPM_BUILD_ROOT
%makeinstall

%clean
rm -r $RPM_BUILD_ROOT

%post
/sbin/ldconfig

%postun
/sbin/ldconfig

%files
%defattr(-,root,root)
%doc AUTHORS INSTALL NEWS THANKS TODO
%{_libdir}/lib*.so.*

%files devel
%defattr(-, root, root)
%doc ChangeLog COPYING README
%{_libdir}/lib*.so
%{_libdir}/*.a
%{_libdir}/*.la
%{_includedir}/cdio/*
%{_infodir}/libcdio.info*
%{_libdir}/pkgconfig/libcdio.pc
%{_libdir}/pkgconfig/libiso9660.pc

%files -n cdinfo
%{_bindir}/*

%changelog
* Fri Nov 28 2003 Jason Luka <jason@geshp.com>
- Update for Fedora Core 

* Tue Sep 9 2003 Rocky Bernstein <valtri@atlas.cz>
- small fixes really from Frantisek Dvorak <valtri@atlas.cz>

* Sun Aug 30 2003 Frantisek Dvorak <valtri@atlas.cz>
- two files added

* Wed Aug 06 2003 Rocky Bernstein <rocky@panix.com>
- fixes really Manfred Tremmel <Manfred.Tremmel@iiv.de>
  at http://www.iiv.de/schwinde/buerger/tremmel/

* Fri Apr 25 2003 Manfred Tremmel <Manfred.Tremmel@iiv.de>
- first spec file
