/////////////////////////////////////////////////////////////////////////////
// Name:        _scrolbar.i
// Purpose:     SWIG interface defs for wxScrollBar
//
// Author:      Robin Dunn
//
// Created:     10-June-1998
// RCS-ID:      $Id: _scrolbar.i,v 1.4 2003/12/20 01:01:36 RD Exp $
// Copyright:   (c) 2003 by Total Control Software
// Licence:     wxWindows license
/////////////////////////////////////////////////////////////////////////////

// Not a %module


//---------------------------------------------------------------------------

MAKE_CONST_WXSTRING(ScrollBarNameStr);

//---------------------------------------------------------------------------
%newgroup

class wxScrollBar : public wxControl {
public:
    %addtofunc wxScrollBar         "self._setOORInfo(self)"
    %addtofunc wxScrollBar()       ""

    wxScrollBar(wxWindow* parent, wxWindowID id = -1,
                const wxPoint& pos = wxDefaultPosition,
                const wxSize& size = wxDefaultSize,
                long style = wxSB_HORIZONTAL,
                const wxValidator& validator = wxDefaultValidator,
                const wxString& name = wxPyScrollBarNameStr);
    %name(PreScrollBar)wxScrollBar();

    bool Create(wxWindow* parent, wxWindowID id = -1,
                const wxPoint& pos = wxDefaultPosition,
                const wxSize& size = wxDefaultSize,
                long style = wxSB_HORIZONTAL,
                const wxValidator& validator = wxDefaultValidator,
                const wxString& name = wxPyScrollBarNameStr);

    virtual int GetThumbPosition() const;
    virtual int GetThumbSize() const;
    %pythoncode { GetThumbLength = GetThumbSize };
    virtual int GetPageSize() const;
    virtual int GetRange() const;

    bool IsVertical() const { return (m_windowStyle & wxVERTICAL) != 0; }

    virtual void SetThumbPosition(int viewStart);
    virtual void SetScrollbar(int position, int thumbSize,
                              int range, int pageSize,
                              bool refresh = True);
};

//---------------------------------------------------------------------------
