/****************************************************************************
** libmatroska : parse Matroska files, see http://www.matroska.org/
**
** <file/class description>
**
** Copyright (C) 2002-2003 Steve Lhomme.  All rights reserved.
**
** This file may be distributed under the terms of the Q Public License
** as defined by Trolltech AS of Norway and appearing in the file
** LICENSE.QPL included in the packaging of this file.
**
** This file may be distributed and/or modified under the terms of the
** GNU General Public License version 2 as published by the Free Software
** Foundation and appearing in the file LICENSE.GPL included in the
** packaging of this file.
**
** Licensees holding an other license may use this file in accordance with 
** the Agreement provided with the Software.
**
** This file is provided AS IS with NO WARRANTY OF ANY KIND, INCLUDING THE
** WARRANTY OF DESIGN, MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE.
**
** See http://www.matroska.org/license/qpl/ for QPL licensing information.
** See http://www.matroska.org/license/gpl/ for GPL licensing information.
**
** Contact license@matroska.org if any conditions of this licensing are
** not clear to you.
**
**********************************************************************/
/*!
	\file
	\version \$Id: mkxPrioFrame.cpp,v 1.2 2003/06/21 08:32:27 robux4 Exp $
	\author Steve Lhomme     <robux4 @ users.sf.net>
*/

/*=====================================================================

  If we have in input the data in coding order from matroska, we need
  to be able to tell which frame is next in the stream.

  In input we may have IBP frames in that order :
  I1 P2 P5 B3 B4 P6 I7

  In output we need to be able to give the frames in this order :
  I1 P2 B3 B4 P5 P6 I7


  File -+->   MkxQueue   --> (coding order)  ==   data   ==>
        |                                                    MkxOutPin --> Codec
        +-> MkxPrioCache --> (display order) == duration ==>

======================================================================*/

#include <streams.h>

#include "mkxPrioFrame.h"

MkxPrioCache::MkxPrioCache(unsigned int aMinCache)
 :MinCache(aMinCache)
{
	PopEnabled = CreateEvent(NULL, // security
		TRUE, // manual-reset
		FALSE, // set on init
		NULL);
}

MkxPrioCache::~MkxPrioCache()
{
	SetEvent(PopEnabled);
	CloseHandle(PopEnabled);
}

void MkxPrioCache::PushBlock(KaxBlockGroup & aBlock)
{
	///< \todo delete an element that has been "displayed"
	MkxPrioBuffer & EltToAdd = *(new MkxPrioBuffer(aBlock));
	MkxPrioKey    & EltKey   = *(new MkxPrioKey(EltToAdd));
	Lock();
	BufferList.insert( std::make_pair(EltKey, EltToAdd) );
	Unlock();
}

KaxBlockGroup * MkxPrioCache::GetElementInTimeOrder()
{
	KaxBlockGroup * result = NULL;
	Lock();
	// only get a buffer that has not been marked
	// mark the buffer given
	Unlock();
	return result;
}

KaxBlockGroup * MkxPrioCache::GetNextInTimeOrder(KaxBlockGroup & aBlock)
{
	KaxBlockGroup * result = NULL;
	// find the right buffer to output
	MkxPrioBuffer TmpBuf(aBlock);
	MkxPrioKey    TmpKey(TmpBuf);
	Lock();
	std::map<MkxPrioKey, MkxPrioBuffer>::iterator & TheElt = BufferList.find( TmpKey );
	if (TheElt != BufferList.end()) {
		TheElt++;
		if (TheElt != BufferList.end()) {
			result = (*TheElt).second.Block;
		}
	}
	Unlock();
	return result;
}

void MkxPrioCache::UsedBlock(KaxBlockGroup & aBlock)
{
	MkxPrioBuffer TmpBuf(aBlock);
	MkxPrioKey    TmpKey(TmpBuf);
	std::map<MkxPrioKey, MkxPrioBuffer>::iterator & TheElt = BufferList.find( TmpKey );
	if (TheElt != BufferList.end()) {
		(*TheElt).second.Displayed = true;
	}
}

