/*****************************************************************************
 * input_dvd.h: thread structure of the DVD plugin
 *****************************************************************************
 * Copyright (C) 1999-2001 VideoLAN
 *
 * Author: Stphane Borel <stef@via.ecp.fr>
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111, USA.
 *****************************************************************************/

/*****************************************************************************
 * thread_dvd_data_t: extension of input_thread_t for DVD specificity
 *****************************************************************************/
typedef struct thread_dvd_data_s
{
    int                     i_fd;
    boolean_t               b_encrypted;
#if defined( HAVE_SYS_DVDIO_H ) || defined( LINUX_DVD )
    /* Scrambling Information */
    struct css_s            css;
#endif
    /* Structure that contains all information of the DVD */
    struct ifo_s            ifo;
} thread_dvd_data_t;


