/*
 * Decompiled with CFR 0.152.
 */
package org.havi.ui;

import java.awt.Dimension;
import java.awt.Point;
import org.havi.ui.HScreenConfigTemplate;
import org.havi.ui.HScreenRectangle;

public abstract class HScreenConfiguration {
    private boolean FlickerFilter;
    private boolean Interlaced;
    private Dimension AspectRatio;
    private Dimension Resolution;
    private HScreenRectangle ScreenArea;

    HScreenConfiguration() {
    }

    HScreenConfiguration(HScreenConfigTemplate hsct) {
        this.FlickerFilter = hsct.getPreferencePriority(4) == 1;
        this.Interlaced = hsct.getPreferencePriority(5) == 1;
        this.AspectRatio = (Dimension)hsct.getPreferenceObject(7);
        this.Resolution = (Dimension)hsct.getPreferenceObject(8);
        this.ScreenArea = (HScreenRectangle)hsct.getPreferenceObject(9);
    }

    public Point convertTo(HScreenConfiguration destination, Point source) {
        try {
            Dimension dstResolution = destination.getPixelResolution();
            HScreenRectangle dstScreenArea = destination.getScreenArea();
            return new Point(Math.round((float)source.x + this.ScreenArea.x * (float)this.Resolution.width - dstScreenArea.x * (float)dstResolution.width), Math.round((float)source.y + this.ScreenArea.y * (float)this.Resolution.height - dstScreenArea.y * (float)dstResolution.height));
        }
        catch (Exception e) {
            return null;
        }
    }

    public boolean getFlickerFilter() {
        return this.FlickerFilter;
    }

    public boolean getInterlaced() {
        return this.Interlaced;
    }

    public Dimension getPixelAspectRatio() {
        return this.AspectRatio;
    }

    public Dimension getPixelResolution() {
        return this.Resolution;
    }

    public HScreenRectangle getScreenArea() {
        return this.ScreenArea;
    }

    public Dimension getOffset(HScreenConfiguration hsc) {
        Point origin = hsc.convertTo(this, new Point(0, 0));
        return origin == null ? null : new Dimension(origin.x, origin.y);
    }
}

