/*
 * Decompiled with CFR 0.152.
 */
package vlcskineditor;

import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.File;
import javax.imageio.ImageIO;
import javax.swing.JFrame;
import javax.swing.JOptionPane;
import vlcskineditor.Language;
import vlcskineditor.ProgressWindow;
import vlcskineditor.SliderBGGen;

public class SliderBGBuilder {
    SliderBGGen sbgg;
    BufferedImage bg;
    BufferedImage e1;
    BufferedImage middle;
    BufferedImage e2;
    BufferedImage overlay;
    int width;
    int height;
    int margin_top;
    int margin_bottom;
    int margin_left;
    int margin_right;
    int overlay_x;
    int overlay_y;
    public int nbframes;
    boolean usebg;
    boolean usee1;
    boolean usee2;
    boolean useoverlay;
    boolean tile_bg;
    boolean tile_middle;
    boolean horizontal;
    int bg_width = 0;
    int e1_width = 0;
    int middle_width = 0;
    int e2_width = 0;
    int e1_height = 0;
    int e2_height = 0;
    int middle_height = 0;
    int bg_height = 0;
    BufferedImage output;
    JFrame frame;
    ProgressWindow pg_win;
    public boolean cancontinue = true;

    public SliderBGBuilder(SliderBGGen sliderBGGen) {
        this.sbgg = sliderBGGen;
        this.usebg = true;
        try {
            this.bg = ImageIO.read(new File(this.sbgg.bg_tf.getText()));
            this.bg_width = this.bg.getWidth(null);
            this.bg_height = this.bg.getHeight(null);
        }
        catch (Exception exception) {
            this.usebg = false;
        }
        this.usee1 = true;
        try {
            this.e1 = ImageIO.read(new File(this.sbgg.e1_tf.getText()));
            this.e1_width = this.e1.getWidth(null);
            this.e1_height = this.e1.getHeight(null);
        }
        catch (Exception exception) {
            this.usee1 = false;
        }
        try {
            this.middle = ImageIO.read(new File(this.sbgg.md_tf.getText()));
            this.middle_width = this.middle.getWidth(null);
            this.middle_height = this.middle.getHeight(null);
        }
        catch (Exception exception) {
            JOptionPane.showMessageDialog(this.sbgg, Language.get("ERROR_SBGGEN_MIDDLE_MSG"), exception.getLocalizedMessage(), 0);
            this.cancontinue = false;
        }
        this.usee2 = true;
        try {
            this.e2 = ImageIO.read(new File(this.sbgg.e2_tf.getText()));
            this.e2_width = this.e2.getWidth(null);
            this.e2_height = this.e2.getHeight(null);
        }
        catch (Exception exception) {
            this.usee2 = false;
        }
        this.useoverlay = true;
        try {
            this.overlay = ImageIO.read(new File(this.sbgg.ol_tf.getText()));
        }
        catch (Exception exception) {
            this.useoverlay = false;
        }
        this.usee1 = false;
        if (false) {
            this.e1 = this.middle;
        }
        this.usee2 = false;
        if (false) {
            this.e2 = this.middle;
        }
        this.width = Integer.parseInt(this.sbgg.width_tf.getText());
        this.height = Integer.parseInt(this.sbgg.height_tf.getText());
        this.margin_top = Integer.parseInt(this.sbgg.margin_t_tf.getText());
        this.margin_bottom = Integer.parseInt(this.sbgg.margin_b_tf.getText());
        this.margin_left = Integer.parseInt(this.sbgg.margin_l_tf.getText());
        this.margin_right = Integer.parseInt(this.sbgg.margin_r_tf.getText());
        this.tile_bg = this.sbgg.bgt_rb.isSelected();
        this.tile_middle = this.sbgg.mdt_rb.isSelected();
        this.horizontal = this.sbgg.ltr_rb.isSelected();
        System.out.println("tile_bg: " + this.tile_bg);
        System.out.println("tile_middle: " + this.tile_middle);
    }

    public void build() {
        block40: {
            block39: {
                if (!this.horizontal || !this.cancontinue) break block39;
                this.nbframes = this.width - this.margin_left - this.margin_right + 1;
                int n = this.nbframes * this.height;
                this.output = new BufferedImage(this.width, n, 2);
                Graphics2D graphics2D = this.output.createGraphics();
                this.pg_win = new ProgressWindow(this.sbgg, Language.get("SBGGEN_PROGRESS"));
                for (int i = 0; i <= this.nbframes; ++i) {
                    int n2;
                    int n3;
                    int n4;
                    System.out.println("Processing frame " + i + " of " + this.nbframes + "...");
                    this.pg_win.setProgress(this.nbframes / 100 * i);
                    if (this.usebg) {
                        if (this.tile_bg) {
                            n4 = this.width / this.bg_width;
                            n3 = this.width % this.bg_width;
                            for (n2 = 0; n2 < n4; ++n2) {
                                graphics2D.drawImage((Image)this.bg, n2 * this.bg_width, this.height * i, this.sbgg);
                            }
                            graphics2D.drawImage((Image)this.bg.getSubimage(0, 0, n3, this.height), n4 * this.bg_width, this.height * i, this.sbgg);
                        } else {
                            graphics2D.drawImage(this.bg, 0, this.height * i, this.width, this.height, this.sbgg);
                        }
                    }
                    if (i > 0) {
                        if (i <= this.e1_width) {
                            graphics2D.drawImage((Image)this.e1.getSubimage(0, 0, i, this.e1_height), this.margin_left, this.height * i + this.margin_top, this.sbgg);
                        } else if (i <= this.e1_width + this.middle_width) {
                            if (this.e1 != null) {
                                graphics2D.drawImage((Image)this.e1, this.margin_left, this.height * i + this.margin_top, this.sbgg);
                            }
                            if (!this.tile_middle) {
                                graphics2D.drawImage(this.middle, this.margin_left + this.e1_width, this.height * i + this.margin_top, i - this.e1_width, this.height - this.margin_top - this.margin_bottom, this.sbgg);
                            } else {
                                graphics2D.drawImage((Image)this.middle.getSubimage(0, 0, i - this.e1_width, this.height - this.margin_top - this.margin_bottom), this.margin_left + this.e1_width, this.height * i + this.margin_top, this.sbgg);
                            }
                        } else if (i <= this.e1_width + this.middle_width + this.e2_width) {
                            graphics2D.drawImage((Image)this.e1, this.margin_left, this.height * i + this.margin_top, this.sbgg);
                            graphics2D.drawImage((Image)this.middle, this.margin_left + this.e1_width, this.height * i + this.margin_top, this.sbgg);
                            graphics2D.drawImage((Image)this.e2.getSubimage(0, 0, i - this.e1_width - this.middle_width, this.height - this.margin_top - this.margin_bottom), this.margin_left + this.e1_width + this.middle_width, this.height * i + this.margin_top, this.sbgg);
                        } else {
                            graphics2D.drawImage((Image)this.e1, this.margin_left, this.height * i + this.margin_top, this.sbgg);
                            if (this.tile_middle) {
                                n4 = i - this.e1_width - this.e2_width;
                                n3 = n4 / this.middle_width;
                                n2 = n4 % this.middle_width;
                                for (int j = 0; j < n3; ++j) {
                                    graphics2D.drawImage((Image)this.middle, this.margin_left + this.e1_width + j * this.middle_width, this.height * i + this.margin_top, this.sbgg);
                                }
                                graphics2D.drawImage((Image)this.middle.getSubimage(0, 0, n2, this.height - this.margin_top - this.margin_bottom), this.margin_left + this.e1_width + n3 * this.middle_width, this.height * i + this.margin_top, this.sbgg);
                            } else {
                                n4 = i - this.e1_width - this.e2_width;
                                graphics2D.drawImage(this.middle, this.margin_left + this.e1_width, this.height * i + this.margin_top, n4, this.height - this.margin_top - this.margin_bottom, this.sbgg);
                            }
                            graphics2D.drawImage((Image)this.e2, this.margin_left + i - this.e2_width, this.height * i + this.margin_top, this.sbgg);
                        }
                    }
                    if (!this.useoverlay) continue;
                    graphics2D.drawImage((Image)this.overlay, this.overlay_x, this.overlay_y + this.height * i, this.sbgg);
                }
                break block40;
            }
            if (this.horizontal || !this.cancontinue) break block40;
            this.nbframes = this.height - this.margin_top - this.margin_bottom + 1;
            int n = this.nbframes * this.width;
            this.output = new BufferedImage(n, this.height, 2);
            Graphics2D graphics2D = this.output.createGraphics();
            this.pg_win = new ProgressWindow(this.sbgg, Language.get("SBGGEN_PROGRESS"));
            for (int i = 0; i <= this.nbframes; ++i) {
                int n5;
                int n6;
                int n7;
                System.out.println("Processing frame " + i + " of " + this.nbframes + "...");
                this.pg_win.setProgress(this.nbframes / 100 * i);
                if (this.usebg) {
                    if (this.tile_bg) {
                        n7 = this.height / this.bg_height;
                        n6 = this.height % this.bg_height;
                        for (n5 = 0; n5 < n7; ++n5) {
                            graphics2D.drawImage((Image)this.bg, this.width * i, this.bg_height * n5, this.sbgg);
                        }
                        graphics2D.drawImage((Image)this.bg.getSubimage(0, this.bg_height - n6, this.bg_width, n6), this.width * i, this.bg_height * n7, this.sbgg);
                    } else {
                        graphics2D.drawImage(this.bg, 0, this.height * i, this.width, this.height, this.sbgg);
                    }
                }
                if (i > 0) {
                    if (i <= this.e2_height) {
                        graphics2D.drawImage((Image)this.e2.getSubimage(0, this.e2_height - i, this.e2_width, i), this.width * i + this.margin_right, this.height - this.margin_bottom - i, this.sbgg);
                    } else if (i <= this.e2_height + this.middle_height) {
                        if (this.e2 != null) {
                            graphics2D.drawImage((Image)this.e2, this.width * i + this.margin_left, this.height - this.margin_bottom - this.e2_height, this.sbgg);
                        }
                        if (!this.tile_middle) {
                            graphics2D.drawImage(this.middle, this.margin_left + this.width * i, this.height - this.margin_bottom - i, this.middle_width, i - this.e1_height, this.sbgg);
                        } else {
                            graphics2D.drawImage((Image)this.middle.getSubimage(0, this.middle_height - (i - this.e1_height), this.middle_width, i - this.e1_height), this.margin_left + this.width * i, this.height - this.margin_bottom - i, this.sbgg);
                        }
                    } else if (i <= this.e2_height + this.middle_height + this.e1_height) {
                        if (this.e2 != null) {
                            graphics2D.drawImage((Image)this.e2, this.width * i + this.margin_left, this.height - this.margin_bottom - this.e2_height, this.sbgg);
                        }
                        graphics2D.drawImage((Image)this.middle, this.width * i + this.margin_left, this.height - this.margin_bottom - this.middle_height - this.e2_height, this.sbgg);
                        graphics2D.drawImage((Image)this.e1.getSubimage(0, this.e1_height - (i - this.e2_height - this.middle_height), this.e1_width, i - this.e2_height - this.middle_height), this.margin_left + this.width * i, this.height - this.margin_bottom - i, this.sbgg);
                    } else {
                        if (this.e2 != null) {
                            graphics2D.drawImage((Image)this.e2, this.width * i + this.margin_left, this.height - this.margin_bottom - this.e2_height, this.sbgg);
                        }
                        if (this.tile_middle) {
                            n7 = i - this.e1_height - this.e2_height;
                            n6 = n7 / this.middle_height;
                            n5 = n7 % this.middle_height;
                            for (int j = 0; j < n6; ++j) {
                                graphics2D.drawImage((Image)this.middle, this.margin_left + this.width * i, this.height - this.margin_bottom - this.e2_height - (j + 1) * this.middle_height, this.sbgg);
                            }
                            if (n5 > 0) {
                                graphics2D.drawImage(this.middle.getSubimage(0, 0, this.middle_width, n5), this.margin_left + this.width * i, this.height - this.margin_bottom - this.e2_height - n6 * this.middle_height - n5, this.middle_width, n5, this.sbgg);
                            }
                        } else {
                            n7 = i - this.e1_height - this.e2_height;
                            graphics2D.drawImage(this.middle, this.margin_left + this.width * i, this.height - i + this.e1_height, this.middle_width, n7, this.sbgg);
                        }
                        graphics2D.drawImage((Image)this.e1, this.width * i + this.margin_left, this.height - (i + 1), this.sbgg);
                    }
                }
                if (!this.useoverlay) continue;
                graphics2D.drawImage((Image)this.overlay, this.overlay_x + this.width * i, this.overlay_y, this.sbgg);
            }
        }
    }

    public void save(File file) {
        try {
            ImageIO.write((RenderedImage)this.output, "png", file);
        }
        catch (Exception exception) {
            JOptionPane.showMessageDialog(this.sbgg, Language.get("ERROR_SAVEPNG_MSG") + "\n" + exception.toString(), Language.get("ERROR_SAVEPNG_TITLE"), 0);
            return;
        }
    }
}

