/*
    This file is part of the WebKit open source project.
    This file has been generated by generate-bindings.pl. DO NOT MODIFY!

    This library is free software; you can redistribute it and/or
    modify it under the terms of the GNU Library General Public
    License as published by the Free Software Foundation; either
    version 2 of the License, or (at your option) any later version.

    This library is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
    Library General Public License for more details.

    You should have received a copy of the GNU Library General Public License
    along with this library; see the file COPYING.LIB.  If not, write to
    the Free Software Foundation, Inc., 51 Franklin Street, Fifth Floor,
    Boston, MA 02110-1301, USA.
*/

#include "config.h"
#include "WebKitDOMHTMLHtmlElement.h"

#include "DOMObjectCache.h"
#include "ExceptionCode.h"
#include "HTMLNames.h"
#include "JSMainThreadExecState.h"
#include "WebKitDOMHTMLHtmlElementPrivate.h"
#include "WebKitDOMNodePrivate.h"
#include "WebKitDOMPrivate.h"
#include "gobject/ConvertToUTF8String.h"
#include <wtf/GetPtr.h>
#include <wtf/RefPtr.h>

namespace WebKit {

WebKitDOMHTMLHtmlElement* kit(WebCore::HTMLHtmlElement* obj)
{
    return WEBKIT_DOM_HTML_HTML_ELEMENT(kit(static_cast<WebCore::Node*>(obj)));
}

WebCore::HTMLHtmlElement* core(WebKitDOMHTMLHtmlElement* request)
{
    return request ? static_cast<WebCore::HTMLHtmlElement*>(WEBKIT_DOM_OBJECT(request)->coreObject) : 0;
}

WebKitDOMHTMLHtmlElement* wrapHTMLHtmlElement(WebCore::HTMLHtmlElement* coreObject)
{
    ASSERT(coreObject);
    return WEBKIT_DOM_HTML_HTML_ELEMENT(g_object_new(WEBKIT_TYPE_DOM_HTML_HTML_ELEMENT, "core-object", coreObject, NULL));
}

} // namespace WebKit

G_DEFINE_TYPE(WebKitDOMHTMLHtmlElement, webkit_dom_html_html_element, WEBKIT_TYPE_DOM_HTML_ELEMENT)

enum {
    PROP_0,
    PROP_VERSION,
    PROP_MANIFEST,
};

static void webkit_dom_html_html_element_set_property(GObject* object, guint propertyId, const GValue* value, GParamSpec* pspec)
{
    WebCore::JSMainThreadNullState state;

    WebKitDOMHTMLHtmlElement* self = WEBKIT_DOM_HTML_HTML_ELEMENT(object);
    WebCore::HTMLHtmlElement* coreSelf = WebKit::core(self);

    switch (propertyId) {
    case PROP_VERSION: {
        coreSelf->setAttribute(WebCore::HTMLNames::versionAttr, WTF::String::fromUTF8(g_value_get_string(value)));
        break;
    }
    case PROP_MANIFEST: {
        coreSelf->setAttribute(WebCore::HTMLNames::manifestAttr, WTF::String::fromUTF8(g_value_get_string(value)));
        break;
    }
    default:
        G_OBJECT_WARN_INVALID_PROPERTY_ID(object, propertyId, pspec);
        break;
    }
}

static void webkit_dom_html_html_element_get_property(GObject* object, guint propertyId, GValue* value, GParamSpec* pspec)
{
    WebCore::JSMainThreadNullState state;

    WebKitDOMHTMLHtmlElement* self = WEBKIT_DOM_HTML_HTML_ELEMENT(object);
    WebCore::HTMLHtmlElement* coreSelf = WebKit::core(self);

    switch (propertyId) {
    case PROP_VERSION: {
        g_value_take_string(value, convertToUTF8String(coreSelf->fastGetAttribute(WebCore::HTMLNames::versionAttr)));
        break;
    }
    case PROP_MANIFEST: {
        g_value_take_string(value, convertToUTF8String(coreSelf->getURLAttribute(WebCore::HTMLNames::manifestAttr)));
        break;
    }
    default:
        G_OBJECT_WARN_INVALID_PROPERTY_ID(object, propertyId, pspec);
        break;
    }
}

static void webkit_dom_html_html_element_class_init(WebKitDOMHTMLHtmlElementClass* requestClass)
{
    GObjectClass* gobjectClass = G_OBJECT_CLASS(requestClass);
    gobjectClass->set_property = webkit_dom_html_html_element_set_property;
    gobjectClass->get_property = webkit_dom_html_html_element_get_property;

    g_object_class_install_property(gobjectClass,
                                    PROP_VERSION,
                                    g_param_spec_string("version", /* name */
                                                           "html_html_element_version", /* short description */
                                                           "read-write  gchar* HTMLHtmlElement.version", /* longer - could do with some extra doc stuff here */
                                                           "", /* default */
                                                           WEBKIT_PARAM_READWRITE));
    g_object_class_install_property(gobjectClass,
                                    PROP_MANIFEST,
                                    g_param_spec_string("manifest", /* name */
                                                           "html_html_element_manifest", /* short description */
                                                           "read-write  gchar* HTMLHtmlElement.manifest", /* longer - could do with some extra doc stuff here */
                                                           "", /* default */
                                                           WEBKIT_PARAM_READWRITE));
}

static void webkit_dom_html_html_element_init(WebKitDOMHTMLHtmlElement* request)
{
}

gchar*
webkit_dom_html_html_element_get_version(WebKitDOMHTMLHtmlElement* self)
{
    WebCore::JSMainThreadNullState state;
    g_return_val_if_fail(WEBKIT_DOM_IS_HTML_HTML_ELEMENT(self), 0);
    WebCore::HTMLHtmlElement* item = WebKit::core(self);
    gchar* result = convertToUTF8String(item->fastGetAttribute(WebCore::HTMLNames::versionAttr));
    return result;
}

void
webkit_dom_html_html_element_set_version(WebKitDOMHTMLHtmlElement* self, const gchar* value)
{
    WebCore::JSMainThreadNullState state;
    g_return_if_fail(WEBKIT_DOM_IS_HTML_HTML_ELEMENT(self));
    g_return_if_fail(value);
    WebCore::HTMLHtmlElement* item = WebKit::core(self);
    WTF::String convertedValue = WTF::String::fromUTF8(value);
    item->setAttribute(WebCore::HTMLNames::versionAttr, convertedValue);
}

gchar*
webkit_dom_html_html_element_get_manifest(WebKitDOMHTMLHtmlElement* self)
{
    WebCore::JSMainThreadNullState state;
    g_return_val_if_fail(WEBKIT_DOM_IS_HTML_HTML_ELEMENT(self), 0);
    WebCore::HTMLHtmlElement* item = WebKit::core(self);
    gchar* result = convertToUTF8String(item->getURLAttribute(WebCore::HTMLNames::manifestAttr));
    return result;
}

void
webkit_dom_html_html_element_set_manifest(WebKitDOMHTMLHtmlElement* self, const gchar* value)
{
    WebCore::JSMainThreadNullState state;
    g_return_if_fail(WEBKIT_DOM_IS_HTML_HTML_ELEMENT(self));
    g_return_if_fail(value);
    WebCore::HTMLHtmlElement* item = WebKit::core(self);
    WTF::String convertedValue = WTF::String::fromUTF8(value);
    item->setAttribute(WebCore::HTMLNames::manifestAttr, convertedValue);
}

