/*
    This file is part of the WebKit open source project.
    This file has been generated by generate-bindings.pl. DO NOT MODIFY!

    This library is free software; you can redistribute it and/or
    modify it under the terms of the GNU Library General Public
    License as published by the Free Software Foundation; either
    version 2 of the License, or (at your option) any later version.

    This library is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
    Library General Public License for more details.

    You should have received a copy of the GNU Library General Public License
    along with this library; see the file COPYING.LIB.  If not, write to
    the Free Software Foundation, Inc., 51 Franklin Street, Fifth Floor,
    Boston, MA 02110-1301, USA.
*/

#include "config.h"
#include "WebKitDOMDOMNamedFlowCollection.h"

#include "DOMObjectCache.h"
#include "ExceptionCode.h"
#include "JSMainThreadExecState.h"
#include "WebKitDOMDOMNamedFlowCollectionPrivate.h"
#include "WebKitDOMPrivate.h"
#include "WebKitDOMWebKitNamedFlowPrivate.h"
#include "gobject/ConvertToUTF8String.h"
#include <wtf/GetPtr.h>
#include <wtf/RefPtr.h>

#define WEBKIT_DOM_DOM_NAMED_FLOW_COLLECTION_GET_PRIVATE(obj) G_TYPE_INSTANCE_GET_PRIVATE(obj, WEBKIT_TYPE_DOM_DOM_NAMED_FLOW_COLLECTION, WebKitDOMDOMNamedFlowCollectionPrivate)

typedef struct _WebKitDOMDOMNamedFlowCollectionPrivate {
#if ENABLE(CSS_REGIONS)
    RefPtr<WebCore::DOMNamedFlowCollection> coreObject;
#endif // ENABLE(CSS_REGIONS)
} WebKitDOMDOMNamedFlowCollectionPrivate;

#if ENABLE(CSS_REGIONS)

namespace WebKit {

WebKitDOMDOMNamedFlowCollection* kit(WebCore::DOMNamedFlowCollection* obj)
{
    if (!obj)
        return 0;

    if (gpointer ret = DOMObjectCache::get(obj))
        return WEBKIT_DOM_DOM_NAMED_FLOW_COLLECTION(ret);

    return wrapDOMNamedFlowCollection(obj);
}

WebCore::DOMNamedFlowCollection* core(WebKitDOMDOMNamedFlowCollection* request)
{
    return request ? static_cast<WebCore::DOMNamedFlowCollection*>(WEBKIT_DOM_OBJECT(request)->coreObject) : 0;
}

WebKitDOMDOMNamedFlowCollection* wrapDOMNamedFlowCollection(WebCore::DOMNamedFlowCollection* coreObject)
{
    ASSERT(coreObject);
    return WEBKIT_DOM_DOM_NAMED_FLOW_COLLECTION(g_object_new(WEBKIT_TYPE_DOM_DOM_NAMED_FLOW_COLLECTION, "core-object", coreObject, NULL));
}

} // namespace WebKit

#endif // ENABLE(CSS_REGIONS)

G_DEFINE_TYPE(WebKitDOMDOMNamedFlowCollection, webkit_dom_dom_named_flow_collection, WEBKIT_TYPE_DOM_OBJECT)

enum {
    PROP_0,
    PROP_LENGTH,
};

static void webkit_dom_dom_named_flow_collection_finalize(GObject* object)
{
    WebKitDOMDOMNamedFlowCollectionPrivate* priv = WEBKIT_DOM_DOM_NAMED_FLOW_COLLECTION_GET_PRIVATE(object);
#if ENABLE(CSS_REGIONS)
    WebKit::DOMObjectCache::forget(priv->coreObject.get());
#endif // ENABLE(CSS_REGIONS)
    priv->~WebKitDOMDOMNamedFlowCollectionPrivate();
    G_OBJECT_CLASS(webkit_dom_dom_named_flow_collection_parent_class)->finalize(object);
}

static void webkit_dom_dom_named_flow_collection_get_property(GObject* object, guint propertyId, GValue* value, GParamSpec* pspec)
{
    WebCore::JSMainThreadNullState state;
#if ENABLE(CSS_REGIONS)
    WebKitDOMDOMNamedFlowCollection* self = WEBKIT_DOM_DOM_NAMED_FLOW_COLLECTION(object);
    WebCore::DOMNamedFlowCollection* coreSelf = WebKit::core(self);
#endif // ENABLE(CSS_REGIONS)
    switch (propertyId) {
    case PROP_LENGTH: {
#if ENABLE(CSS_REGIONS)
        g_value_set_ulong(value, coreSelf->length());
#else
        WEBKIT_WARN_FEATURE_NOT_PRESENT("Css Regions")
#endif /* ENABLE(CSS_REGIONS) */
        break;
    }
    default:
        G_OBJECT_WARN_INVALID_PROPERTY_ID(object, propertyId, pspec);
        break;
    }
}

static GObject* webkit_dom_dom_named_flow_collection_constructor(GType type, guint constructPropertiesCount, GObjectConstructParam* constructProperties)
{
    GObject* object = G_OBJECT_CLASS(webkit_dom_dom_named_flow_collection_parent_class)->constructor(type, constructPropertiesCount, constructProperties);
#if ENABLE(CSS_REGIONS)
    WebKitDOMDOMNamedFlowCollectionPrivate* priv = WEBKIT_DOM_DOM_NAMED_FLOW_COLLECTION_GET_PRIVATE(object);
    priv->coreObject = static_cast<WebCore::DOMNamedFlowCollection*>(WEBKIT_DOM_OBJECT(object)->coreObject);
    WebKit::DOMObjectCache::put(priv->coreObject.get(), object);
#endif // ENABLE(CSS_REGIONS)
    return object;
}

static void webkit_dom_dom_named_flow_collection_class_init(WebKitDOMDOMNamedFlowCollectionClass* requestClass)
{
    GObjectClass* gobjectClass = G_OBJECT_CLASS(requestClass);
    g_type_class_add_private(gobjectClass, sizeof(WebKitDOMDOMNamedFlowCollectionPrivate));
    gobjectClass->constructor = webkit_dom_dom_named_flow_collection_constructor;
    gobjectClass->finalize = webkit_dom_dom_named_flow_collection_finalize;
    gobjectClass->get_property = webkit_dom_dom_named_flow_collection_get_property;

    g_object_class_install_property(gobjectClass,
                                    PROP_LENGTH,
                                    g_param_spec_ulong("length", /* name */
                                                           "dom_named_flow_collection_length", /* short description */
                                                           "read-only  gulong DOMNamedFlowCollection.length", /* longer - could do with some extra doc stuff here */
                                                           0, /* min */
G_MAXULONG, /* max */
0, /* default */
                                                           WEBKIT_PARAM_READABLE));
}

static void webkit_dom_dom_named_flow_collection_init(WebKitDOMDOMNamedFlowCollection* request)
{
    WebKitDOMDOMNamedFlowCollectionPrivate* priv = WEBKIT_DOM_DOM_NAMED_FLOW_COLLECTION_GET_PRIVATE(request);
    new (priv) WebKitDOMDOMNamedFlowCollectionPrivate();
}

WebKitDOMWebKitNamedFlow*
webkit_dom_dom_named_flow_collection_item(WebKitDOMDOMNamedFlowCollection* self, gulong index)
{
#if ENABLE(CSS_REGIONS)
    WebCore::JSMainThreadNullState state;
    g_return_val_if_fail(WEBKIT_DOM_IS_DOM_NAMED_FLOW_COLLECTION(self), 0);
    WebCore::DOMNamedFlowCollection* item = WebKit::core(self);
    RefPtr<WebCore::WebKitNamedFlow> gobjectResult = WTF::getPtr(item->item(index));
    return WebKit::kit(gobjectResult.get());
#else
    WEBKIT_WARN_FEATURE_NOT_PRESENT("Css Regions")
    return 0;
#endif /* ENABLE(CSS_REGIONS) */
}

WebKitDOMWebKitNamedFlow*
webkit_dom_dom_named_flow_collection_named_item(WebKitDOMDOMNamedFlowCollection* self, const gchar* name)
{
#if ENABLE(CSS_REGIONS)
    WebCore::JSMainThreadNullState state;
    g_return_val_if_fail(WEBKIT_DOM_IS_DOM_NAMED_FLOW_COLLECTION(self), 0);
    g_return_val_if_fail(name, 0);
    WebCore::DOMNamedFlowCollection* item = WebKit::core(self);
    WTF::String convertedName = WTF::String::fromUTF8(name);
    RefPtr<WebCore::WebKitNamedFlow> gobjectResult = WTF::getPtr(item->namedItem(convertedName));
    return WebKit::kit(gobjectResult.get());
#else
    WEBKIT_WARN_FEATURE_NOT_PRESENT("Css Regions")
    return 0;
#endif /* ENABLE(CSS_REGIONS) */
}

gulong
webkit_dom_dom_named_flow_collection_get_length(WebKitDOMDOMNamedFlowCollection* self)
{
#if ENABLE(CSS_REGIONS)
    WebCore::JSMainThreadNullState state;
    g_return_val_if_fail(WEBKIT_DOM_IS_DOM_NAMED_FLOW_COLLECTION(self), 0);
    WebCore::DOMNamedFlowCollection* item = WebKit::core(self);
    gulong result = item->length();
    return result;
#else
    WEBKIT_WARN_FEATURE_NOT_PRESENT("Css Regions")
    return static_cast<gulong>(0);
#endif /* ENABLE(CSS_REGIONS) */
}

