/*
    This file is part of the WebKit open source project.
    This file has been generated by generate-bindings.pl. DO NOT MODIFY!

    This library is free software; you can redistribute it and/or
    modify it under the terms of the GNU Library General Public
    License as published by the Free Software Foundation; either
    version 2 of the License, or (at your option) any later version.

    This library is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
    Library General Public License for more details.

    You should have received a copy of the GNU Library General Public License
    along with this library; see the file COPYING.LIB.  If not, write to
    the Free Software Foundation, Inc., 51 Franklin Street, Fifth Floor,
    Boston, MA 02110-1301, USA.
*/

#include "config.h"

#if ENABLE(SVG)

#include "JSSVGMatrix.h"

#include "ExceptionCode.h"
#include "JSDOMBinding.h"
#include "JSSVGMatrix.h"
#include "SVGMatrix.h"
#include <runtime/Error.h>
#include <wtf/GetPtr.h>

using namespace JSC;

namespace WebCore {

/* Hash table */

static const HashTableValue JSSVGMatrixTableValues[] =
{
    { "a", DontDelete, (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsSVGMatrixA), (intptr_t)setJSSVGMatrixA, NoIntrinsic },
    { "b", DontDelete, (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsSVGMatrixB), (intptr_t)setJSSVGMatrixB, NoIntrinsic },
    { "c", DontDelete, (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsSVGMatrixC), (intptr_t)setJSSVGMatrixC, NoIntrinsic },
    { "d", DontDelete, (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsSVGMatrixD), (intptr_t)setJSSVGMatrixD, NoIntrinsic },
    { "e", DontDelete, (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsSVGMatrixE), (intptr_t)setJSSVGMatrixE, NoIntrinsic },
    { "f", DontDelete, (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsSVGMatrixF), (intptr_t)setJSSVGMatrixF, NoIntrinsic },
    { "constructor", DontEnum | ReadOnly, (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsSVGMatrixConstructor), (intptr_t)0, NoIntrinsic },
    { 0, 0, 0, 0, NoIntrinsic }
};

static const HashTable JSSVGMatrixTable = { 17, 15, JSSVGMatrixTableValues, 0 };
/* Hash table for constructor */

static const HashTableValue JSSVGMatrixConstructorTableValues[] =
{
    { 0, 0, 0, 0, NoIntrinsic }
};

static const HashTable JSSVGMatrixConstructorTable = { 1, 0, JSSVGMatrixConstructorTableValues, 0 };
const ClassInfo JSSVGMatrixConstructor::s_info = { "SVGMatrixConstructor", &Base::s_info, &JSSVGMatrixConstructorTable, 0, CREATE_METHOD_TABLE(JSSVGMatrixConstructor) };

JSSVGMatrixConstructor::JSSVGMatrixConstructor(Structure* structure, JSDOMGlobalObject* globalObject)
    : DOMConstructorObject(structure, globalObject)
{
}

void JSSVGMatrixConstructor::finishCreation(ExecState* exec, JSDOMGlobalObject* globalObject)
{
    Base::finishCreation(exec->globalData());
    ASSERT(inherits(&s_info));
    putDirect(exec->globalData(), exec->propertyNames().prototype, JSSVGMatrixPrototype::self(exec, globalObject), DontDelete | ReadOnly);
}

bool JSSVGMatrixConstructor::getOwnPropertySlot(JSCell* cell, ExecState* exec, PropertyName propertyName, PropertySlot& slot)
{
    return getStaticValueSlot<JSSVGMatrixConstructor, JSDOMWrapper>(exec, &JSSVGMatrixConstructorTable, jsCast<JSSVGMatrixConstructor*>(cell), propertyName, slot);
}

bool JSSVGMatrixConstructor::getOwnPropertyDescriptor(JSObject* object, ExecState* exec, PropertyName propertyName, PropertyDescriptor& descriptor)
{
    return getStaticValueDescriptor<JSSVGMatrixConstructor, JSDOMWrapper>(exec, &JSSVGMatrixConstructorTable, jsCast<JSSVGMatrixConstructor*>(object), propertyName, descriptor);
}

/* Hash table for prototype */

static const HashTableValue JSSVGMatrixPrototypeTableValues[] =
{
    { "multiply", DontDelete | JSC::Function, (intptr_t)static_cast<NativeFunction>(jsSVGMatrixPrototypeFunctionMultiply), (intptr_t)1, NoIntrinsic },
    { "inverse", DontDelete | JSC::Function, (intptr_t)static_cast<NativeFunction>(jsSVGMatrixPrototypeFunctionInverse), (intptr_t)0, NoIntrinsic },
    { "translate", DontDelete | JSC::Function, (intptr_t)static_cast<NativeFunction>(jsSVGMatrixPrototypeFunctionTranslate), (intptr_t)2, NoIntrinsic },
    { "scale", DontDelete | JSC::Function, (intptr_t)static_cast<NativeFunction>(jsSVGMatrixPrototypeFunctionScale), (intptr_t)1, NoIntrinsic },
    { "scaleNonUniform", DontDelete | JSC::Function, (intptr_t)static_cast<NativeFunction>(jsSVGMatrixPrototypeFunctionScaleNonUniform), (intptr_t)2, NoIntrinsic },
    { "rotate", DontDelete | JSC::Function, (intptr_t)static_cast<NativeFunction>(jsSVGMatrixPrototypeFunctionRotate), (intptr_t)1, NoIntrinsic },
    { "rotateFromVector", DontDelete | JSC::Function, (intptr_t)static_cast<NativeFunction>(jsSVGMatrixPrototypeFunctionRotateFromVector), (intptr_t)2, NoIntrinsic },
    { "flipX", DontDelete | JSC::Function, (intptr_t)static_cast<NativeFunction>(jsSVGMatrixPrototypeFunctionFlipX), (intptr_t)0, NoIntrinsic },
    { "flipY", DontDelete | JSC::Function, (intptr_t)static_cast<NativeFunction>(jsSVGMatrixPrototypeFunctionFlipY), (intptr_t)0, NoIntrinsic },
    { "skewX", DontDelete | JSC::Function, (intptr_t)static_cast<NativeFunction>(jsSVGMatrixPrototypeFunctionSkewX), (intptr_t)1, NoIntrinsic },
    { "skewY", DontDelete | JSC::Function, (intptr_t)static_cast<NativeFunction>(jsSVGMatrixPrototypeFunctionSkewY), (intptr_t)1, NoIntrinsic },
    { 0, 0, 0, 0, NoIntrinsic }
};

static const HashTable JSSVGMatrixPrototypeTable = { 33, 31, JSSVGMatrixPrototypeTableValues, 0 };
const ClassInfo JSSVGMatrixPrototype::s_info = { "SVGMatrixPrototype", &Base::s_info, &JSSVGMatrixPrototypeTable, 0, CREATE_METHOD_TABLE(JSSVGMatrixPrototype) };

JSObject* JSSVGMatrixPrototype::self(ExecState* exec, JSGlobalObject* globalObject)
{
    return getDOMPrototype<JSSVGMatrix>(exec, globalObject);
}

bool JSSVGMatrixPrototype::getOwnPropertySlot(JSCell* cell, ExecState* exec, PropertyName propertyName, PropertySlot& slot)
{
    JSSVGMatrixPrototype* thisObject = jsCast<JSSVGMatrixPrototype*>(cell);
    return getStaticFunctionSlot<JSObject>(exec, &JSSVGMatrixPrototypeTable, thisObject, propertyName, slot);
}

bool JSSVGMatrixPrototype::getOwnPropertyDescriptor(JSObject* object, ExecState* exec, PropertyName propertyName, PropertyDescriptor& descriptor)
{
    JSSVGMatrixPrototype* thisObject = jsCast<JSSVGMatrixPrototype*>(object);
    return getStaticFunctionDescriptor<JSObject>(exec, &JSSVGMatrixPrototypeTable, thisObject, propertyName, descriptor);
}

const ClassInfo JSSVGMatrix::s_info = { "SVGMatrix", &Base::s_info, &JSSVGMatrixTable, 0 , CREATE_METHOD_TABLE(JSSVGMatrix) };

JSSVGMatrix::JSSVGMatrix(Structure* structure, JSDOMGlobalObject* globalObject, PassRefPtr<SVGPropertyTearOff<SVGMatrix> > impl)
    : JSDOMWrapper(structure, globalObject)
    , m_impl(impl.leakRef())
{
}

void JSSVGMatrix::finishCreation(JSGlobalData& globalData)
{
    Base::finishCreation(globalData);
    ASSERT(inherits(&s_info));
}

JSObject* JSSVGMatrix::createPrototype(ExecState* exec, JSGlobalObject* globalObject)
{
    return JSSVGMatrixPrototype::create(exec->globalData(), globalObject, JSSVGMatrixPrototype::createStructure(globalObject->globalData(), globalObject, globalObject->objectPrototype()));
}

void JSSVGMatrix::destroy(JSC::JSCell* cell)
{
    JSSVGMatrix* thisObject = static_cast<JSSVGMatrix*>(cell);
    thisObject->JSSVGMatrix::~JSSVGMatrix();
}

JSSVGMatrix::~JSSVGMatrix()
{
    releaseImplIfNotNull();
}

bool JSSVGMatrix::getOwnPropertySlot(JSCell* cell, ExecState* exec, PropertyName propertyName, PropertySlot& slot)
{
    JSSVGMatrix* thisObject = jsCast<JSSVGMatrix*>(cell);
    ASSERT_GC_OBJECT_INHERITS(thisObject, &s_info);
    return getStaticValueSlot<JSSVGMatrix, Base>(exec, &JSSVGMatrixTable, thisObject, propertyName, slot);
}

bool JSSVGMatrix::getOwnPropertyDescriptor(JSObject* object, ExecState* exec, PropertyName propertyName, PropertyDescriptor& descriptor)
{
    JSSVGMatrix* thisObject = jsCast<JSSVGMatrix*>(object);
    ASSERT_GC_OBJECT_INHERITS(thisObject, &s_info);
    return getStaticValueDescriptor<JSSVGMatrix, Base>(exec, &JSSVGMatrixTable, thisObject, propertyName, descriptor);
}

JSValue jsSVGMatrixA(ExecState* exec, JSValue slotBase, PropertyName)
{
    JSSVGMatrix* castedThis = jsCast<JSSVGMatrix*>(asObject(slotBase));
    UNUSED_PARAM(exec);
    SVGMatrix& impl = castedThis->impl()->propertyReference();
    JSValue result =  jsNumber(impl.a());
    return result;
}


JSValue jsSVGMatrixB(ExecState* exec, JSValue slotBase, PropertyName)
{
    JSSVGMatrix* castedThis = jsCast<JSSVGMatrix*>(asObject(slotBase));
    UNUSED_PARAM(exec);
    SVGMatrix& impl = castedThis->impl()->propertyReference();
    JSValue result =  jsNumber(impl.b());
    return result;
}


JSValue jsSVGMatrixC(ExecState* exec, JSValue slotBase, PropertyName)
{
    JSSVGMatrix* castedThis = jsCast<JSSVGMatrix*>(asObject(slotBase));
    UNUSED_PARAM(exec);
    SVGMatrix& impl = castedThis->impl()->propertyReference();
    JSValue result =  jsNumber(impl.c());
    return result;
}


JSValue jsSVGMatrixD(ExecState* exec, JSValue slotBase, PropertyName)
{
    JSSVGMatrix* castedThis = jsCast<JSSVGMatrix*>(asObject(slotBase));
    UNUSED_PARAM(exec);
    SVGMatrix& impl = castedThis->impl()->propertyReference();
    JSValue result =  jsNumber(impl.d());
    return result;
}


JSValue jsSVGMatrixE(ExecState* exec, JSValue slotBase, PropertyName)
{
    JSSVGMatrix* castedThis = jsCast<JSSVGMatrix*>(asObject(slotBase));
    UNUSED_PARAM(exec);
    SVGMatrix& impl = castedThis->impl()->propertyReference();
    JSValue result =  jsNumber(impl.e());
    return result;
}


JSValue jsSVGMatrixF(ExecState* exec, JSValue slotBase, PropertyName)
{
    JSSVGMatrix* castedThis = jsCast<JSSVGMatrix*>(asObject(slotBase));
    UNUSED_PARAM(exec);
    SVGMatrix& impl = castedThis->impl()->propertyReference();
    JSValue result =  jsNumber(impl.f());
    return result;
}


JSValue jsSVGMatrixConstructor(ExecState* exec, JSValue slotBase, PropertyName)
{
    JSSVGMatrix* domObject = jsCast<JSSVGMatrix*>(asObject(slotBase));
    return JSSVGMatrix::getConstructor(exec, domObject->globalObject());
}

void JSSVGMatrix::put(JSCell* cell, ExecState* exec, PropertyName propertyName, JSValue value, PutPropertySlot& slot)
{
    JSSVGMatrix* thisObject = jsCast<JSSVGMatrix*>(cell);
    ASSERT_GC_OBJECT_INHERITS(thisObject, &s_info);
    lookupPut<JSSVGMatrix, Base>(exec, propertyName, value, &JSSVGMatrixTable, thisObject, slot);
}

void setJSSVGMatrixA(ExecState* exec, JSObject* thisObject, JSValue value)
{
    UNUSED_PARAM(exec);
    JSSVGMatrix* castedThis = jsCast<JSSVGMatrix*>(thisObject);
    SVGPropertyTearOff<SVGMatrix> * impl = static_cast<SVGPropertyTearOff<SVGMatrix> *>(castedThis->impl());
    if (impl->isReadOnly()) {
        setDOMException(exec, NO_MODIFICATION_ALLOWED_ERR);
        return;
    }
    SVGMatrix& podImpl = impl->propertyReference();
    podImpl.setA(value.toNumber(exec));
    impl->commitChange();
}


void setJSSVGMatrixB(ExecState* exec, JSObject* thisObject, JSValue value)
{
    UNUSED_PARAM(exec);
    JSSVGMatrix* castedThis = jsCast<JSSVGMatrix*>(thisObject);
    SVGPropertyTearOff<SVGMatrix> * impl = static_cast<SVGPropertyTearOff<SVGMatrix> *>(castedThis->impl());
    if (impl->isReadOnly()) {
        setDOMException(exec, NO_MODIFICATION_ALLOWED_ERR);
        return;
    }
    SVGMatrix& podImpl = impl->propertyReference();
    podImpl.setB(value.toNumber(exec));
    impl->commitChange();
}


void setJSSVGMatrixC(ExecState* exec, JSObject* thisObject, JSValue value)
{
    UNUSED_PARAM(exec);
    JSSVGMatrix* castedThis = jsCast<JSSVGMatrix*>(thisObject);
    SVGPropertyTearOff<SVGMatrix> * impl = static_cast<SVGPropertyTearOff<SVGMatrix> *>(castedThis->impl());
    if (impl->isReadOnly()) {
        setDOMException(exec, NO_MODIFICATION_ALLOWED_ERR);
        return;
    }
    SVGMatrix& podImpl = impl->propertyReference();
    podImpl.setC(value.toNumber(exec));
    impl->commitChange();
}


void setJSSVGMatrixD(ExecState* exec, JSObject* thisObject, JSValue value)
{
    UNUSED_PARAM(exec);
    JSSVGMatrix* castedThis = jsCast<JSSVGMatrix*>(thisObject);
    SVGPropertyTearOff<SVGMatrix> * impl = static_cast<SVGPropertyTearOff<SVGMatrix> *>(castedThis->impl());
    if (impl->isReadOnly()) {
        setDOMException(exec, NO_MODIFICATION_ALLOWED_ERR);
        return;
    }
    SVGMatrix& podImpl = impl->propertyReference();
    podImpl.setD(value.toNumber(exec));
    impl->commitChange();
}


void setJSSVGMatrixE(ExecState* exec, JSObject* thisObject, JSValue value)
{
    UNUSED_PARAM(exec);
    JSSVGMatrix* castedThis = jsCast<JSSVGMatrix*>(thisObject);
    SVGPropertyTearOff<SVGMatrix> * impl = static_cast<SVGPropertyTearOff<SVGMatrix> *>(castedThis->impl());
    if (impl->isReadOnly()) {
        setDOMException(exec, NO_MODIFICATION_ALLOWED_ERR);
        return;
    }
    SVGMatrix& podImpl = impl->propertyReference();
    podImpl.setE(value.toNumber(exec));
    impl->commitChange();
}


void setJSSVGMatrixF(ExecState* exec, JSObject* thisObject, JSValue value)
{
    UNUSED_PARAM(exec);
    JSSVGMatrix* castedThis = jsCast<JSSVGMatrix*>(thisObject);
    SVGPropertyTearOff<SVGMatrix> * impl = static_cast<SVGPropertyTearOff<SVGMatrix> *>(castedThis->impl());
    if (impl->isReadOnly()) {
        setDOMException(exec, NO_MODIFICATION_ALLOWED_ERR);
        return;
    }
    SVGMatrix& podImpl = impl->propertyReference();
    podImpl.setF(value.toNumber(exec));
    impl->commitChange();
}


JSValue JSSVGMatrix::getConstructor(ExecState* exec, JSGlobalObject* globalObject)
{
    return getDOMConstructor<JSSVGMatrixConstructor>(exec, jsCast<JSDOMGlobalObject*>(globalObject));
}

EncodedJSValue JSC_HOST_CALL jsSVGMatrixPrototypeFunctionMultiply(ExecState* exec)
{
    JSValue thisValue = exec->hostThisValue();
    if (!thisValue.inherits(&JSSVGMatrix::s_info))
        return throwVMTypeError(exec);
    JSSVGMatrix* castedThis = jsCast<JSSVGMatrix*>(asObject(thisValue));
    ASSERT_GC_OBJECT_INHERITS(castedThis, &JSSVGMatrix::s_info);
    SVGPropertyTearOff<SVGMatrix> * impl = static_cast<SVGPropertyTearOff<SVGMatrix> *>(castedThis->impl());
    if (impl->isReadOnly()) {
        setDOMException(exec, NO_MODIFICATION_ALLOWED_ERR);
        return JSValue::encode(jsUndefined());
    }
    SVGMatrix& podImpl = impl->propertyReference();
    if (exec->argumentCount() < 1)
        return throwVMError(exec, createNotEnoughArgumentsError(exec));
    if (exec->argumentCount() > 0 && !exec->argument(0).isUndefinedOrNull() && !exec->argument(0).inherits(&JSSVGMatrix::s_info))
        return throwVMTypeError(exec);
    SVGPropertyTearOff<SVGMatrix>* secondMatrix(toSVGMatrix(MAYBE_MISSING_PARAMETER(exec, 0, DefaultIsUndefined)));
    if (exec->hadException())
        return JSValue::encode(jsUndefined());
    if (!secondMatrix) {
        setDOMException(exec, TYPE_MISMATCH_ERR);
        return JSValue::encode(jsUndefined());
    }

    JSC::JSValue result = toJS(exec, castedThis->globalObject(), WTF::getPtr(SVGPropertyTearOff<SVGMatrix>::create(podImpl.multiply(secondMatrix->propertyReference()))));
    return JSValue::encode(result);
}

EncodedJSValue JSC_HOST_CALL jsSVGMatrixPrototypeFunctionInverse(ExecState* exec)
{
    JSValue thisValue = exec->hostThisValue();
    if (!thisValue.inherits(&JSSVGMatrix::s_info))
        return throwVMTypeError(exec);
    JSSVGMatrix* castedThis = jsCast<JSSVGMatrix*>(asObject(thisValue));
    ASSERT_GC_OBJECT_INHERITS(castedThis, &JSSVGMatrix::s_info);
    SVGPropertyTearOff<SVGMatrix> * impl = static_cast<SVGPropertyTearOff<SVGMatrix> *>(castedThis->impl());
    if (impl->isReadOnly()) {
        setDOMException(exec, NO_MODIFICATION_ALLOWED_ERR);
        return JSValue::encode(jsUndefined());
    }
    SVGMatrix& podImpl = impl->propertyReference();
    ExceptionCode ec = 0;

    JSC::JSValue result = toJS(exec, castedThis->globalObject(), WTF::getPtr(SVGPropertyTearOff<SVGMatrix>::create(podImpl.inverse(ec))));
    setDOMException(exec, ec);
    return JSValue::encode(result);
}

EncodedJSValue JSC_HOST_CALL jsSVGMatrixPrototypeFunctionTranslate(ExecState* exec)
{
    JSValue thisValue = exec->hostThisValue();
    if (!thisValue.inherits(&JSSVGMatrix::s_info))
        return throwVMTypeError(exec);
    JSSVGMatrix* castedThis = jsCast<JSSVGMatrix*>(asObject(thisValue));
    ASSERT_GC_OBJECT_INHERITS(castedThis, &JSSVGMatrix::s_info);
    SVGPropertyTearOff<SVGMatrix> * impl = static_cast<SVGPropertyTearOff<SVGMatrix> *>(castedThis->impl());
    if (impl->isReadOnly()) {
        setDOMException(exec, NO_MODIFICATION_ALLOWED_ERR);
        return JSValue::encode(jsUndefined());
    }
    SVGMatrix& podImpl = impl->propertyReference();
    if (exec->argumentCount() < 2)
        return throwVMError(exec, createNotEnoughArgumentsError(exec));
    float x(MAYBE_MISSING_PARAMETER(exec, 0, DefaultIsUndefined).toFloat(exec));
    if (exec->hadException())
        return JSValue::encode(jsUndefined());
    float y(MAYBE_MISSING_PARAMETER(exec, 1, DefaultIsUndefined).toFloat(exec));
    if (exec->hadException())
        return JSValue::encode(jsUndefined());

    JSC::JSValue result = toJS(exec, castedThis->globalObject(), WTF::getPtr(SVGPropertyTearOff<SVGMatrix>::create(podImpl.translate(x, y))));
    return JSValue::encode(result);
}

EncodedJSValue JSC_HOST_CALL jsSVGMatrixPrototypeFunctionScale(ExecState* exec)
{
    JSValue thisValue = exec->hostThisValue();
    if (!thisValue.inherits(&JSSVGMatrix::s_info))
        return throwVMTypeError(exec);
    JSSVGMatrix* castedThis = jsCast<JSSVGMatrix*>(asObject(thisValue));
    ASSERT_GC_OBJECT_INHERITS(castedThis, &JSSVGMatrix::s_info);
    SVGPropertyTearOff<SVGMatrix> * impl = static_cast<SVGPropertyTearOff<SVGMatrix> *>(castedThis->impl());
    if (impl->isReadOnly()) {
        setDOMException(exec, NO_MODIFICATION_ALLOWED_ERR);
        return JSValue::encode(jsUndefined());
    }
    SVGMatrix& podImpl = impl->propertyReference();
    if (exec->argumentCount() < 1)
        return throwVMError(exec, createNotEnoughArgumentsError(exec));
    float scaleFactor(MAYBE_MISSING_PARAMETER(exec, 0, DefaultIsUndefined).toFloat(exec));
    if (exec->hadException())
        return JSValue::encode(jsUndefined());

    JSC::JSValue result = toJS(exec, castedThis->globalObject(), WTF::getPtr(SVGPropertyTearOff<SVGMatrix>::create(podImpl.scale(scaleFactor))));
    return JSValue::encode(result);
}

EncodedJSValue JSC_HOST_CALL jsSVGMatrixPrototypeFunctionScaleNonUniform(ExecState* exec)
{
    JSValue thisValue = exec->hostThisValue();
    if (!thisValue.inherits(&JSSVGMatrix::s_info))
        return throwVMTypeError(exec);
    JSSVGMatrix* castedThis = jsCast<JSSVGMatrix*>(asObject(thisValue));
    ASSERT_GC_OBJECT_INHERITS(castedThis, &JSSVGMatrix::s_info);
    SVGPropertyTearOff<SVGMatrix> * impl = static_cast<SVGPropertyTearOff<SVGMatrix> *>(castedThis->impl());
    if (impl->isReadOnly()) {
        setDOMException(exec, NO_MODIFICATION_ALLOWED_ERR);
        return JSValue::encode(jsUndefined());
    }
    SVGMatrix& podImpl = impl->propertyReference();
    if (exec->argumentCount() < 2)
        return throwVMError(exec, createNotEnoughArgumentsError(exec));
    float scaleFactorX(MAYBE_MISSING_PARAMETER(exec, 0, DefaultIsUndefined).toFloat(exec));
    if (exec->hadException())
        return JSValue::encode(jsUndefined());
    float scaleFactorY(MAYBE_MISSING_PARAMETER(exec, 1, DefaultIsUndefined).toFloat(exec));
    if (exec->hadException())
        return JSValue::encode(jsUndefined());

    JSC::JSValue result = toJS(exec, castedThis->globalObject(), WTF::getPtr(SVGPropertyTearOff<SVGMatrix>::create(podImpl.scaleNonUniform(scaleFactorX, scaleFactorY))));
    return JSValue::encode(result);
}

EncodedJSValue JSC_HOST_CALL jsSVGMatrixPrototypeFunctionRotate(ExecState* exec)
{
    JSValue thisValue = exec->hostThisValue();
    if (!thisValue.inherits(&JSSVGMatrix::s_info))
        return throwVMTypeError(exec);
    JSSVGMatrix* castedThis = jsCast<JSSVGMatrix*>(asObject(thisValue));
    ASSERT_GC_OBJECT_INHERITS(castedThis, &JSSVGMatrix::s_info);
    SVGPropertyTearOff<SVGMatrix> * impl = static_cast<SVGPropertyTearOff<SVGMatrix> *>(castedThis->impl());
    if (impl->isReadOnly()) {
        setDOMException(exec, NO_MODIFICATION_ALLOWED_ERR);
        return JSValue::encode(jsUndefined());
    }
    SVGMatrix& podImpl = impl->propertyReference();
    if (exec->argumentCount() < 1)
        return throwVMError(exec, createNotEnoughArgumentsError(exec));
    float angle(MAYBE_MISSING_PARAMETER(exec, 0, DefaultIsUndefined).toFloat(exec));
    if (exec->hadException())
        return JSValue::encode(jsUndefined());

    JSC::JSValue result = toJS(exec, castedThis->globalObject(), WTF::getPtr(SVGPropertyTearOff<SVGMatrix>::create(podImpl.rotate(angle))));
    return JSValue::encode(result);
}

EncodedJSValue JSC_HOST_CALL jsSVGMatrixPrototypeFunctionRotateFromVector(ExecState* exec)
{
    JSValue thisValue = exec->hostThisValue();
    if (!thisValue.inherits(&JSSVGMatrix::s_info))
        return throwVMTypeError(exec);
    JSSVGMatrix* castedThis = jsCast<JSSVGMatrix*>(asObject(thisValue));
    ASSERT_GC_OBJECT_INHERITS(castedThis, &JSSVGMatrix::s_info);
    SVGPropertyTearOff<SVGMatrix> * impl = static_cast<SVGPropertyTearOff<SVGMatrix> *>(castedThis->impl());
    if (impl->isReadOnly()) {
        setDOMException(exec, NO_MODIFICATION_ALLOWED_ERR);
        return JSValue::encode(jsUndefined());
    }
    SVGMatrix& podImpl = impl->propertyReference();
    if (exec->argumentCount() < 2)
        return throwVMError(exec, createNotEnoughArgumentsError(exec));
    ExceptionCode ec = 0;
    float x(MAYBE_MISSING_PARAMETER(exec, 0, DefaultIsUndefined).toFloat(exec));
    if (exec->hadException())
        return JSValue::encode(jsUndefined());
    float y(MAYBE_MISSING_PARAMETER(exec, 1, DefaultIsUndefined).toFloat(exec));
    if (exec->hadException())
        return JSValue::encode(jsUndefined());

    JSC::JSValue result = toJS(exec, castedThis->globalObject(), WTF::getPtr(SVGPropertyTearOff<SVGMatrix>::create(podImpl.rotateFromVector(x, y, ec))));
    setDOMException(exec, ec);
    return JSValue::encode(result);
}

EncodedJSValue JSC_HOST_CALL jsSVGMatrixPrototypeFunctionFlipX(ExecState* exec)
{
    JSValue thisValue = exec->hostThisValue();
    if (!thisValue.inherits(&JSSVGMatrix::s_info))
        return throwVMTypeError(exec);
    JSSVGMatrix* castedThis = jsCast<JSSVGMatrix*>(asObject(thisValue));
    ASSERT_GC_OBJECT_INHERITS(castedThis, &JSSVGMatrix::s_info);
    SVGPropertyTearOff<SVGMatrix> * impl = static_cast<SVGPropertyTearOff<SVGMatrix> *>(castedThis->impl());
    if (impl->isReadOnly()) {
        setDOMException(exec, NO_MODIFICATION_ALLOWED_ERR);
        return JSValue::encode(jsUndefined());
    }
    SVGMatrix& podImpl = impl->propertyReference();

    JSC::JSValue result = toJS(exec, castedThis->globalObject(), WTF::getPtr(SVGPropertyTearOff<SVGMatrix>::create(podImpl.flipX())));
    return JSValue::encode(result);
}

EncodedJSValue JSC_HOST_CALL jsSVGMatrixPrototypeFunctionFlipY(ExecState* exec)
{
    JSValue thisValue = exec->hostThisValue();
    if (!thisValue.inherits(&JSSVGMatrix::s_info))
        return throwVMTypeError(exec);
    JSSVGMatrix* castedThis = jsCast<JSSVGMatrix*>(asObject(thisValue));
    ASSERT_GC_OBJECT_INHERITS(castedThis, &JSSVGMatrix::s_info);
    SVGPropertyTearOff<SVGMatrix> * impl = static_cast<SVGPropertyTearOff<SVGMatrix> *>(castedThis->impl());
    if (impl->isReadOnly()) {
        setDOMException(exec, NO_MODIFICATION_ALLOWED_ERR);
        return JSValue::encode(jsUndefined());
    }
    SVGMatrix& podImpl = impl->propertyReference();

    JSC::JSValue result = toJS(exec, castedThis->globalObject(), WTF::getPtr(SVGPropertyTearOff<SVGMatrix>::create(podImpl.flipY())));
    return JSValue::encode(result);
}

EncodedJSValue JSC_HOST_CALL jsSVGMatrixPrototypeFunctionSkewX(ExecState* exec)
{
    JSValue thisValue = exec->hostThisValue();
    if (!thisValue.inherits(&JSSVGMatrix::s_info))
        return throwVMTypeError(exec);
    JSSVGMatrix* castedThis = jsCast<JSSVGMatrix*>(asObject(thisValue));
    ASSERT_GC_OBJECT_INHERITS(castedThis, &JSSVGMatrix::s_info);
    SVGPropertyTearOff<SVGMatrix> * impl = static_cast<SVGPropertyTearOff<SVGMatrix> *>(castedThis->impl());
    if (impl->isReadOnly()) {
        setDOMException(exec, NO_MODIFICATION_ALLOWED_ERR);
        return JSValue::encode(jsUndefined());
    }
    SVGMatrix& podImpl = impl->propertyReference();
    if (exec->argumentCount() < 1)
        return throwVMError(exec, createNotEnoughArgumentsError(exec));
    float angle(MAYBE_MISSING_PARAMETER(exec, 0, DefaultIsUndefined).toFloat(exec));
    if (exec->hadException())
        return JSValue::encode(jsUndefined());

    JSC::JSValue result = toJS(exec, castedThis->globalObject(), WTF::getPtr(SVGPropertyTearOff<SVGMatrix>::create(podImpl.skewX(angle))));
    return JSValue::encode(result);
}

EncodedJSValue JSC_HOST_CALL jsSVGMatrixPrototypeFunctionSkewY(ExecState* exec)
{
    JSValue thisValue = exec->hostThisValue();
    if (!thisValue.inherits(&JSSVGMatrix::s_info))
        return throwVMTypeError(exec);
    JSSVGMatrix* castedThis = jsCast<JSSVGMatrix*>(asObject(thisValue));
    ASSERT_GC_OBJECT_INHERITS(castedThis, &JSSVGMatrix::s_info);
    SVGPropertyTearOff<SVGMatrix> * impl = static_cast<SVGPropertyTearOff<SVGMatrix> *>(castedThis->impl());
    if (impl->isReadOnly()) {
        setDOMException(exec, NO_MODIFICATION_ALLOWED_ERR);
        return JSValue::encode(jsUndefined());
    }
    SVGMatrix& podImpl = impl->propertyReference();
    if (exec->argumentCount() < 1)
        return throwVMError(exec, createNotEnoughArgumentsError(exec));
    float angle(MAYBE_MISSING_PARAMETER(exec, 0, DefaultIsUndefined).toFloat(exec));
    if (exec->hadException())
        return JSValue::encode(jsUndefined());

    JSC::JSValue result = toJS(exec, castedThis->globalObject(), WTF::getPtr(SVGPropertyTearOff<SVGMatrix>::create(podImpl.skewY(angle))));
    return JSValue::encode(result);
}

static inline bool isObservable(JSSVGMatrix* jsSVGMatrix)
{
    if (jsSVGMatrix->hasCustomProperties())
        return true;
    return false;
}

bool JSSVGMatrixOwner::isReachableFromOpaqueRoots(JSC::Handle<JSC::Unknown> handle, void*, SlotVisitor& visitor)
{
    JSSVGMatrix* jsSVGMatrix = jsCast<JSSVGMatrix*>(handle.get().asCell());
    if (!isObservable(jsSVGMatrix))
        return false;
    UNUSED_PARAM(visitor);
    return false;
}

void JSSVGMatrixOwner::finalize(JSC::Handle<JSC::Unknown> handle, void* context)
{
    JSSVGMatrix* jsSVGMatrix = jsCast<JSSVGMatrix*>(handle.get().asCell());
    DOMWrapperWorld* world = static_cast<DOMWrapperWorld*>(context);
    uncacheWrapper(world, jsSVGMatrix->impl(), jsSVGMatrix);
    jsSVGMatrix->releaseImpl();
}

JSC::JSValue toJS(JSC::ExecState* exec, JSDOMGlobalObject* globalObject, SVGPropertyTearOff<SVGMatrix> * impl)
{
    return wrap<JSSVGMatrix, SVGPropertyTearOff<SVGMatrix> >(exec, globalObject, impl);
}

SVGPropertyTearOff<SVGMatrix> * toSVGMatrix(JSC::JSValue value)
{
    return value.inherits(&JSSVGMatrix::s_info) ? jsCast<JSSVGMatrix*>(asObject(value))->impl() : 0;
}

}

#endif // ENABLE(SVG)
