/* -*- coding: utf-8 -*- */
/* Copyright (C) 1996-2015 Piotr Held <pjheld@gmail.com>
 *
 * This file is part of Octave.
 *
 * Octave is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public
 * License as published by the Free Software Foundation;
 * either version 3 of the License, or (at your option) any
 * later version.
 *
 * Octave is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied
 * warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR
 * PURPOSE.  See the GNU General Public License for more
 * details.
 *
 * You should have received a copy of the GNU General Public
 * License along with Octave; see the file COPYING.  If not,
 * see <http://www.gnu.org/licenses/>.
 */
/* Author: Piotr Held <pjheld@gmail.com>.
 * This function is based on randomize of TISEAN 3.0.1 
 * https://github.com/heggus/Tisean"
 */
/******************************************************************************/
/******************************************************************************/

#define HELPTEXT "Part of tisean package\n\
No argument checking\n\
FOR INTERNAL USE ONLY"

#include <limits>
#include <cstdio>

#include <octave/oct.h>
#include <octave/oct-map.h>

#include "randomize/normal.h"
#include "randomize/Cost_fcn.h"
#include "randomize/Cost_auto_fcn.h"
#include "randomize/Cool_fcn.h"
#include "randomize/Permute_fcn.h"
#include "randomize/runner.h"


DEFUN_DLD (__randomize__, args, nargout, HELPTEXT)
{
  octave_value_list retval;
  int nargin = args.length ();


  if (nargin != 5 && nargin != 11)
    {
      print_usage ();
    }
  else
    {
    // Assigning inputs
      Matrix input                     = args(0).matrix_value ();
      octave_scalar_map run_params     = args(1).scalar_map_value ();
      octave_scalar_map cost_params    = args(2).scalar_map_value ();
      octave_scalar_map cool_params    = args(3).scalar_map_value ();
      octave_scalar_map permute_params = args(4).scalar_map_value ();

      octave_idx_type no_sur = 1;
      double imp_b4_w8 = 0.9;
      double seed = 0; // currently unsupported
      // Check if run_params are correct
      if (run_params.isfield (std::string ("no_sur"))
          && run_params.isfield (std::string ("improvement_b4_write"))
          && run_params.isfield (std::string ("seed")))
        {
          no_sur    = run_params.getfield (std::string ("no_sur"))
                                 .idx_type_value ();
          imp_b4_w8 = run_params.getfield (std::string("improvement_b4_write"))
                                 .double_value ();
          seed      = run_params.getfield (std::string ("seed"))
                                 .double_value ();
        }
      else
        {
          error_with_id ("Octave:tisean", "Run function did not "
                                          "receive correct parameters");
        }

      // Do some code for more than one surrogate (nsur > 1) -- maybe

      // write stdout !!! for nsur > 1

      if (nargin == 5)
        srand (time (NULL));

      // Initialize cost function
      Cost_auto_fcn cost_auto_f (&input, cost_params, permute_params);
      Cost_fcn &cost_f = cost_auto_f;

      // Initialize all of the functions
      Cool_fcn cool_f (cool_params);
      octave_idx_type current_time = 0;

      double cmin;
      // Return from saved state
      if (nargin == 11)
        {
          cost_auto_f.cost_transform (false);

          int8NDArray saved_cool_f = args(5).int8_array_value ();
          memcpy (&cool_f, saved_cool_f.fortran_vec (), sizeof (cool_f));
          current_time = args(6).idx_type_value ();
          input = args(7).matrix_value ();
          cost_auto_f.set_c (args(8).matrix_value ());
          cmin = args(9).double_value ();
          cost_f.set_cost (args(10).double_value ());
        }
      else
        {
          cost_auto_f.cost_transform ();

          cmin = cost_f.cost_full ();
          printf ("cmin: %e\n", cmin);

        }


      if (! error_state)
        {

          Matrix output (input);

          bool end;
          end = runner (imp_b4_w8, cmin, cost_f, cool_f, current_time, 100000,
                        output);
          retval(0) = output;
          int8NDArray save_cool_f (dim_vector (sizeof (cool_f), 1));
          memcpy (save_cool_f.fortran_vec (), &cool_f, sizeof (cool_f));
          retval(1) = save_cool_f;
          retval(2) = current_time;
          retval(3) = end;
          Matrix input_saved_state (input);
          retval(4) = input_saved_state;
          retval(5) = cost_auto_f.get_c ();
          retval(6) = cmin;
          retval(7) = cost_f.get_cost ();

        }
    }
  return retval;
}
