/*

Copyright (C) 2019 Olaf Till <i7tiol@t-online.de>

This program is free software; you can redistribute it and/or modify
it under the terms of the GNU General Public License as published by
the Free Software Foundation; either version 3 of the License, or
(at your option) any later version.

This program is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
GNU General Public License for more details.

You should have received a copy of the GNU General Public License
along with this program; If not, see <http://www.gnu.org/licenses/>.

*/

#include "parallel-gnutls.h"

static
octave_parallel::control &get_scheduler (void)
{
  static octave_parallel::control sched;

  return sched;
}

// This function is only for testing while developing and may be
// removed.
DEFUN_DLD (__test_rfeval__, args, ,
           "-*- texinfo -*-\n\
@deftypefn {Loadable Function} {} __octave_server__ ()\n\
Undocumented internal function for testing development, may crash.\n\
@end deftypefn")
{
  octave_value retval;

  octave_value arg1, arg2, arg3;

  if (args.length () != 3)
    {
      error ("__test_rfeval__: exactly three arguments required. This function may crash, use it only for testing development.");
      return retval;
    }
  else
    {
      arg1 = args(0);
      arg2 = args(1);
      arg3 = args(2);
    }

  octave_parallel::control &sched = get_scheduler ();

  octave_value arg_idx = 1; // arbitrary

  octave_value eh;

  bool have_eh = false;

  if (arg3.is_function_handle ())
    {
      eh = arg3;
      have_eh = true;
    }

  if (arg1.is_function_handle ())
    {
      octave_value nout = octave_value (octave_int32 (arg2.int_value ()));

      std::string dir = ".";

      if (sched.instc->initialize_new_function_handle (arg1, dir, eh, nout))
        {
          error ("could not initialize function handle");
          return retval;
        }
    }
  else
    {
      if (sched.instc->send_octave_value (arg1))
        {
          error ("could not send argument set");
          return retval;
        }
      else if (have_eh && sched.instc->send_octave_value (arg_idx))
        {
          error ("could not send argument index");
          return retval;
        }
      else if (sched.instc->recv_octave_value (retval))
        {
          error ("could not receive result");
          return retval;
        }
    }

  return retval;
}
/*
%!test
%! __test_rfeval__ (@ (x) sqrt (x), 1, @ (info, x) info.message);
%! assert (__test_rfeval__ (9, 1, @ (info, x) info.message){1}, 3);
%! assert (iscellstr (__test_rfeval__ ("a", 1, @ (info, x) info.message)));
%!test
%! __test_rfeval__ (@ (x) sqrt (x), 1, 1);
%! assert (__test_rfeval__ (9, 1, 1){1}, 3);
%! assert (__test_rfeval__ ("a", 1, 1), int32 (-1));
*/
