.TH ANNO %manext1% 2005-12-07 "%nmhversion%"
.
.\" %nmhwarning%
.
.SH NAME
anno \- annotate nmh messages
.SH SYNOPSIS
.HP 5
.na
.B anno
.RB [ \-help ]
.RB [ \-version ]
.RI [ +folder ]
.RI [ msgs ]
.RB [ \-component
.IR field ]
.RB [ \-inplace " | " \-noinplace ]
.RB [ \-date " | " \-nodate ]
.RB [ \-draft ]
.RB [ \-append ]
.RB [ \-list ]
.RB [ \-delete ]
.RB [ \-number
.IR [ num|all ]]
.RB [ \-preserve " | " \-nopreserve ]
.RB [ \-text
.IR body ]
.ad
.SH DESCRIPTION
.B anno
manipulates header fields or
.I annotations
in messages.
Header fields consist of a field name and an optional field body
as defined by RFC 2822.
The
.B \-component
switch specifies the field name, and the
.B \-text
switch specifies the field body.
.PP
The messages are either the
.I msgs
in the named folder, or the draft if invoked with the
.B \-draft
switch.
.PP
Usually, annotation is performed by the commands
.BR dist ,
.BR forw ,
and
.BR repl ,
if they are given the
.B \-anno
switch.  This allows you to keep track of your distribution of,
forwarding of, and replies to a message.
.PP
By using
.BR anno ,
you can perform arbitrary annotations of your own.
Each message selected will be annotated with the lines
.PP
    field:\ date
    field:\ body
.PP
The
.B \-nodate
switch inhibits the date annotation, leaving only the
body annotation.
.PP
By default,
.B anno
prepends the annotations to the message.
Annotations are instead appended if the
.B \-append
switch is specified.
.PP
If a
.B \-component
.I field
is not specified when
.B anno
is invoked,
.B anno
will prompt the user for a field name.
.PP
The field specified must be a valid RFC 2822-style message field name,
consisting only of alphanumeric characters and dashes.
The body may consist of arbitrary text.
.PP
Normally
.B anno
does the annotation in place in order to preserve
any links to the message.  You may change this by using the
.B \-noinplace
switch.
.PP
The
.B \-list
switch produces a listing of the field bodies for header fields with
names matching the specified component, one per line.
The listing is numbered, starting at 1, if the
.B \-number
switch is also used.
A tab character separates the number and the field body.
The field body is treated as if it is a file name, and only the final
path name component is listed.
The complete field body is listed if the
.B \-text
switch is used; the argument to the
.B \-text
switch is required but ignored.
.PP
The
.B \-delete
switch removes header fields from messages.
The first header field whose name matches the component is deleted if
no other options are specified.
If the
.B \-text
switch is used in conjunction with the
.B \-delete
switch, the first header field whose name matches the component and
whose body matches the text is deleted.
The text is treated as if it was a file name; if it begins with a
slash, the entire field body must match the text, otherwise just the
last path name component of the field body must match.
If the
.B \-number
switch is used in conjunction with the
.B \-delete
switch, header field
.I num
whose name matches the component is deleted.
The number matches that which is produced by the
.B \-list
switch.
The special value
.B all
can be used for the number, and causes all components that match the
name to be deleted.
.PP
By default,
.B anno
changes the last-accessed and last-modified times on annotated messages
to the time of the annotation.
.B anno
preserves the original times if the
.B \-preserve
switch is used.
A matching
.B \-nopreserve
switch allows time preservation to be turned off, if enabled
in the profile.
.SH FILES
.TP 20
$HOME/.mh_profile
The user's profile.
.SH "PROFILE COMPONENTS"
.PD 0
.TP 20
Path:
To determine the user's nmh directory.
.TP
Current\-Folder:
To find the default current folder.
.PD
.SH "SEE ALSO"
.IR dist (1),
.IR forw (1),
.IR repl (1)
.SH DEFAULTS
.PD 0
.TP 20
+folder
The current folder.
.TP
msgs
The current message.
.TP
-inplace
.TP
-date
.PD
.SH CONTEXT
If a folder is given, it will become the current folder.  The first
message annotated will become the current message.
