; NOTE: Assertions have been autogenerated by utils/update_llc_test_checks.py
; RUN: llc < %s -mtriple=i686-apple-darwin -mattr=avx2 -show-mc-encoding | FileCheck %s --check-prefix=CHECK --check-prefix=AVX2 --check-prefix=X86 --check-prefix=X86-AVX
; RUN: llc < %s -mtriple=i686-apple-darwin -mattr=+avx512f,+avx512bw,+avx512vl,+avx512dq -show-mc-encoding | FileCheck %s --check-prefix=CHECK --check-prefix=AVX512VL --check-prefix=X86 --check-prefix=X86-AVX512VL
; RUN: llc < %s -mtriple=x86_64-apple-darwin -mattr=avx2 -show-mc-encoding | FileCheck %s --check-prefix=CHECK --check-prefix=AVX2 --check-prefix=X64 --check-prefix=X64-AVX
; RUN: llc < %s -mtriple=x86_64-apple-darwin -mattr=+avx512f,+avx512bw,+avx512vl,+avx512dq -show-mc-encoding | FileCheck %s --check-prefix=CHECK --check-prefix=AVX512VL --check-prefix=X64 --check-prefix=X64-AVX512VL

; NOTE: This should use IR equivalent to what is generated by clang/test/CodeGen/sse2-builtins.c

define <32 x i8> @test_x86_avx2_paddus_b(<32 x i8> %a0, <32 x i8> %a1) {
; X86-AVX-LABEL: test_x86_avx2_paddus_b:
; X86-AVX:       ## %bb.0:
; X86-AVX-NEXT:    vpaddusb %ymm1, %ymm0, %ymm0 ## encoding: [0xc5,0xfd,0xdc,0xc1]
; X86-AVX-NEXT:    retl ## encoding: [0xc3]
;
; X86-AVX512VL-LABEL: test_x86_avx2_paddus_b:
; X86-AVX512VL:       ## %bb.0:
; X86-AVX512VL-NEXT:    vpaddusb %ymm1, %ymm0, %ymm0 ## EVEX TO VEX Compression encoding: [0xc5,0xfd,0xdc,0xc1]
; X86-AVX512VL-NEXT:    retl ## encoding: [0xc3]
;
; X64-AVX-LABEL: test_x86_avx2_paddus_b:
; X64-AVX:       ## %bb.0:
; X64-AVX-NEXT:    vpaddusb %ymm1, %ymm0, %ymm0 ## encoding: [0xc5,0xfd,0xdc,0xc1]
; X64-AVX-NEXT:    retq ## encoding: [0xc3]
;
; X64-AVX512VL-LABEL: test_x86_avx2_paddus_b:
; X64-AVX512VL:       ## %bb.0:
; X64-AVX512VL-NEXT:    vpaddusb %ymm1, %ymm0, %ymm0 ## EVEX TO VEX Compression encoding: [0xc5,0xfd,0xdc,0xc1]
; X64-AVX512VL-NEXT:    retq ## encoding: [0xc3]
  %1 = add <32 x i8> %a0, %a1
  %2 = icmp ugt <32 x i8> %a0, %1
  %3 = select <32 x i1> %2, <32 x i8> <i8 -1, i8 -1, i8 -1, i8 -1, i8 -1, i8 -1, i8 -1, i8 -1, i8 -1, i8 -1, i8 -1, i8 -1, i8 -1, i8 -1, i8 -1, i8 -1, i8 -1, i8 -1, i8 -1, i8 -1, i8 -1, i8 -1, i8 -1, i8 -1, i8 -1, i8 -1, i8 -1, i8 -1, i8 -1, i8 -1, i8 -1, i8 -1>, <32 x i8> %1
  ret <32 x i8> %3
}

define <16 x i16> @test_x86_avx2_paddus_w(<16 x i16> %a0, <16 x i16> %a1) {
; X86-AVX-LABEL: test_x86_avx2_paddus_w:
; X86-AVX:       ## %bb.0:
; X86-AVX-NEXT:    vpaddusw %ymm1, %ymm0, %ymm0 ## encoding: [0xc5,0xfd,0xdd,0xc1]
; X86-AVX-NEXT:    retl ## encoding: [0xc3]
;
; X86-AVX512VL-LABEL: test_x86_avx2_paddus_w:
; X86-AVX512VL:       ## %bb.0:
; X86-AVX512VL-NEXT:    vpaddusw %ymm1, %ymm0, %ymm0 ## EVEX TO VEX Compression encoding: [0xc5,0xfd,0xdd,0xc1]
; X86-AVX512VL-NEXT:    retl ## encoding: [0xc3]
;
; X64-AVX-LABEL: test_x86_avx2_paddus_w:
; X64-AVX:       ## %bb.0:
; X64-AVX-NEXT:    vpaddusw %ymm1, %ymm0, %ymm0 ## encoding: [0xc5,0xfd,0xdd,0xc1]
; X64-AVX-NEXT:    retq ## encoding: [0xc3]
;
; X64-AVX512VL-LABEL: test_x86_avx2_paddus_w:
; X64-AVX512VL:       ## %bb.0:
; X64-AVX512VL-NEXT:    vpaddusw %ymm1, %ymm0, %ymm0 ## EVEX TO VEX Compression encoding: [0xc5,0xfd,0xdd,0xc1]
; X64-AVX512VL-NEXT:    retq ## encoding: [0xc3]
  %1 = add <16 x i16> %a0, %a1
  %2 = icmp ugt <16 x i16> %a0, %1
  %3 = select <16 x i1> %2, <16 x i16> <i16 -1, i16 -1, i16 -1, i16 -1, i16 -1, i16 -1, i16 -1, i16 -1, i16 -1, i16 -1, i16 -1, i16 -1, i16 -1, i16 -1, i16 -1, i16 -1>, <16 x i16> %1
  ret <16 x i16> %3
}

define <32 x i8> @test_x86_avx2_psubus_b(<32 x i8> %a0, <32 x i8> %a1) {
; X86-AVX-LABEL: test_x86_avx2_psubus_b:
; X86-AVX:       ## %bb.0:
; X86-AVX-NEXT:    vpsubusb %ymm1, %ymm0, %ymm0 ## encoding: [0xc5,0xfd,0xd8,0xc1]
; X86-AVX-NEXT:    retl ## encoding: [0xc3]
;
; X86-AVX512VL-LABEL: test_x86_avx2_psubus_b:
; X86-AVX512VL:       ## %bb.0:
; X86-AVX512VL-NEXT:    vpsubusb %ymm1, %ymm0, %ymm0 ## EVEX TO VEX Compression encoding: [0xc5,0xfd,0xd8,0xc1]
; X86-AVX512VL-NEXT:    retl ## encoding: [0xc3]
;
; X64-AVX-LABEL: test_x86_avx2_psubus_b:
; X64-AVX:       ## %bb.0:
; X64-AVX-NEXT:    vpsubusb %ymm1, %ymm0, %ymm0 ## encoding: [0xc5,0xfd,0xd8,0xc1]
; X64-AVX-NEXT:    retq ## encoding: [0xc3]
;
; X64-AVX512VL-LABEL: test_x86_avx2_psubus_b:
; X64-AVX512VL:       ## %bb.0:
; X64-AVX512VL-NEXT:    vpsubusb %ymm1, %ymm0, %ymm0 ## EVEX TO VEX Compression encoding: [0xc5,0xfd,0xd8,0xc1]
; X64-AVX512VL-NEXT:    retq ## encoding: [0xc3]
  %cmp = icmp ugt <32 x i8> %a0, %a1
  %sel = select <32 x i1> %cmp, <32 x i8> %a0, <32 x i8> %a1
  %sub = sub <32 x i8> %sel, %a1
  ret <32 x i8> %sub
}

define <16 x i16> @test_x86_avx2_psubus_w(<16 x i16> %a0, <16 x i16> %a1) {
; X86-AVX-LABEL: test_x86_avx2_psubus_w:
; X86-AVX:       ## %bb.0:
; X86-AVX-NEXT:    vpsubusw %ymm1, %ymm0, %ymm0 ## encoding: [0xc5,0xfd,0xd9,0xc1]
; X86-AVX-NEXT:    retl ## encoding: [0xc3]
;
; X86-AVX512VL-LABEL: test_x86_avx2_psubus_w:
; X86-AVX512VL:       ## %bb.0:
; X86-AVX512VL-NEXT:    vpsubusw %ymm1, %ymm0, %ymm0 ## EVEX TO VEX Compression encoding: [0xc5,0xfd,0xd9,0xc1]
; X86-AVX512VL-NEXT:    retl ## encoding: [0xc3]
;
; X64-AVX-LABEL: test_x86_avx2_psubus_w:
; X64-AVX:       ## %bb.0:
; X64-AVX-NEXT:    vpsubusw %ymm1, %ymm0, %ymm0 ## encoding: [0xc5,0xfd,0xd9,0xc1]
; X64-AVX-NEXT:    retq ## encoding: [0xc3]
;
; X64-AVX512VL-LABEL: test_x86_avx2_psubus_w:
; X64-AVX512VL:       ## %bb.0:
; X64-AVX512VL-NEXT:    vpsubusw %ymm1, %ymm0, %ymm0 ## EVEX TO VEX Compression encoding: [0xc5,0xfd,0xd9,0xc1]
; X64-AVX512VL-NEXT:    retq ## encoding: [0xc3]
  %cmp = icmp ugt <16 x i16> %a0, %a1
  %sel = select <16 x i1> %cmp, <16 x i16> %a0, <16 x i16> %a1
  %sub = sub <16 x i16> %sel, %a1
  ret <16 x i16> %sub
}

define <32 x i16> @test_x86_avx2_paddus_w_512(<32 x i16> %a, <32 x i16> %b) {
; X86-AVX-LABEL: test_x86_avx2_paddus_w_512:
; X86-AVX:       ## %bb.0:
; X86-AVX-NEXT:    vpaddusw %ymm2, %ymm0, %ymm0 ## encoding: [0xc5,0xfd,0xdd,0xc2]
; X86-AVX-NEXT:    vpaddusw %ymm3, %ymm1, %ymm1 ## encoding: [0xc5,0xf5,0xdd,0xcb]
; X86-AVX-NEXT:    retl ## encoding: [0xc3]
;
; X86-AVX512VL-LABEL: test_x86_avx2_paddus_w_512:
; X86-AVX512VL:       ## %bb.0:
; X86-AVX512VL-NEXT:    vpaddusw %zmm1, %zmm0, %zmm0 ## encoding: [0x62,0xf1,0x7d,0x48,0xdd,0xc1]
; X86-AVX512VL-NEXT:    retl ## encoding: [0xc3]
;
; X64-AVX-LABEL: test_x86_avx2_paddus_w_512:
; X64-AVX:       ## %bb.0:
; X64-AVX-NEXT:    vpaddusw %ymm2, %ymm0, %ymm0 ## encoding: [0xc5,0xfd,0xdd,0xc2]
; X64-AVX-NEXT:    vpaddusw %ymm3, %ymm1, %ymm1 ## encoding: [0xc5,0xf5,0xdd,0xcb]
; X64-AVX-NEXT:    retq ## encoding: [0xc3]
;
; X64-AVX512VL-LABEL: test_x86_avx2_paddus_w_512:
; X64-AVX512VL:       ## %bb.0:
; X64-AVX512VL-NEXT:    vpaddusw %zmm1, %zmm0, %zmm0 ## encoding: [0x62,0xf1,0x7d,0x48,0xdd,0xc1]
; X64-AVX512VL-NEXT:    retq ## encoding: [0xc3]
  %1 = add <32 x i16> %a, %b
  %2 = icmp ugt <32 x i16> %a, %1
  %3 = select <32 x i1> %2, <32 x i16> <i16 -1, i16 -1, i16 -1, i16 -1, i16 -1, i16 -1, i16 -1, i16 -1, i16 -1, i16 -1, i16 -1, i16 -1, i16 -1, i16 -1, i16 -1, i16 -1, i16 -1, i16 -1, i16 -1, i16 -1, i16 -1, i16 -1, i16 -1, i16 -1, i16 -1, i16 -1, i16 -1, i16 -1, i16 -1, i16 -1, i16 -1, i16 -1>, <32 x i16> %1
  ret <32 x i16> %3
}

define <32 x i16> @test_x86_avx2_psubus_w_512(<32 x i16> %a, <32 x i16> %b) {
; X86-AVX-LABEL: test_x86_avx2_psubus_w_512:
; X86-AVX:       ## %bb.0:
; X86-AVX-NEXT:    vpsubusw %ymm2, %ymm0, %ymm0 ## encoding: [0xc5,0xfd,0xd9,0xc2]
; X86-AVX-NEXT:    vpsubusw %ymm3, %ymm1, %ymm1 ## encoding: [0xc5,0xf5,0xd9,0xcb]
; X86-AVX-NEXT:    retl ## encoding: [0xc3]
;
; X86-AVX512VL-LABEL: test_x86_avx2_psubus_w_512:
; X86-AVX512VL:       ## %bb.0:
; X86-AVX512VL-NEXT:    vpsubusw %zmm1, %zmm0, %zmm0 ## encoding: [0x62,0xf1,0x7d,0x48,0xd9,0xc1]
; X86-AVX512VL-NEXT:    retl ## encoding: [0xc3]
;
; X64-AVX-LABEL: test_x86_avx2_psubus_w_512:
; X64-AVX:       ## %bb.0:
; X64-AVX-NEXT:    vpsubusw %ymm2, %ymm0, %ymm0 ## encoding: [0xc5,0xfd,0xd9,0xc2]
; X64-AVX-NEXT:    vpsubusw %ymm3, %ymm1, %ymm1 ## encoding: [0xc5,0xf5,0xd9,0xcb]
; X64-AVX-NEXT:    retq ## encoding: [0xc3]
;
; X64-AVX512VL-LABEL: test_x86_avx2_psubus_w_512:
; X64-AVX512VL:       ## %bb.0:
; X64-AVX512VL-NEXT:    vpsubusw %zmm1, %zmm0, %zmm0 ## encoding: [0x62,0xf1,0x7d,0x48,0xd9,0xc1]
; X64-AVX512VL-NEXT:    retq ## encoding: [0xc3]
  %cmp = icmp ugt <32 x i16> %a, %b
  %sel = select <32 x i1> %cmp, <32 x i16> %a, <32 x i16> %b
  %sub = sub <32 x i16> %sel, %b
  ret <32 x i16> %sub
}
