; NOTE: Assertions have been autogenerated by utils/update_test_checks.py UTC_ARGS: --version 2
; RUN: opt -passes=inline < %s -S | FileCheck %s

; Test that instsimplify invoked by the inliner respects null_pointer_is_valid
; (by ensuring that the instruction is inserted into the function when invoking
; instsimplify).

define internal i1 @f(ptr %p) null_pointer_is_valid {
  %g = getelementptr inbounds i8, ptr %p, i32 -1
  %r = icmp eq ptr %g, null
  ret i1 %r
}

define i1 @g(ptr %p) null_pointer_is_valid {
; CHECK-LABEL: define i1 @g
; CHECK-SAME: (ptr [[P:%.*]]) #[[ATTR0:[0-9]+]] {
; CHECK-NEXT:    [[G_I:%.*]] = getelementptr inbounds i8, ptr [[P]], i32 -1
; CHECK-NEXT:    [[R_I:%.*]] = icmp eq ptr [[G_I]], null
; CHECK-NEXT:    ret i1 [[R_I]]
;
  %r = call i1 @f(ptr %p)
  ret i1 %r
}

define internal i1 @f2(ptr %p) {
  %g = getelementptr inbounds i8, ptr %p, i32 -1
  %r = icmp eq ptr %g, null
  ret i1 %r
}

define i1 @g2(ptr %p) null_pointer_is_valid {
; CHECK-LABEL: define i1 @g2
; CHECK-SAME: (ptr [[P:%.*]]) #[[ATTR0]] {
; CHECK-NEXT:    [[G_I:%.*]] = getelementptr inbounds i8, ptr [[P]], i32 -1
; CHECK-NEXT:    [[R_I:%.*]] = icmp eq ptr [[G_I]], null
; CHECK-NEXT:    ret i1 [[R_I]]
;
  %r = call i1 @f2(ptr %p)
  ret i1 %r
}

