; NOTE: Assertions have been autogenerated by utils/update_llc_test_checks.py
; RUN: llc -mtriple=arm-eabi -mattr=+neon,+fullfp16 %s -o - | FileCheck %s

define <8 x i8> @test_vrev64D8(ptr %A) nounwind {
; CHECK-LABEL: test_vrev64D8:
; CHECK:       @ %bb.0:
; CHECK-NEXT:    vldr d16, [r0]
; CHECK-NEXT:    vrev64.8 d16, d16
; CHECK-NEXT:    vmov r0, r1, d16
; CHECK-NEXT:    mov pc, lr
	%tmp1 = load <8 x i8>, ptr %A
	%tmp2 = shufflevector <8 x i8> %tmp1, <8 x i8> undef, <8 x i32> <i32 7, i32 6, i32 5, i32 4, i32 3, i32 2, i32 1, i32 0>
	ret <8 x i8> %tmp2
}

define <4 x i16> @test_vrev64D16(ptr %A) nounwind {
; CHECK-LABEL: test_vrev64D16:
; CHECK:       @ %bb.0:
; CHECK-NEXT:    vldr d16, [r0]
; CHECK-NEXT:    vrev64.16 d16, d16
; CHECK-NEXT:    vmov r0, r1, d16
; CHECK-NEXT:    mov pc, lr
	%tmp1 = load <4 x i16>, ptr %A
	%tmp2 = shufflevector <4 x i16> %tmp1, <4 x i16> undef, <4 x i32> <i32 3, i32 2, i32 1, i32 0>
	ret <4 x i16> %tmp2
}

define <4 x half> @test_vrev64Df16(ptr %A) nounwind {
; CHECK-LABEL: test_vrev64Df16:
; CHECK:       @ %bb.0:
; CHECK-NEXT:    vldr d16, [r0]
; CHECK-NEXT:    vrev64.16 d16, d16
; CHECK-NEXT:    vmov r0, r1, d16
; CHECK-NEXT:    mov pc, lr
	%tmp1 = load <4 x half>, ptr %A
	%tmp2 = shufflevector <4 x half> %tmp1, <4 x half> undef, <4 x i32> <i32 3, i32 2, i32 1, i32 0>
	ret <4 x half> %tmp2
}

define <2 x i32> @test_vrev64D32(ptr %A) nounwind {
; CHECK-LABEL: test_vrev64D32:
; CHECK:       @ %bb.0:
; CHECK-NEXT:    vldr d16, [r0]
; CHECK-NEXT:    vrev64.32 d16, d16
; CHECK-NEXT:    vmov r0, r1, d16
; CHECK-NEXT:    mov pc, lr
	%tmp1 = load <2 x i32>, ptr %A
	%tmp2 = shufflevector <2 x i32> %tmp1, <2 x i32> undef, <2 x i32> <i32 1, i32 0>
	ret <2 x i32> %tmp2
}

define <2 x float> @test_vrev64Df(ptr %A) nounwind {
; CHECK-LABEL: test_vrev64Df:
; CHECK:       @ %bb.0:
; CHECK-NEXT:    vldr d16, [r0]
; CHECK-NEXT:    vrev64.32 d16, d16
; CHECK-NEXT:    vmov r0, r1, d16
; CHECK-NEXT:    mov pc, lr
	%tmp1 = load <2 x float>, ptr %A
	%tmp2 = shufflevector <2 x float> %tmp1, <2 x float> undef, <2 x i32> <i32 1, i32 0>
	ret <2 x float> %tmp2
}

define <16 x i8> @test_vrev64Q8(ptr %A) nounwind {
; CHECK-LABEL: test_vrev64Q8:
; CHECK:       @ %bb.0:
; CHECK-NEXT:    vld1.64 {d16, d17}, [r0]
; CHECK-NEXT:    vrev64.8 q8, q8
; CHECK-NEXT:    vmov r0, r1, d16
; CHECK-NEXT:    vmov r2, r3, d17
; CHECK-NEXT:    mov pc, lr
	%tmp1 = load <16 x i8>, ptr %A
	%tmp2 = shufflevector <16 x i8> %tmp1, <16 x i8> undef, <16 x i32> <i32 7, i32 6, i32 5, i32 4, i32 3, i32 2, i32 1, i32 0, i32 15, i32 14, i32 13, i32 12, i32 11, i32 10, i32 9, i32 8>
	ret <16 x i8> %tmp2
}

define <8 x i16> @test_vrev64Q16(ptr %A) nounwind {
; CHECK-LABEL: test_vrev64Q16:
; CHECK:       @ %bb.0:
; CHECK-NEXT:    vld1.64 {d16, d17}, [r0]
; CHECK-NEXT:    vrev64.16 q8, q8
; CHECK-NEXT:    vmov r0, r1, d16
; CHECK-NEXT:    vmov r2, r3, d17
; CHECK-NEXT:    mov pc, lr
	%tmp1 = load <8 x i16>, ptr %A
	%tmp2 = shufflevector <8 x i16> %tmp1, <8 x i16> undef, <8 x i32> <i32 3, i32 2, i32 1, i32 0, i32 7, i32 6, i32 5, i32 4>
	ret <8 x i16> %tmp2
}

define <8 x half> @test_vrev64Qf16(ptr %A) nounwind {
; CHECK-LABEL: test_vrev64Qf16:
; CHECK:       @ %bb.0:
; CHECK-NEXT:    vld1.64 {d16, d17}, [r0]
; CHECK-NEXT:    vrev64.16 q8, q8
; CHECK-NEXT:    vmov r0, r1, d16
; CHECK-NEXT:    vmov r2, r3, d17
; CHECK-NEXT:    mov pc, lr
	%tmp1 = load <8 x half>, ptr %A
	%tmp2 = shufflevector <8 x half> %tmp1, <8 x half> undef, <8 x i32> <i32 3, i32 2, i32 1, i32 0, i32 7, i32 6, i32 5, i32 4>
	ret <8 x half> %tmp2
}

define <4 x i32> @test_vrev64Q32(ptr %A) nounwind {
; CHECK-LABEL: test_vrev64Q32:
; CHECK:       @ %bb.0:
; CHECK-NEXT:    vld1.64 {d16, d17}, [r0]
; CHECK-NEXT:    vrev64.32 q8, q8
; CHECK-NEXT:    vmov r0, r1, d16
; CHECK-NEXT:    vmov r2, r3, d17
; CHECK-NEXT:    mov pc, lr
	%tmp1 = load <4 x i32>, ptr %A
	%tmp2 = shufflevector <4 x i32> %tmp1, <4 x i32> undef, <4 x i32> <i32 1, i32 0, i32 3, i32 2>
	ret <4 x i32> %tmp2
}

define <4 x float> @test_vrev64Qf(ptr %A) nounwind {
; CHECK-LABEL: test_vrev64Qf:
; CHECK:       @ %bb.0:
; CHECK-NEXT:    vld1.64 {d16, d17}, [r0]
; CHECK-NEXT:    vrev64.32 q8, q8
; CHECK-NEXT:    vmov r0, r1, d16
; CHECK-NEXT:    vmov r2, r3, d17
; CHECK-NEXT:    mov pc, lr
	%tmp1 = load <4 x float>, ptr %A
	%tmp2 = shufflevector <4 x float> %tmp1, <4 x float> undef, <4 x i32> <i32 1, i32 0, i32 3, i32 2>
	ret <4 x float> %tmp2
}

define <8 x i8> @test_vrev32D8(ptr %A) nounwind {
; CHECK-LABEL: test_vrev32D8:
; CHECK:       @ %bb.0:
; CHECK-NEXT:    vldr d16, [r0]
; CHECK-NEXT:    vrev32.8 d16, d16
; CHECK-NEXT:    vmov r0, r1, d16
; CHECK-NEXT:    mov pc, lr
	%tmp1 = load <8 x i8>, ptr %A
	%tmp2 = shufflevector <8 x i8> %tmp1, <8 x i8> undef, <8 x i32> <i32 3, i32 2, i32 1, i32 0, i32 7, i32 6, i32 5, i32 4>
	ret <8 x i8> %tmp2
}

define <4 x i16> @test_vrev32D16(ptr %A) nounwind {
; CHECK-LABEL: test_vrev32D16:
; CHECK:       @ %bb.0:
; CHECK-NEXT:    vldr d16, [r0]
; CHECK-NEXT:    vrev32.16 d16, d16
; CHECK-NEXT:    vmov r0, r1, d16
; CHECK-NEXT:    mov pc, lr
	%tmp1 = load <4 x i16>, ptr %A
	%tmp2 = shufflevector <4 x i16> %tmp1, <4 x i16> undef, <4 x i32> <i32 1, i32 0, i32 3, i32 2>
	ret <4 x i16> %tmp2
}

define <4 x half> @test_vrev32Df16(ptr %A) nounwind {
; CHECK-LABEL: test_vrev32Df16:
; CHECK:       @ %bb.0:
; CHECK-NEXT:    vldr d16, [r0]
; CHECK-NEXT:    vrev32.16 d16, d16
; CHECK-NEXT:    vmov r0, r1, d16
; CHECK-NEXT:    mov pc, lr
	%tmp1 = load <4 x half>, ptr %A
	%tmp2 = shufflevector <4 x half> %tmp1, <4 x half> undef, <4 x i32> <i32 1, i32 0, i32 3, i32 2>
	ret <4 x half> %tmp2
}

define <16 x i8> @test_vrev32Q8(ptr %A) nounwind {
; CHECK-LABEL: test_vrev32Q8:
; CHECK:       @ %bb.0:
; CHECK-NEXT:    vld1.64 {d16, d17}, [r0]
; CHECK-NEXT:    vrev32.8 q8, q8
; CHECK-NEXT:    vmov r0, r1, d16
; CHECK-NEXT:    vmov r2, r3, d17
; CHECK-NEXT:    mov pc, lr
	%tmp1 = load <16 x i8>, ptr %A
	%tmp2 = shufflevector <16 x i8> %tmp1, <16 x i8> undef, <16 x i32> <i32 3, i32 2, i32 1, i32 0, i32 7, i32 6, i32 5, i32 4, i32 11, i32 10, i32 9, i32 8, i32 15, i32 14, i32 13, i32 12>
	ret <16 x i8> %tmp2
}

define <8 x i16> @test_vrev32Q16(ptr %A) nounwind {
; CHECK-LABEL: test_vrev32Q16:
; CHECK:       @ %bb.0:
; CHECK-NEXT:    vld1.64 {d16, d17}, [r0]
; CHECK-NEXT:    vrev32.16 q8, q8
; CHECK-NEXT:    vmov r0, r1, d16
; CHECK-NEXT:    vmov r2, r3, d17
; CHECK-NEXT:    mov pc, lr
	%tmp1 = load <8 x i16>, ptr %A
	%tmp2 = shufflevector <8 x i16> %tmp1, <8 x i16> undef, <8 x i32> <i32 1, i32 0, i32 3, i32 2, i32 5, i32 4, i32 7, i32 6>
	ret <8 x i16> %tmp2
}

define <8 x half> @test_vrev32Qf16(ptr %A) nounwind {
; CHECK-LABEL: test_vrev32Qf16:
; CHECK:       @ %bb.0:
; CHECK-NEXT:    vld1.64 {d16, d17}, [r0]
; CHECK-NEXT:    vrev32.16 q8, q8
; CHECK-NEXT:    vmov r0, r1, d16
; CHECK-NEXT:    vmov r2, r3, d17
; CHECK-NEXT:    mov pc, lr
	%tmp1 = load <8 x half>, ptr %A
	%tmp2 = shufflevector <8 x half> %tmp1, <8 x half> undef, <8 x i32> <i32 1, i32 0, i32 3, i32 2, i32 5, i32 4, i32 7, i32 6>
	ret <8 x half> %tmp2
}

define <8 x i8> @test_vrev16D8(ptr %A) nounwind {
; CHECK-LABEL: test_vrev16D8:
; CHECK:       @ %bb.0:
; CHECK-NEXT:    vldr d16, [r0]
; CHECK-NEXT:    vrev16.8 d16, d16
; CHECK-NEXT:    vmov r0, r1, d16
; CHECK-NEXT:    mov pc, lr
	%tmp1 = load <8 x i8>, ptr %A
	%tmp2 = shufflevector <8 x i8> %tmp1, <8 x i8> undef, <8 x i32> <i32 1, i32 0, i32 3, i32 2, i32 5, i32 4, i32 7, i32 6>
	ret <8 x i8> %tmp2
}

define <16 x i8> @test_vrev16Q8(ptr %A) nounwind {
; CHECK-LABEL: test_vrev16Q8:
; CHECK:       @ %bb.0:
; CHECK-NEXT:    vld1.64 {d16, d17}, [r0]
; CHECK-NEXT:    vrev16.8 q8, q8
; CHECK-NEXT:    vmov r0, r1, d16
; CHECK-NEXT:    vmov r2, r3, d17
; CHECK-NEXT:    mov pc, lr
	%tmp1 = load <16 x i8>, ptr %A
	%tmp2 = shufflevector <16 x i8> %tmp1, <16 x i8> undef, <16 x i32> <i32 1, i32 0, i32 3, i32 2, i32 5, i32 4, i32 7, i32 6, i32 9, i32 8, i32 11, i32 10, i32 13, i32 12, i32 15, i32 14>
	ret <16 x i8> %tmp2
}

; Undef shuffle indices should not prevent matching to VREV:

define <8 x i8> @test_vrev64D8_undef(ptr %A) nounwind {
; CHECK-LABEL: test_vrev64D8_undef:
; CHECK:       @ %bb.0:
; CHECK-NEXT:    vldr d16, [r0]
; CHECK-NEXT:    vrev64.8 d16, d16
; CHECK-NEXT:    vmov r0, r1, d16
; CHECK-NEXT:    mov pc, lr
	%tmp1 = load <8 x i8>, ptr %A
	%tmp2 = shufflevector <8 x i8> %tmp1, <8 x i8> undef, <8 x i32> <i32 7, i32 undef, i32 undef, i32 4, i32 3, i32 2, i32 1, i32 0>
	ret <8 x i8> %tmp2
}

define <8 x i16> @test_vrev32Q16_undef(ptr %A) nounwind {
; CHECK-LABEL: test_vrev32Q16_undef:
; CHECK:       @ %bb.0:
; CHECK-NEXT:    vld1.64 {d16, d17}, [r0]
; CHECK-NEXT:    vrev32.16 q8, q8
; CHECK-NEXT:    vmov r0, r1, d16
; CHECK-NEXT:    vmov r2, r3, d17
; CHECK-NEXT:    mov pc, lr
	%tmp1 = load <8 x i16>, ptr %A
	%tmp2 = shufflevector <8 x i16> %tmp1, <8 x i16> undef, <8 x i32> <i32 undef, i32 0, i32 undef, i32 2, i32 5, i32 4, i32 7, i32 undef>
	ret <8 x i16> %tmp2
}

define <8 x half> @test_vrev32Qf16_undef(ptr %A) nounwind {
; CHECK-LABEL: test_vrev32Qf16_undef:
; CHECK:       @ %bb.0:
; CHECK-NEXT:    vld1.64 {d16, d17}, [r0]
; CHECK-NEXT:    vrev32.16 q8, q8
; CHECK-NEXT:    vmov r0, r1, d16
; CHECK-NEXT:    vmov r2, r3, d17
; CHECK-NEXT:    mov pc, lr
	%tmp1 = load <8 x half>, ptr %A
	%tmp2 = shufflevector <8 x half> %tmp1, <8 x half> undef, <8 x i32> <i32 undef, i32 0, i32 undef, i32 2, i32 5, i32 4, i32 7, i32 undef>
	ret <8 x half> %tmp2
}

; A vcombine feeding a VREV should not obscure things.  Radar 8597007.

define void @test_with_vcombine(ptr %v) nounwind {
; CHECK-LABEL: test_with_vcombine:
; CHECK:       @ %bb.0:
; CHECK-NEXT:    vld1.64 {d16, d17}, [r0:128]
; CHECK-NEXT:    vadd.f32 d18, d17, d17
; CHECK-NEXT:    vrev64.32 d16, d16
; CHECK-NEXT:    vrev64.32 d17, d18
; CHECK-NEXT:    vst1.64 {d16, d17}, [r0:128]
; CHECK-NEXT:    mov pc, lr
  %tmp1 = load <4 x float>, ptr %v, align 16
  %tmp2 = bitcast <4 x float> %tmp1 to <2 x double>
  %tmp3 = extractelement <2 x double> %tmp2, i32 0
  %tmp4 = bitcast double %tmp3 to <2 x float>
  %tmp5 = extractelement <2 x double> %tmp2, i32 1
  %tmp6 = bitcast double %tmp5 to <2 x float>
  %tmp7 = fadd <2 x float> %tmp6, %tmp6
  %tmp8 = shufflevector <2 x float> %tmp4, <2 x float> %tmp7, <4 x i32> <i32 1, i32 0, i32 3, i32 2>
  store <4 x float> %tmp8, ptr %v, align 16
  ret void
}

; The type <2 x i16> is legalized to <2 x i32> and need to be trunc-stored
; to <2 x i16> when stored to memory.
define void @test_vrev64(ptr nocapture %source, ptr nocapture %dst) nounwind ssp {
; CHECK-LABEL: test_vrev64:
; CHECK:       @ %bb.0: @ %entry
; CHECK-NEXT:    vld1.32 {d16, d17}, [r0]
; CHECK-NEXT:    vmov.u16 r0, d17[2]
; CHECK-NEXT:    vmov.u16 r2, d17[1]
; CHECK-NEXT:    vmov.32 d16[0], r0
; CHECK-NEXT:    vmov.32 d16[1], r2
; CHECK-NEXT:    vuzp.16 d16, d17
; CHECK-NEXT:    vst1.32 {d16[0]}, [r1:32]
; CHECK-NEXT:    mov pc, lr
entry:
  %tmp2 = load <8 x i16>, ptr %source, align 4
  %tmp3 = extractelement <8 x i16> %tmp2, i32 6
  %tmp5 = insertelement <2 x i16> undef, i16 %tmp3, i32 0
  %tmp9 = extractelement <8 x i16> %tmp2, i32 5
  %tmp11 = insertelement <2 x i16> %tmp5, i16 %tmp9, i32 1
  store <2 x i16> %tmp11, ptr %dst, align 4
  ret void
}

; Test vrev of float4
define void @float_vrev64(ptr nocapture %source, ptr nocapture %dest) nounwind noinline ssp {
; CHECK-LABEL: float_vrev64:
; CHECK:       @ %bb.0: @ %entry
; CHECK-NEXT:    vmov.i32 q8, #0x0
; CHECK-NEXT:    vld1.32 {d18, d19}, [r0]
; CHECK-NEXT:    add r0, r1, #176
; CHECK-NEXT:    vext.32 q8, q9, q8, #3
; CHECK-NEXT:    vrev64.32 q8, q8
; CHECK-NEXT:    vst1.32 {d16, d17}, [r0]
; CHECK-NEXT:    mov pc, lr
entry:
  %tmp2 = load <4 x float>, ptr %source, align 4
  %tmp5 = shufflevector <4 x float> <float 0.000000e+00, float undef, float undef, float undef>, <4 x float> %tmp2, <4 x i32> <i32 0, i32 7, i32 0, i32 0>
  %arrayidx8 = getelementptr inbounds <4 x float>, ptr %dest, i32 11
  store <4 x float> %tmp5, ptr %arrayidx8, align 4
  ret void
}

define <4 x i32> @test_vrev32_bswap(<4 x i32> %source) nounwind {
; CHECK-LABEL: test_vrev32_bswap:
; CHECK:       @ %bb.0:
; CHECK-NEXT:    vmov d17, r2, r3
; CHECK-NEXT:    vmov d16, r0, r1
; CHECK-NEXT:    vrev32.8 q8, q8
; CHECK-NEXT:    vmov r0, r1, d16
; CHECK-NEXT:    vmov r2, r3, d17
; CHECK-NEXT:    mov pc, lr
  %bswap = call <4 x i32> @llvm.bswap.v4i32(<4 x i32> %source)
  ret <4 x i32> %bswap
}

declare <4 x i32> @llvm.bswap.v4i32(<4 x i32>) nounwind readnone
