; NOTE: Assertions have been autogenerated by utils/update_llc_test_checks.py
; RUN: llc < %s -mtriple=aarch64-apple-darwin  | FileCheck %s

declare i16 @llvm.bswap.i16(i16)
declare i32 @llvm.bswap.i32(i32)
declare i64 @llvm.bswap.i64(i64)

define i1 @test1(i16 %arg) {
; CHECK-LABEL: test1:
; CHECK:       ; %bb.0:
; CHECK-NEXT:    mov w0, #1
; CHECK-NEXT:    ret
  %a = or i16 %arg, 511
  %b = call i16 @llvm.bswap.i16(i16 %a)
  %and = and i16 %b, 256
  %res = icmp eq i16 %and, 256
  ret i1 %res
}

define i1 @test2(i16 %arg) {
; CHECK-LABEL: test2:
; CHECK:       ; %bb.0:
; CHECK-NEXT:    mov w0, #1
; CHECK-NEXT:    ret
  %a = or i16 %arg, 1
  %b = call i16 @llvm.bswap.i16(i16 %a)
  %and = and i16 %b, 256
  %res = icmp eq i16 %and, 256
  ret i1 %res
}

define i1 @test3(i16 %arg) {
; CHECK-LABEL: test3:
; CHECK:       ; %bb.0:
; CHECK-NEXT:    mov w0, #1
; CHECK-NEXT:    ret
  %a = or i16 %arg, 256
  %b = call i16 @llvm.bswap.i16(i16 %a)
  %and = and i16 %b, 1
  %res = icmp eq i16 %and, 1
  ret i1 %res
}

define i1 @test4(i32 %arg) {
; CHECK-LABEL: test4:
; CHECK:       ; %bb.0:
; CHECK-NEXT:    mov w0, #1
; CHECK-NEXT:    ret
  %a = or i32 %arg, 2147483647  ; i32_MAX
  %b = call i32 @llvm.bswap.i32(i32 %a)
  %and = and i32 %b, 127
  %res = icmp eq i32 %and, 127
  ret i1 %res
}

define i8 @demand_one_byte0(i32 %x) {
; CHECK-LABEL: demand_one_byte0:
; CHECK:       ; %bb.0:
; CHECK-NEXT:    rev w0, w0
; CHECK-NEXT:    ret
  %b = call i32 @llvm.bswap.i32(i32 %x)
  %r = trunc i32 %b to i8
  ret i8 %r
}

define i32 @demand_one_byte1(i32 %x) {
; CHECK-LABEL: demand_one_byte1:
; CHECK:       ; %bb.0:
; CHECK-NEXT:    lsr w8, w0, #8
; CHECK-NEXT:    and w0, w8, #0xff00
; CHECK-NEXT:    ret
  %b = call i32 @llvm.bswap.i32(i32 %x)
  %r = and i32 %b, 65280 ; 0x0000ff00
  ret i32 %r
}

define i32 @demand_one_byte2(i32 %x) {
; CHECK-LABEL: demand_one_byte2:
; CHECK:       ; %bb.0:
; CHECK-NEXT:    lsl w8, w0, #8
; CHECK-NEXT:    orr w0, w8, #0xff00ffff
; CHECK-NEXT:    ret
  %b = call i32 @llvm.bswap.i32(i32 %x)
  %r = or i32 %b, 4278255615 ; 0xff00ffff
  ret i32 %r
}

define i64 @demand_one_byte3(i64 %x) {
; CHECK-LABEL: demand_one_byte3:
; CHECK:       ; %bb.0:
; CHECK-NEXT:    and x0, x0, #0xff
; CHECK-NEXT:    ret
  %b = call i64 @llvm.bswap.i64(i64 %x)
  %r = lshr i64 %b, 56
  ret i64 %r
}

define void @demand_one_loaded_byte(ptr %xp, ptr %yp) {
; CHECK-LABEL: demand_one_loaded_byte:
; CHECK:       ; %bb.0:
; CHECK-NEXT:    ldrb w8, [x0, #4]
; CHECK-NEXT:    strb w8, [x1]
; CHECK-NEXT:    ret
  %x = load i64, ptr %xp, align 8
  %x_zzzz7654 = lshr i64 %x, 32
  %x_z7654zzz = shl nuw nsw i64 %x_zzzz7654, 24
  %x_4zzz = trunc i64 %x_z7654zzz to i32
  %y = load i32, ptr %yp, align 4
  %y_321z = and i32 %y, -256
  %x_zzz4 = call i32 @llvm.bswap.i32(i32 %x_4zzz)
  %r = or i32 %x_zzz4, %y_321z
  store i32 %r, ptr %yp, align 4
  ret void
}
