; NOTE: Assertions have been autogenerated by utils/update_test_checks.py
; RUN: opt < %s -passes=ipsccp -S | FileCheck %s --check-prefixes=CHECK,IPSCCP
; RUN: opt < %s -passes=sccp -S | FileCheck %s --check-prefixes=CHECK,SCCP

declare void @use(i1)
declare i32 @get_i32()

define void @range_attribute(i32 range(i32 0, 10) %v) {
; CHECK-LABEL: @range_attribute(
; CHECK-NEXT:    call void @use(i1 true)
; CHECK-NEXT:    [[C2:%.*]] = icmp ult i32 [[V:%.*]], 9
; CHECK-NEXT:    call void @use(i1 [[C2]])
; CHECK-NEXT:    call void @use(i1 false)
; CHECK-NEXT:    [[C4:%.*]] = icmp ugt i32 [[V]], 8
; CHECK-NEXT:    call void @use(i1 [[C4]])
; CHECK-NEXT:    ret void
;
  %c1 = icmp ult i32 %v, 10
  call void @use(i1 %c1)
  %c2 = icmp ult i32 %v, 9
  call void @use(i1 %c2)
  %c3 = icmp ugt i32 %v, 9
  call void @use(i1 %c3)
  %c4 = icmp ugt i32 %v, 8
  call void @use(i1 %c4)
  ret void
}

define i32 @range_attribute_single(i32 range(i32 0, 1) %v) {
; IPSCCP-LABEL: @range_attribute_single(
; IPSCCP-NEXT:    ret i32 0
;
; SCCP-LABEL: @range_attribute_single(
; SCCP-NEXT:    ret i32 [[V:%.*]]
;
  ret i32 %v
}

define void @call_range_attribute() {
; CHECK-LABEL: @call_range_attribute(
; CHECK-NEXT:    [[V:%.*]] = call range(i32 0, 10) i32 @get_i32()
; CHECK-NEXT:    call void @use(i1 true)
; CHECK-NEXT:    [[C2:%.*]] = icmp ult i32 [[V]], 9
; CHECK-NEXT:    call void @use(i1 [[C2]])
; CHECK-NEXT:    call void @use(i1 false)
; CHECK-NEXT:    [[C4:%.*]] = icmp ugt i32 [[V]], 8
; CHECK-NEXT:    call void @use(i1 [[C4]])
; CHECK-NEXT:    ret void
;
  %v = call range(i32 0, 10) i32 @get_i32()
  %c1 = icmp ult i32 %v, 10
  call void @use(i1 %c1)
  %c2 = icmp ult i32 %v, 9
  call void @use(i1 %c2)
  %c3 = icmp ugt i32 %v, 9
  call void @use(i1 %c3)
  %c4 = icmp ugt i32 %v, 8
  call void @use(i1 %c4)
  ret void
}


declare range(i32 0, 10) i32 @get_i32_in_range()

define void @call_range_result() {
; CHECK-LABEL: @call_range_result(
; CHECK-NEXT:    [[V:%.*]] = call i32 @get_i32_in_range()
; CHECK-NEXT:    call void @use(i1 true)
; CHECK-NEXT:    [[C2:%.*]] = icmp ult i32 [[V]], 9
; CHECK-NEXT:    call void @use(i1 [[C2]])
; CHECK-NEXT:    call void @use(i1 false)
; CHECK-NEXT:    [[C4:%.*]] = icmp ugt i32 [[V]], 8
; CHECK-NEXT:    call void @use(i1 [[C4]])
; CHECK-NEXT:    ret void
;
  %v = call i32 @get_i32_in_range()
  %c1 = icmp ult i32 %v, 10
  call void @use(i1 %c1)
  %c2 = icmp ult i32 %v, 9
  call void @use(i1 %c2)
  %c3 = icmp ugt i32 %v, 9
  call void @use(i1 %c3)
  %c4 = icmp ugt i32 %v, 8
  call void @use(i1 %c4)
  ret void
}

define internal i1 @ip_cmp_range_attribute(i32 %v) {
; IPSCCP-LABEL: @ip_cmp_range_attribute(
; IPSCCP-NEXT:    ret i1 poison
;
; SCCP-LABEL: @ip_cmp_range_attribute(
; SCCP-NEXT:    [[C:%.*]] = icmp ult i32 [[V:%.*]], 10
; SCCP-NEXT:    ret i1 [[C]]
;
  %c = icmp ult i32 %v, 10
  ret i1 %c
}

define i1 @ip_range_attribute(i32 range(i32 0, 10) %v) {
; IPSCCP-LABEL: @ip_range_attribute(
; IPSCCP-NEXT:    [[C:%.*]] = call i1 @ip_cmp_range_attribute(i32 [[V:%.*]])
; IPSCCP-NEXT:    ret i1 true
;
; SCCP-LABEL: @ip_range_attribute(
; SCCP-NEXT:    [[C:%.*]] = call i1 @ip_cmp_range_attribute(i32 [[V:%.*]])
; SCCP-NEXT:    ret i1 [[C]]
;
  %c = call i1 @ip_cmp_range_attribute(i32 %v)
  ret i1 %c
}

define internal i1 @ip_cmp_range_call(i32 %v) {
; IPSCCP-LABEL: @ip_cmp_range_call(
; IPSCCP-NEXT:    ret i1 poison
;
; SCCP-LABEL: @ip_cmp_range_call(
; SCCP-NEXT:    [[C:%.*]] = icmp ult i32 [[V:%.*]], 10
; SCCP-NEXT:    ret i1 [[C]]
;
  %c = icmp ult i32 %v, 10
  ret i1 %c
}

define i1 @ip_range_call() {
; IPSCCP-LABEL: @ip_range_call(
; IPSCCP-NEXT:    [[V:%.*]] = call range(i32 0, 10) i32 @get_i32()
; IPSCCP-NEXT:    [[C:%.*]] = call i1 @ip_cmp_range_call(i32 [[V]])
; IPSCCP-NEXT:    ret i1 true
;
; SCCP-LABEL: @ip_range_call(
; SCCP-NEXT:    [[V:%.*]] = call range(i32 0, 10) i32 @get_i32()
; SCCP-NEXT:    [[C:%.*]] = call i1 @ip_cmp_range_call(i32 [[V]])
; SCCP-NEXT:    ret i1 [[C]]
;
  %v = call range(i32 0, 10) i32 @get_i32()
  %c = call i1 @ip_cmp_range_call(i32 %v)
  ret i1 %c
}

define internal i1 @ip_cmp_range_result(i32 %v) {
; IPSCCP-LABEL: @ip_cmp_range_result(
; IPSCCP-NEXT:    ret i1 poison
;
; SCCP-LABEL: @ip_cmp_range_result(
; SCCP-NEXT:    [[C:%.*]] = icmp ult i32 [[V:%.*]], 10
; SCCP-NEXT:    ret i1 [[C]]
;
  %c = icmp ult i32 %v, 10
  ret i1 %c
}

define i1 @ip_range_result() {
; IPSCCP-LABEL: @ip_range_result(
; IPSCCP-NEXT:    [[V:%.*]] = call range(i32 0, 10) i32 @get_i32()
; IPSCCP-NEXT:    [[C:%.*]] = call i1 @ip_cmp_range_result(i32 [[V]])
; IPSCCP-NEXT:    ret i1 true
;
; SCCP-LABEL: @ip_range_result(
; SCCP-NEXT:    [[V:%.*]] = call range(i32 0, 10) i32 @get_i32()
; SCCP-NEXT:    [[C:%.*]] = call i1 @ip_cmp_range_result(i32 [[V]])
; SCCP-NEXT:    ret i1 [[C]]
;
  %v = call range(i32 0, 10) i32 @get_i32()
  %c = call i1 @ip_cmp_range_result(i32 %v)
  ret i1 %c
}

define internal i1 @ip_cmp_with_range_attribute(i32 range(i32 0, 10) %v) {
; IPSCCP-LABEL: @ip_cmp_with_range_attribute(
; IPSCCP-NEXT:    ret i1 poison
;
; SCCP-LABEL: @ip_cmp_with_range_attribute(
; SCCP-NEXT:    [[C:%.*]] = icmp eq i32 [[V:%.*]], 5
; SCCP-NEXT:    ret i1 [[C]]
;
  %c = icmp eq i32 %v, 5
  ret i1 %c
}

define i1 @ip_range_attribute_constant() {
; IPSCCP-LABEL: @ip_range_attribute_constant(
; IPSCCP-NEXT:    [[C:%.*]] = call i1 @ip_cmp_with_range_attribute(i32 5)
; IPSCCP-NEXT:    ret i1 true
;
; SCCP-LABEL: @ip_range_attribute_constant(
; SCCP-NEXT:    [[C:%.*]] = call i1 @ip_cmp_with_range_attribute(i32 5)
; SCCP-NEXT:    ret i1 [[C]]
;
  %c = call i1 @ip_cmp_with_range_attribute(i32 5)
  ret i1 %c
}

define internal i1 @ip_cmp_attribute_overdefined_callee(i32 range(i32 0, 10) %x) {
; IPSCCP-LABEL: @ip_cmp_attribute_overdefined_callee(
; IPSCCP-NEXT:    ret i1 poison
;
; SCCP-LABEL: @ip_cmp_attribute_overdefined_callee(
; SCCP-NEXT:    ret i1 true
;
  %cmp = icmp ult i32 %x, 10
  ret i1 %cmp
}

define i1 @ip_cmp_attribute_overdefined_caller(i32 %x) {
; IPSCCP-LABEL: @ip_cmp_attribute_overdefined_caller(
; IPSCCP-NEXT:    [[RES:%.*]] = call i1 @ip_cmp_attribute_overdefined_callee(i32 [[X:%.*]])
; IPSCCP-NEXT:    ret i1 true
;
; SCCP-LABEL: @ip_cmp_attribute_overdefined_caller(
; SCCP-NEXT:    [[RES:%.*]] = call i1 @ip_cmp_attribute_overdefined_callee(i32 [[X:%.*]])
; SCCP-NEXT:    ret i1 [[RES]]
;
  %res = call i1 @ip_cmp_attribute_overdefined_callee(i32 %x)
  ret i1 %res
}

define internal i1 @ip_cmp_attribute_intersect_callee(i32 range(i32 0, 10) %x) {
; IPSCCP-LABEL: @ip_cmp_attribute_intersect_callee(
; IPSCCP-NEXT:    ret i1 poison
;
; SCCP-LABEL: @ip_cmp_attribute_intersect_callee(
; SCCP-NEXT:    [[CMP2:%.*]] = icmp uge i32 [[X:%.*]], 5
; SCCP-NEXT:    [[AND:%.*]] = and i1 true, [[CMP2]]
; SCCP-NEXT:    ret i1 [[AND]]
;
  %cmp1 = icmp ult i32 %x, 10
  %cmp2 = icmp uge i32 %x, 5
  %and = and i1 %cmp1, %cmp2
  ret i1 %and
}

define i1 @ip_cmp_attribute_intersect_caller(i32 range(i32 5, 15) %x) {
; IPSCCP-LABEL: @ip_cmp_attribute_intersect_caller(
; IPSCCP-NEXT:    [[RES:%.*]] = call i1 @ip_cmp_attribute_intersect_callee(i32 [[X:%.*]])
; IPSCCP-NEXT:    ret i1 true
;
; SCCP-LABEL: @ip_cmp_attribute_intersect_caller(
; SCCP-NEXT:    [[RES:%.*]] = call i1 @ip_cmp_attribute_intersect_callee(i32 [[X:%.*]])
; SCCP-NEXT:    ret i1 [[RES]]
;
  %res = call i1 @ip_cmp_attribute_intersect_callee(i32 %x)
  ret i1 %res
}
