; NOTE: Assertions have been autogenerated by utils/update_test_checks.py
; RUN: opt -passes=memcpyopt -S < %s -verify-memoryssa | FileCheck %s

declare void @llvm.memcpy.p0.p0.i64(ptr nocapture, ptr nocapture, i64, i1) nounwind

@undef = internal constant i32 undef, align 4
define void @test_undef() nounwind {
; CHECK-LABEL: @test_undef(
; CHECK-NEXT:    [[A:%.*]] = alloca i32, align 4
; CHECK-NEXT:    call void @llvm.memset.p0.i64(ptr align 4 [[A]], i8 undef, i64 4, i1 false)
; CHECK-NEXT:    ret void
;
  %a = alloca i32, align 4
  call void @llvm.memcpy.p0.p0.i64(ptr align 4 %a, ptr align 4 @undef, i64 4, i1 false)
  ret void
}

@i32x3 = internal constant [3 x i32] [i32 -1, i32 -1, i32 -1], align 4
define void @test_i32x3() nounwind {
; CHECK-LABEL: @test_i32x3(
; CHECK-NEXT:    [[A:%.*]] = alloca [3 x i32], align 4
; CHECK-NEXT:    call void @llvm.memset.p0.i64(ptr align 4 [[A]], i8 -1, i64 12, i1 false)
; CHECK-NEXT:    ret void
;
  %a = alloca [3 x i32], align 4
  call void @llvm.memcpy.p0.p0.i64(ptr align 4 %a, ptr align 4 @i32x3, i64 12, i1 false)
  ret void
}

@i32x3_undef = internal constant [3 x i32] [i32 -1, i32 undef, i32 -1], align 4
define void @test_i32x3_undef() nounwind {
; CHECK-LABEL: @test_i32x3_undef(
; CHECK-NEXT:    [[A:%.*]] = alloca [3 x i32], align 4
; CHECK-NEXT:    call void @llvm.memset.p0.i64(ptr align 4 [[A]], i8 -1, i64 12, i1 false)
; CHECK-NEXT:    ret void
;
  %a = alloca [3 x i32], align 4
  call void @llvm.memcpy.p0.p0.i64(ptr align 4 %a, ptr align 4 @i32x3_undef, i64 12, i1 false)
  ret void
}

%struct.bitfield = type { i8, [3 x i8] }
@bitfield = private unnamed_addr constant %struct.bitfield { i8 -86, [3 x i8] [i8 -86, i8 -86, i8 -86] }, align 4
define void @test_bitfield() nounwind {
; CHECK-LABEL: @test_bitfield(
; CHECK-NEXT:    [[A:%.*]] = alloca [[STRUCT_BITFIELD:%.*]], align 4
; CHECK-NEXT:    call void @llvm.memset.p0.i64(ptr align 4 [[A]], i8 -86, i64 4, i1 false)
; CHECK-NEXT:    ret void
;
  %a = alloca %struct.bitfield, align 4
  call void @llvm.memcpy.p0.p0.i64(ptr align 4 %a, ptr align 4 @bitfield, i64 4, i1 false)
  ret void
}

@i1x16_zero = internal constant <16 x i1> <i1 0, i1 0, i1 0, i1 0, i1 0, i1 0, i1 0, i1 0, i1 0, i1 0, i1 0, i1 0, i1 0, i1 0, i1 0, i1 0>, align 4
define void @test_i1x16_zero() nounwind {
; CHECK-LABEL: @test_i1x16_zero(
; CHECK-NEXT:    [[A:%.*]] = alloca <16 x i1>, align 4
; CHECK-NEXT:    call void @llvm.memset.p0.i64(ptr align 4 [[A]], i8 0, i64 16, i1 false)
; CHECK-NEXT:    ret void
;
  %a = alloca <16 x i1>, align 4
  call void @llvm.memcpy.p0.p0.i64(ptr align 4 %a, ptr align 4 @i1x16_zero, i64 16, i1 false)
  ret void
}

; i1 isn't currently handled. Should it?
@i1x16_one = internal constant <16 x i1> <i1 1, i1 1, i1 1, i1 1, i1 1, i1 1, i1 1, i1 1, i1 1, i1 1, i1 1, i1 1, i1 1, i1 1, i1 1, i1 1>, align 4
define void @test_i1x16_one() nounwind {
; CHECK-LABEL: @test_i1x16_one(
; CHECK-NEXT:    [[A:%.*]] = alloca <16 x i1>, align 4
; CHECK-NEXT:    call void @llvm.memcpy.p0.p0.i64(ptr align 4 [[A]], ptr align 4 @i1x16_one, i64 16, i1 false)
; CHECK-NEXT:    ret void
;
  %a = alloca <16 x i1>, align 4
  call void @llvm.memcpy.p0.p0.i64(ptr align 4 %a, ptr align 4 @i1x16_one, i64 16, i1 false)
  ret void
}

@half = internal constant half 0xH0000, align 4
define void @test_half() nounwind {
; CHECK-LABEL: @test_half(
; CHECK-NEXT:    [[A:%.*]] = alloca half, align 4
; CHECK-NEXT:    call void @llvm.memset.p0.i64(ptr align 4 [[A]], i8 0, i64 2, i1 false)
; CHECK-NEXT:    ret void
;
  %a = alloca half, align 4
  call void @llvm.memcpy.p0.p0.i64(ptr align 4 %a, ptr align 4 @half, i64 2, i1 false)
  ret void
}
