; RUN: llvm-mc -triple=amdgcn -mcpu=gfx1200 -show-encoding %s | FileCheck --check-prefixes=GFX12 %s

image_load v[0:3], v0, s[0:7] dmask:0xf dim:SQ_RSRC_IMG_1D
// GFX12: encoding: [0x00,0x00,0xc0,0xd3,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00]

image_load v[1:4], [v2, v3], s[4:11] dmask:0xf dim:SQ_RSRC_IMG_2D
// GFX12: encoding: [0x01,0x00,0xc0,0xd3,0x01,0x08,0x00,0x00,0x02,0x03,0x00,0x00]

image_load v[4:7], [v4, v5, v6], s[8:15] dmask:0xf dim:SQ_RSRC_IMG_3D
// GFX12: encoding: [0x02,0x00,0xc0,0xd3,0x04,0x10,0x00,0x00,0x04,0x05,0x06,0x00]

image_load v[252:255], [v4, v5, v6], s[8:15] dmask:0xf dim:SQ_RSRC_IMG_CUBE
// GFX12: encoding: [0x03,0x00,0xc0,0xd3,0xfc,0x10,0x00,0x00,0x04,0x05,0x06,0x00]

image_load v[0:3], [v4, v5], s[8:15] dmask:0xf dim:SQ_RSRC_IMG_1D_ARRAY
// GFX12: encoding: [0x04,0x00,0xc0,0xd3,0x00,0x10,0x00,0x00,0x04,0x05,0x00,0x00]

image_load v[0:3], [v4, v5, v6], s[8:15] dmask:0xf dim:SQ_RSRC_IMG_2D_ARRAY
// GFX12: encoding: [0x05,0x00,0xc0,0xd3,0x00,0x10,0x00,0x00,0x04,0x05,0x06,0x00]

image_load v[0:3], [v4, v5, v6], s[8:15] dmask:0xf dim:SQ_RSRC_IMG_2D_MSAA
// GFX12: encoding: [0x06,0x00,0xc0,0xd3,0x00,0x10,0x00,0x00,0x04,0x05,0x06,0x00]

image_load v[0:3], [v4, v5, v6, v7], s[8:15] dmask:0xf dim:SQ_RSRC_IMG_2D_MSAA_ARRAY
// GFX12: encoding: [0x07,0x00,0xc0,0xd3,0x00,0x10,0x00,0x00,0x04,0x05,0x06,0x07]

image_load v[0:1], v255, s[0:7] dmask:0x9 dim:1D
// GFX12: encoding: [0x00,0x00,0x40,0xd2,0x00,0x00,0x00,0x00,0xff,0x00,0x00,0x00]

image_load v255, [v254, v255], s[0:7] dmask:0x1 dim:2D
// GFX12: encoding: [0x01,0x00,0x40,0xd0,0xff,0x00,0x00,0x00,0xfe,0xff,0x00,0x00]

image_load v0, [v2, v22, v222], s[0:7] dmask:0x1 dim:3D
// GFX12: encoding: [0x02,0x00,0x40,0xd0,0x00,0x00,0x00,0x00,0x02,0x16,0xde,0x00]

image_load v0, [v2, v3, v4], s[0:7] dmask:0x1 dim:CUBE
// GFX12: encoding: [0x03,0x00,0x40,0xd0,0x00,0x00,0x00,0x00,0x02,0x03,0x04,0x00]

image_load v0, [v2, v3], s[0:7] dmask:0x1 dim:1D_ARRAY
// GFX12: encoding: [0x04,0x00,0x40,0xd0,0x00,0x00,0x00,0x00,0x02,0x03,0x00,0x00]

image_load v0, [v2, v3, v4], s[0:7] dmask:0x1 dim:2D_ARRAY
// GFX12: encoding: [0x05,0x00,0x40,0xd0,0x00,0x00,0x00,0x00,0x02,0x03,0x04,0x00]

image_load v0, [v2, v3, v4], s[0:7] dmask:0x1 dim:2D_MSAA
// GFX12: encoding: [0x06,0x00,0x40,0xd0,0x00,0x00,0x00,0x00,0x02,0x03,0x04,0x00]

image_load v0, [v2, v3, v4, v5], s[0:7] dmask:0x1 dim:2D_MSAA_ARRAY
// GFX12: encoding: [0x07,0x00,0x40,0xd0,0x00,0x00,0x00,0x00,0x02,0x03,0x04,0x05]

image_load v[0:3], v0, s[0:7] dmask:0xf dim:SQ_RSRC_IMG_1D a16
// GFX12: encoding: [0x40,0x00,0xc0,0xd3,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00]

image_load v[1:4], v2, s[4:11] dmask:0xf dim:SQ_RSRC_IMG_2D a16
// GFX12: encoding: [0x41,0x00,0xc0,0xd3,0x01,0x08,0x00,0x00,0x02,0x00,0x00,0x00]

image_load v[0:3], [v4, v5], s[8:15] dmask:0xf dim:SQ_RSRC_IMG_3D a16
// GFX12: encoding: [0x42,0x00,0xc0,0xd3,0x00,0x10,0x00,0x00,0x04,0x05,0x00,0x00]

image_load v[0:3], [v4, v5], s[8:15] dmask:0xf dim:SQ_RSRC_IMG_CUBE a16
// GFX12: encoding: [0x43,0x00,0xc0,0xd3,0x00,0x10,0x00,0x00,0x04,0x05,0x00,0x00]

image_load v[0:3], v4, s[8:15] dmask:0xf dim:SQ_RSRC_IMG_1D_ARRAY a16
// GFX12: encoding: [0x44,0x00,0xc0,0xd3,0x00,0x10,0x00,0x00,0x04,0x00,0x00,0x00]

image_load v[0:3], [v4, v5], s[8:15] dmask:0xf dim:SQ_RSRC_IMG_2D_ARRAY a16
// GFX12: encoding: [0x45,0x00,0xc0,0xd3,0x00,0x10,0x00,0x00,0x04,0x05,0x00,0x00]

image_load v[0:3], [v4, v5], s[8:15] dmask:0xf dim:SQ_RSRC_IMG_2D_MSAA a16
// GFX12: encoding: [0x46,0x00,0xc0,0xd3,0x00,0x10,0x00,0x00,0x04,0x05,0x00,0x00]

image_load v[0:3], [v4, v5], s[8:15] dmask:0xf dim:SQ_RSRC_IMG_2D_MSAA_ARRAY a16
// GFX12: encoding: [0x47,0x00,0xc0,0xd3,0x00,0x10,0x00,0x00,0x04,0x05,0x00,0x00]

image_load v0, v0, s[0:7] dmask:0x1 dim:SQ_RSRC_IMG_1D d16
// GFX12: encoding: [0x20,0x00,0x40,0xd0,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00]

image_load v0, v0, s[0:7] dmask:0x6 dim:SQ_RSRC_IMG_1D d16
// GFX12: encoding: [0x20,0x00,0x80,0xd1,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00]

image_load v[0:1], v0, s[0:7] dmask:0xe dim:SQ_RSRC_IMG_1D d16
// GFX12: encoding: [0x20,0x00,0x80,0xd3,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00]

image_load v[0:1], v0, s[0:7] dmask:0xf dim:SQ_RSRC_IMG_1D d16
// GFX12: encoding: [0x20,0x00,0xc0,0xd3,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00]

image_load v1, [v0, v1], s[16:23] dmask:0x1 dim:SQ_RSRC_IMG_2D
// GFX12: encoding: [0x01,0x00,0x40,0xd0,0x01,0x20,0x00,0x00,0x00,0x01,0x00,0x00]

image_load v[1:2], [v0, v1], s[16:23] dmask:0x1 dim:SQ_RSRC_IMG_2D tfe
// GFX12: encoding: [0x01,0x00,0x40,0xd0,0x01,0x20,0x80,0x00,0x00,0x01,0x00,0x00]

image_load v[1:2], [v0, v1], s[16:23] dmask:0x3 dim:SQ_RSRC_IMG_2D
// GFX12: encoding: [0x01,0x00,0xc0,0xd0,0x01,0x20,0x00,0x00,0x00,0x01,0x00,0x00]

image_load v[1:3], [v0, v1], s[16:23] dmask:0x3 dim:SQ_RSRC_IMG_2D tfe
// GFX12: encoding: [0x01,0x00,0xc0,0xd0,0x01,0x20,0x80,0x00,0x00,0x01,0x00,0x00]

image_load v[1:3], [v0, v1], s[16:23] dmask:0x7 dim:SQ_RSRC_IMG_2D
// GFX12: encoding: [0x01,0x00,0xc0,0xd1,0x01,0x20,0x00,0x00,0x00,0x01,0x00,0x00]

image_load v[1:4], [v0, v1], s[16:23] dmask:0x7 dim:SQ_RSRC_IMG_2D tfe
// GFX12: encoding: [0x01,0x00,0xc0,0xd1,0x01,0x20,0x80,0x00,0x00,0x01,0x00,0x00]

image_load v[1:4], [v0, v1], s[16:23] dmask:0xf dim:SQ_RSRC_IMG_2D
// GFX12: encoding: [0x01,0x00,0xc0,0xd3,0x01,0x20,0x00,0x00,0x00,0x01,0x00,0x00]

image_load v[1:5], [v0, v1], s[16:23] dmask:0xf dim:SQ_RSRC_IMG_2D tfe
// GFX12: encoding: [0x01,0x00,0xc0,0xd3,0x01,0x20,0x80,0x00,0x00,0x01,0x00,0x00]

// FIXME: This test is incorrect because r128 assumes a 128-bit RSRC.
image_load v0, v0, s[0:7] dmask:0x1 dim:SQ_RSRC_IMG_1D r128
// GFX12: encoding: [0x10,0x00,0x40,0xd0,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00]

image_load v0, v0, s[0:7] dmask:0x1 dim:SQ_RSRC_IMG_1D scope:SCOPE_CU
// GFX12: encoding: [0x00,0x00,0x40,0xd0,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00]

image_load v0, v0, s[0:7] dmask:0x1 dim:SQ_RSRC_IMG_1D scope:SCOPE_SE
// GFX12: encoding: [0x00,0x00,0x40,0xd0,0x00,0x00,0x04,0x00,0x00,0x00,0x00,0x00]

image_load v0, v0, s[0:7] dmask:0x1 dim:SQ_RSRC_IMG_1D scope:SCOPE_DEV
// GFX12: encoding: [0x00,0x00,0x40,0xd0,0x00,0x00,0x08,0x00,0x00,0x00,0x00,0x00]

image_load v0, v0, s[0:7] dmask:0x1 dim:SQ_RSRC_IMG_1D scope:SCOPE_SYS
// GFX12: encoding: [0x00,0x00,0x40,0xd0,0x00,0x00,0x0c,0x00,0x00,0x00,0x00,0x00]

image_load v0, v0, s[0:7] dmask:0x1 dim:SQ_RSRC_IMG_1D th:TH_LOAD_RT
// GFX12: encoding: [0x00,0x00,0x40,0xd0,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00]

image_load v0, v0, s[0:7] dmask:0x1 dim:SQ_RSRC_IMG_1D th:TH_LOAD_NT
// GFX12: encoding: [0x00,0x00,0x40,0xd0,0x00,0x00,0x10,0x00,0x00,0x00,0x00,0x00]

image_load v0, v0, s[0:7] dmask:0x1 dim:SQ_RSRC_IMG_1D th:TH_LOAD_HT
// GFX12: encoding: [0x00,0x00,0x40,0xd0,0x00,0x00,0x20,0x00,0x00,0x00,0x00,0x00]

image_load v0, v0, s[0:7] dmask:0x1 dim:SQ_RSRC_IMG_1D th:TH_LOAD_LU
// GFX12: encoding: [0x00,0x00,0x40,0xd0,0x00,0x00,0x30,0x00,0x00,0x00,0x00,0x00]

image_load v0, v0, s[0:7] dmask:0x1 dim:SQ_RSRC_IMG_1D th:TH_LOAD_NT_RT
// GFX12: encoding: [0x00,0x00,0x40,0xd0,0x00,0x00,0x40,0x00,0x00,0x00,0x00,0x00]

image_load v0, v0, s[0:7] dmask:0x1 dim:SQ_RSRC_IMG_1D th:TH_LOAD_RT_NT
// GFX12: encoding: [0x00,0x00,0x40,0xd0,0x00,0x00,0x50,0x00,0x00,0x00,0x00,0x00]

image_load v0, v0, s[0:7] dmask:0x1 dim:SQ_RSRC_IMG_1D th:TH_LOAD_NT_HT
// GFX12: encoding: [0x00,0x00,0x40,0xd0,0x00,0x00,0x60,0x00,0x00,0x00,0x00,0x00]

image_load v0, v0, s[0:7] dmask:0x1 dim:SQ_RSRC_IMG_1D th:TH_LOAD_BYPASS scope:SCOPE_SYS
// GFX12: encoding: [0x00,0x00,0x40,0xd0,0x00,0x00,0x3c,0x00,0x00,0x00,0x00,0x00]

image_load v[0:2], [v4, v5], s[8:15] dmask:0xf dim:SQ_RSRC_IMG_2D_ARRAY th:TH_LOAD_HT scope:SCOPE_SE a16 tfe d16
// GFX12: encoding: [0x65,0x00,0xc0,0xd3,0x00,0x10,0xa4,0x00,0x04,0x05,0x00,0x00]

// FIXME: This test is incorrect because r128 assumes a 128-bit RSRC.
image_load v[0:2], [v4, v5], s[8:15] dmask:0xf dim:SQ_RSRC_IMG_2D_ARRAY th:TH_LOAD_HT scope:SCOPE_SE r128 a16 tfe d16
// GFX12: encoding: [0x75,0x00,0xc0,0xd3,0x00,0x10,0xa4,0x00,0x04,0x05,0x00,0x00]

image_load v[4:7], [v1, v0], s[4:11] dmask:0xf dim:SQ_RSRC_IMG_2D
// GFX12: encoding: [0x01,0x00,0xc0,0xd3,0x04,0x08,0x00,0x00,0x01,0x00,0x00,0x00]

image_load v[1:4], [v2, v1, v0], s[4:11] dmask:0xf dim:SQ_RSRC_IMG_3D
// GFX12: encoding: [0x02,0x00,0xc0,0xd3,0x01,0x08,0x00,0x00,0x02,0x01,0x00,0x00]

image_load v[1:4], [v3, v2, v1, v0], s[4:11] dmask:0xf dim:SQ_RSRC_IMG_2D_MSAA_ARRAY
// GFX12: encoding: [0x07,0x00,0xc0,0xd3,0x01,0x08,0x00,0x00,0x03,0x02,0x01,0x00]

image_load_mip v[252:255], [v0, v1], s[0:7] dmask:0xf dim:SQ_RSRC_IMG_1D
// GFX12: encoding: [0x00,0x40,0xc0,0xd3,0xfc,0x00,0x00,0x00,0x00,0x01,0x00,0x00]

image_load_mip v[253:255], [v255, v254], s[0:7] dmask:0xe dim:SQ_RSRC_IMG_1D
// GFX12: encoding: [0x00,0x40,0x80,0xd3,0xfd,0x00,0x00,0x00,0xff,0xfe,0x00,0x00]

image_load_mip v[254:255], [v254, v255, v253], s[0:7] dmask:0xc dim:SQ_RSRC_IMG_2D
// GFX12: encoding: [0x01,0x40,0x00,0xd3,0xfe,0x00,0x00,0x00,0xfe,0xff,0xfd,0x00]

image_load_mip v255, [v254, v255, v253, v252], s[0:7] dmask:0x8 dim:SQ_RSRC_IMG_3D
// GFX12: encoding: [0x02,0x40,0x00,0xd2,0xff,0x00,0x00,0x00,0xfe,0xff,0xfd,0xfc]

image_load_mip v255, [v254, v255, v253, v252], s[0:7] dmask:0x8 dim:SQ_RSRC_IMG_CUBE
// GFX12: encoding: [0x03,0x40,0x00,0xd2,0xff,0x00,0x00,0x00,0xfe,0xff,0xfd,0xfc]

image_load_mip v255, [v254, v255, v253], s[0:7] dmask:0x8 dim:SQ_RSRC_IMG_1D_ARRAY
// GFX12: encoding: [0x04,0x40,0x00,0xd2,0xff,0x00,0x00,0x00,0xfe,0xff,0xfd,0x00]

image_load_mip v255, [v254, v255, v253, v255], s[0:7] dmask:0x8 dim:SQ_RSRC_IMG_2D_ARRAY
// GFX12: encoding: [0x05,0x40,0x00,0xd2,0xff,0x00,0x00,0x00,0xfe,0xff,0xfd,0xff]

image_load_mip v[252:255], [v0, v1], s[0:7] dmask:0xf dim:SQ_RSRC_IMG_1D th:TH_LOAD_NT
// GFX12: encoding: [0x00,0x40,0xc0,0xd3,0xfc,0x00,0x10,0x00,0x00,0x01,0x00,0x00]

image_load_pck v5, v1, s[8:15] dmask:0x1 dim:SQ_RSRC_IMG_1D
// GFX12: encoding: [0x00,0x80,0x40,0xd0,0x05,0x10,0x00,0x00,0x01,0x00,0x00,0x00]

image_load_pck v[5:6], [v1, v2], s[8:15] dmask:0x3 dim:SQ_RSRC_IMG_2D
// GFX12: encoding: [0x01,0x80,0xc0,0xd0,0x05,0x10,0x00,0x00,0x01,0x02,0x00,0x00]

image_load_pck v[5:6], [v1, v2, v3], s[8:15] dmask:0xc dim:SQ_RSRC_IMG_3D
// GFX12: encoding: [0x02,0x80,0x00,0xd3,0x05,0x10,0x00,0x00,0x01,0x02,0x03,0x00]

image_load_pck v[5:6], [v1, v2, v3], s[8:15] dmask:0xa dim:SQ_RSRC_IMG_CUBE
// GFX12: encoding: [0x03,0x80,0x80,0xd2,0x05,0x10,0x00,0x00,0x01,0x02,0x03,0x00]

image_load_pck v[5:7], [v1, v2], s[8:15] dmask:0xb dim:SQ_RSRC_IMG_1D_ARRAY
// GFX12: encoding: [0x04,0x80,0xc0,0xd2,0x05,0x10,0x00,0x00,0x01,0x02,0x00,0x00]

image_load_pck v[5:7], [v1, v2, v3], s[8:15] dmask:0xd dim:SQ_RSRC_IMG_2D_ARRAY
// GFX12: encoding: [0x05,0x80,0x40,0xd3,0x05,0x10,0x00,0x00,0x01,0x02,0x03,0x00]

image_load_pck v[5:7], [v1, v2, v3], s[8:15] dmask:0x7 dim:SQ_RSRC_IMG_2D_MSAA
// GFX12: encoding: [0x06,0x80,0xc0,0xd1,0x05,0x10,0x00,0x00,0x01,0x02,0x03,0x00]

image_load_pck v[5:8], [v1, v2, v3, v4], s[8:15] dmask:0xf dim:SQ_RSRC_IMG_2D_MSAA_ARRAY
// GFX12: encoding: [0x07,0x80,0xc0,0xd3,0x05,0x10,0x00,0x00,0x01,0x02,0x03,0x04]

image_load_pck v5, v1, s[8:15] dmask:0x1 dim:SQ_RSRC_IMG_1D th:TH_LOAD_NT
// GFX12: encoding: [0x00,0x80,0x40,0xd0,0x05,0x10,0x10,0x00,0x01,0x00,0x00,0x00]

image_load_pck_sgn v5, v1, s[8:15] dmask:0x1 dim:SQ_RSRC_IMG_1D
// GFX12: encoding: [0x00,0xc0,0x40,0xd0,0x05,0x10,0x00,0x00,0x01,0x00,0x00,0x00]

image_load_pck_sgn v[5:6], [v1, v2], s[8:15] dmask:0x3 dim:SQ_RSRC_IMG_2D
// GFX12: encoding: [0x01,0xc0,0xc0,0xd0,0x05,0x10,0x00,0x00,0x01,0x02,0x00,0x00]

image_load_pck_sgn v[5:6], [v1, v2, v3], s[8:15] dmask:0xc dim:SQ_RSRC_IMG_3D
// GFX12: encoding: [0x02,0xc0,0x00,0xd3,0x05,0x10,0x00,0x00,0x01,0x02,0x03,0x00]

image_load_pck_sgn v[5:6], [v1, v2, v3], s[8:15] dmask:0xa dim:SQ_RSRC_IMG_CUBE
// GFX12: encoding: [0x03,0xc0,0x80,0xd2,0x05,0x10,0x00,0x00,0x01,0x02,0x03,0x00]

image_load_pck_sgn v[5:7], [v1, v2], s[8:15] dmask:0xb dim:SQ_RSRC_IMG_1D_ARRAY
// GFX12: encoding: [0x04,0xc0,0xc0,0xd2,0x05,0x10,0x00,0x00,0x01,0x02,0x00,0x00]

image_load_pck_sgn v[5:7], [v1, v2, v3], s[8:15] dmask:0xd dim:SQ_RSRC_IMG_2D_ARRAY
// GFX12: encoding: [0x05,0xc0,0x40,0xd3,0x05,0x10,0x00,0x00,0x01,0x02,0x03,0x00]

image_load_pck_sgn v[5:7], [v1, v2, v3], s[8:15] dmask:0x7 dim:SQ_RSRC_IMG_2D_MSAA
// GFX12: encoding: [0x06,0xc0,0xc0,0xd1,0x05,0x10,0x00,0x00,0x01,0x02,0x03,0x00]

image_load_pck_sgn v[5:8], [v1, v2, v3, v4], s[8:15] dmask:0xf dim:SQ_RSRC_IMG_2D_MSAA_ARRAY
// GFX12: encoding: [0x07,0xc0,0xc0,0xd3,0x05,0x10,0x00,0x00,0x01,0x02,0x03,0x04]

image_load_pck_sgn v5, v1, s[8:15] dmask:0x1 dim:SQ_RSRC_IMG_1D th:TH_LOAD_NT
// GFX12: encoding: [0x00,0xc0,0x40,0xd0,0x05,0x10,0x10,0x00,0x01,0x00,0x00,0x00]

image_load_mip_pck v5, [v0, v1], s[8:15] dmask:0x1 dim:SQ_RSRC_IMG_1D
// GFX12: encoding: [0x00,0x00,0x41,0xd0,0x05,0x10,0x00,0x00,0x00,0x01,0x00,0x00]

image_load_mip_pck v[5:6], [v0, v1, v2], s[8:15] dmask:0x3 dim:SQ_RSRC_IMG_2D
// GFX12: encoding: [0x01,0x00,0xc1,0xd0,0x05,0x10,0x00,0x00,0x00,0x01,0x02,0x00]

image_load_mip_pck v[5:6], [v0, v1, v2, v3], s[8:15] dmask:0xc dim:SQ_RSRC_IMG_3D
// GFX12: encoding: [0x02,0x00,0x01,0xd3,0x05,0x10,0x00,0x00,0x00,0x01,0x02,0x03]

image_load_mip_pck v[5:6], [v0, v1, v2, v3], s[8:15] dmask:0xa dim:SQ_RSRC_IMG_CUBE
// GFX12: encoding: [0x03,0x00,0x81,0xd2,0x05,0x10,0x00,0x00,0x00,0x01,0x02,0x03]

image_load_mip_pck v[5:7], [v0, v1, v2], s[8:15] dmask:0xb dim:SQ_RSRC_IMG_1D_ARRAY
// GFX12: encoding: [0x04,0x00,0xc1,0xd2,0x05,0x10,0x00,0x00,0x00,0x01,0x02,0x00]

image_load_mip_pck v[5:7], [v0, v1, v2, v3], s[8:15] dmask:0xd dim:SQ_RSRC_IMG_2D_ARRAY
// GFX12: encoding: [0x05,0x00,0x41,0xd3,0x05,0x10,0x00,0x00,0x00,0x01,0x02,0x03]

image_load_mip_pck v5, [v0, v1], s[8:15] dmask:0x1 dim:SQ_RSRC_IMG_1D th:TH_LOAD_NT
// GFX12: encoding: [0x00,0x00,0x41,0xd0,0x05,0x10,0x10,0x00,0x00,0x01,0x00,0x00]

image_load_mip_pck_sgn v5, [v0, v1], s[8:15] dmask:0x1 dim:SQ_RSRC_IMG_1D
// GFX12: encoding: [0x00,0x40,0x41,0xd0,0x05,0x10,0x00,0x00,0x00,0x01,0x00,0x00]

image_load_mip_pck_sgn v[5:6], [v0, v1, v2], s[8:15] dmask:0x3 dim:SQ_RSRC_IMG_2D
// GFX12: encoding: [0x01,0x40,0xc1,0xd0,0x05,0x10,0x00,0x00,0x00,0x01,0x02,0x00]

image_load_mip_pck_sgn v[5:6], [v0, v1, v2, v3], s[8:15] dmask:0xc dim:SQ_RSRC_IMG_3D
// GFX12: encoding: [0x02,0x40,0x01,0xd3,0x05,0x10,0x00,0x00,0x00,0x01,0x02,0x03]

image_load_mip_pck_sgn v[5:6], [v0, v1, v2, v3], s[8:15] dmask:0xa dim:SQ_RSRC_IMG_CUBE
// GFX12: encoding: [0x03,0x40,0x81,0xd2,0x05,0x10,0x00,0x00,0x00,0x01,0x02,0x03]

image_load_mip_pck_sgn v[5:7], [v0, v1, v2], s[8:15] dmask:0xb dim:SQ_RSRC_IMG_1D_ARRAY
// GFX12: encoding: [0x04,0x40,0xc1,0xd2,0x05,0x10,0x00,0x00,0x00,0x01,0x02,0x00]

image_load_mip_pck_sgn v[5:7], [v0, v1, v2, v3], s[8:15] dmask:0xd dim:SQ_RSRC_IMG_2D_ARRAY
// GFX12: encoding: [0x05,0x40,0x41,0xd3,0x05,0x10,0x00,0x00,0x00,0x01,0x02,0x03]

image_load_mip_pck_sgn v5, [v0, v1], s[8:15] dmask:0x1 dim:SQ_RSRC_IMG_1D th:TH_LOAD_NT
// GFX12: encoding: [0x00,0x40,0x41,0xd0,0x05,0x10,0x10,0x00,0x00,0x01,0x00,0x00]

image_store v[0:3], v0, s[0:7] dmask:0xf dim:SQ_RSRC_IMG_1D
// GFX12: encoding: [0x00,0x80,0xc1,0xd3,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00]

image_store v[1:4], [v2, v3], s[4:11] dmask:0xf dim:SQ_RSRC_IMG_2D
// GFX12: encoding: [0x01,0x80,0xc1,0xd3,0x01,0x08,0x00,0x00,0x02,0x03,0x00,0x00]

image_store v[4:7], [v4, v5, v6], s[8:15] dmask:0xf dim:SQ_RSRC_IMG_3D
// GFX12: encoding: [0x02,0x80,0xc1,0xd3,0x04,0x10,0x00,0x00,0x04,0x05,0x06,0x00]

image_store v[252:255], [v4, v5, v6], s[8:15] dmask:0xf dim:SQ_RSRC_IMG_CUBE
// GFX12: encoding: [0x03,0x80,0xc1,0xd3,0xfc,0x10,0x00,0x00,0x04,0x05,0x06,0x00]

image_store v[0:3], [v4, v5], s[8:15] dmask:0xf dim:SQ_RSRC_IMG_1D_ARRAY
// GFX12: encoding: [0x04,0x80,0xc1,0xd3,0x00,0x10,0x00,0x00,0x04,0x05,0x00,0x00]

image_store v[0:3], [v4, v5, v6], s[8:15] dmask:0xf dim:SQ_RSRC_IMG_2D_ARRAY
// GFX12: encoding: [0x05,0x80,0xc1,0xd3,0x00,0x10,0x00,0x00,0x04,0x05,0x06,0x00]

image_store v[0:3], [v4, v5, v6], s[8:15] dmask:0xf dim:SQ_RSRC_IMG_2D_MSAA
// GFX12: encoding: [0x06,0x80,0xc1,0xd3,0x00,0x10,0x00,0x00,0x04,0x05,0x06,0x00]

image_store v[0:3], [v4, v5, v6, v7], s[8:15] dmask:0xf dim:SQ_RSRC_IMG_2D_MSAA_ARRAY
// GFX12: encoding: [0x07,0x80,0xc1,0xd3,0x00,0x10,0x00,0x00,0x04,0x05,0x06,0x07]

image_store v[0:3], v0, s[0:7] dmask:0xf dim:SQ_RSRC_IMG_1D a16
// GFX12: encoding: [0x40,0x80,0xc1,0xd3,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00]

image_store v[1:4], v2, s[4:11] dmask:0xf dim:SQ_RSRC_IMG_2D a16
// GFX12: encoding: [0x41,0x80,0xc1,0xd3,0x01,0x08,0x00,0x00,0x02,0x00,0x00,0x00]

image_store v[4:7], [v4, v5], s[8:15] dmask:0xf dim:SQ_RSRC_IMG_3D a16
// GFX12: encoding: [0x42,0x80,0xc1,0xd3,0x04,0x10,0x00,0x00,0x04,0x05,0x00,0x00]

image_store v[252:255], [v4, v5], s[8:15] dmask:0xf dim:SQ_RSRC_IMG_CUBE a16
// GFX12: encoding: [0x43,0x80,0xc1,0xd3,0xfc,0x10,0x00,0x00,0x04,0x05,0x00,0x00]

image_store v[0:3], v4, s[8:15] dmask:0xf dim:SQ_RSRC_IMG_1D_ARRAY a16
// GFX12: encoding: [0x44,0x80,0xc1,0xd3,0x00,0x10,0x00,0x00,0x04,0x00,0x00,0x00]

image_store v[0:3], [v4, v5], s[8:15] dmask:0xf dim:SQ_RSRC_IMG_2D_ARRAY a16
// GFX12: encoding: [0x45,0x80,0xc1,0xd3,0x00,0x10,0x00,0x00,0x04,0x05,0x00,0x00]

image_store v[0:3], [v4, v5], s[8:15] dmask:0xf dim:SQ_RSRC_IMG_2D_MSAA a16
// GFX12: encoding: [0x46,0x80,0xc1,0xd3,0x00,0x10,0x00,0x00,0x04,0x05,0x00,0x00]

image_store v[0:3], [v4, v5], s[8:15] dmask:0xf dim:SQ_RSRC_IMG_2D_MSAA_ARRAY a16
// GFX12: encoding: [0x47,0x80,0xc1,0xd3,0x00,0x10,0x00,0x00,0x04,0x05,0x00,0x00]

image_store v0, v0, s[0:7] dmask:0x1 dim:SQ_RSRC_IMG_1D d16
// GFX12: encoding: [0x20,0x80,0x41,0xd0,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00]

image_store v0, v0, s[0:7] dmask:0x6 dim:SQ_RSRC_IMG_1D d16
// GFX12: encoding: [0x20,0x80,0x81,0xd1,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00]

image_store v[0:1], v0, s[0:7] dmask:0xe dim:SQ_RSRC_IMG_1D d16
// GFX12: encoding: [0x20,0x80,0x81,0xd3,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00]

image_store v[0:1], v0, s[0:7] dmask:0xf dim:SQ_RSRC_IMG_1D d16
// GFX12: encoding: [0x20,0x80,0xc1,0xd3,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00]

image_store v1, [v0, v1], s[16:23] dmask:0x1 dim:SQ_RSRC_IMG_2D
// GFX12: encoding: [0x01,0x80,0x41,0xd0,0x01,0x20,0x00,0x00,0x00,0x01,0x00,0x00]

image_store v[1:2], [v0, v1], s[16:23] dmask:0x1 dim:SQ_RSRC_IMG_2D tfe
// GFX12: encoding: [0x01,0x80,0x41,0xd0,0x01,0x20,0x80,0x00,0x00,0x01,0x00,0x00]

image_store v[1:2], [v0, v1], s[16:23] dmask:0x3 dim:SQ_RSRC_IMG_2D
// GFX12: encoding: [0x01,0x80,0xc1,0xd0,0x01,0x20,0x00,0x00,0x00,0x01,0x00,0x00]

image_store v[1:3], [v0, v1], s[16:23] dmask:0x3 dim:SQ_RSRC_IMG_2D tfe
// GFX12: encoding: [0x01,0x80,0xc1,0xd0,0x01,0x20,0x80,0x00,0x00,0x01,0x00,0x00]

image_store v[1:3], [v0, v1], s[16:23] dmask:0x7 dim:SQ_RSRC_IMG_2D
// GFX12: encoding: [0x01,0x80,0xc1,0xd1,0x01,0x20,0x00,0x00,0x00,0x01,0x00,0x00]

image_store v[1:4], [v0, v1], s[16:23] dmask:0x7 dim:SQ_RSRC_IMG_2D tfe
// GFX12: encoding: [0x01,0x80,0xc1,0xd1,0x01,0x20,0x80,0x00,0x00,0x01,0x00,0x00]

image_store v[1:4], [v0, v1], s[16:23] dmask:0xf dim:SQ_RSRC_IMG_2D
// GFX12: encoding: [0x01,0x80,0xc1,0xd3,0x01,0x20,0x00,0x00,0x00,0x01,0x00,0x00]

image_store v[1:5], [v0, v1], s[16:23] dmask:0xf dim:SQ_RSRC_IMG_2D tfe
// GFX12: encoding: [0x01,0x80,0xc1,0xd3,0x01,0x20,0x80,0x00,0x00,0x01,0x00,0x00]

// FIXME: This test is incorrect because r128 assumes a 128-bit RSRC.
image_store v0, v0, s[0:7] dmask:0x1 dim:SQ_RSRC_IMG_1D r128
// GFX12: encoding: [0x10,0x80,0x41,0xd0,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00]

image_store v0, v0, s[0:7] dmask:0x1 dim:SQ_RSRC_IMG_1D scope:SCOPE_CU
// GFX12: encoding: [0x00,0x80,0x41,0xd0,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00]

image_store v0, v0, s[0:7] dmask:0x1 dim:SQ_RSRC_IMG_1D scope:SCOPE_SE
// GFX12: encoding: [0x00,0x80,0x41,0xd0,0x00,0x00,0x04,0x00,0x00,0x00,0x00,0x00]

image_store v0, v0, s[0:7] dmask:0x1 dim:SQ_RSRC_IMG_1D scope:SCOPE_DEV
// GFX12: encoding: [0x00,0x80,0x41,0xd0,0x00,0x00,0x08,0x00,0x00,0x00,0x00,0x00]

image_store v0, v0, s[0:7] dmask:0x1 dim:SQ_RSRC_IMG_1D scope:SCOPE_SYS
// GFX12: encoding: [0x00,0x80,0x41,0xd0,0x00,0x00,0x0c,0x00,0x00,0x00,0x00,0x00]

image_store v0, v0, s[0:7] dmask:0x1 dim:SQ_RSRC_IMG_1D th:TH_STORE_RT
// GFX12: encoding: [0x00,0x80,0x41,0xd0,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00]

image_store v0, v0, s[0:7] dmask:0x1 dim:SQ_RSRC_IMG_1D th:TH_STORE_NT
// GFX12: encoding: [0x00,0x80,0x41,0xd0,0x00,0x00,0x10,0x00,0x00,0x00,0x00,0x00]

image_store v0, v0, s[0:7] dmask:0x1 dim:SQ_RSRC_IMG_1D th:TH_STORE_HT
// GFX12: encoding: [0x00,0x80,0x41,0xd0,0x00,0x00,0x20,0x00,0x00,0x00,0x00,0x00]

image_store v0, v0, s[0:7] dmask:0x1 dim:SQ_RSRC_IMG_1D th:TH_STORE_RT_WB
// GFX12: encoding: [0x00,0x80,0x41,0xd0,0x00,0x00,0x30,0x00,0x00,0x00,0x00,0x00]

image_store v0, v0, s[0:7] dmask:0x1 dim:SQ_RSRC_IMG_1D th:TH_STORE_NT_RT
// GFX12: encoding: [0x00,0x80,0x41,0xd0,0x00,0x00,0x40,0x00,0x00,0x00,0x00,0x00]

image_store v0, v0, s[0:7] dmask:0x1 dim:SQ_RSRC_IMG_1D th:TH_STORE_RT_NT
// GFX12: encoding: [0x00,0x80,0x41,0xd0,0x00,0x00,0x50,0x00,0x00,0x00,0x00,0x00]

image_store v0, v0, s[0:7] dmask:0x1 dim:SQ_RSRC_IMG_1D th:TH_STORE_NT_HT
// GFX12: encoding: [0x00,0x80,0x41,0xd0,0x00,0x00,0x60,0x00,0x00,0x00,0x00,0x00]

image_store v0, v0, s[0:7] dmask:0x1 dim:SQ_RSRC_IMG_1D th:TH_STORE_NT_WB
// GFX12: encoding: [0x00,0x80,0x41,0xd0,0x00,0x00,0x70,0x00,0x00,0x00,0x00,0x00]

image_store v0, v0, s[0:7] dmask:0x1 dim:SQ_RSRC_IMG_1D th:TH_STORE_BYPASS scope:SCOPE_SYS
// GFX12: encoding: [0x00,0x80,0x41,0xd0,0x00,0x00,0x3c,0x00,0x00,0x00,0x00,0x00]

image_store v[1:4], [v2, v0], s[4:11] dmask:0xf dim:SQ_RSRC_IMG_2D
// GFX12: encoding: [0x01,0x80,0xc1,0xd3,0x01,0x08,0x00,0x00,0x02,0x00,0x00,0x00]

image_store v[1:4], [v2, v1, v0], s[4:11] dmask:0xf dim:SQ_RSRC_IMG_3D
// GFX12: encoding: [0x02,0x80,0xc1,0xd3,0x01,0x08,0x00,0x00,0x02,0x01,0x00,0x00]

image_store v[1:4], [v3, v2, v1, v0], s[4:11] dmask:0xf dim:SQ_RSRC_IMG_2D_MSAA_ARRAY
// GFX12: encoding: [0x07,0x80,0xc1,0xd3,0x01,0x08,0x00,0x00,0x03,0x02,0x01,0x00]

image_store_mip v[252:255], [v0, v1], s[0:7] dmask:0xf dim:SQ_RSRC_IMG_1D
// GFX12: encoding: [0x00,0xc0,0xc1,0xd3,0xfc,0x00,0x00,0x00,0x00,0x01,0x00,0x00]

image_store_mip v[253:255], [v255, v254], s[0:7] dmask:0xe dim:SQ_RSRC_IMG_1D
// GFX12: encoding: [0x00,0xc0,0x81,0xd3,0xfd,0x00,0x00,0x00,0xff,0xfe,0x00,0x00]

image_store_mip v[254:255], [v254, v255, v253], s[0:7] dmask:0xc dim:SQ_RSRC_IMG_2D
// GFX12: encoding: [0x01,0xc0,0x01,0xd3,0xfe,0x00,0x00,0x00,0xfe,0xff,0xfd,0x00]

image_store_mip v255, [v254, v255, v253, v252], s[0:7] dmask:0x8 dim:SQ_RSRC_IMG_3D
// GFX12: encoding: [0x02,0xc0,0x01,0xd2,0xff,0x00,0x00,0x00,0xfe,0xff,0xfd,0xfc]

image_store_mip v255, [v254, v255, v253, v252], s[0:7] dmask:0x8 dim:SQ_RSRC_IMG_CUBE
// GFX12: encoding: [0x03,0xc0,0x01,0xd2,0xff,0x00,0x00,0x00,0xfe,0xff,0xfd,0xfc]

image_store_mip v255, [v254, v255, v253], s[0:7] dmask:0x8 dim:SQ_RSRC_IMG_1D_ARRAY
// GFX12: encoding: [0x04,0xc0,0x01,0xd2,0xff,0x00,0x00,0x00,0xfe,0xff,0xfd,0x00]

image_store_mip v255, [v254, v255, v253, v255], s[0:7] dmask:0x8 dim:SQ_RSRC_IMG_2D_ARRAY
// GFX12: encoding: [0x05,0xc0,0x01,0xd2,0xff,0x00,0x00,0x00,0xfe,0xff,0xfd,0xff]

image_store_mip v[252:255], [v0, v1], s[0:7] dmask:0xf dim:SQ_RSRC_IMG_1D th:TH_STORE_NT
// GFX12: encoding: [0x00,0xc0,0xc1,0xd3,0xfc,0x00,0x10,0x00,0x00,0x01,0x00,0x00]

image_store_pck v5, v1, s[8:15] dmask:0x1 dim:SQ_RSRC_IMG_1D
// GFX12: encoding: [0x00,0x00,0x42,0xd0,0x05,0x10,0x00,0x00,0x01,0x00,0x00,0x00]

image_store_pck v[5:6], [v1, v2], s[8:15] dmask:0x3 dim:SQ_RSRC_IMG_2D
// GFX12: encoding: [0x01,0x00,0xc2,0xd0,0x05,0x10,0x00,0x00,0x01,0x02,0x00,0x00]

image_store_pck v[5:6], [v1, v2, v3], s[8:15] dmask:0xc dim:SQ_RSRC_IMG_3D
// GFX12: encoding: [0x02,0x00,0x02,0xd3,0x05,0x10,0x00,0x00,0x01,0x02,0x03,0x00]

image_store_pck v[5:6], [v1, v2, v3], s[8:15] dmask:0xa dim:SQ_RSRC_IMG_CUBE
// GFX12: encoding: [0x03,0x00,0x82,0xd2,0x05,0x10,0x00,0x00,0x01,0x02,0x03,0x00]

image_store_pck v[5:7], [v1, v2], s[8:15] dmask:0xb dim:SQ_RSRC_IMG_1D_ARRAY
// GFX12: encoding: [0x04,0x00,0xc2,0xd2,0x05,0x10,0x00,0x00,0x01,0x02,0x00,0x00]

image_store_pck v[5:7], [v1, v2, v3], s[8:15] dmask:0xd dim:SQ_RSRC_IMG_2D_ARRAY
// GFX12: encoding: [0x05,0x00,0x42,0xd3,0x05,0x10,0x00,0x00,0x01,0x02,0x03,0x00]

image_store_pck v[5:7], [v1, v2, v3], s[8:15] dmask:0x7 dim:SQ_RSRC_IMG_2D_MSAA
// GFX12: encoding: [0x06,0x00,0xc2,0xd1,0x05,0x10,0x00,0x00,0x01,0x02,0x03,0x00]

image_store_pck v[5:8], [v1, v2, v3, v4], s[8:15] dmask:0xf dim:SQ_RSRC_IMG_2D_MSAA_ARRAY
// GFX12: encoding: [0x07,0x00,0xc2,0xd3,0x05,0x10,0x00,0x00,0x01,0x02,0x03,0x04]

image_store_pck v5, v1, s[8:15] dmask:0x1 dim:SQ_RSRC_IMG_1D th:TH_STORE_NT
// GFX12: encoding: [0x00,0x00,0x42,0xd0,0x05,0x10,0x10,0x00,0x01,0x00,0x00,0x00]

image_store_mip_pck v5, [v0, v1], s[8:15] dmask:0x1 dim:SQ_RSRC_IMG_1D
// GFX12: encoding: [0x00,0x40,0x42,0xd0,0x05,0x10,0x00,0x00,0x00,0x01,0x00,0x00]

image_store_mip_pck v[5:6], [v0, v1, v2], s[8:15] dmask:0x3 dim:SQ_RSRC_IMG_2D
// GFX12: encoding: [0x01,0x40,0xc2,0xd0,0x05,0x10,0x00,0x00,0x00,0x01,0x02,0x00]

image_store_mip_pck v[5:6], [v0, v1, v2, v3], s[8:15] dmask:0xc dim:SQ_RSRC_IMG_3D
// GFX12: encoding: [0x02,0x40,0x02,0xd3,0x05,0x10,0x00,0x00,0x00,0x01,0x02,0x03]

image_store_mip_pck v[5:6], [v0, v1, v2, v3], s[8:15] dmask:0xa dim:SQ_RSRC_IMG_CUBE
// GFX12: encoding: [0x03,0x40,0x82,0xd2,0x05,0x10,0x00,0x00,0x00,0x01,0x02,0x03]

image_store_mip_pck v[5:7], [v0, v1, v2], s[8:15] dmask:0xb dim:SQ_RSRC_IMG_1D_ARRAY
// GFX12: encoding: [0x04,0x40,0xc2,0xd2,0x05,0x10,0x00,0x00,0x00,0x01,0x02,0x00]

image_store_mip_pck v[5:7], [v0, v1, v2, v3], s[8:15] dmask:0xd dim:SQ_RSRC_IMG_2D_ARRAY
// GFX12: encoding: [0x05,0x40,0x42,0xd3,0x05,0x10,0x00,0x00,0x00,0x01,0x02,0x03]

image_store_mip_pck v5, [v0, v1], s[8:15] dmask:0x1 dim:SQ_RSRC_IMG_1D th:TH_STORE_NT
// GFX12: encoding: [0x00,0x40,0x42,0xd0,0x05,0x10,0x10,0x00,0x00,0x01,0x00,0x00]

image_atomic_swap v0, v0, s[0:7] dmask:0x1 dim:SQ_RSRC_IMG_1D
// GFX12: encoding: [0x00,0x80,0x42,0xd0,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00]

image_atomic_swap v1, [v2, v3], s[4:11] dmask:0x1 dim:SQ_RSRC_IMG_2D
// GFX12: encoding: [0x01,0x80,0x42,0xd0,0x01,0x08,0x00,0x00,0x02,0x03,0x00,0x00]

image_atomic_swap v4, [v4, v5, v6], s[8:15] dmask:0x1 dim:SQ_RSRC_IMG_3D
// GFX12: encoding: [0x02,0x80,0x42,0xd0,0x04,0x10,0x00,0x00,0x04,0x05,0x06,0x00]

image_atomic_swap v255, [v4, v5, v6], s[8:15] dmask:0x1 dim:SQ_RSRC_IMG_CUBE
// GFX12: encoding: [0x03,0x80,0x42,0xd0,0xff,0x10,0x00,0x00,0x04,0x05,0x06,0x00]

image_atomic_swap v[0:1], [v4, v5], s[8:15] dmask:0x3 dim:SQ_RSRC_IMG_1D_ARRAY
// GFX12: encoding: [0x04,0x80,0xc2,0xd0,0x00,0x10,0x00,0x00,0x04,0x05,0x00,0x00]

image_atomic_swap v[1:2], [v4, v5, v6], s[8:15] dmask:0x3 dim:SQ_RSRC_IMG_2D_ARRAY
// GFX12: encoding: [0x05,0x80,0xc2,0xd0,0x01,0x10,0x00,0x00,0x04,0x05,0x06,0x00]

image_atomic_swap v[3:4], [v4, v5, v6], s[8:15] dmask:0x3 dim:SQ_RSRC_IMG_2D_MSAA
// GFX12: encoding: [0x06,0x80,0xc2,0xd0,0x03,0x10,0x00,0x00,0x04,0x05,0x06,0x00]

image_atomic_swap v[254:255], [v4, v5, v6, v7], s[96:103] dmask:0x3 dim:SQ_RSRC_IMG_2D_MSAA_ARRAY
// GFX12: encoding: [0x07,0x80,0xc2,0xd0,0xfe,0xc0,0x00,0x00,0x04,0x05,0x06,0x07]

image_atomic_swap v0, v0, s[0:7] dmask:0x1 dim:SQ_RSRC_IMG_1D scope:SCOPE_CU
// GFX12: encoding: [0x00,0x80,0x42,0xd0,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00]

image_atomic_swap v0, v0, s[0:7] dmask:0x1 dim:SQ_RSRC_IMG_1D scope:SCOPE_SE
// GFX12: encoding: [0x00,0x80,0x42,0xd0,0x00,0x00,0x04,0x00,0x00,0x00,0x00,0x00]

image_atomic_swap v0, v0, s[0:7] dmask:0x1 dim:SQ_RSRC_IMG_1D scope:SCOPE_DEV
// GFX12: encoding: [0x00,0x80,0x42,0xd0,0x00,0x00,0x08,0x00,0x00,0x00,0x00,0x00]

image_atomic_swap v0, v0, s[0:7] dmask:0x1 dim:SQ_RSRC_IMG_1D scope:SCOPE_SYS
// GFX12: encoding: [0x00,0x80,0x42,0xd0,0x00,0x00,0x0c,0x00,0x00,0x00,0x00,0x00]

image_atomic_swap v0, v0, s[0:7] dmask:0x1 dim:SQ_RSRC_IMG_1D th:TH_ATOMIC_RETURN
// GFX12: encoding: [0x00,0x80,0x42,0xd0,0x00,0x00,0x10,0x00,0x00,0x00,0x00,0x00]

image_atomic_swap v0, v0, s[0:7] dmask:0x1 dim:SQ_RSRC_IMG_1D th:TH_ATOMIC_RT
// GFX12: encoding: [0x00,0x80,0x42,0xd0,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00]

image_atomic_swap v0, v0, s[0:7] dmask:0x1 dim:SQ_RSRC_IMG_1D th:TH_ATOMIC_RT_RETURN
// GFX12: encoding: [0x00,0x80,0x42,0xd0,0x00,0x00,0x10,0x00,0x00,0x00,0x00,0x00]

image_atomic_swap v0, v0, s[0:7] dmask:0x1 dim:SQ_RSRC_IMG_1D th:TH_ATOMIC_NT
// GFX12: encoding: [0x00,0x80,0x42,0xd0,0x00,0x00,0x20,0x00,0x00,0x00,0x00,0x00]

image_atomic_swap v0, v0, s[0:7] dmask:0x1 dim:SQ_RSRC_IMG_1D th:TH_ATOMIC_NT_RETURN
// GFX12: encoding: [0x00,0x80,0x42,0xd0,0x00,0x00,0x30,0x00,0x00,0x00,0x00,0x00]

image_atomic_swap v0, v0, s[0:7] dmask:0x1 dim:SQ_RSRC_IMG_1D th:TH_ATOMIC_CASCADE_RT scope:SCOPE_DEV
// GFX12: encoding: [0x00,0x80,0x42,0xd0,0x00,0x00,0x48,0x00,0x00,0x00,0x00,0x00]

image_atomic_swap v0, v0, s[0:7] dmask:0x1 dim:SQ_RSRC_IMG_1D th:TH_ATOMIC_CASCADE_NT scope:SCOPE_SYS
// GFX12: encoding: [0x00,0x80,0x42,0xd0,0x00,0x00,0x6c,0x00,0x00,0x00,0x00,0x00]

// FIXME: This test is incorrect because r128 assumes a 128-bit RSRC.
image_atomic_swap v0, [v2, v3], s[4:11] dmask:0x1 dim:SQ_RSRC_IMG_2D r128
// GFX12: encoding: [0x11,0x80,0x42,0xd0,0x00,0x08,0x00,0x00,0x02,0x03,0x00,0x00]

image_atomic_swap v0, v0, s[0:7] dmask:0x1 dim:SQ_RSRC_IMG_1D a16
// GFX12: encoding: [0x40,0x80,0x42,0xd0,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00]

image_atomic_swap v1, v2, s[4:11] dmask:0x1 dim:SQ_RSRC_IMG_2D a16
// GFX12: encoding: [0x41,0x80,0x42,0xd0,0x01,0x08,0x00,0x00,0x02,0x00,0x00,0x00]

image_atomic_swap v4, [v4, v5], s[8:15] dmask:0x1 dim:SQ_RSRC_IMG_3D a16
// GFX12: encoding: [0x42,0x80,0x42,0xd0,0x04,0x10,0x00,0x00,0x04,0x05,0x00,0x00]

image_atomic_swap v255, [v4, v5], s[8:15] dmask:0x1 dim:SQ_RSRC_IMG_CUBE a16
// GFX12: encoding: [0x43,0x80,0x42,0xd0,0xff,0x10,0x00,0x00,0x04,0x05,0x00,0x00]

image_atomic_swap v[0:1], v4, s[8:15] dmask:0x3 dim:SQ_RSRC_IMG_1D_ARRAY a16
// GFX12: encoding: [0x44,0x80,0xc2,0xd0,0x00,0x10,0x00,0x00,0x04,0x00,0x00,0x00]

image_atomic_swap v[1:2], [v4, v5], s[8:15] dmask:0x3 dim:SQ_RSRC_IMG_2D_ARRAY a16
// GFX12: encoding: [0x45,0x80,0xc2,0xd0,0x01,0x10,0x00,0x00,0x04,0x05,0x00,0x00]

image_atomic_swap v[3:4], [v4, v5], s[8:15] dmask:0x3 dim:SQ_RSRC_IMG_2D_MSAA a16
// GFX12: encoding: [0x46,0x80,0xc2,0xd0,0x03,0x10,0x00,0x00,0x04,0x05,0x00,0x00]

image_atomic_swap v[254:255], [v4, v5], s[96:103] dmask:0x3 dim:SQ_RSRC_IMG_2D_MSAA_ARRAY a16
// GFX12: encoding: [0x47,0x80,0xc2,0xd0,0xfe,0xc0,0x00,0x00,0x04,0x05,0x00,0x00]

image_atomic_swap v1, [v2, v0], s[4:11] dmask:0x1 dim:SQ_RSRC_IMG_2D
// GFX12: encoding: [0x01,0x80,0x42,0xd0,0x01,0x08,0x00,0x00,0x02,0x00,0x00,0x00]

image_atomic_swap v1, [v2, v1, v0], s[4:11] dmask:0x1 dim:SQ_RSRC_IMG_3D
// GFX12: encoding: [0x02,0x80,0x42,0xd0,0x01,0x08,0x00,0x00,0x02,0x01,0x00,0x00]

image_atomic_swap v1, [v3, v2, v1, v0], s[4:11] dmask:0x1 dim:SQ_RSRC_IMG_2D_MSAA_ARRAY
// GFX12: encoding: [0x07,0x80,0x42,0xd0,0x01,0x08,0x00,0x00,0x03,0x02,0x01,0x00]

image_atomic_cmpswap v[0:1], v0, s[0:7] dmask:0x3 dim:SQ_RSRC_IMG_1D
// GFX12: encoding: [0x00,0xc0,0xc2,0xd0,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00]

image_atomic_cmpswap v[1:2], [v2, v3], s[4:11] dmask:0x3 dim:SQ_RSRC_IMG_2D
// GFX12: encoding: [0x01,0xc0,0xc2,0xd0,0x01,0x08,0x00,0x00,0x02,0x03,0x00,0x00]

image_atomic_cmpswap v[3:4], [v4, v5, v6], s[8:15] dmask:0x3 dim:SQ_RSRC_IMG_3D
// GFX12: encoding: [0x02,0xc0,0xc2,0xd0,0x03,0x10,0x00,0x00,0x04,0x05,0x06,0x00]

image_atomic_cmpswap v[254:255], [v4, v5, v6], s[8:15] dmask:0x3 dim:SQ_RSRC_IMG_CUBE
// GFX12: encoding: [0x03,0xc0,0xc2,0xd0,0xfe,0x10,0x00,0x00,0x04,0x05,0x06,0x00]

image_atomic_cmpswap v[0:3], [v4, v5], s[8:15] dmask:0xf dim:SQ_RSRC_IMG_1D_ARRAY
// GFX12: encoding: [0x04,0xc0,0xc2,0xd3,0x00,0x10,0x00,0x00,0x04,0x05,0x00,0x00]

image_atomic_cmpswap v[1:4], [v4, v5, v6], s[8:15] dmask:0xf dim:SQ_RSRC_IMG_2D_ARRAY
// GFX12: encoding: [0x05,0xc0,0xc2,0xd3,0x01,0x10,0x00,0x00,0x04,0x05,0x06,0x00]

image_atomic_cmpswap v[4:7], [v4, v5, v6], s[8:15] dmask:0xf dim:SQ_RSRC_IMG_2D_MSAA
// GFX12: encoding: [0x06,0xc0,0xc2,0xd3,0x04,0x10,0x00,0x00,0x04,0x05,0x06,0x00]

image_atomic_cmpswap v[252:255], [v4, v5, v6, v7], s[96:103] dmask:0xf dim:SQ_RSRC_IMG_2D_MSAA_ARRAY
// GFX12: encoding: [0x07,0xc0,0xc2,0xd3,0xfc,0xc0,0x00,0x00,0x04,0x05,0x06,0x07]

image_atomic_cmpswap v[0:1], v0, s[0:7] dmask:0x3 dim:SQ_RSRC_IMG_1D th:TH_ATOMIC_NT
// GFX12: encoding: [0x00,0xc0,0xc2,0xd0,0x00,0x00,0x20,0x00,0x00,0x00,0x00,0x00]

image_atomic_add_uint v0, v0, s[0:7] dmask:0x1 dim:SQ_RSRC_IMG_1D
// GFX12: encoding: [0x00,0x00,0x43,0xd0,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00]

image_atomic_add_uint v1, [v2, v3], s[4:11] dmask:0x1 dim:SQ_RSRC_IMG_2D
// GFX12: encoding: [0x01,0x00,0x43,0xd0,0x01,0x08,0x00,0x00,0x02,0x03,0x00,0x00]

image_atomic_add_uint v4, [v4, v5, v6], s[8:15] dmask:0x1 dim:SQ_RSRC_IMG_3D
// GFX12: encoding: [0x02,0x00,0x43,0xd0,0x04,0x10,0x00,0x00,0x04,0x05,0x06,0x00]

image_atomic_add_uint v255, [v4, v5, v6], s[8:15] dmask:0x1 dim:SQ_RSRC_IMG_CUBE
// GFX12: encoding: [0x03,0x00,0x43,0xd0,0xff,0x10,0x00,0x00,0x04,0x05,0x06,0x00]

image_atomic_add_uint v[0:1], [v4, v5], s[8:15] dmask:0x3 dim:SQ_RSRC_IMG_1D_ARRAY
// GFX12: encoding: [0x04,0x00,0xc3,0xd0,0x00,0x10,0x00,0x00,0x04,0x05,0x00,0x00]

image_atomic_add_uint v[1:2], [v4, v5, v6], s[8:15] dmask:0x3 dim:SQ_RSRC_IMG_2D_ARRAY
// GFX12: encoding: [0x05,0x00,0xc3,0xd0,0x01,0x10,0x00,0x00,0x04,0x05,0x06,0x00]

image_atomic_add_uint v[3:4], [v4, v5, v6], s[8:15] dmask:0x3 dim:SQ_RSRC_IMG_2D_MSAA
// GFX12: encoding: [0x06,0x00,0xc3,0xd0,0x03,0x10,0x00,0x00,0x04,0x05,0x06,0x00]

image_atomic_add_uint v[254:255], [v4, v5, v6, v7], s[96:103] dmask:0x3 dim:SQ_RSRC_IMG_2D_MSAA_ARRAY
// GFX12: encoding: [0x07,0x00,0xc3,0xd0,0xfe,0xc0,0x00,0x00,0x04,0x05,0x06,0x07]

image_atomic_add_uint v0, v0, s[0:7] dmask:0x1 dim:SQ_RSRC_IMG_1D th:TH_ATOMIC_NT
// GFX12: encoding: [0x00,0x00,0x43,0xd0,0x00,0x00,0x20,0x00,0x00,0x00,0x00,0x00]

image_atomic_add_uint v1, [v2, v0], s[4:11] dmask:0x1 dim:SQ_RSRC_IMG_2D
// GFX12: encoding: [0x01,0x00,0x43,0xd0,0x01,0x08,0x00,0x00,0x02,0x00,0x00,0x00]

image_atomic_add_uint v1, [v2, v1, v0], s[4:11] dmask:0x1 dim:SQ_RSRC_IMG_3D
// GFX12: encoding: [0x02,0x00,0x43,0xd0,0x01,0x08,0x00,0x00,0x02,0x01,0x00,0x00]

image_atomic_add_uint v1, [v3, v2, v1, v0], s[4:11] dmask:0x1 dim:SQ_RSRC_IMG_2D_MSAA_ARRAY
// GFX12: encoding: [0x07,0x00,0x43,0xd0,0x01,0x08,0x00,0x00,0x03,0x02,0x01,0x00]

image_atomic_sub_uint v0, v0, s[0:7] dmask:0x1 dim:SQ_RSRC_IMG_1D
// GFX12: encoding: [0x00,0x40,0x43,0xd0,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00]

image_atomic_sub_uint v1, [v2, v3], s[4:11] dmask:0x1 dim:SQ_RSRC_IMG_2D
// GFX12: encoding: [0x01,0x40,0x43,0xd0,0x01,0x08,0x00,0x00,0x02,0x03,0x00,0x00]

image_atomic_sub_uint v4, [v4, v5, v6], s[8:15] dmask:0x1 dim:SQ_RSRC_IMG_3D
// GFX12: encoding: [0x02,0x40,0x43,0xd0,0x04,0x10,0x00,0x00,0x04,0x05,0x06,0x00]

image_atomic_sub_uint v255, [v4, v5, v6], s[8:15] dmask:0x1 dim:SQ_RSRC_IMG_CUBE
// GFX12: encoding: [0x03,0x40,0x43,0xd0,0xff,0x10,0x00,0x00,0x04,0x05,0x06,0x00]

image_atomic_sub_uint v[0:1], [v4, v5], s[8:15] dmask:0x3 dim:SQ_RSRC_IMG_1D_ARRAY
// GFX12: encoding: [0x04,0x40,0xc3,0xd0,0x00,0x10,0x00,0x00,0x04,0x05,0x00,0x00]

image_atomic_sub_uint v[1:2], [v4, v5, v6], s[8:15] dmask:0x3 dim:SQ_RSRC_IMG_2D_ARRAY
// GFX12: encoding: [0x05,0x40,0xc3,0xd0,0x01,0x10,0x00,0x00,0x04,0x05,0x06,0x00]

image_atomic_sub_uint v[3:4], [v4, v5, v6], s[8:15] dmask:0x3 dim:SQ_RSRC_IMG_2D_MSAA
// GFX12: encoding: [0x06,0x40,0xc3,0xd0,0x03,0x10,0x00,0x00,0x04,0x05,0x06,0x00]

image_atomic_sub_uint v[254:255], [v4, v5, v6, v7], s[96:103] dmask:0x3 dim:SQ_RSRC_IMG_2D_MSAA_ARRAY
// GFX12: encoding: [0x07,0x40,0xc3,0xd0,0xfe,0xc0,0x00,0x00,0x04,0x05,0x06,0x07]

image_atomic_sub_uint v0, v0, s[0:7] dmask:0x1 dim:SQ_RSRC_IMG_1D th:TH_ATOMIC_NT
// GFX12: encoding: [0x00,0x40,0x43,0xd0,0x00,0x00,0x20,0x00,0x00,0x00,0x00,0x00]

image_atomic_min_int v0, v0, s[0:7] dmask:0x1 dim:SQ_RSRC_IMG_1D
// GFX12: encoding: [0x00,0x80,0x43,0xd0,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00]

image_atomic_min_int v1, [v2, v3], s[4:11] dmask:0x1 dim:SQ_RSRC_IMG_2D
// GFX12: encoding: [0x01,0x80,0x43,0xd0,0x01,0x08,0x00,0x00,0x02,0x03,0x00,0x00]

image_atomic_min_int v4, [v4, v5, v6], s[8:15] dmask:0x1 dim:SQ_RSRC_IMG_3D
// GFX12: encoding: [0x02,0x80,0x43,0xd0,0x04,0x10,0x00,0x00,0x04,0x05,0x06,0x00]

image_atomic_min_int v255, [v4, v5, v6], s[8:15] dmask:0x1 dim:SQ_RSRC_IMG_CUBE
// GFX12: encoding: [0x03,0x80,0x43,0xd0,0xff,0x10,0x00,0x00,0x04,0x05,0x06,0x00]

image_atomic_min_int v[0:1], [v4, v5], s[8:15] dmask:0x3 dim:SQ_RSRC_IMG_1D_ARRAY
// GFX12: encoding: [0x04,0x80,0xc3,0xd0,0x00,0x10,0x00,0x00,0x04,0x05,0x00,0x00]

image_atomic_min_int v[1:2], [v4, v5, v6], s[8:15] dmask:0x3 dim:SQ_RSRC_IMG_2D_ARRAY
// GFX12: encoding: [0x05,0x80,0xc3,0xd0,0x01,0x10,0x00,0x00,0x04,0x05,0x06,0x00]

image_atomic_min_int v[3:4], [v4, v5, v6], s[8:15] dmask:0x3 dim:SQ_RSRC_IMG_2D_MSAA
// GFX12: encoding: [0x06,0x80,0xc3,0xd0,0x03,0x10,0x00,0x00,0x04,0x05,0x06,0x00]

image_atomic_min_int v[254:255], [v4, v5, v6, v7], s[96:103] dmask:0x3 dim:SQ_RSRC_IMG_2D_MSAA_ARRAY
// GFX12: encoding: [0x07,0x80,0xc3,0xd0,0xfe,0xc0,0x00,0x00,0x04,0x05,0x06,0x07]

image_atomic_min_int v0, v0, s[0:7] dmask:0x1 dim:SQ_RSRC_IMG_1D th:TH_ATOMIC_NT
// GFX12: encoding: [0x00,0x80,0x43,0xd0,0x00,0x00,0x20,0x00,0x00,0x00,0x00,0x00]

image_atomic_min_uint v0, v0, s[0:7] dmask:0x1 dim:SQ_RSRC_IMG_1D
// GFX12: encoding: [0x00,0xc0,0x43,0xd0,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00]

image_atomic_min_uint v1, [v2, v3], s[4:11] dmask:0x1 dim:SQ_RSRC_IMG_2D
// GFX12: encoding: [0x01,0xc0,0x43,0xd0,0x01,0x08,0x00,0x00,0x02,0x03,0x00,0x00]

image_atomic_min_uint v4, [v4, v5, v6], s[8:15] dmask:0x1 dim:SQ_RSRC_IMG_3D
// GFX12: encoding: [0x02,0xc0,0x43,0xd0,0x04,0x10,0x00,0x00,0x04,0x05,0x06,0x00]

image_atomic_min_uint v255, [v4, v5, v6], s[8:15] dmask:0x1 dim:SQ_RSRC_IMG_CUBE
// GFX12: encoding: [0x03,0xc0,0x43,0xd0,0xff,0x10,0x00,0x00,0x04,0x05,0x06,0x00]

image_atomic_min_uint v[0:1], [v4, v5], s[8:15] dmask:0x3 dim:SQ_RSRC_IMG_1D_ARRAY
// GFX12: encoding: [0x04,0xc0,0xc3,0xd0,0x00,0x10,0x00,0x00,0x04,0x05,0x00,0x00]

image_atomic_min_uint v[1:2], [v4, v5, v6], s[8:15] dmask:0x3 dim:SQ_RSRC_IMG_2D_ARRAY
// GFX12: encoding: [0x05,0xc0,0xc3,0xd0,0x01,0x10,0x00,0x00,0x04,0x05,0x06,0x00]

image_atomic_min_uint v[3:4], [v4, v5, v6], s[8:15] dmask:0x3 dim:SQ_RSRC_IMG_2D_MSAA
// GFX12: encoding: [0x06,0xc0,0xc3,0xd0,0x03,0x10,0x00,0x00,0x04,0x05,0x06,0x00]

image_atomic_min_uint v[254:255], [v4, v5, v6, v7], s[96:103] dmask:0x3 dim:SQ_RSRC_IMG_2D_MSAA_ARRAY
// GFX12: encoding: [0x07,0xc0,0xc3,0xd0,0xfe,0xc0,0x00,0x00,0x04,0x05,0x06,0x07]

image_atomic_min_uint v0, v0, s[0:7] dmask:0x1 dim:SQ_RSRC_IMG_1D th:TH_ATOMIC_NT
// GFX12: encoding: [0x00,0xc0,0x43,0xd0,0x00,0x00,0x20,0x00,0x00,0x00,0x00,0x00]

image_atomic_max_int v0, v0, s[0:7] dmask:0x1 dim:SQ_RSRC_IMG_1D
// GFX12: encoding: [0x00,0x00,0x44,0xd0,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00]

image_atomic_max_int v1, [v2, v3], s[4:11] dmask:0x1 dim:SQ_RSRC_IMG_2D
// GFX12: encoding: [0x01,0x00,0x44,0xd0,0x01,0x08,0x00,0x00,0x02,0x03,0x00,0x00]

image_atomic_max_int v4, [v4, v5, v6], s[8:15] dmask:0x1 dim:SQ_RSRC_IMG_3D
// GFX12: encoding: [0x02,0x00,0x44,0xd0,0x04,0x10,0x00,0x00,0x04,0x05,0x06,0x00]

image_atomic_max_int v255, [v4, v5, v6], s[8:15] dmask:0x1 dim:SQ_RSRC_IMG_CUBE
// GFX12: encoding: [0x03,0x00,0x44,0xd0,0xff,0x10,0x00,0x00,0x04,0x05,0x06,0x00]

image_atomic_max_int v[0:1], [v4, v5], s[8:15] dmask:0x3 dim:SQ_RSRC_IMG_1D_ARRAY
// GFX12: encoding: [0x04,0x00,0xc4,0xd0,0x00,0x10,0x00,0x00,0x04,0x05,0x00,0x00]

image_atomic_max_int v[1:2], [v4, v5, v6], s[8:15] dmask:0x3 dim:SQ_RSRC_IMG_2D_ARRAY
// GFX12: encoding: [0x05,0x00,0xc4,0xd0,0x01,0x10,0x00,0x00,0x04,0x05,0x06,0x00]

image_atomic_max_int v[3:4], [v4, v5, v6], s[8:15] dmask:0x3 dim:SQ_RSRC_IMG_2D_MSAA
// GFX12: encoding: [0x06,0x00,0xc4,0xd0,0x03,0x10,0x00,0x00,0x04,0x05,0x06,0x00]

image_atomic_max_int v[254:255], [v4, v5, v6, v7], s[96:103] dmask:0x3 dim:SQ_RSRC_IMG_2D_MSAA_ARRAY
// GFX12: encoding: [0x07,0x00,0xc4,0xd0,0xfe,0xc0,0x00,0x00,0x04,0x05,0x06,0x07]

image_atomic_max_int v0, v0, s[0:7] dmask:0x1 dim:SQ_RSRC_IMG_1D th:TH_ATOMIC_NT
// GFX12: encoding: [0x00,0x00,0x44,0xd0,0x00,0x00,0x20,0x00,0x00,0x00,0x00,0x00]

image_atomic_max_uint v0, v0, s[0:7] dmask:0x1 dim:SQ_RSRC_IMG_1D
// GFX12: encoding: [0x00,0x40,0x44,0xd0,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00]

image_atomic_max_uint v1, [v2, v3], s[4:11] dmask:0x1 dim:SQ_RSRC_IMG_2D
// GFX12: encoding: [0x01,0x40,0x44,0xd0,0x01,0x08,0x00,0x00,0x02,0x03,0x00,0x00]

image_atomic_max_uint v4, [v4, v5, v6], s[8:15] dmask:0x1 dim:SQ_RSRC_IMG_3D
// GFX12: encoding: [0x02,0x40,0x44,0xd0,0x04,0x10,0x00,0x00,0x04,0x05,0x06,0x00]

image_atomic_max_uint v255, [v4, v5, v6], s[8:15] dmask:0x1 dim:SQ_RSRC_IMG_CUBE
// GFX12: encoding: [0x03,0x40,0x44,0xd0,0xff,0x10,0x00,0x00,0x04,0x05,0x06,0x00]

image_atomic_max_uint v[0:1], [v4, v5], s[8:15] dmask:0x3 dim:SQ_RSRC_IMG_1D_ARRAY
// GFX12: encoding: [0x04,0x40,0xc4,0xd0,0x00,0x10,0x00,0x00,0x04,0x05,0x00,0x00]

image_atomic_max_uint v[1:2], [v4, v5, v6], s[8:15] dmask:0x3 dim:SQ_RSRC_IMG_2D_ARRAY
// GFX12: encoding: [0x05,0x40,0xc4,0xd0,0x01,0x10,0x00,0x00,0x04,0x05,0x06,0x00]

image_atomic_max_uint v[3:4], [v4, v5, v6], s[8:15] dmask:0x3 dim:SQ_RSRC_IMG_2D_MSAA
// GFX12: encoding: [0x06,0x40,0xc4,0xd0,0x03,0x10,0x00,0x00,0x04,0x05,0x06,0x00]

image_atomic_max_uint v[254:255], [v4, v5, v6, v7], s[96:103] dmask:0x3 dim:SQ_RSRC_IMG_2D_MSAA_ARRAY
// GFX12: encoding: [0x07,0x40,0xc4,0xd0,0xfe,0xc0,0x00,0x00,0x04,0x05,0x06,0x07]

image_atomic_max_uint v0, v0, s[0:7] dmask:0x1 dim:SQ_RSRC_IMG_1D th:TH_ATOMIC_NT
// GFX12: encoding: [0x00,0x40,0x44,0xd0,0x00,0x00,0x20,0x00,0x00,0x00,0x00,0x00]

image_atomic_and v0, v0, s[0:7] dmask:0x1 dim:SQ_RSRC_IMG_1D
// GFX12: encoding: [0x00,0x80,0x44,0xd0,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00]

image_atomic_and v1, [v2, v3], s[4:11] dmask:0x1 dim:SQ_RSRC_IMG_2D
// GFX12: encoding: [0x01,0x80,0x44,0xd0,0x01,0x08,0x00,0x00,0x02,0x03,0x00,0x00]

image_atomic_and v4, [v4, v5, v6], s[8:15] dmask:0x1 dim:SQ_RSRC_IMG_3D
// GFX12: encoding: [0x02,0x80,0x44,0xd0,0x04,0x10,0x00,0x00,0x04,0x05,0x06,0x00]

image_atomic_and v255, [v4, v5, v6], s[8:15] dmask:0x1 dim:SQ_RSRC_IMG_CUBE
// GFX12: encoding: [0x03,0x80,0x44,0xd0,0xff,0x10,0x00,0x00,0x04,0x05,0x06,0x00]

image_atomic_and v[0:1], [v4, v5], s[8:15] dmask:0x3 dim:SQ_RSRC_IMG_1D_ARRAY
// GFX12: encoding: [0x04,0x80,0xc4,0xd0,0x00,0x10,0x00,0x00,0x04,0x05,0x00,0x00]

image_atomic_and v[1:2], [v4, v5, v6], s[8:15] dmask:0x3 dim:SQ_RSRC_IMG_2D_ARRAY
// GFX12: encoding: [0x05,0x80,0xc4,0xd0,0x01,0x10,0x00,0x00,0x04,0x05,0x06,0x00]

image_atomic_and v[3:4], [v4, v5, v6], s[8:15] dmask:0x3 dim:SQ_RSRC_IMG_2D_MSAA
// GFX12: encoding: [0x06,0x80,0xc4,0xd0,0x03,0x10,0x00,0x00,0x04,0x05,0x06,0x00]

image_atomic_and v[254:255], [v4, v5, v6, v7], s[96:103] dmask:0x3 dim:SQ_RSRC_IMG_2D_MSAA_ARRAY
// GFX12: encoding: [0x07,0x80,0xc4,0xd0,0xfe,0xc0,0x00,0x00,0x04,0x05,0x06,0x07]

image_atomic_and v0, v0, s[0:7] dmask:0x1 dim:SQ_RSRC_IMG_1D th:TH_ATOMIC_NT
// GFX12: encoding: [0x00,0x80,0x44,0xd0,0x00,0x00,0x20,0x00,0x00,0x00,0x00,0x00]

image_atomic_or v0, v0, s[0:7] dmask:0x1 dim:SQ_RSRC_IMG_1D
// GFX12: encoding: [0x00,0xc0,0x44,0xd0,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00]

image_atomic_or v1, [v2, v3], s[4:11] dmask:0x1 dim:SQ_RSRC_IMG_2D
// GFX12: encoding: [0x01,0xc0,0x44,0xd0,0x01,0x08,0x00,0x00,0x02,0x03,0x00,0x00]

image_atomic_or v4, [v4, v5, v6], s[8:15] dmask:0x1 dim:SQ_RSRC_IMG_3D
// GFX12: encoding: [0x02,0xc0,0x44,0xd0,0x04,0x10,0x00,0x00,0x04,0x05,0x06,0x00]

image_atomic_or v255, [v4, v5, v6], s[8:15] dmask:0x1 dim:SQ_RSRC_IMG_CUBE
// GFX12: encoding: [0x03,0xc0,0x44,0xd0,0xff,0x10,0x00,0x00,0x04,0x05,0x06,0x00]

image_atomic_or v[0:1], [v4, v5], s[8:15] dmask:0x3 dim:SQ_RSRC_IMG_1D_ARRAY
// GFX12: encoding: [0x04,0xc0,0xc4,0xd0,0x00,0x10,0x00,0x00,0x04,0x05,0x00,0x00]

image_atomic_or v[1:2], [v4, v5, v6], s[8:15] dmask:0x3 dim:SQ_RSRC_IMG_2D_ARRAY
// GFX12: encoding: [0x05,0xc0,0xc4,0xd0,0x01,0x10,0x00,0x00,0x04,0x05,0x06,0x00]

image_atomic_or v[3:4], [v4, v5, v6], s[8:15] dmask:0x3 dim:SQ_RSRC_IMG_2D_MSAA
// GFX12: encoding: [0x06,0xc0,0xc4,0xd0,0x03,0x10,0x00,0x00,0x04,0x05,0x06,0x00]

image_atomic_or v[254:255], [v4, v5, v6, v7], s[96:103] dmask:0x3 dim:SQ_RSRC_IMG_2D_MSAA_ARRAY
// GFX12: encoding: [0x07,0xc0,0xc4,0xd0,0xfe,0xc0,0x00,0x00,0x04,0x05,0x06,0x07]

image_atomic_or v0, v0, s[0:7] dmask:0x1 dim:SQ_RSRC_IMG_1D th:TH_ATOMIC_NT
// GFX12: encoding: [0x00,0xc0,0x44,0xd0,0x00,0x00,0x20,0x00,0x00,0x00,0x00,0x00]

image_atomic_xor v0, v0, s[0:7] dmask:0x1 dim:SQ_RSRC_IMG_1D
// GFX12: encoding: [0x00,0x00,0x45,0xd0,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00]

image_atomic_xor v1, [v2, v3], s[4:11] dmask:0x1 dim:SQ_RSRC_IMG_2D
// GFX12: encoding: [0x01,0x00,0x45,0xd0,0x01,0x08,0x00,0x00,0x02,0x03,0x00,0x00]

image_atomic_xor v4, [v4, v5, v6], s[8:15] dmask:0x1 dim:SQ_RSRC_IMG_3D
// GFX12: encoding: [0x02,0x00,0x45,0xd0,0x04,0x10,0x00,0x00,0x04,0x05,0x06,0x00]

image_atomic_xor v255, [v4, v5, v6], s[8:15] dmask:0x1 dim:SQ_RSRC_IMG_CUBE
// GFX12: encoding: [0x03,0x00,0x45,0xd0,0xff,0x10,0x00,0x00,0x04,0x05,0x06,0x00]

image_atomic_xor v[0:1], [v4, v5], s[8:15] dmask:0x3 dim:SQ_RSRC_IMG_1D_ARRAY
// GFX12: encoding: [0x04,0x00,0xc5,0xd0,0x00,0x10,0x00,0x00,0x04,0x05,0x00,0x00]

image_atomic_xor v[1:2], [v4, v5, v6], s[8:15] dmask:0x3 dim:SQ_RSRC_IMG_2D_ARRAY
// GFX12: encoding: [0x05,0x00,0xc5,0xd0,0x01,0x10,0x00,0x00,0x04,0x05,0x06,0x00]

image_atomic_xor v[3:4], [v4, v5, v6], s[8:15] dmask:0x3 dim:SQ_RSRC_IMG_2D_MSAA
// GFX12: encoding: [0x06,0x00,0xc5,0xd0,0x03,0x10,0x00,0x00,0x04,0x05,0x06,0x00]

image_atomic_xor v[254:255], [v4, v5, v6, v7], s[96:103] dmask:0x3 dim:SQ_RSRC_IMG_2D_MSAA_ARRAY
// GFX12: encoding: [0x07,0x00,0xc5,0xd0,0xfe,0xc0,0x00,0x00,0x04,0x05,0x06,0x07]

image_atomic_xor v0, v0, s[0:7] dmask:0x1 dim:SQ_RSRC_IMG_1D th:TH_ATOMIC_NT
// GFX12: encoding: [0x00,0x00,0x45,0xd0,0x00,0x00,0x20,0x00,0x00,0x00,0x00,0x00]

image_atomic_inc_uint v0, v0, s[0:7] dmask:0x1 dim:SQ_RSRC_IMG_1D
// GFX12: encoding: [0x00,0x40,0x45,0xd0,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00]

image_atomic_inc_uint v1, [v2, v3], s[4:11] dmask:0x1 dim:SQ_RSRC_IMG_2D
// GFX12: encoding: [0x01,0x40,0x45,0xd0,0x01,0x08,0x00,0x00,0x02,0x03,0x00,0x00]

image_atomic_inc_uint v4, [v4, v5, v6], s[8:15] dmask:0x1 dim:SQ_RSRC_IMG_3D
// GFX12: encoding: [0x02,0x40,0x45,0xd0,0x04,0x10,0x00,0x00,0x04,0x05,0x06,0x00]

image_atomic_inc_uint v255, [v4, v5, v6], s[8:15] dmask:0x1 dim:SQ_RSRC_IMG_CUBE
// GFX12: encoding: [0x03,0x40,0x45,0xd0,0xff,0x10,0x00,0x00,0x04,0x05,0x06,0x00]

image_atomic_inc_uint v[0:1], [v4, v5], s[8:15] dmask:0x3 dim:SQ_RSRC_IMG_1D_ARRAY
// GFX12: encoding: [0x04,0x40,0xc5,0xd0,0x00,0x10,0x00,0x00,0x04,0x05,0x00,0x00]

image_atomic_inc_uint v[1:2], [v4, v5, v6], s[8:15] dmask:0x3 dim:SQ_RSRC_IMG_2D_ARRAY
// GFX12: encoding: [0x05,0x40,0xc5,0xd0,0x01,0x10,0x00,0x00,0x04,0x05,0x06,0x00]

image_atomic_inc_uint v[3:4], [v4, v5, v6], s[8:15] dmask:0x3 dim:SQ_RSRC_IMG_2D_MSAA
// GFX12: encoding: [0x06,0x40,0xc5,0xd0,0x03,0x10,0x00,0x00,0x04,0x05,0x06,0x00]

image_atomic_inc_uint v[254:255], [v4, v5, v6, v7], s[96:103] dmask:0x3 dim:SQ_RSRC_IMG_2D_MSAA_ARRAY
// GFX12: encoding: [0x07,0x40,0xc5,0xd0,0xfe,0xc0,0x00,0x00,0x04,0x05,0x06,0x07]

image_atomic_inc_uint v0, v0, s[0:7] dmask:0x1 dim:SQ_RSRC_IMG_1D th:TH_ATOMIC_NT
// GFX12: encoding: [0x00,0x40,0x45,0xd0,0x00,0x00,0x20,0x00,0x00,0x00,0x00,0x00]

image_atomic_dec_uint v0, v0, s[0:7] dmask:0x1 dim:SQ_RSRC_IMG_1D
// GFX12: encoding: [0x00,0x80,0x45,0xd0,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00]

image_atomic_dec_uint v1, [v2, v3], s[4:11] dmask:0x1 dim:SQ_RSRC_IMG_2D
// GFX12: encoding: [0x01,0x80,0x45,0xd0,0x01,0x08,0x00,0x00,0x02,0x03,0x00,0x00]

image_atomic_dec_uint v4, [v4, v5, v6], s[8:15] dmask:0x1 dim:SQ_RSRC_IMG_3D
// GFX12: encoding: [0x02,0x80,0x45,0xd0,0x04,0x10,0x00,0x00,0x04,0x05,0x06,0x00]

image_atomic_dec_uint v255, [v4, v5, v6], s[8:15] dmask:0x1 dim:SQ_RSRC_IMG_CUBE
// GFX12: encoding: [0x03,0x80,0x45,0xd0,0xff,0x10,0x00,0x00,0x04,0x05,0x06,0x00]

image_atomic_dec_uint v[0:1], [v4, v5], s[8:15] dmask:0x3 dim:SQ_RSRC_IMG_1D_ARRAY
// GFX12: encoding: [0x04,0x80,0xc5,0xd0,0x00,0x10,0x00,0x00,0x04,0x05,0x00,0x00]

image_atomic_dec_uint v[1:2], [v4, v5, v6], s[8:15] dmask:0x3 dim:SQ_RSRC_IMG_2D_ARRAY
// GFX12: encoding: [0x05,0x80,0xc5,0xd0,0x01,0x10,0x00,0x00,0x04,0x05,0x06,0x00]

image_atomic_dec_uint v[3:4], [v4, v5, v6], s[8:15] dmask:0x3 dim:SQ_RSRC_IMG_2D_MSAA
// GFX12: encoding: [0x06,0x80,0xc5,0xd0,0x03,0x10,0x00,0x00,0x04,0x05,0x06,0x00]

image_atomic_dec_uint v[254:255], [v4, v5, v6, v7], s[96:103] dmask:0x3 dim:SQ_RSRC_IMG_2D_MSAA_ARRAY
// GFX12: encoding: [0x07,0x80,0xc5,0xd0,0xfe,0xc0,0x00,0x00,0x04,0x05,0x06,0x07]

image_atomic_dec_uint v0, v0, s[0:7] dmask:0x1 dim:SQ_RSRC_IMG_1D th:TH_ATOMIC_NT
// GFX12: encoding: [0x00,0x80,0x45,0xd0,0x00,0x00,0x20,0x00,0x00,0x00,0x00,0x00]

image_atomic_pk_add_f16 v0, v0, s[0:7] dmask:0x1 dim:SQ_RSRC_IMG_1D
// GFX12: encoding: [0x00,0x80,0x61,0xd0,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00]

image_atomic_pk_add_f16 v1, [v2, v3], s[4:11] dmask:0x1 dim:SQ_RSRC_IMG_2D
// GFX12: encoding: [0x01,0x80,0x61,0xd0,0x01,0x08,0x00,0x00,0x02,0x03,0x00,0x00]

image_atomic_pk_add_f16 v4, [v4, v5, v6], s[8:15] dmask:0x1 dim:SQ_RSRC_IMG_3D
// GFX12: encoding: [0x02,0x80,0x61,0xd0,0x04,0x10,0x00,0x00,0x04,0x05,0x06,0x00]

image_atomic_pk_add_f16 v255, [v4, v5, v6], s[8:15] dmask:0x1 dim:SQ_RSRC_IMG_CUBE
// GFX12: encoding: [0x03,0x80,0x61,0xd0,0xff,0x10,0x00,0x00,0x04,0x05,0x06,0x00]

image_atomic_pk_add_f16 v[0:1], [v4, v5], s[8:15] dmask:0x3 dim:SQ_RSRC_IMG_1D_ARRAY
// GFX12: encoding: [0x04,0x80,0xe1,0xd0,0x00,0x10,0x00,0x00,0x04,0x05,0x00,0x00]

image_atomic_pk_add_f16 v[1:2], [v4, v5, v6], s[8:15] dmask:0x3 dim:SQ_RSRC_IMG_2D_ARRAY
// GFX12: encoding: [0x05,0x80,0xe1,0xd0,0x01,0x10,0x00,0x00,0x04,0x05,0x06,0x00]

image_atomic_pk_add_f16 v[3:4], [v4, v5, v6], s[8:15] dmask:0x3 dim:SQ_RSRC_IMG_2D_MSAA
// GFX12: encoding: [0x06,0x80,0xe1,0xd0,0x03,0x10,0x00,0x00,0x04,0x05,0x06,0x00]

image_atomic_pk_add_f16 v[254:255], [v4, v5, v6, v7], s[96:103] dmask:0x3 dim:SQ_RSRC_IMG_2D_MSAA_ARRAY
// GFX12: encoding: [0x07,0x80,0xe1,0xd0,0xfe,0xc0,0x00,0x00,0x04,0x05,0x06,0x07]

image_atomic_pk_add_f16 v0, v0, s[0:7] dmask:0x1 dim:SQ_RSRC_IMG_1D th:TH_ATOMIC_NT
// GFX12: encoding: [0x00,0x80,0x61,0xd0,0x00,0x00,0x20,0x00,0x00,0x00,0x00,0x00]

image_atomic_pk_add_bf16 v0, v0, s[0:7] dmask:0x1 dim:SQ_RSRC_IMG_1D
// GFX12: encoding: [0x00,0xc0,0x61,0xd0,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00]

image_atomic_pk_add_bf16 v1, [v2, v3], s[4:11] dmask:0x1 dim:SQ_RSRC_IMG_2D
// GFX12: encoding: [0x01,0xc0,0x61,0xd0,0x01,0x08,0x00,0x00,0x02,0x03,0x00,0x00]

image_atomic_pk_add_bf16 v4, [v4, v5, v6], s[8:15] dmask:0x1 dim:SQ_RSRC_IMG_3D
// GFX12: encoding: [0x02,0xc0,0x61,0xd0,0x04,0x10,0x00,0x00,0x04,0x05,0x06,0x00]

image_atomic_pk_add_bf16 v255, [v4, v5, v6], s[8:15] dmask:0x1 dim:SQ_RSRC_IMG_CUBE
// GFX12: encoding: [0x03,0xc0,0x61,0xd0,0xff,0x10,0x00,0x00,0x04,0x05,0x06,0x00]

image_atomic_pk_add_bf16 v[0:1], [v4, v5], s[8:15] dmask:0x3 dim:SQ_RSRC_IMG_1D_ARRAY
// GFX12: encoding: [0x04,0xc0,0xe1,0xd0,0x00,0x10,0x00,0x00,0x04,0x05,0x00,0x00]

image_atomic_pk_add_bf16 v[1:2], [v4, v5, v6], s[8:15] dmask:0x3 dim:SQ_RSRC_IMG_2D_ARRAY
// GFX12: encoding: [0x05,0xc0,0xe1,0xd0,0x01,0x10,0x00,0x00,0x04,0x05,0x06,0x00]

image_atomic_pk_add_bf16 v[3:4], [v4, v5, v6], s[8:15] dmask:0x3 dim:SQ_RSRC_IMG_2D_MSAA
// GFX12: encoding: [0x06,0xc0,0xe1,0xd0,0x03,0x10,0x00,0x00,0x04,0x05,0x06,0x00]

image_atomic_pk_add_bf16 v[254:255], [v4, v5, v6, v7], s[96:103] dmask:0x3 dim:SQ_RSRC_IMG_2D_MSAA_ARRAY
// GFX12: encoding: [0x07,0xc0,0xe1,0xd0,0xfe,0xc0,0x00,0x00,0x04,0x05,0x06,0x07]

image_atomic_pk_add_bf16 v0, v0, s[0:7] dmask:0x1 dim:SQ_RSRC_IMG_1D th:TH_ATOMIC_NT
// GFX12: encoding: [0x00,0xc0,0x61,0xd0,0x00,0x00,0x20,0x00,0x00,0x00,0x00,0x00]

image_atomic_add_flt v0, v0, s[0:7] dmask:0x1 dim:SQ_RSRC_IMG_1D
// GFX12: encoding: [0x00,0xc0,0x60,0xd0,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00]

image_atomic_add_flt v1, [v2, v3], s[4:11] dmask:0x1 dim:SQ_RSRC_IMG_2D
// GFX12: encoding: [0x01,0xc0,0x60,0xd0,0x01,0x08,0x00,0x00,0x02,0x03,0x00,0x00]

image_atomic_add_flt v4, [v4, v5, v6], s[8:15] dmask:0x1 dim:SQ_RSRC_IMG_3D
// GFX12: encoding: [0x02,0xc0,0x60,0xd0,0x04,0x10,0x00,0x00,0x04,0x05,0x06,0x00]

image_atomic_add_flt v255, [v4, v5, v6], s[8:15] dmask:0x1 dim:SQ_RSRC_IMG_CUBE
// GFX12: encoding: [0x03,0xc0,0x60,0xd0,0xff,0x10,0x00,0x00,0x04,0x05,0x06,0x00]

image_atomic_add_flt v[0:1], [v4, v5], s[8:15] dmask:0x3 dim:SQ_RSRC_IMG_1D_ARRAY
// GFX12: encoding: [0x04,0xc0,0xe0,0xd0,0x00,0x10,0x00,0x00,0x04,0x05,0x00,0x00]

image_atomic_add_flt v[1:2], [v4, v5, v6], s[8:15] dmask:0x3 dim:SQ_RSRC_IMG_2D_ARRAY
// GFX12: encoding: [0x05,0xc0,0xe0,0xd0,0x01,0x10,0x00,0x00,0x04,0x05,0x06,0x00]

image_atomic_add_flt v[3:4], [v4, v5, v6], s[8:15] dmask:0x3 dim:SQ_RSRC_IMG_2D_MSAA
// GFX12: encoding: [0x06,0xc0,0xe0,0xd0,0x03,0x10,0x00,0x00,0x04,0x05,0x06,0x00]

image_atomic_add_flt v[254:255], [v4, v5, v6, v7], s[96:103] dmask:0x3 dim:SQ_RSRC_IMG_2D_MSAA_ARRAY
// GFX12: encoding: [0x07,0xc0,0xe0,0xd0,0xfe,0xc0,0x00,0x00,0x04,0x05,0x06,0x07]

image_atomic_add_flt v0, v0, s[0:7] dmask:0x1 dim:SQ_RSRC_IMG_1D th:TH_ATOMIC_NT
// GFX12: encoding: [0x00,0xc0,0x60,0xd0,0x00,0x00,0x20,0x00,0x00,0x00,0x00,0x00]

image_atomic_min_flt v0, v0, s[0:7] dmask:0x1 dim:SQ_RSRC_IMG_1D
// GFX12: encoding: [0x00,0x00,0x61,0xd0,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00]

image_atomic_min_flt v1, [v2, v3], s[4:11] dmask:0x1 dim:SQ_RSRC_IMG_2D
// GFX12: encoding: [0x01,0x00,0x61,0xd0,0x01,0x08,0x00,0x00,0x02,0x03,0x00,0x00]

image_atomic_min_flt v4, [v4, v5, v6], s[8:15] dmask:0x1 dim:SQ_RSRC_IMG_3D
// GFX12: encoding: [0x02,0x00,0x61,0xd0,0x04,0x10,0x00,0x00,0x04,0x05,0x06,0x00]

image_atomic_min_flt v255, [v4, v5, v6], s[8:15] dmask:0x1 dim:SQ_RSRC_IMG_CUBE
// GFX12: encoding: [0x03,0x00,0x61,0xd0,0xff,0x10,0x00,0x00,0x04,0x05,0x06,0x00]

image_atomic_min_flt v[0:1], [v4, v5], s[8:15] dmask:0x3 dim:SQ_RSRC_IMG_1D_ARRAY
// GFX12: encoding: [0x04,0x00,0xe1,0xd0,0x00,0x10,0x00,0x00,0x04,0x05,0x00,0x00]

image_atomic_min_flt v[1:2], [v4, v5, v6], s[8:15] dmask:0x3 dim:SQ_RSRC_IMG_2D_ARRAY
// GFX12: encoding: [0x05,0x00,0xe1,0xd0,0x01,0x10,0x00,0x00,0x04,0x05,0x06,0x00]

image_atomic_min_flt v[3:4], [v4, v5, v6], s[8:15] dmask:0x3 dim:SQ_RSRC_IMG_2D_MSAA
// GFX12: encoding: [0x06,0x00,0xe1,0xd0,0x03,0x10,0x00,0x00,0x04,0x05,0x06,0x00]

image_atomic_min_flt v[254:255], [v4, v5, v6, v7], s[96:103] dmask:0x3 dim:SQ_RSRC_IMG_2D_MSAA_ARRAY
// GFX12: encoding: [0x07,0x00,0xe1,0xd0,0xfe,0xc0,0x00,0x00,0x04,0x05,0x06,0x07]

image_atomic_min_flt v0, v0, s[0:7] dmask:0x1 dim:SQ_RSRC_IMG_1D th:TH_ATOMIC_NT
// GFX12: encoding: [0x00,0x00,0x61,0xd0,0x00,0x00,0x20,0x00,0x00,0x00,0x00,0x00]

image_atomic_max_flt v0, v0, s[0:7] dmask:0x1 dim:SQ_RSRC_IMG_1D
// GFX12: encoding: [0x00,0x40,0x61,0xd0,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00]

image_atomic_max_flt v1, [v2, v3], s[4:11] dmask:0x1 dim:SQ_RSRC_IMG_2D
// GFX12: encoding: [0x01,0x40,0x61,0xd0,0x01,0x08,0x00,0x00,0x02,0x03,0x00,0x00]

image_atomic_max_flt v4, [v4, v5, v6], s[8:15] dmask:0x1 dim:SQ_RSRC_IMG_3D
// GFX12: encoding: [0x02,0x40,0x61,0xd0,0x04,0x10,0x00,0x00,0x04,0x05,0x06,0x00]

image_atomic_max_flt v255, [v4, v5, v6], s[8:15] dmask:0x1 dim:SQ_RSRC_IMG_CUBE
// GFX12: encoding: [0x03,0x40,0x61,0xd0,0xff,0x10,0x00,0x00,0x04,0x05,0x06,0x00]

image_atomic_max_flt v[0:1], [v4, v5], s[8:15] dmask:0x3 dim:SQ_RSRC_IMG_1D_ARRAY
// GFX12: encoding: [0x04,0x40,0xe1,0xd0,0x00,0x10,0x00,0x00,0x04,0x05,0x00,0x00]

image_atomic_max_flt v[1:2], [v4, v5, v6], s[8:15] dmask:0x3 dim:SQ_RSRC_IMG_2D_ARRAY
// GFX12: encoding: [0x05,0x40,0xe1,0xd0,0x01,0x10,0x00,0x00,0x04,0x05,0x06,0x00]

image_atomic_max_flt v[3:4], [v4, v5, v6], s[8:15] dmask:0x3 dim:SQ_RSRC_IMG_2D_MSAA
// GFX12: encoding: [0x06,0x40,0xe1,0xd0,0x03,0x10,0x00,0x00,0x04,0x05,0x06,0x00]

image_atomic_max_flt v[254:255], [v4, v5, v6, v7], s[96:103] dmask:0x3 dim:SQ_RSRC_IMG_2D_MSAA_ARRAY
// GFX12: encoding: [0x07,0x40,0xe1,0xd0,0xfe,0xc0,0x00,0x00,0x04,0x05,0x06,0x07]

image_atomic_max_flt v0, v0, s[0:7] dmask:0x1 dim:SQ_RSRC_IMG_1D th:TH_ATOMIC_NT
// GFX12: encoding: [0x00,0x40,0x61,0xd0,0x00,0x00,0x20,0x00,0x00,0x00,0x00,0x00]

image_bvh_intersect_ray v[4:7], [v9, v10, v[11:13], v[14:16], v[17:19]], s[4:7]
// GFX12: encoding: [0x10,0x40,0xc6,0xd3,0x04,0x08,0x00,0x11,0x09,0x0a,0x0b,0x0e]

image_bvh_intersect_ray v[4:7], [v9, v10, v[11:13], v[14:16]], s[4:7] a16
// GFX12: encoding: [0x50,0x40,0xc6,0xd3,0x04,0x08,0x00,0x00,0x09,0x0a,0x0b,0x0e]

image_bvh64_intersect_ray v[4:7], [v[9:10], v11, v[12:14], v[15:17], v[18:20]], s[4:7]
// GFX12: encoding: [0x10,0x80,0xc6,0xd3,0x04,0x08,0x00,0x12,0x09,0x0b,0x0c,0x0f]

image_bvh64_intersect_ray v[4:7], [v[9:10], v11, v[12:14], v[15:17]], s[4:7] a16
// GFX12: encoding: [0x50,0x80,0xc6,0xd3,0x04,0x08,0x00,0x00,0x09,0x0b,0x0c,0x0f]

image_get_resinfo v4, v32, s[96:103] dmask:0x1 dim:SQ_RSRC_IMG_1D
// GFX12: encoding: [0x00,0xc0,0x45,0xd0,0x04,0xc0,0x00,0x00,0x20,0x00,0x00,0x00]

image_get_resinfo v4, v32, s[96:103] dmask:0x2 dim:SQ_RSRC_IMG_2D
// GFX12: encoding: [0x01,0xc0,0x85,0xd0,0x04,0xc0,0x00,0x00,0x20,0x00,0x00,0x00]

image_get_resinfo v4, v32, s[96:103] dmask:0x8 dim:SQ_RSRC_IMG_3D
// GFX12: encoding: [0x02,0xc0,0x05,0xd2,0x04,0xc0,0x00,0x00,0x20,0x00,0x00,0x00]

image_get_resinfo v[4:5], v32, s[96:103] dmask:0x5 dim:SQ_RSRC_IMG_CUBE
// GFX12: encoding: [0x03,0xc0,0x45,0xd1,0x04,0xc0,0x00,0x00,0x20,0x00,0x00,0x00]

image_get_resinfo v[4:5], v32, s[96:103] dmask:0xa dim:SQ_RSRC_IMG_1D_ARRAY
// GFX12: encoding: [0x04,0xc0,0x85,0xd2,0x04,0xc0,0x00,0x00,0x20,0x00,0x00,0x00]

image_get_resinfo v[4:6], v32, s[96:103] dmask:0xb dim:SQ_RSRC_IMG_2D_ARRAY
// GFX12: encoding: [0x05,0xc0,0xc5,0xd2,0x04,0xc0,0x00,0x00,0x20,0x00,0x00,0x00]

image_get_resinfo v[4:6], v32, s[96:103] dmask:0xe dim:SQ_RSRC_IMG_2D_MSAA
// GFX12: encoding: [0x06,0xc0,0x85,0xd3,0x04,0xc0,0x00,0x00,0x20,0x00,0x00,0x00]

image_get_resinfo v[4:7], v32, s[96:103] dmask:0xf dim:SQ_RSRC_IMG_2D_MSAA_ARRAY
// GFX12: encoding: [0x07,0xc0,0xc5,0xd3,0x04,0xc0,0x00,0x00,0x20,0x00,0x00,0x00]

image_get_resinfo v4, v32, s[96:103] dmask:0x1 dim:SQ_RSRC_IMG_1D th:TH_LOAD_RT
// GFX12: encoding: [0x00,0xc0,0x45,0xd0,0x04,0xc0,0x00,0x00,0x20,0x00,0x00,0x00]

image_get_resinfo v4, v32, s[96:103] dmask:0x1 dim:SQ_RSRC_IMG_1D th:TH_LOAD_NT
// GFX12: encoding: [0x00,0xc0,0x45,0xd0,0x04,0xc0,0x10,0x00,0x20,0x00,0x00,0x00]

image_get_resinfo v4, v32, s[96:103] dmask:0x1 dim:SQ_RSRC_IMG_1D th:TH_LOAD_HT
// GFX12: encoding: [0x00,0xc0,0x45,0xd0,0x04,0xc0,0x20,0x00,0x20,0x00,0x00,0x00]

image_get_resinfo v4, v32, s[96:103] dmask:0x1 dim:SQ_RSRC_IMG_1D th:TH_LOAD_LU
// GFX12: encoding: [0x00,0xc0,0x45,0xd0,0x04,0xc0,0x30,0x00,0x20,0x00,0x00,0x00]

image_get_resinfo v4, v32, s[96:103] dmask:0x1 dim:SQ_RSRC_IMG_1D th:TH_LOAD_NT_RT
// GFX12: encoding: [0x00,0xc0,0x45,0xd0,0x04,0xc0,0x40,0x00,0x20,0x00,0x00,0x00]

image_get_resinfo v4, v32, s[96:103] dmask:0x1 dim:SQ_RSRC_IMG_1D th:TH_LOAD_RT_NT
// GFX12: encoding: [0x00,0xc0,0x45,0xd0,0x04,0xc0,0x50,0x00,0x20,0x00,0x00,0x00]

image_get_resinfo v4, v32, s[96:103] dmask:0x1 dim:SQ_RSRC_IMG_1D th:TH_LOAD_NT_HT
// GFX12: encoding: [0x00,0xc0,0x45,0xd0,0x04,0xc0,0x60,0x00,0x20,0x00,0x00,0x00]

image_get_resinfo v4, v32, s[96:103] dmask:0x1 dim:SQ_RSRC_IMG_1D th:TH_LOAD_BYPASS scope:SCOPE_SYS
// GFX12: encoding: [0x00,0xc0,0x45,0xd0,0x04,0xc0,0x3c,0x00,0x20,0x00,0x00,0x00]
