; NOTE: Assertions have been autogenerated by utils/update_llc_test_checks.py
; RUN: llc -mtriple=thumb-eabi %s -verify-machineinstrs -o - | FileCheck %s --check-prefix=THUMB
; RUN: llc -mtriple=thumbv6-eabi %s -verify-machineinstrs -o - | FileCheck %s --check-prefix=THUMBV6

; The scheduler used to ignore OptionalDefs, and could unwittingly insert
; a flag-setting instruction in between an ADDS and the corresponding ADC.

; FIXME: The ABS lowering changed to XOR followed by SUB so this may no longer
; be testing what it used to.

define i1 @test(i64 %arg) {
; THUMB-LABEL: test:
; THUMB:       @ %bb.0: @ %entry
; THUMB-NEXT:    .save {r4, lr}
; THUMB-NEXT:    push {r4, lr}
; THUMB-NEXT:    asrs r2, r1, #31
; THUMB-NEXT:    movs r3, r1
; THUMB-NEXT:    eors r3, r2
; THUMB-NEXT:    movs r4, r0
; THUMB-NEXT:    eors r4, r2
; THUMB-NEXT:    subs r4, r4, r2
; THUMB-NEXT:    sbcs r3, r2
; THUMB-NEXT:    eors r3, r1
; THUMB-NEXT:    eors r0, r4
; THUMB-NEXT:    orrs r0, r3
; THUMB-NEXT:    rsbs r1, r0, #0
; THUMB-NEXT:    adcs r0, r1
; THUMB-NEXT:    pop {r4}
; THUMB-NEXT:    pop {r1}
; THUMB-NEXT:    bx r1
;
; THUMBV6-LABEL: test:
; THUMBV6:       @ %bb.0: @ %entry
; THUMBV6-NEXT:    .save {r4, lr}
; THUMBV6-NEXT:    push {r4, lr}
; THUMBV6-NEXT:    asrs r2, r1, #31
; THUMBV6-NEXT:    mov r3, r1
; THUMBV6-NEXT:    eors r3, r2
; THUMBV6-NEXT:    mov r4, r0
; THUMBV6-NEXT:    eors r4, r2
; THUMBV6-NEXT:    subs r4, r4, r2
; THUMBV6-NEXT:    sbcs r3, r2
; THUMBV6-NEXT:    eors r3, r1
; THUMBV6-NEXT:    eors r0, r4
; THUMBV6-NEXT:    orrs r0, r3
; THUMBV6-NEXT:    rsbs r1, r0, #0
; THUMBV6-NEXT:    adcs r0, r1
; THUMBV6-NEXT:    pop {r4, pc}
entry:
  %ispos = icmp sgt i64 %arg, -1
  %neg = sub i64 0, %arg
  %sel = select i1 %ispos, i64 %arg, i64 %neg
  %cmp2 = icmp eq i64 %sel, %arg
  ret i1 %cmp2
}
