<?xml version="1.0" encoding="ISO-8859-1"?>
<!DOCTYPE html PUBLIC "-//W3C//DTD XHTML 1.0 Strict//EN" "http://www.w3.org/TR/xhtml1/DTD/xhtml1-strict.dtd">
<html xmlns="http://www.w3.org/1999/xhtml" lang="fr" xml:lang="fr"><head>
<meta content="text/html; charset=ISO-8859-1" http-equiv="Content-Type" />
<!--
        XXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXX
              This file is generated from xml source: DO NOT EDIT
        XXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXX
      -->
<title>event - Serveur Apache HTTP Version 2.4</title>
<link href="../style/css/manual.css" rel="stylesheet" media="all" type="text/css" title="Main stylesheet" />
<link href="../style/css/manual-loose-100pc.css" rel="alternate stylesheet" media="all" type="text/css" title="No Sidebar - Default font size" />
<link href="../style/css/manual-print.css" rel="stylesheet" media="print" type="text/css" /><link rel="stylesheet" type="text/css" href="../style/css/prettify.css" />
<script src="../style/scripts/prettify.min.js" type="text/javascript">
</script>

<link href="../images/favicon.ico" rel="shortcut icon" /></head>
<body>
<div id="page-header">
<p class="menu"><a href="../mod/">Modules</a> | <a href="../mod/directives.html">Directives</a> | <a href="http://wiki.apache.org/httpd/FAQ">FAQ</a> | <a href="../glossary.html">Glossaire</a> | <a href="../sitemap.html">Plan du site</a></p>
<p class="apache">Serveur Apache HTTP Version 2.4</p>
<img alt="" src="../images/feather.png" /></div>
<div class="up"><a href="./"><img title="&lt;-" alt="&lt;-" src="../images/left.gif" /></a></div>
<div id="path">
<a href="http://www.apache.org/">Apache</a> &gt; <a href="http://httpd.apache.org/">Serveur HTTP</a> &gt; <a href="http://httpd.apache.org/docs/">Documentation</a> &gt; <a href="../">Version 2.4</a> &gt; <a href="./">Modules</a></div>
<div id="page-content">
<div id="preamble"><h1>Apache MPM event</h1>
<div class="toplang">
<p><span>Langues Disponibles: </span><a href="../en/mod/event.html" hreflang="en" rel="alternate" title="English">&nbsp;en&nbsp;</a> |
<a href="../fr/mod/event.html" title="Franais">&nbsp;fr&nbsp;</a></p>
</div>
<div class="outofdate">Cette traduction peut tre prime. Vrifiez la version
            anglaise pour les changements rcents.</div>
<table class="module"><tr><th><a href="module-dict.html#Description">Description:</a></th><td>Une variante du MPM <code class="module"><a href="../mod/worker.html">worker</a></code> conue pour ne
mobiliser des threads que pour les connexions en cours de traitement</td></tr>
<tr><th><a href="module-dict.html#Status">Statut:</a></th><td>MPM</td></tr>
<tr><th><a href="module-dict.html#ModuleIdentifier">IdentificateurdeModule:</a></th><td>mpm_event_module</td></tr>
<tr><th><a href="module-dict.html#SourceFile">FichierSource:</a></th><td>event.c</td></tr></table>
<h3>Sommaire</h3>

    <p>Le module multi-processus (MPM) <code class="module"><a href="../mod/event.html">event</a></code> est conu
    pour permettre le traitement d'un nombre accru de requtes
    simultanes en dlguant certaines tches
    aux threads d'coute, librant par l-mme les
    threads de travail et leur permettant de traiter les nouvelles requtes.</p>

    <p>Pour utiliser le MPM <code class="module"><a href="../mod/event.html">event</a></code>, ajoutez
    <code>--with-mpm=event</code> aux arguments du script
    <code class="program"><a href="../programs/configure.html">configure</a></code> lorsque vous compilez le programme
    <code class="program"><a href="../programs/httpd.html">httpd</a></code>.</p>

</div>
<div id="quickview"><h3>Sujets</h3>
<ul id="topics">
<li><img alt="" src="../images/down.gif" /> <a href="#event-worker-relationship">Relations avec le MPM Worker</a></li>
<li><img alt="" src="../images/down.gif" /> <a href="#how-it-works">Comment tout cela fonctionne</a></li>
<li><img alt="" src="../images/down.gif" /> <a href="#requirements">Prrequis</a></li>
</ul><h3 class="directives">Directives</h3>
<ul id="toc">
<li><img alt="" src="../images/down.gif" /> <a href="#asyncrequestworkerfactor">AsyncRequestWorkerFactor</a></li>
<li><img alt="" src="../images/right.gif" /> <a href="mpm_common.html#coredumpdirectory">CoreDumpDirectory</a></li>
<li><img alt="" src="../images/right.gif" /> <a href="mpm_common.html#enableexceptionhook">EnableExceptionHook</a></li>
<li><img alt="" src="../images/right.gif" /> <a href="mod_unixd.html#group">Group</a></li>
<li><img alt="" src="../images/right.gif" /> <a href="mpm_common.html#listen">Listen</a></li>
<li><img alt="" src="../images/right.gif" /> <a href="mpm_common.html#listenbacklog">ListenBacklog</a></li>
<li><img alt="" src="../images/right.gif" /> <a href="mpm_common.html#maxconnectionsperchild">MaxConnectionsPerChild</a></li>
<li><img alt="" src="../images/right.gif" /> <a href="mpm_common.html#maxmemfree">MaxMemFree</a></li>
<li><img alt="" src="../images/right.gif" /> <a href="mpm_common.html#maxrequestworkers">MaxRequestWorkers</a></li>
<li><img alt="" src="../images/right.gif" /> <a href="mpm_common.html#maxsparethreads">MaxSpareThreads</a></li>
<li><img alt="" src="../images/right.gif" /> <a href="mpm_common.html#minsparethreads">MinSpareThreads</a></li>
<li><img alt="" src="../images/right.gif" /> <a href="mpm_common.html#pidfile">PidFile</a></li>
<li><img alt="" src="../images/right.gif" /> <a href="mpm_common.html#scoreboardfile">ScoreBoardFile</a></li>
<li><img alt="" src="../images/right.gif" /> <a href="mpm_common.html#sendbuffersize">SendBufferSize</a></li>
<li><img alt="" src="../images/right.gif" /> <a href="mpm_common.html#serverlimit">ServerLimit</a></li>
<li><img alt="" src="../images/right.gif" /> <a href="mpm_common.html#startservers">StartServers</a></li>
<li><img alt="" src="../images/right.gif" /> <a href="mpm_common.html#threadlimit">ThreadLimit</a></li>
<li><img alt="" src="../images/right.gif" /> <a href="mpm_common.html#threadsperchild">ThreadsPerChild</a></li>
<li><img alt="" src="../images/right.gif" /> <a href="mpm_common.html#threadstacksize">ThreadStackSize</a></li>
<li><img alt="" src="../images/right.gif" /> <a href="mod_unixd.html#user">User</a></li>
</ul>
<h3>Traitement des bugs</h3><ul class="seealso"><li><a href="https://www.apache.org/dist/httpd/CHANGES_2.4">Journal des modifications de httpd</a></li><li><a href="https://bz.apache.org/bugzilla/buglist.cgi?bug_status=__open__&amp;list_id=144532&amp;product=Apache%20httpd-2&amp;query_format=specific&amp;order=changeddate%20DESC%2Cpriority%2Cbug_severity&amp;component=mpm_event">Problmes connus</a></li><li><a href="https://bz.apache.org/bugzilla/enter_bug.cgi?product=Apache%20httpd-2&amp;component=mpm_event">Signaler un bug</a></li></ul><h3>Voir aussi</h3>
<ul class="seealso">
<li><a href="worker.html">Le MPM worker</a></li>
<li><a href="#comments_section">Commentaires</a></li></ul></div>
<div class="top"><a href="#page-header"><img alt="top" src="../images/up.gif" /></a></div>
<div class="section">
<h2><a name="event-worker-relationship" id="event-worker-relationship">Relations avec le MPM Worker</a></h2>
<p>Le MPM <code class="module"><a href="../mod/event.html">event</a></code> s'inspire du MPM <code class="module"><a href="../mod/worker.html">worker</a></code> qui
implmente un serveur hybride multi-processus et multi-threads. Un processus de
contrle unique (le parent) est charg de lancer des processus enfants. Chaque
processus enfant cre un nombre de threads serveurs dfini via la directive
<code class="directive"><a href="../mod/mpm_common.html#threadsperchild">ThreadsPerChild</a></code>, ainsi qu'un thread
d'coute qui surveille les requtes entrantes et les distribue aux threads de
travail pour traitement au fur et  mesure de leur arrive.</p>

<p>Les directives de configuration  l'excution sont identiques  celles que
propose le MPM <code class="module"><a href="../mod/worker.html">worker</a></code>, avec l'unique addition de la directive
<code class="directive">AsyncRequestWorkerFactor</code>.</p>

</div><div class="top"><a href="#page-header"><img alt="top" src="../images/up.gif" /></a></div>
<div class="section">
<h2><a name="how-it-works" id="how-it-works">Comment tout cela fonctionne</a></h2>
    
    <p>Ce module MPM tente de rsoudre le "problme keep
    alive" de HTTP. Lorsqu'un client a effectu une premire requte, il peut
    garder la connexion ouverte et envoyer les requtes suivante en utilisant le
    mme socket, ce qui diminue considrablement la charge qui aurait t
    induite par la cration de nouvelles connexions TCP. Cependant, le
    fonctionnement du serveur HTTP Apache impose de rserver un couple processus
    enfant/thread pour attendre les donnes en provenance du client, ce qui
    prsente certains inconvnients.     
    Pour rsoudre ce problme, le MPM Event utilise un thread d'coute ddi
    pour chaque processus pour grer les sockets d'coute, tous les sockets qui
    sont dans un tat de connexion persistante, les sockets o les
    filtres de gestionnaire et de protocole ont fait leur travail, et ceux pour
    lesquels la seule chose restant  faire est l'envoi des donnes au client.
    </p>

    <p>Cette nouvelle architecture, en exploitant les sockets non blocants et
    les fonctionnalits des noyaux modernes mis en valeur par
    <a class="glossarylink" href="../glossary.html#apr" title="voir glossaire">APR</a> (comme epoll de Linux), n'a plus besoin du
    <code class="directive"><a href="../mod/core.html#mutex">Mutex</a></code> <code>mpm-accept</code> pour
    viter le problme de "thundering herd".</p>

    <p>La directive <code class="directive">AsyncRequestWorkerFactor</code> permet de
    dfinir le nombre total de connexions qu'un bloc processus/thread peut
    grer.</p>

    <h3><a name="async-connections" id="async-connections">Connexions asynchrones</a></h3>
        <p>Avec les MPM prcdents, les connexions asynchrones ncessitaient
	un thread de travail ddi, mais ce n'est plus le cas avec le MPM Event.
	La page d'tat de <code class="module"><a href="../mod/mod_status.html">mod_status</a></code> montre de nouvelles
	colonnes dans la section "Async connections" :</p>
        <dl>
            <dt>Writing</dt>
            <dd>Lors de l'envoi de la rponse au client, il peut arriver que le
	    tampon d'criture TCP soit plein si la connexion est trop lente. Si
	    cela se produit, une instruction <code>write()</code> vers le socket
	    renvoie en gnral <code>EWOULDBLOCK</code> ou <code>EAGAIN</code>
	    pour que l'on puisse y crire  nouveau aprs un certain temps
	    d'inactivit. Le thread de travail qui utilise le socket doit alors
	    tre en mesure de rcuprer la tche en attente et la restituer au
	    thread d'coute qui,  son tour, la rattribuera au premier thread
	    de travail disponible, lorsqu'un vnement sera gnr pour le socket
	    (par exemple, "il est maintenant possible d'crire dans le socket").
	    Veuillez vous reporter  la section  propos des limitations pour
	    plus de dtails.
            </dd>

            <dt>Keep-alive</dt>
            <dd>La gestion des connexions persistantes constitue la principale
	    amlioration par rapport au MPM Worker. Lorsqu'un thread de travail
	    a termin l'envoi d'une rponse  un client, il peut restituer la
	    gestion du socket au thread d'coute, qui  son tour va attendre un
	    vnement en provenance du systme d'exploitation comme "le socket
	    est lisible". Si une nouvelle requte arrive en provenance du
	    client, le thread d'coute l'attribuera au premier thread de travail
	    disponible. Inversement, si le dlai <code class="directive"><a href="../mod/core.html#keepalivetimeout">KeepAliveTimeout</a></code> est atteint, le socket
	    sera ferm par le thread d'coute. Les threads de travail n'ont
	    donc plus  s'occuper des sockets inactifs et ils peuvent tre
	    rutiliss pour traiter d'autres requtes.</dd>

            <dt>Closing</dt>
            <dd>Parfois, le MPM doit effectuer une fermeture progressive, c'est
	     dire envoyer au client une erreur survenue prcdemment alors que
	    ce dernier est en train de transmettre des donnes  httpd. Envoyer la rponse et
	    fermer immdiatement la connexion n'est pas une bonne solution car
	    le client (qui est encore en train d'envoyer le reste de la requte)
	    verrait sa connexion rinitialise et ne pourrait pas lire la
	    rponse de httpd. Si cela se produit, httpd essaie donc de lire le
	    reste de la requte afin de permettre au client de lire la rponse
	    entirement. La fermeture progressive est limite dans le temps,
	    mais elle peut tout de mme tre assez longue, si bien qu'il est
	    intressant qu'un thread de travail puisse se dcharger de cette
	    tche sur le thread d'coute.</dd>
        </dl>

        <p>Ces amliorations sont disponible pour les connexions HTTP ou HTTPS.</p> 

    

    <h3><a name="limitations" id="limitations">Limitations</a></h3>
        <p>La gestion amliore des connexions peut ne pas fonctionner pour
	certains filtres de connexion qui se sont dclars eux-mmes
	incompatibles avec le MPM Event. Dans ce cas, le MPM Event radoptera le
	comportement du MPM <code class="module"><a href="../mod/worker.html">worker</a></code> et rservera un thread de
	travail par connexion. Notez que tous les modules inclus dans la
	distribution du serveur httpd sont compatibles avec le MPM Event.</p>

        <p>Une restriction similaire apparat lorsqu'une requte utilise un
	filtre en sortie qui doit pouvoir lire et/ou modifier la totalit du
	corps de la rponse. Si la connexion avec le client se bloque pendant
	que le filtre traite les donnes, et si la quantit de donnes produites
	par le filtre est trop importante pour tre stocke en mmoire, le
	thread utilis pour la requte n'est pas libr pendant que httpd attend
	que les donnes soient transmises au client.<br /> 
        Pour illustrer ce cas de figure, nous pouvons envisager les deux
	situations suivantes : servir une ressource statique (comme un fichier
	CSS) ou servir un contenu issu d'un programme FCGI/CGI ou d'un serveur
	mandat. La premire situation est prvisible ; en effet, le MPM Event a
	une parfaite visibilit sur la fin du contenu, et il peut utiliser les
	vnements : le thread de travail qui sert la rponse peut envoyer les
	premiers octets jusqu' ce que <code>EWOULDBLOCK</code> ou
	<code>EAGAIN</code> soit renvoy, et dlguer le reste de la rponse au thread
	d'coute. Ce dernier en retour attend un vnement sur le socket, et
	dlgue le reste de la rponse au premier
	thread de travail disponible. Dans la deuxime situation par contre
	(FCGI/CGI/contenu mandat), le MPM n'a pas de visibilit sur la fin de
	la rponse, et le thread de travail doit terminer sa tche avant de
	rendre le contrle au thread d'coute. La seule solution consisterait
	alors  stocker la rponse en mmoire, mais ce ne serait pas l'option la
	plus sure en matire de stabilit du serveur et d'empreinte mmoire.
        </p>

    

    <h3><a name="background" id="background">Matriel d'arrire-plan</a></h3>
        <p>Le modle event a t rendu possible par l'introduction de nouvelles
	APIs dans les systmes d'exploitation supports :</p>
        <ul>
            <li>epoll (Linux) </li>
            <li>kqueue (BSD) </li>
            <li>event ports (Solaris) </li>
        </ul>
        <p>Avant que ces APIs soient mises  disposition, les APIs
	traditionnelles <code>select</code> et <code>poll</code> devaient tre
	utilises. Ces APIs deviennent lentes si on les utilise pour grer de
	nombreuses connexions ou si le jeu de connexions possde un taux de
	renouvellement lev. Les nouvelles APIs permettent de grer beaucoup
	plus de connexions et leur performances sont meilleures lorsque le jeu
	de connexions  grer change frquemment. Ces APIs ont donc rendu
	possible l'criture le MPM Event qui est mieux adapt  la situation
	HTTP typique o de nombreuses connexions sont inactives.</p>

        <p>Le MPM Event suppose que l'implmentation de <code>apr_pollset</code>
	sous-jacente est raisonnablement sure avec l'utilisation des threads
	(threadsafe). Ceci vite au MPM de devoir effectuer trop verrouillages
	de haut niveau, ou d'avoir  rveiller le thread d'coute pour lui
	envoyer un socket keep-alive. Ceci n'est possible qu'avec KQueue et
	EPoll.</p>

    
        
</div><div class="top"><a href="#page-header"><img alt="top" src="../images/up.gif" /></a></div>
<div class="section">
<h2><a name="requirements" id="requirements">Prrequis</a></h2>
    <p>Ce MPM dpend des oprations atomiques compare-and-swap
    d'<a class="glossarylink" href="../glossary.html#apr" title="voir glossaire">APR</a> pour la synchronisation des threads. Si
    vous compilez pour une plate-forme x86 et n'avez pas besoin du
    support 386, ou si vous compilez pour une plate-forme SPARC et
    n'avez pas besoin du support pre-UltraSPARC, ajoutez
    <code>--enable-nonportable-atomics=yes</code> aux arguments du
    script <code class="program"><a href="../programs/configure.html">configure</a></code>. Ceci permettra  APR
    d'implmenter les oprations atomiques en utilisant des instructions
    performantes indisponibles avec les processeurs plus
    anciens.</p>

    <p>Ce MPM ne fonctionne pas de manire optimale sur les
    plates-formes plus anciennes qui ne grent pas correctement les
    threads, mais ce problme est sans objet du fait du prrequis
    concernant EPoll ou KQueue.</p>

    <ul>

      <li>Pour utiliser ce MPM sous FreeBSD, la version 5.3 ou
      suprieure de ce systme est recommande. Il est cependant
      possible d'excuter ce MPM sous FreeBSD 5.2.1 si vous utilisez
      <code>libkse</code> (voir <code>man libmap.conf</code>).</li>

      <li>Pour NetBSD, il est recommander d'utiliser la version 2.0 ou
      suprieure.</li>

      <li>Pour Linux, un noyau 2.6 est recommand. Il faut aussi
      s'assurer que votre version de <code>glibc</code> a t compile
      avec le support pour EPoll.</li>

    </ul>
</div>
<div class="top"><a href="#page-header"><img alt="top" src="../images/up.gif" /></a></div>
<div class="directive-section"><h2><a name="asyncrequestworkerfactor" id="asyncrequestworkerfactor">Directive</a> <a name="AsyncRequestWorkerFactor" id="AsyncRequestWorkerFactor">AsyncRequestWorkerFactor</a></h2>
<table class="directive">
<tr><th><a href="directive-dict.html#Description">Description:</a></th><td>Limite le nombre de connexions simultanes par thread</td></tr>
<tr><th><a href="directive-dict.html#Syntax">Syntaxe:</a></th><td><code>AsyncRequestWorkerFactor <var>facteur</var></code></td></tr>
<tr><th><a href="directive-dict.html#Default">Dfaut:</a></th><td><code>2</code></td></tr>
<tr><th><a href="directive-dict.html#Context">Contexte:</a></th><td>configuration du serveur</td></tr>
<tr><th><a href="directive-dict.html#Status">Statut:</a></th><td>MPM</td></tr>
<tr><th><a href="directive-dict.html#Module">Module:</a></th><td>event</td></tr>
<tr><th><a href="directive-dict.html#Compatibility">Compatibilit:</a></th><td>Disponible depuis la version 2.3.13</td></tr>
</table>
    <p>Le MPM event gre certaines connexions de manire asynchrone ;
    dans ce cas, les threads traitant la requte sont allous selon les
    besoins et pour de courtes priodes. Dans les autres cas, un
    thread est rserv par
    connexion. Ceci peut conduire  des situations o tous les threads
    sont saturs et o aucun thread n'est capable d'effectuer de
    nouvelles tches pour les connexions asynchrones tablies.</p>

    <p>Pour minimiser les effets de ce problme, le MPM event utilise
    deux mthodes :</p>
    <ul>
    	<li>il limite le nombre de connexions
	    simultanes par thread en fonction du nombre de processus
	    inactifs;</li>
	<li>si tous les processus sont occups, il ferme des connexions
	permanentes, mme si la limite de dure de la connexion n'a
	pas t atteinte. Ceci autorise les clients
	concerns  se reconnecter  un autre processus
	possdant encore des threads disponibles.</li>
    </ul>

    <p>Cette directive permet de personnaliser finement la limite du
    nombre de connexions par thread. Un <strong>processus</strong> n'acceptera de
    nouvelles connexions que si le nombre actuel de connexions (sans
    compter les connexions  l'tat "closing") est
    infrieur  :</p>

    <p class="indent"><strong>
        <code class="directive"><a href="../mod/mpm_common.html#threadsperchild">ThreadsPerChild</a></code> +
        (<code class="directive">AsyncRequestWorkerFactor</code> *
        <var>nombre de threads inactifs</var>)
    </strong></p>

    <p>Il est possible d'effectuer une estimation du nombre maximum de
    connexions simultanes pour tous les processus et pour un nombre donn moyen
    de threads de travail inactifs comme suit :
    </p>


    <p class="indent"><strong>
        (<code class="directive"><a href="../mod/mpm_common.html#threadsperchild">ThreadsPerChild</a></code> +
        (<code class="directive">AsyncRequestWorkerFactor</code> *
        <var>number of idle workers</var>)) * 
        <code class="directive"><a href="../mod/mpm_common.html#serverlimit">ServerLimit</a></code>
    </strong></p>

    <div class="note"><h3>Exemple</h3>
    <pre class="prettyprint lang-config">ThreadsPerChild = 10
ServerLimit = 4
AsyncRequestWorkerFactor = 2
MaxRequestWorkers = 40

idle_workers = 4 (moyenne pour tous les processus pour faire simple)

max_connections = (ThreadsPerChild + (AsyncRequestWorkerFactor * idle_workers)) * ServerLimit 
                = (10 + (2 * 4)) * 4 = 72</pre>

    </div>

    <p>Lorsque tous les threads de travail sont inactifs, le nombre maximum
    absolu de connexions simultanes peut tre calcul de manire plus simple :</p>

    <p class="indent"><strong>
        (<code class="directive">AsyncRequestWorkerFactor</code> + 1) *
        <code class="directive"><a href="../mod/mpm_common.html#maxrequestworkers">MaxRequestWorkers</a></code>
    </strong></p>

    <div class="note"><h3>Exemple</h3>
    <pre class="prettyprint lang-config">ThreadsPerChild = 10 
ServerLimit = 4
MaxRequestWorkers = 40
AsyncRequestWorkerFactor = 2</pre>


    <p>Si tous les threads de tous les processus sont inactifs, alors :</p>

    <pre class="prettyprint lang-config">idle_workers = 10</pre>


    <p>Nous pouvons calculer le nombre maximum absolu de connexions simultanes
    de deux manires :</p>
    
    <pre class="prettyprint lang-config">max_connections = (ThreadsPerChild + (AsyncRequestWorkerFactor * idle_workers)) * ServerLimit 
                = (10 + (2 * 10)) * 4 = 120
    
max_connections = (AsyncRequestWorkerFactor + 1) * MaxRequestWorkers 
                = (2 + 1) * 40 = 120</pre>

    </div>

    <p>Le rglage de la directive
    <code class="directive">AsyncRequestWorkerFactor</code> ncessite de connatre le
    trafic gr par httpd pour chaque style d'utilisation spcifique ; si vous
    modifiez la valeur par dfaut, vous devrez par consquent effectuer des
    tests approfondis en vous appuyant troitement sur les donnes fournies par
    <code class="module"><a href="../mod/mod_status.html">mod_status</a></code>.</p>

    <p>La directive <code class="directive"><a href="../mod/mpm_common.html#maxrequestworkers">MaxRequestWorkers</a></code> se nommait
    <code class="directive">MaxClients</code> avant la version 2.3.13. La valeur
    ci-dessus montre que cet ancien nom ne correspondait pas  sa
    signification exacte pour le MPM event.</p>

    <p>La directive <code class="directive">AsyncRequestWorkerFactor</code>
    accepte des valeurs d'argument de type non entier, comme "1.5".</p>


</div>
</div>
<div class="bottomlang">
<p><span>Langues Disponibles: </span><a href="../en/mod/event.html" hreflang="en" rel="alternate" title="English">&nbsp;en&nbsp;</a> |
<a href="../fr/mod/event.html" title="Franais">&nbsp;fr&nbsp;</a></p>
</div><div class="top"><a href="#page-header"><img src="../images/up.gif" alt="top" /></a></div><div class="section"><h2><a id="comments_section" name="comments_section">Commentaires</a></h2><div class="warning"><strong>Notice:</strong><br />This is not a Q&amp;A section. Comments placed here should be pointed towards suggestions on improving the documentation or server, and may be removed again by our moderators if they are either implemented or considered invalid/off-topic. Questions on how to manage the Apache HTTP Server should be directed at either our IRC channel, #httpd, on Freenode, or sent to our <a href="http://httpd.apache.org/lists.html">mailing lists</a>.</div>
<script type="text/javascript"><!--//--><![CDATA[//><!--
var comments_shortname = 'httpd';
var comments_identifier = 'http://httpd.apache.org/docs/2.4/mod/event.html';
(function(w, d) {
    if (w.location.hostname.toLowerCase() == "httpd.apache.org") {
        d.write('<div id="comments_thread"><\/div>');
        var s = d.createElement('script');
        s.type = 'text/javascript';
        s.async = true;
        s.src = 'https://comments.apache.org/show_comments.lua?site=' + comments_shortname + '&page=' + comments_identifier;
        (d.getElementsByTagName('head')[0] || d.getElementsByTagName('body')[0]).appendChild(s);
    }
    else { 
        d.write('<div id="comments_thread">Comments are disabled for this page at the moment.<\/div>');
    }
})(window, document);
//--><!]]></script></div><div id="footer">
<p class="apache">Copyright 2016 The Apache Software Foundation.<br />Autoris sous <a href="http://www.apache.org/licenses/LICENSE-2.0">Apache License, Version 2.0</a>.</p>
<p class="menu"><a href="../mod/">Modules</a> | <a href="../mod/directives.html">Directives</a> | <a href="http://wiki.apache.org/httpd/FAQ">FAQ</a> | <a href="../glossary.html">Glossaire</a> | <a href="../sitemap.html">Plan du site</a></p></div><script type="text/javascript"><!--//--><![CDATA[//><!--
if (typeof(prettyPrint) !== 'undefined') {
    prettyPrint();
}
//--><!]]></script>
</body></html>