/* -- THIS FILE IS GENERATED - DO NOT EDIT *//* -*- Mode: C; c-basic-offset: 4 -*- */

#define PY_SSIZE_T_CLEAN
#include <Python.h>




#if PY_VERSION_HEX < 0x02050000
typedef int Py_ssize_t;
#define PY_SSIZE_T_MAX INT_MAX
#define PY_SSIZE_T_MIN INT_MIN
typedef inquiry lenfunc;
typedef intargfunc ssizeargfunc;
typedef intobjargproc ssizeobjargproc;
#endif


#line 4 "gconf.override"
#include <Python.h>

#include "gconf-fixes.h"
#include "gconf-types.h"

#define NO_IMPORT_PYGOBJECT
#include "pygobject.h"
#include <glib.h>
#include <gconf/gconf-client.h>
#include <gconf/gconf-enum-types.h>
#include "config.h"

static gpointer pygconf_parse_pygvalue(GConfValueType gvalue_type,
				       PyObject *pyvalue);
#line 35 "gconf.c"


/* ---------- types from other modules ---------- */
static PyTypeObject *_PyGObject_Type;
#define PyGObject_Type (*_PyGObject_Type)


/* ---------- forward type declarations ---------- */
PyTypeObject G_GNUC_INTERNAL PyGConfValue_Type;
PyTypeObject G_GNUC_INTERNAL PyGConfEntry_Type;
PyTypeObject G_GNUC_INTERNAL PyGConfSchema_Type;
PyTypeObject G_GNUC_INTERNAL PyGConfMetaInfo_Type;
PyTypeObject G_GNUC_INTERNAL PyGConfChangeSet_Type;
PyTypeObject G_GNUC_INTERNAL PyGConfClient_Type;

#line 51 "gconf.c"



/* ----------- GConfValue ----------- */

static int
_wrap_gconf_value_new(PyGBoxed *self, PyObject *args, PyObject *kwargs)
{
    static char *kwlist[] = { "type", NULL };
    PyObject *py_type = NULL;
    GConfValueType type;

    if (!PyArg_ParseTupleAndKeywords(args, kwargs,"O:GConf.Value.__init__", kwlist, &py_type))
        return -1;
    if (pyg_enum_get_value(GCONF_TYPE_VALUE_TYPE, py_type, (gpointer)&type))
        return -1;
    self->gtype = GCONF_TYPE_VALUE;
    self->free_on_dealloc = FALSE;
    self->boxed = gconf_value_new(type);

    if (!self->boxed) {
        PyErr_SetString(PyExc_RuntimeError, "could not create GConfValue object");
        return -1;
    }
    self->free_on_dealloc = TRUE;
    return 0;
}

#line 648 "gconf.override"
static PyObject *
_wrap_gconf_value_get_string(PyObject *self)
{
    const gchar *ret;
    GConfValue *value;

    value = pyg_boxed_get(self, GConfValue);
    if (value->type != GCONF_VALUE_STRING) {
	PyErr_SetString(PyExc_TypeError, "gconf value does not contain a string.");
	return NULL;
    }
    ret = gconf_value_get_string(value);
    if (ret)
        return PyString_FromString(ret);
    Py_INCREF(Py_None);
    return Py_None;
}
#line 98 "gconf.c"


#line 632 "gconf.override"
static PyObject *
_wrap_gconf_value_get_int(PyObject *self)
{
    int ret;
    GConfValue *value;

    value = pyg_boxed_get(self, GConfValue);
    if (value->type != GCONF_VALUE_INT) {
	PyErr_SetString(PyExc_TypeError, "gconf value does not contain an integer.");
	return NULL;
    }
    ret = gconf_value_get_int(value);
    return PyInt_FromLong(ret);
}
#line 116 "gconf.c"


#line 667 "gconf.override"
static PyObject *
_wrap_gconf_value_get_float(PyObject *self)
{
    double ret;
    GConfValue *value;

    value = pyg_boxed_get(self, GConfValue);
    if (value->type != GCONF_VALUE_FLOAT) {
	PyErr_SetString(PyExc_TypeError, "gconf value does not contain a float.");
	return NULL;
    }
    ret = gconf_value_get_float(value);
    return PyFloat_FromDouble(ret);
}
#line 134 "gconf.c"


static PyObject *
_wrap_gconf_value_get_list_type(PyObject *self)
{
    gint ret;

    
    ret = gconf_value_get_list_type(pyg_boxed_get(self, GConfValue));
    
    return pyg_enum_from_gtype(GCONF_TYPE_VALUE_TYPE, ret);
}

#line 604 "gconf.override"
static PyObject *
_wrap_gconf_value_get_list(PyGObject *self, PyObject *args, PyObject *kwargs)
{
    GConfValue *value;
    PyObject *pylist;
    GSList *values = NULL, *list;
    int i = 0;

    value = pyg_boxed_get(self, GConfValue);
    if (value->type != GCONF_VALUE_LIST) {
	PyErr_SetString(PyExc_TypeError, "gconf value does not contain a list.");
	return NULL;
    }
    values = gconf_value_get_list(value);

    pylist = PyTuple_New(g_slist_length(values));
    for (list = values; list; list = list->next) {
	PyObject *pyvalue;
	value = list->data;
	pyvalue = pyg_boxed_new(GCONF_TYPE_VALUE, value, TRUE, TRUE);

	PyTuple_SetItem(pylist, i++, pyvalue);
    }
    
    return pylist;
}
#line 175 "gconf.c"


#line 583 "gconf.override"
static PyObject *
_wrap_gconf_value_get_car(PyGObject *self, PyObject *args, PyObject *kwargs)
{
    GConfValue* vobj;

    vobj = gconf_value_get_car(pyg_boxed_get(self, GConfValue));
    return pyg_boxed_new(GCONF_TYPE_VALUE, vobj, TRUE, TRUE);
}

#line 188 "gconf.c"


#line 594 "gconf.override"
static PyObject *
_wrap_gconf_value_get_cdr(PyGObject *self, PyObject *args, PyObject *kwargs)
{
    GConfValue* vobj;

    vobj = gconf_value_get_cdr(pyg_boxed_get(self, GConfValue));
    return pyg_boxed_new(GCONF_TYPE_VALUE, vobj, TRUE, TRUE);
}
#line 200 "gconf.c"


#line 683 "gconf.override"
static PyObject *
_wrap_gconf_value_get_bool(PyObject *self)
{
    int ret;
    PyObject *py_ret;
    GConfValue *value;

    value = pyg_boxed_get(self, GConfValue);
    if (value->type != GCONF_VALUE_BOOL) {
	PyErr_SetString(PyExc_TypeError, "gconf value does not contain a boolean.");
	return NULL;
    }
    ret = gconf_value_get_bool(value);
    py_ret = ret ? Py_True : Py_False;
    Py_INCREF(py_ret);
    return py_ret;
}
#line 221 "gconf.c"


static PyObject *
_wrap_gconf_value_get_schema(PyObject *self)
{
    GConfSchema *ret;

    
    ret = gconf_value_get_schema(pyg_boxed_get(self, GConfValue));
    
    /* pyg_boxed_new handles NULL checking */
    return pyg_boxed_new(GCONF_TYPE_SCHEMA, ret, TRUE, TRUE);
}

static PyObject *
_wrap_gconf_value_copy(PyObject *self)
{
    GConfValue *ret;

    
    ret = gconf_value_copy(pyg_boxed_get(self, GConfValue));
    
    /* pyg_boxed_new handles NULL checking */
    return pyg_boxed_new(GCONF_TYPE_VALUE, ret, TRUE, TRUE);
}

static PyObject *
_wrap_gconf_value_free(PyObject *self)
{
    
    gconf_value_free(pyg_boxed_get(self, GConfValue));
    
    Py_INCREF(Py_None);
    return Py_None;
}

static PyObject *
_wrap_gconf_value_set_int(PyObject *self, PyObject *args, PyObject *kwargs)
{
    static char *kwlist[] = { "the_int", NULL };
    int the_int;

    if (!PyArg_ParseTupleAndKeywords(args, kwargs,"i:GConf.Value.set_int", kwlist, &the_int))
        return NULL;
    
    gconf_value_set_int(pyg_boxed_get(self, GConfValue), the_int);
    
    Py_INCREF(Py_None);
    return Py_None;
}

static PyObject *
_wrap_gconf_value_set_string(PyObject *self, PyObject *args, PyObject *kwargs)
{
    static char *kwlist[] = { "the_str", NULL };
    char *the_str;

    if (!PyArg_ParseTupleAndKeywords(args, kwargs,"s:GConf.Value.set_string", kwlist, &the_str))
        return NULL;
    
    gconf_value_set_string(pyg_boxed_get(self, GConfValue), the_str);
    
    Py_INCREF(Py_None);
    return Py_None;
}

static PyObject *
_wrap_gconf_value_set_float(PyObject *self, PyObject *args, PyObject *kwargs)
{
    static char *kwlist[] = { "the_float", NULL };
    double the_float;

    if (!PyArg_ParseTupleAndKeywords(args, kwargs,"d:GConf.Value.set_float", kwlist, &the_float))
        return NULL;
    
    gconf_value_set_float(pyg_boxed_get(self, GConfValue), the_float);
    
    Py_INCREF(Py_None);
    return Py_None;
}

static PyObject *
_wrap_gconf_value_set_bool(PyObject *self, PyObject *args, PyObject *kwargs)
{
    static char *kwlist[] = { "the_bool", NULL };
    int the_bool;

    if (!PyArg_ParseTupleAndKeywords(args, kwargs,"i:GConf.Value.set_bool", kwlist, &the_bool))
        return NULL;
    
    gconf_value_set_bool(pyg_boxed_get(self, GConfValue), the_bool);
    
    Py_INCREF(Py_None);
    return Py_None;
}

static PyObject *
_wrap_gconf_value_set_schema(PyObject *self, PyObject *args, PyObject *kwargs)
{
    static char *kwlist[] = { "sc", NULL };
    PyObject *py_sc;
    GConfSchema *sc = NULL;

    if (!PyArg_ParseTupleAndKeywords(args, kwargs,"O:GConf.Value.set_schema", kwlist, &py_sc))
        return NULL;
    if (pyg_boxed_check(py_sc, GCONF_TYPE_SCHEMA))
        sc = pyg_boxed_get(py_sc, GConfSchema);
    else {
        PyErr_SetString(PyExc_TypeError, "sc should be a GConfSchema");
        return NULL;
    }
    
    gconf_value_set_schema(pyg_boxed_get(self, GConfValue), sc);
    
    Py_INCREF(Py_None);
    return Py_None;
}

static PyObject *
_wrap_gconf_value_set_schema_nocopy(PyObject *self, PyObject *args, PyObject *kwargs)
{
    static char *kwlist[] = { "sc", NULL };
    PyObject *py_sc;
    GConfSchema *sc = NULL;

    if (!PyArg_ParseTupleAndKeywords(args, kwargs,"O:GConf.Value.set_schema_nocopy", kwlist, &py_sc))
        return NULL;
    if (pyg_boxed_check(py_sc, GCONF_TYPE_SCHEMA))
        sc = pyg_boxed_get(py_sc, GConfSchema);
    else {
        PyErr_SetString(PyExc_TypeError, "sc should be a GConfSchema");
        return NULL;
    }
    
    gconf_value_set_schema_nocopy(pyg_boxed_get(self, GConfValue), sc);
    
    Py_INCREF(Py_None);
    return Py_None;
}

static PyObject *
_wrap_gconf_value_set_car(PyObject *self, PyObject *args, PyObject *kwargs)
{
    static char *kwlist[] = { "car", NULL };
    PyObject *py_car;
    GConfValue *car = NULL;

    if (!PyArg_ParseTupleAndKeywords(args, kwargs,"O:GConf.Value.set_car", kwlist, &py_car))
        return NULL;
    if (pyg_boxed_check(py_car, GCONF_TYPE_VALUE))
        car = pyg_boxed_get(py_car, GConfValue);
    else {
        PyErr_SetString(PyExc_TypeError, "car should be a GConfValue");
        return NULL;
    }
    
    gconf_value_set_car(pyg_boxed_get(self, GConfValue), car);
    
    Py_INCREF(Py_None);
    return Py_None;
}

static PyObject *
_wrap_gconf_value_set_cdr(PyObject *self, PyObject *args, PyObject *kwargs)
{
    static char *kwlist[] = { "cdr", NULL };
    PyObject *py_cdr;
    GConfValue *cdr = NULL;

    if (!PyArg_ParseTupleAndKeywords(args, kwargs,"O:GConf.Value.set_cdr", kwlist, &py_cdr))
        return NULL;
    if (pyg_boxed_check(py_cdr, GCONF_TYPE_VALUE))
        cdr = pyg_boxed_get(py_cdr, GConfValue);
    else {
        PyErr_SetString(PyExc_TypeError, "cdr should be a GConfValue");
        return NULL;
    }
    
    gconf_value_set_cdr(pyg_boxed_get(self, GConfValue), cdr);
    
    Py_INCREF(Py_None);
    return Py_None;
}

static PyObject *
_wrap_gconf_value_set_list_type(PyObject *self, PyObject *args, PyObject *kwargs)
{
    static char *kwlist[] = { "type", NULL };
    PyObject *py_type = NULL;
    GConfValueType type;

    if (!PyArg_ParseTupleAndKeywords(args, kwargs,"O:GConf.Value.set_list_type", kwlist, &py_type))
        return NULL;
    if (pyg_enum_get_value(GCONF_TYPE_VALUE_TYPE, py_type, (gpointer)&type))
        return NULL;
    
    gconf_value_set_list_type(pyg_boxed_get(self, GConfValue), type);
    
    Py_INCREF(Py_None);
    return Py_None;
}

#line 702 "gconf.override"
static PyObject *
_wrap_gconf_value_set_list(PyObject *self, PyObject *args, PyObject *kwargs)
{
    static char *kwlist[] = { "list", NULL };
    GSList *list;
    PyObject *py_list;
    int i, len;
    GConfValue *value = pyg_boxed_get(self, GConfValue);

    if (!PyArg_ParseTupleAndKeywords(args, kwargs, "O!:GConfValue.set_list", kwlist,
                                     &PyList_Type, &py_list))
        return NULL;
    if (value->type != GCONF_VALUE_LIST) {
	PyErr_SetString(PyExc_TypeError, "gconf value type must be list.");
	return NULL;
    }

    len = PyList_Size(py_list);
    for (i = 0, list = NULL; i < len; i++) {
        PyObject *item = PyList_GET_ITEM(py_list, i);
        if (!pyg_boxed_check(item, GCONF_TYPE_VALUE)) {
            PyErr_SetString(PyExc_TypeError, "list elements must be of type gconf.Value");
            g_slist_free(list);
            return NULL;
        }
        list = g_slist_append(list, pyg_boxed_get(item, GConfValue));
    }
    gconf_value_set_list(value, list);
    g_slist_free(list);
    Py_INCREF(Py_None);
    return Py_None;
}
#line 457 "gconf.c"


static PyObject *
_wrap_gconf_value_to_string(PyObject *self)
{
    gchar *ret;

    
    ret = gconf_value_to_string(pyg_boxed_get(self, GConfValue));
    
    if (ret) {
        PyObject *py_ret = PyString_FromString(ret);
        g_free(ret);
        return py_ret;
    }
    Py_INCREF(Py_None);
    return Py_None;
}

static const PyMethodDef _PyGConfValue_methods[] = {
    { "get_string", (PyCFunction)_wrap_gconf_value_get_string, METH_NOARGS,
      NULL },
    { "get_int", (PyCFunction)_wrap_gconf_value_get_int, METH_NOARGS,
      NULL },
    { "get_float", (PyCFunction)_wrap_gconf_value_get_float, METH_NOARGS,
      NULL },
    { "get_list_type", (PyCFunction)_wrap_gconf_value_get_list_type, METH_NOARGS,
      NULL },
    { "get_list", (PyCFunction)_wrap_gconf_value_get_list, METH_VARARGS,
      NULL },
    { "get_car", (PyCFunction)_wrap_gconf_value_get_car, METH_VARARGS,
      NULL },
    { "get_cdr", (PyCFunction)_wrap_gconf_value_get_cdr, METH_VARARGS,
      NULL },
    { "get_bool", (PyCFunction)_wrap_gconf_value_get_bool, METH_NOARGS,
      NULL },
    { "get_schema", (PyCFunction)_wrap_gconf_value_get_schema, METH_NOARGS,
      NULL },
    { "copy", (PyCFunction)_wrap_gconf_value_copy, METH_NOARGS,
      NULL },
    { "free", (PyCFunction)_wrap_gconf_value_free, METH_NOARGS,
      NULL },
    { "set_int", (PyCFunction)_wrap_gconf_value_set_int, METH_VARARGS|METH_KEYWORDS,
      NULL },
    { "set_string", (PyCFunction)_wrap_gconf_value_set_string, METH_VARARGS|METH_KEYWORDS,
      NULL },
    { "set_float", (PyCFunction)_wrap_gconf_value_set_float, METH_VARARGS|METH_KEYWORDS,
      NULL },
    { "set_bool", (PyCFunction)_wrap_gconf_value_set_bool, METH_VARARGS|METH_KEYWORDS,
      NULL },
    { "set_schema", (PyCFunction)_wrap_gconf_value_set_schema, METH_VARARGS|METH_KEYWORDS,
      NULL },
    { "set_schema_nocopy", (PyCFunction)_wrap_gconf_value_set_schema_nocopy, METH_VARARGS|METH_KEYWORDS,
      NULL },
    { "set_car", (PyCFunction)_wrap_gconf_value_set_car, METH_VARARGS|METH_KEYWORDS,
      NULL },
    { "set_cdr", (PyCFunction)_wrap_gconf_value_set_cdr, METH_VARARGS|METH_KEYWORDS,
      NULL },
    { "set_list_type", (PyCFunction)_wrap_gconf_value_set_list_type, METH_VARARGS|METH_KEYWORDS,
      NULL },
    { "set_list", (PyCFunction)_wrap_gconf_value_set_list, METH_VARARGS|METH_KEYWORDS,
      NULL },
    { "to_string", (PyCFunction)_wrap_gconf_value_to_string, METH_NOARGS,
      NULL },
    { NULL, NULL, 0, NULL }
};

static PyObject *
_wrap_gconf_value__get_type(PyObject *self, void *closure)
{
    gint ret;

    ret = pyg_boxed_get(self, GConfValue)->type;
    return pyg_enum_from_gtype(GCONF_TYPE_VALUE_TYPE, ret);
}

static const PyGetSetDef gconf_value_getsets[] = {
    { "type", (getter)_wrap_gconf_value__get_type, (setter)0 },
    { NULL, (getter)0, (setter)0 },
};

PyTypeObject G_GNUC_INTERNAL PyGConfValue_Type = {
    PyObject_HEAD_INIT(NULL)
    0,                                 /* ob_size */
    "gconf.Value",                   /* tp_name */
    sizeof(PyGBoxed),          /* tp_basicsize */
    0,                                 /* tp_itemsize */
    /* methods */
    (destructor)0,        /* tp_dealloc */
    (printfunc)0,                      /* tp_print */
    (getattrfunc)0,       /* tp_getattr */
    (setattrfunc)0,       /* tp_setattr */
    (cmpfunc)0,           /* tp_compare */
    (reprfunc)0,             /* tp_repr */
    (PyNumberMethods*)0,     /* tp_as_number */
    (PySequenceMethods*)0, /* tp_as_sequence */
    (PyMappingMethods*)0,   /* tp_as_mapping */
    (hashfunc)0,             /* tp_hash */
    (ternaryfunc)0,          /* tp_call */
    (reprfunc)0,              /* tp_str */
    (getattrofunc)0,     /* tp_getattro */
    (setattrofunc)0,     /* tp_setattro */
    (PyBufferProcs*)0,  /* tp_as_buffer */
    Py_TPFLAGS_DEFAULT | Py_TPFLAGS_BASETYPE,                      /* tp_flags */
    NULL,                        /* Documentation string */
    (traverseproc)0,     /* tp_traverse */
    (inquiry)0,             /* tp_clear */
    (richcmpfunc)0,   /* tp_richcompare */
    0,             /* tp_weaklistoffset */
    (getiterfunc)0,          /* tp_iter */
    (iternextfunc)0,     /* tp_iternext */
    (struct PyMethodDef*)_PyGConfValue_methods, /* tp_methods */
    (struct PyMemberDef*)0,              /* tp_members */
    (struct PyGetSetDef*)gconf_value_getsets,  /* tp_getset */
    NULL,                              /* tp_base */
    NULL,                              /* tp_dict */
    (descrgetfunc)0,    /* tp_descr_get */
    (descrsetfunc)0,    /* tp_descr_set */
    0,                 /* tp_dictoffset */
    (initproc)_wrap_gconf_value_new,             /* tp_init */
    (allocfunc)0,           /* tp_alloc */
    (newfunc)0,               /* tp_new */
    (freefunc)0,             /* tp_free */
    (inquiry)0              /* tp_is_gc */
};



/* ----------- GConfEntry ----------- */

static int
_wrap_gconf_entry_new(PyGBoxed *self, PyObject *args, PyObject *kwargs)
{
    static char *kwlist[] = { "key", "val", NULL };
    char *key;
    PyObject *py_val;
    GConfValue *val = NULL;

    if (!PyArg_ParseTupleAndKeywords(args, kwargs,"sO:GConf.Entry.__init__", kwlist, &key, &py_val))
        return -1;
    if (pyg_boxed_check(py_val, GCONF_TYPE_VALUE))
        val = pyg_boxed_get(py_val, GConfValue);
    else {
        PyErr_SetString(PyExc_TypeError, "val should be a GConfValue");
        return -1;
    }
    self->gtype = GCONF_TYPE_ENTRY;
    self->free_on_dealloc = FALSE;
    self->boxed = gconf_entry_new(key, val);

    if (!self->boxed) {
        PyErr_SetString(PyExc_RuntimeError, "could not create GConfEntry object");
        return -1;
    }
    self->free_on_dealloc = TRUE;
    return 0;
}

static PyObject *
_wrap_gconf_entry_get_key(PyObject *self)
{
    const gchar *ret;

    
    ret = gconf_entry_get_key(pyg_boxed_get(self, GConfEntry));
    
    if (ret)
        return PyString_FromString(ret);
    Py_INCREF(Py_None);
    return Py_None;
}

static PyObject *
_wrap_gconf_entry_get_value(PyObject *self)
{
    GConfValue *ret;

    
    ret = gconf_entry_get_value(pyg_boxed_get(self, GConfEntry));
    
    /* pyg_boxed_new handles NULL checking */
    return pyg_boxed_new(GCONF_TYPE_VALUE, ret, TRUE, TRUE);
}

static PyObject *
_wrap_gconf_entry_get_schema_name(PyObject *self)
{
    const gchar *ret;

    
    ret = gconf_entry_get_schema_name(pyg_boxed_get(self, GConfEntry));
    
    if (ret)
        return PyString_FromString(ret);
    Py_INCREF(Py_None);
    return Py_None;
}

static PyObject *
_wrap_gconf_entry_get_is_default(PyObject *self)
{
    int ret;

    
    ret = gconf_entry_get_is_default(pyg_boxed_get(self, GConfEntry));
    
    return PyBool_FromLong(ret);

}

static PyObject *
_wrap_gconf_entry_get_is_writable(PyObject *self)
{
    int ret;

    
    ret = gconf_entry_get_is_writable(pyg_boxed_get(self, GConfEntry));
    
    return PyBool_FromLong(ret);

}

static PyObject *
_wrap_gconf_entry_copy(PyObject *self)
{
    GConfEntry *ret;

    
    ret = gconf_entry_copy(pyg_boxed_get(self, GConfEntry));
    
    /* pyg_boxed_new handles NULL checking */
    return pyg_boxed_new(GCONF_TYPE_ENTRY, ret, TRUE, TRUE);
}

static PyObject *
_wrap_gconf_entry_free(PyObject *self)
{
    
    gconf_entry_free(pyg_boxed_get(self, GConfEntry));
    
    Py_INCREF(Py_None);
    return Py_None;
}

static PyObject *
_wrap_gconf_entry_ref(PyObject *self)
{
    
    gconf_entry_ref(pyg_boxed_get(self, GConfEntry));
    
    Py_INCREF(Py_None);
    return Py_None;
}

static PyObject *
_wrap_gconf_entry_unref(PyObject *self)
{
    
    gconf_entry_unref(pyg_boxed_get(self, GConfEntry));
    
    Py_INCREF(Py_None);
    return Py_None;
}

static PyObject *
_wrap_gconf_entry_steal_value(PyObject *self)
{
    GConfValue *ret;

    
    ret = gconf_entry_steal_value(pyg_boxed_get(self, GConfEntry));
    
    /* pyg_boxed_new handles NULL checking */
    return pyg_boxed_new(GCONF_TYPE_VALUE, ret, TRUE, TRUE);
}

static PyObject *
_wrap_gconf_entry_set_value(PyObject *self, PyObject *args, PyObject *kwargs)
{
    static char *kwlist[] = { "val", NULL };
    PyObject *py_val;
    GConfValue *val = NULL;

    if (!PyArg_ParseTupleAndKeywords(args, kwargs,"O:GConf.Entry.set_value", kwlist, &py_val))
        return NULL;
    if (pyg_boxed_check(py_val, GCONF_TYPE_VALUE))
        val = pyg_boxed_get(py_val, GConfValue);
    else {
        PyErr_SetString(PyExc_TypeError, "val should be a GConfValue");
        return NULL;
    }
    
    gconf_entry_set_value(pyg_boxed_get(self, GConfEntry), val);
    
    Py_INCREF(Py_None);
    return Py_None;
}

static PyObject *
_wrap_gconf_entry_set_value_nocopy(PyObject *self, PyObject *args, PyObject *kwargs)
{
    static char *kwlist[] = { "val", NULL };
    PyObject *py_val;
    GConfValue *val = NULL;

    if (!PyArg_ParseTupleAndKeywords(args, kwargs,"O:GConf.Entry.set_value_nocopy", kwlist, &py_val))
        return NULL;
    if (pyg_boxed_check(py_val, GCONF_TYPE_VALUE))
        val = pyg_boxed_get(py_val, GConfValue);
    else {
        PyErr_SetString(PyExc_TypeError, "val should be a GConfValue");
        return NULL;
    }
    
    gconf_entry_set_value_nocopy(pyg_boxed_get(self, GConfEntry), val);
    
    Py_INCREF(Py_None);
    return Py_None;
}

static PyObject *
_wrap_gconf_entry_set_schema_name(PyObject *self, PyObject *args, PyObject *kwargs)
{
    static char *kwlist[] = { "name", NULL };
    char *name;

    if (!PyArg_ParseTupleAndKeywords(args, kwargs,"s:GConf.Entry.set_schema_name", kwlist, &name))
        return NULL;
    
    gconf_entry_set_schema_name(pyg_boxed_get(self, GConfEntry), name);
    
    Py_INCREF(Py_None);
    return Py_None;
}

static PyObject *
_wrap_gconf_entry_set_is_default(PyObject *self, PyObject *args, PyObject *kwargs)
{
    static char *kwlist[] = { "is_default", NULL };
    int is_default;

    if (!PyArg_ParseTupleAndKeywords(args, kwargs,"i:GConf.Entry.set_is_default", kwlist, &is_default))
        return NULL;
    
    gconf_entry_set_is_default(pyg_boxed_get(self, GConfEntry), is_default);
    
    Py_INCREF(Py_None);
    return Py_None;
}

static PyObject *
_wrap_gconf_entry_set_is_writable(PyObject *self, PyObject *args, PyObject *kwargs)
{
    static char *kwlist[] = { "is_writable", NULL };
    int is_writable;

    if (!PyArg_ParseTupleAndKeywords(args, kwargs,"i:GConf.Entry.set_is_writable", kwlist, &is_writable))
        return NULL;
    
    gconf_entry_set_is_writable(pyg_boxed_get(self, GConfEntry), is_writable);
    
    Py_INCREF(Py_None);
    return Py_None;
}

static const PyMethodDef _PyGConfEntry_methods[] = {
    { "get_key", (PyCFunction)_wrap_gconf_entry_get_key, METH_NOARGS,
      NULL },
    { "get_value", (PyCFunction)_wrap_gconf_entry_get_value, METH_NOARGS,
      NULL },
    { "get_schema_name", (PyCFunction)_wrap_gconf_entry_get_schema_name, METH_NOARGS,
      NULL },
    { "get_is_default", (PyCFunction)_wrap_gconf_entry_get_is_default, METH_NOARGS,
      NULL },
    { "get_is_writable", (PyCFunction)_wrap_gconf_entry_get_is_writable, METH_NOARGS,
      NULL },
    { "copy", (PyCFunction)_wrap_gconf_entry_copy, METH_NOARGS,
      NULL },
    { "free", (PyCFunction)_wrap_gconf_entry_free, METH_NOARGS,
      NULL },
    { "ref", (PyCFunction)_wrap_gconf_entry_ref, METH_NOARGS,
      NULL },
    { "unref", (PyCFunction)_wrap_gconf_entry_unref, METH_NOARGS,
      NULL },
    { "steal_value", (PyCFunction)_wrap_gconf_entry_steal_value, METH_NOARGS,
      NULL },
    { "set_value", (PyCFunction)_wrap_gconf_entry_set_value, METH_VARARGS|METH_KEYWORDS,
      NULL },
    { "set_value_nocopy", (PyCFunction)_wrap_gconf_entry_set_value_nocopy, METH_VARARGS|METH_KEYWORDS,
      NULL },
    { "set_schema_name", (PyCFunction)_wrap_gconf_entry_set_schema_name, METH_VARARGS|METH_KEYWORDS,
      NULL },
    { "set_is_default", (PyCFunction)_wrap_gconf_entry_set_is_default, METH_VARARGS|METH_KEYWORDS,
      NULL },
    { "set_is_writable", (PyCFunction)_wrap_gconf_entry_set_is_writable, METH_VARARGS|METH_KEYWORDS,
      NULL },
    { NULL, NULL, 0, NULL }
};

static PyObject *
_wrap_gconf_entry__get_key(PyObject *self, void *closure)
{
    const gchar *ret;

    ret = pyg_boxed_get(self, GConfEntry)->key;
    if (ret)
        return PyString_FromString(ret);
    Py_INCREF(Py_None);
    return Py_None;
}

static PyObject *
_wrap_gconf_entry__get_value(PyObject *self, void *closure)
{
    GConfValue *ret;

    ret = pyg_boxed_get(self, GConfEntry)->value;
    /* pyg_boxed_new handles NULL checking */
    return pyg_boxed_new(GCONF_TYPE_VALUE, ret, TRUE, TRUE);
}

static const PyGetSetDef gconf_entry_getsets[] = {
    { "key", (getter)_wrap_gconf_entry__get_key, (setter)0 },
    { "value", (getter)_wrap_gconf_entry__get_value, (setter)0 },
    { NULL, (getter)0, (setter)0 },
};

PyTypeObject G_GNUC_INTERNAL PyGConfEntry_Type = {
    PyObject_HEAD_INIT(NULL)
    0,                                 /* ob_size */
    "gconf.Entry",                   /* tp_name */
    sizeof(PyGBoxed),          /* tp_basicsize */
    0,                                 /* tp_itemsize */
    /* methods */
    (destructor)0,        /* tp_dealloc */
    (printfunc)0,                      /* tp_print */
    (getattrfunc)0,       /* tp_getattr */
    (setattrfunc)0,       /* tp_setattr */
    (cmpfunc)0,           /* tp_compare */
    (reprfunc)0,             /* tp_repr */
    (PyNumberMethods*)0,     /* tp_as_number */
    (PySequenceMethods*)0, /* tp_as_sequence */
    (PyMappingMethods*)0,   /* tp_as_mapping */
    (hashfunc)0,             /* tp_hash */
    (ternaryfunc)0,          /* tp_call */
    (reprfunc)0,              /* tp_str */
    (getattrofunc)0,     /* tp_getattro */
    (setattrofunc)0,     /* tp_setattro */
    (PyBufferProcs*)0,  /* tp_as_buffer */
    Py_TPFLAGS_DEFAULT | Py_TPFLAGS_BASETYPE,                      /* tp_flags */
    NULL,                        /* Documentation string */
    (traverseproc)0,     /* tp_traverse */
    (inquiry)0,             /* tp_clear */
    (richcmpfunc)0,   /* tp_richcompare */
    0,             /* tp_weaklistoffset */
    (getiterfunc)0,          /* tp_iter */
    (iternextfunc)0,     /* tp_iternext */
    (struct PyMethodDef*)_PyGConfEntry_methods, /* tp_methods */
    (struct PyMemberDef*)0,              /* tp_members */
    (struct PyGetSetDef*)gconf_entry_getsets,  /* tp_getset */
    NULL,                              /* tp_base */
    NULL,                              /* tp_dict */
    (descrgetfunc)0,    /* tp_descr_get */
    (descrsetfunc)0,    /* tp_descr_set */
    0,                 /* tp_dictoffset */
    (initproc)_wrap_gconf_entry_new,             /* tp_init */
    (allocfunc)0,           /* tp_alloc */
    (newfunc)0,               /* tp_new */
    (freefunc)0,             /* tp_free */
    (inquiry)0              /* tp_is_gc */
};



/* ----------- GConfSchema ----------- */

static int
_wrap_gconf_schema_new(PyGBoxed *self, PyObject *args, PyObject *kwargs)
{
    static char *kwlist[] = { NULL };

    if (!PyArg_ParseTupleAndKeywords(args, kwargs,":GConf.Schema.__init__", kwlist))
        return -1;
    self->gtype = GCONF_TYPE_SCHEMA;
    self->free_on_dealloc = FALSE;
    self->boxed = gconf_schema_new();

    if (!self->boxed) {
        PyErr_SetString(PyExc_RuntimeError, "could not create GConfSchema object");
        return -1;
    }
    self->free_on_dealloc = TRUE;
    return 0;
}

static PyObject *
_wrap_gconf_schema_free(PyObject *self)
{
    
    gconf_schema_free(pyg_boxed_get(self, GConfSchema));
    
    Py_INCREF(Py_None);
    return Py_None;
}

static PyObject *
_wrap_gconf_schema_copy(PyObject *self)
{
    GConfSchema *ret;

    
    ret = gconf_schema_copy(pyg_boxed_get(self, GConfSchema));
    
    /* pyg_boxed_new handles NULL checking */
    return pyg_boxed_new(GCONF_TYPE_SCHEMA, ret, TRUE, TRUE);
}

static PyObject *
_wrap_gconf_schema_set_type(PyObject *self, PyObject *args, PyObject *kwargs)
{
    static char *kwlist[] = { "type", NULL };
    PyObject *py_type = NULL;
    GConfValueType type;

    if (!PyArg_ParseTupleAndKeywords(args, kwargs,"O:GConf.Schema.set_type", kwlist, &py_type))
        return NULL;
    if (pyg_enum_get_value(GCONF_TYPE_VALUE_TYPE, py_type, (gpointer)&type))
        return NULL;
    
    gconf_schema_set_type(pyg_boxed_get(self, GConfSchema), type);
    
    Py_INCREF(Py_None);
    return Py_None;
}

static PyObject *
_wrap_gconf_schema_set_list_type(PyObject *self, PyObject *args, PyObject *kwargs)
{
    static char *kwlist[] = { "type", NULL };
    PyObject *py_type = NULL;
    GConfValueType type;

    if (!PyArg_ParseTupleAndKeywords(args, kwargs,"O:GConf.Schema.set_list_type", kwlist, &py_type))
        return NULL;
    if (pyg_enum_get_value(GCONF_TYPE_VALUE_TYPE, py_type, (gpointer)&type))
        return NULL;
    
    gconf_schema_set_list_type(pyg_boxed_get(self, GConfSchema), type);
    
    Py_INCREF(Py_None);
    return Py_None;
}

static PyObject *
_wrap_gconf_schema_set_car_type(PyObject *self, PyObject *args, PyObject *kwargs)
{
    static char *kwlist[] = { "type", NULL };
    PyObject *py_type = NULL;
    GConfValueType type;

    if (!PyArg_ParseTupleAndKeywords(args, kwargs,"O:GConf.Schema.set_car_type", kwlist, &py_type))
        return NULL;
    if (pyg_enum_get_value(GCONF_TYPE_VALUE_TYPE, py_type, (gpointer)&type))
        return NULL;
    
    gconf_schema_set_car_type(pyg_boxed_get(self, GConfSchema), type);
    
    Py_INCREF(Py_None);
    return Py_None;
}

static PyObject *
_wrap_gconf_schema_set_cdr_type(PyObject *self, PyObject *args, PyObject *kwargs)
{
    static char *kwlist[] = { "type", NULL };
    PyObject *py_type = NULL;
    GConfValueType type;

    if (!PyArg_ParseTupleAndKeywords(args, kwargs,"O:GConf.Schema.set_cdr_type", kwlist, &py_type))
        return NULL;
    if (pyg_enum_get_value(GCONF_TYPE_VALUE_TYPE, py_type, (gpointer)&type))
        return NULL;
    
    gconf_schema_set_cdr_type(pyg_boxed_get(self, GConfSchema), type);
    
    Py_INCREF(Py_None);
    return Py_None;
}

static PyObject *
_wrap_gconf_schema_set_locale(PyObject *self, PyObject *args, PyObject *kwargs)
{
    static char *kwlist[] = { "locale", NULL };
    char *locale;

    if (!PyArg_ParseTupleAndKeywords(args, kwargs,"s:GConf.Schema.set_locale", kwlist, &locale))
        return NULL;
    
    gconf_schema_set_locale(pyg_boxed_get(self, GConfSchema), locale);
    
    Py_INCREF(Py_None);
    return Py_None;
}

static PyObject *
_wrap_gconf_schema_set_short_desc(PyObject *self, PyObject *args, PyObject *kwargs)
{
    static char *kwlist[] = { "desc", NULL };
    char *desc;

    if (!PyArg_ParseTupleAndKeywords(args, kwargs,"s:GConf.Schema.set_short_desc", kwlist, &desc))
        return NULL;
    
    gconf_schema_set_short_desc(pyg_boxed_get(self, GConfSchema), desc);
    
    Py_INCREF(Py_None);
    return Py_None;
}

static PyObject *
_wrap_gconf_schema_set_long_desc(PyObject *self, PyObject *args, PyObject *kwargs)
{
    static char *kwlist[] = { "desc", NULL };
    char *desc;

    if (!PyArg_ParseTupleAndKeywords(args, kwargs,"s:GConf.Schema.set_long_desc", kwlist, &desc))
        return NULL;
    
    gconf_schema_set_long_desc(pyg_boxed_get(self, GConfSchema), desc);
    
    Py_INCREF(Py_None);
    return Py_None;
}

static PyObject *
_wrap_gconf_schema_set_owner(PyObject *self, PyObject *args, PyObject *kwargs)
{
    static char *kwlist[] = { "owner", NULL };
    char *owner;

    if (!PyArg_ParseTupleAndKeywords(args, kwargs,"s:GConf.Schema.set_owner", kwlist, &owner))
        return NULL;
    
    gconf_schema_set_owner(pyg_boxed_get(self, GConfSchema), owner);
    
    Py_INCREF(Py_None);
    return Py_None;
}

static PyObject *
_wrap_gconf_schema_set_default_value(PyObject *self, PyObject *args, PyObject *kwargs)
{
    static char *kwlist[] = { "val", NULL };
    PyObject *py_val;
    GConfValue *val = NULL;

    if (!PyArg_ParseTupleAndKeywords(args, kwargs,"O:GConf.Schema.set_default_value", kwlist, &py_val))
        return NULL;
    if (pyg_boxed_check(py_val, GCONF_TYPE_VALUE))
        val = pyg_boxed_get(py_val, GConfValue);
    else {
        PyErr_SetString(PyExc_TypeError, "val should be a GConfValue");
        return NULL;
    }
    
    gconf_schema_set_default_value(pyg_boxed_get(self, GConfSchema), val);
    
    Py_INCREF(Py_None);
    return Py_None;
}

static PyObject *
_wrap_gconf_schema_set_default_value_nocopy(PyObject *self, PyObject *args, PyObject *kwargs)
{
    static char *kwlist[] = { "val", NULL };
    PyObject *py_val;
    GConfValue *val = NULL;

    if (!PyArg_ParseTupleAndKeywords(args, kwargs,"O:GConf.Schema.set_default_value_nocopy", kwlist, &py_val))
        return NULL;
    if (pyg_boxed_check(py_val, GCONF_TYPE_VALUE))
        val = pyg_boxed_get(py_val, GConfValue);
    else {
        PyErr_SetString(PyExc_TypeError, "val should be a GConfValue");
        return NULL;
    }
    
    gconf_schema_set_default_value_nocopy(pyg_boxed_get(self, GConfSchema), val);
    
    Py_INCREF(Py_None);
    return Py_None;
}

static PyObject *
_wrap_gconf_schema_get_type(PyObject *self)
{
    gint ret;

    
    ret = gconf_schema_get_type(pyg_boxed_get(self, GConfSchema));
    
    return pyg_enum_from_gtype(GCONF_TYPE_VALUE_TYPE, ret);
}

static PyObject *
_wrap_gconf_schema_get_list_type(PyObject *self)
{
    gint ret;

    
    ret = gconf_schema_get_list_type(pyg_boxed_get(self, GConfSchema));
    
    return pyg_enum_from_gtype(GCONF_TYPE_VALUE_TYPE, ret);
}

static PyObject *
_wrap_gconf_schema_get_car_type(PyObject *self)
{
    gint ret;

    
    ret = gconf_schema_get_car_type(pyg_boxed_get(self, GConfSchema));
    
    return pyg_enum_from_gtype(GCONF_TYPE_VALUE_TYPE, ret);
}

static PyObject *
_wrap_gconf_schema_get_cdr_type(PyObject *self)
{
    gint ret;

    
    ret = gconf_schema_get_cdr_type(pyg_boxed_get(self, GConfSchema));
    
    return pyg_enum_from_gtype(GCONF_TYPE_VALUE_TYPE, ret);
}

static PyObject *
_wrap_gconf_schema_get_locale(PyObject *self)
{
    const gchar *ret;

    
    ret = gconf_schema_get_locale(pyg_boxed_get(self, GConfSchema));
    
    if (ret)
        return PyString_FromString(ret);
    Py_INCREF(Py_None);
    return Py_None;
}

static PyObject *
_wrap_gconf_schema_get_short_desc(PyObject *self)
{
    const gchar *ret;

    
    ret = gconf_schema_get_short_desc(pyg_boxed_get(self, GConfSchema));
    
    if (ret)
        return PyString_FromString(ret);
    Py_INCREF(Py_None);
    return Py_None;
}

static PyObject *
_wrap_gconf_schema_get_long_desc(PyObject *self)
{
    const gchar *ret;

    
    ret = gconf_schema_get_long_desc(pyg_boxed_get(self, GConfSchema));
    
    if (ret)
        return PyString_FromString(ret);
    Py_INCREF(Py_None);
    return Py_None;
}

static PyObject *
_wrap_gconf_schema_get_owner(PyObject *self)
{
    const gchar *ret;

    
    ret = gconf_schema_get_owner(pyg_boxed_get(self, GConfSchema));
    
    if (ret)
        return PyString_FromString(ret);
    Py_INCREF(Py_None);
    return Py_None;
}

static PyObject *
_wrap_gconf_schema_get_default_value(PyObject *self)
{
    GConfValue *ret;

    
    ret = gconf_schema_get_default_value(pyg_boxed_get(self, GConfSchema));
    
    /* pyg_boxed_new handles NULL checking */
    return pyg_boxed_new(GCONF_TYPE_VALUE, ret, TRUE, TRUE);
}

static const PyMethodDef _PyGConfSchema_methods[] = {
    { "free", (PyCFunction)_wrap_gconf_schema_free, METH_NOARGS,
      NULL },
    { "copy", (PyCFunction)_wrap_gconf_schema_copy, METH_NOARGS,
      NULL },
    { "set_type", (PyCFunction)_wrap_gconf_schema_set_type, METH_VARARGS|METH_KEYWORDS,
      NULL },
    { "set_list_type", (PyCFunction)_wrap_gconf_schema_set_list_type, METH_VARARGS|METH_KEYWORDS,
      NULL },
    { "set_car_type", (PyCFunction)_wrap_gconf_schema_set_car_type, METH_VARARGS|METH_KEYWORDS,
      NULL },
    { "set_cdr_type", (PyCFunction)_wrap_gconf_schema_set_cdr_type, METH_VARARGS|METH_KEYWORDS,
      NULL },
    { "set_locale", (PyCFunction)_wrap_gconf_schema_set_locale, METH_VARARGS|METH_KEYWORDS,
      NULL },
    { "set_short_desc", (PyCFunction)_wrap_gconf_schema_set_short_desc, METH_VARARGS|METH_KEYWORDS,
      NULL },
    { "set_long_desc", (PyCFunction)_wrap_gconf_schema_set_long_desc, METH_VARARGS|METH_KEYWORDS,
      NULL },
    { "set_owner", (PyCFunction)_wrap_gconf_schema_set_owner, METH_VARARGS|METH_KEYWORDS,
      NULL },
    { "set_default_value", (PyCFunction)_wrap_gconf_schema_set_default_value, METH_VARARGS|METH_KEYWORDS,
      NULL },
    { "set_default_value_nocopy", (PyCFunction)_wrap_gconf_schema_set_default_value_nocopy, METH_VARARGS|METH_KEYWORDS,
      NULL },
    { "get_type", (PyCFunction)_wrap_gconf_schema_get_type, METH_NOARGS,
      NULL },
    { "get_list_type", (PyCFunction)_wrap_gconf_schema_get_list_type, METH_NOARGS,
      NULL },
    { "get_car_type", (PyCFunction)_wrap_gconf_schema_get_car_type, METH_NOARGS,
      NULL },
    { "get_cdr_type", (PyCFunction)_wrap_gconf_schema_get_cdr_type, METH_NOARGS,
      NULL },
    { "get_locale", (PyCFunction)_wrap_gconf_schema_get_locale, METH_NOARGS,
      NULL },
    { "get_short_desc", (PyCFunction)_wrap_gconf_schema_get_short_desc, METH_NOARGS,
      NULL },
    { "get_long_desc", (PyCFunction)_wrap_gconf_schema_get_long_desc, METH_NOARGS,
      NULL },
    { "get_owner", (PyCFunction)_wrap_gconf_schema_get_owner, METH_NOARGS,
      NULL },
    { "get_default_value", (PyCFunction)_wrap_gconf_schema_get_default_value, METH_NOARGS,
      NULL },
    { NULL, NULL, 0, NULL }
};

PyTypeObject G_GNUC_INTERNAL PyGConfSchema_Type = {
    PyObject_HEAD_INIT(NULL)
    0,                                 /* ob_size */
    "gconf.Schema",                   /* tp_name */
    sizeof(PyGBoxed),          /* tp_basicsize */
    0,                                 /* tp_itemsize */
    /* methods */
    (destructor)0,        /* tp_dealloc */
    (printfunc)0,                      /* tp_print */
    (getattrfunc)0,       /* tp_getattr */
    (setattrfunc)0,       /* tp_setattr */
    (cmpfunc)0,           /* tp_compare */
    (reprfunc)0,             /* tp_repr */
    (PyNumberMethods*)0,     /* tp_as_number */
    (PySequenceMethods*)0, /* tp_as_sequence */
    (PyMappingMethods*)0,   /* tp_as_mapping */
    (hashfunc)0,             /* tp_hash */
    (ternaryfunc)0,          /* tp_call */
    (reprfunc)0,              /* tp_str */
    (getattrofunc)0,     /* tp_getattro */
    (setattrofunc)0,     /* tp_setattro */
    (PyBufferProcs*)0,  /* tp_as_buffer */
    Py_TPFLAGS_DEFAULT | Py_TPFLAGS_BASETYPE,                      /* tp_flags */
    NULL,                        /* Documentation string */
    (traverseproc)0,     /* tp_traverse */
    (inquiry)0,             /* tp_clear */
    (richcmpfunc)0,   /* tp_richcompare */
    0,             /* tp_weaklistoffset */
    (getiterfunc)0,          /* tp_iter */
    (iternextfunc)0,     /* tp_iternext */
    (struct PyMethodDef*)_PyGConfSchema_methods, /* tp_methods */
    (struct PyMemberDef*)0,              /* tp_members */
    (struct PyGetSetDef*)0,  /* tp_getset */
    NULL,                              /* tp_base */
    NULL,                              /* tp_dict */
    (descrgetfunc)0,    /* tp_descr_get */
    (descrsetfunc)0,    /* tp_descr_set */
    0,                 /* tp_dictoffset */
    (initproc)_wrap_gconf_schema_new,             /* tp_init */
    (allocfunc)0,           /* tp_alloc */
    (newfunc)0,               /* tp_new */
    (freefunc)0,             /* tp_free */
    (inquiry)0              /* tp_is_gc */
};



/* ----------- GConfMetaInfo ----------- */

static int
_wrap_gconf_meta_info_new(PyGBoxed *self, PyObject *args, PyObject *kwargs)
{
    static char *kwlist[] = { NULL };

    if (!PyArg_ParseTupleAndKeywords(args, kwargs,":GConf.MetaInfo.__init__", kwlist))
        return -1;
    self->gtype = GCONF_TYPE_METAINFO;
    self->free_on_dealloc = FALSE;
    self->boxed = gconf_meta_info_new();

    if (!self->boxed) {
        PyErr_SetString(PyExc_RuntimeError, "could not create GConfMetaInfo object");
        return -1;
    }
    self->free_on_dealloc = TRUE;
    return 0;
}

static PyObject *
_wrap_gconf_meta_info_get_schema(PyObject *self)
{
    const gchar *ret;

    
    ret = gconf_meta_info_get_schema(pyg_boxed_get(self, GConfMetaInfo));
    
    if (ret)
        return PyString_FromString(ret);
    Py_INCREF(Py_None);
    return Py_None;
}

static PyObject *
_wrap_gconf_meta_info_get_mod_user(PyObject *self)
{
    const gchar *ret;

    
    ret = gconf_meta_info_get_mod_user(pyg_boxed_get(self, GConfMetaInfo));
    
    if (ret)
        return PyString_FromString(ret);
    Py_INCREF(Py_None);
    return Py_None;
}

static PyObject *
_wrap_gconf_meta_info_mod_time(PyObject *self)
{
    int ret;

    
    ret = gconf_meta_info_mod_time(pyg_boxed_get(self, GConfMetaInfo));
    
    return PyInt_FromLong(ret);
}

static PyObject *
_wrap_gconf_meta_info_free(PyObject *self)
{
    
    gconf_meta_info_free(pyg_boxed_get(self, GConfMetaInfo));
    
    Py_INCREF(Py_None);
    return Py_None;
}

static PyObject *
_wrap_gconf_meta_info_set_schema(PyObject *self, PyObject *args, PyObject *kwargs)
{
    static char *kwlist[] = { "schema_name", NULL };
    char *schema_name;

    if (!PyArg_ParseTupleAndKeywords(args, kwargs,"s:GConf.MetaInfo.set_schema", kwlist, &schema_name))
        return NULL;
    
    gconf_meta_info_set_schema(pyg_boxed_get(self, GConfMetaInfo), schema_name);
    
    Py_INCREF(Py_None);
    return Py_None;
}

static PyObject *
_wrap_gconf_meta_info_set_mod_user(PyObject *self, PyObject *args, PyObject *kwargs)
{
    static char *kwlist[] = { "mod_user", NULL };
    char *mod_user;

    if (!PyArg_ParseTupleAndKeywords(args, kwargs,"s:GConf.MetaInfo.set_mod_user", kwlist, &mod_user))
        return NULL;
    
    gconf_meta_info_set_mod_user(pyg_boxed_get(self, GConfMetaInfo), mod_user);
    
    Py_INCREF(Py_None);
    return Py_None;
}

static PyObject *
_wrap_gconf_meta_info_set_mod_time(PyObject *self, PyObject *args, PyObject *kwargs)
{
    static char *kwlist[] = { "mod_time", NULL };
    int mod_time;

    if (!PyArg_ParseTupleAndKeywords(args, kwargs,"i:GConf.MetaInfo.set_mod_time", kwlist, &mod_time))
        return NULL;
    
    gconf_meta_info_set_mod_time(pyg_boxed_get(self, GConfMetaInfo), mod_time);
    
    Py_INCREF(Py_None);
    return Py_None;
}

static const PyMethodDef _PyGConfMetaInfo_methods[] = {
    { "get_schema", (PyCFunction)_wrap_gconf_meta_info_get_schema, METH_NOARGS,
      NULL },
    { "get_mod_user", (PyCFunction)_wrap_gconf_meta_info_get_mod_user, METH_NOARGS,
      NULL },
    { "mod_time", (PyCFunction)_wrap_gconf_meta_info_mod_time, METH_NOARGS,
      NULL },
    { "free", (PyCFunction)_wrap_gconf_meta_info_free, METH_NOARGS,
      NULL },
    { "set_schema", (PyCFunction)_wrap_gconf_meta_info_set_schema, METH_VARARGS|METH_KEYWORDS,
      NULL },
    { "set_mod_user", (PyCFunction)_wrap_gconf_meta_info_set_mod_user, METH_VARARGS|METH_KEYWORDS,
      NULL },
    { "set_mod_time", (PyCFunction)_wrap_gconf_meta_info_set_mod_time, METH_VARARGS|METH_KEYWORDS,
      NULL },
    { NULL, NULL, 0, NULL }
};

PyTypeObject G_GNUC_INTERNAL PyGConfMetaInfo_Type = {
    PyObject_HEAD_INIT(NULL)
    0,                                 /* ob_size */
    "gconf.MetaInfo",                   /* tp_name */
    sizeof(PyGBoxed),          /* tp_basicsize */
    0,                                 /* tp_itemsize */
    /* methods */
    (destructor)0,        /* tp_dealloc */
    (printfunc)0,                      /* tp_print */
    (getattrfunc)0,       /* tp_getattr */
    (setattrfunc)0,       /* tp_setattr */
    (cmpfunc)0,           /* tp_compare */
    (reprfunc)0,             /* tp_repr */
    (PyNumberMethods*)0,     /* tp_as_number */
    (PySequenceMethods*)0, /* tp_as_sequence */
    (PyMappingMethods*)0,   /* tp_as_mapping */
    (hashfunc)0,             /* tp_hash */
    (ternaryfunc)0,          /* tp_call */
    (reprfunc)0,              /* tp_str */
    (getattrofunc)0,     /* tp_getattro */
    (setattrofunc)0,     /* tp_setattro */
    (PyBufferProcs*)0,  /* tp_as_buffer */
    Py_TPFLAGS_DEFAULT | Py_TPFLAGS_BASETYPE,                      /* tp_flags */
    NULL,                        /* Documentation string */
    (traverseproc)0,     /* tp_traverse */
    (inquiry)0,             /* tp_clear */
    (richcmpfunc)0,   /* tp_richcompare */
    0,             /* tp_weaklistoffset */
    (getiterfunc)0,          /* tp_iter */
    (iternextfunc)0,     /* tp_iternext */
    (struct PyMethodDef*)_PyGConfMetaInfo_methods, /* tp_methods */
    (struct PyMemberDef*)0,              /* tp_members */
    (struct PyGetSetDef*)0,  /* tp_getset */
    NULL,                              /* tp_base */
    NULL,                              /* tp_dict */
    (descrgetfunc)0,    /* tp_descr_get */
    (descrsetfunc)0,    /* tp_descr_set */
    0,                 /* tp_dictoffset */
    (initproc)_wrap_gconf_meta_info_new,             /* tp_init */
    (allocfunc)0,           /* tp_alloc */
    (newfunc)0,               /* tp_new */
    (freefunc)0,             /* tp_free */
    (inquiry)0              /* tp_is_gc */
};



/* ----------- GConfChangeSet ----------- */

static int
_wrap_gconf_change_set_new(PyGBoxed *self, PyObject *args, PyObject *kwargs)
{
    static char *kwlist[] = { NULL };

    if (!PyArg_ParseTupleAndKeywords(args, kwargs,":GConf.ChangeSet.__init__", kwlist))
        return -1;
    self->gtype = GCONF_TYPE_CHANGE_SET;
    self->free_on_dealloc = FALSE;
    self->boxed = gconf_change_set_new();

    if (!self->boxed) {
        PyErr_SetString(PyExc_RuntimeError, "could not create GConfChangeSet object");
        return -1;
    }
    self->free_on_dealloc = TRUE;
    return 0;
}

static PyObject *
_wrap_gconf_change_set_ref(PyObject *self)
{
    
    gconf_change_set_ref(pyg_boxed_get(self, GConfChangeSet));
    
    Py_INCREF(Py_None);
    return Py_None;
}

static PyObject *
_wrap_gconf_change_set_unref(PyObject *self)
{
    
    gconf_change_set_unref(pyg_boxed_get(self, GConfChangeSet));
    
    Py_INCREF(Py_None);
    return Py_None;
}

static PyObject *
_wrap_gconf_change_set_clear(PyObject *self)
{
    
    gconf_change_set_clear(pyg_boxed_get(self, GConfChangeSet));
    
    Py_INCREF(Py_None);
    return Py_None;
}

static PyObject *
_wrap_gconf_change_set_size(PyObject *self)
{
    guint ret;

    
    ret = gconf_change_set_size(pyg_boxed_get(self, GConfChangeSet));
    
    return PyLong_FromUnsignedLong(ret);
}

static PyObject *
_wrap_gconf_change_set_remove(PyObject *self, PyObject *args, PyObject *kwargs)
{
    static char *kwlist[] = { "key", NULL };
    char *key;

    if (!PyArg_ParseTupleAndKeywords(args, kwargs,"s:GConf.ChangeSet.remove", kwlist, &key))
        return NULL;
    
    gconf_change_set_remove(pyg_boxed_get(self, GConfChangeSet), key);
    
    Py_INCREF(Py_None);
    return Py_None;
}

static PyObject *
_wrap_gconf_change_set_set(PyObject *self, PyObject *args, PyObject *kwargs)
{
    static char *kwlist[] = { "key", "value", NULL };
    char *key;
    PyObject *py_value;
    GConfValue *value = NULL;

    if (!PyArg_ParseTupleAndKeywords(args, kwargs,"sO:GConf.ChangeSet.set", kwlist, &key, &py_value))
        return NULL;
    if (pyg_boxed_check(py_value, GCONF_TYPE_VALUE))
        value = pyg_boxed_get(py_value, GConfValue);
    else {
        PyErr_SetString(PyExc_TypeError, "value should be a GConfValue");
        return NULL;
    }
    
    gconf_change_set_set(pyg_boxed_get(self, GConfChangeSet), key, value);
    
    Py_INCREF(Py_None);
    return Py_None;
}

static PyObject *
_wrap_gconf_change_set_set_nocopy(PyObject *self, PyObject *args, PyObject *kwargs)
{
    static char *kwlist[] = { "key", "value", NULL };
    char *key;
    PyObject *py_value;
    GConfValue *value = NULL;

    if (!PyArg_ParseTupleAndKeywords(args, kwargs,"sO:GConf.ChangeSet.set_nocopy", kwlist, &key, &py_value))
        return NULL;
    if (pyg_boxed_check(py_value, GCONF_TYPE_VALUE))
        value = pyg_boxed_get(py_value, GConfValue);
    else {
        PyErr_SetString(PyExc_TypeError, "value should be a GConfValue");
        return NULL;
    }
    
    gconf_change_set_set_nocopy(pyg_boxed_get(self, GConfChangeSet), key, value);
    
    Py_INCREF(Py_None);
    return Py_None;
}

static PyObject *
_wrap_gconf_change_set_unset(PyObject *self, PyObject *args, PyObject *kwargs)
{
    static char *kwlist[] = { "key", NULL };
    char *key;

    if (!PyArg_ParseTupleAndKeywords(args, kwargs,"s:GConf.ChangeSet.unset", kwlist, &key))
        return NULL;
    
    gconf_change_set_unset(pyg_boxed_get(self, GConfChangeSet), key);
    
    Py_INCREF(Py_None);
    return Py_None;
}

static PyObject *
_wrap_gconf_change_set_set_float(PyObject *self, PyObject *args, PyObject *kwargs)
{
    static char *kwlist[] = { "key", "val", NULL };
    char *key;
    double val;

    if (!PyArg_ParseTupleAndKeywords(args, kwargs,"sd:GConf.ChangeSet.set_float", kwlist, &key, &val))
        return NULL;
    
    gconf_change_set_set_float(pyg_boxed_get(self, GConfChangeSet), key, val);
    
    Py_INCREF(Py_None);
    return Py_None;
}

static PyObject *
_wrap_gconf_change_set_set_int(PyObject *self, PyObject *args, PyObject *kwargs)
{
    static char *kwlist[] = { "key", "val", NULL };
    char *key;
    int val;

    if (!PyArg_ParseTupleAndKeywords(args, kwargs,"si:GConf.ChangeSet.set_int", kwlist, &key, &val))
        return NULL;
    
    gconf_change_set_set_int(pyg_boxed_get(self, GConfChangeSet), key, val);
    
    Py_INCREF(Py_None);
    return Py_None;
}

static PyObject *
_wrap_gconf_change_set_set_string(PyObject *self, PyObject *args, PyObject *kwargs)
{
    static char *kwlist[] = { "key", "val", NULL };
    char *key, *val;

    if (!PyArg_ParseTupleAndKeywords(args, kwargs,"ss:GConf.ChangeSet.set_string", kwlist, &key, &val))
        return NULL;
    
    gconf_change_set_set_string(pyg_boxed_get(self, GConfChangeSet), key, val);
    
    Py_INCREF(Py_None);
    return Py_None;
}

static PyObject *
_wrap_gconf_change_set_set_bool(PyObject *self, PyObject *args, PyObject *kwargs)
{
    static char *kwlist[] = { "key", "val", NULL };
    char *key;
    int val;

    if (!PyArg_ParseTupleAndKeywords(args, kwargs,"si:GConf.ChangeSet.set_bool", kwlist, &key, &val))
        return NULL;
    
    gconf_change_set_set_bool(pyg_boxed_get(self, GConfChangeSet), key, val);
    
    Py_INCREF(Py_None);
    return Py_None;
}

static PyObject *
_wrap_gconf_change_set_set_schema(PyObject *self, PyObject *args, PyObject *kwargs)
{
    static char *kwlist[] = { "key", "val", NULL };
    char *key;
    PyObject *py_val;
    GConfSchema *val = NULL;

    if (!PyArg_ParseTupleAndKeywords(args, kwargs,"sO:GConf.ChangeSet.set_schema", kwlist, &key, &py_val))
        return NULL;
    if (pyg_boxed_check(py_val, GCONF_TYPE_SCHEMA))
        val = pyg_boxed_get(py_val, GConfSchema);
    else {
        PyErr_SetString(PyExc_TypeError, "val should be a GConfSchema");
        return NULL;
    }
    
    gconf_change_set_set_schema(pyg_boxed_get(self, GConfChangeSet), key, val);
    
    Py_INCREF(Py_None);
    return Py_None;
}

#line 770 "gconf.override"
static PyObject *
_wrap_gconf_change_set_set_list(PyObject *self, PyObject *args, PyObject *kwargs)
{
    static char *kwlist[] = { "key", "list_type", "list", NULL };
    char *key;
    PyObject *py_list_type = NULL, *py_list;
    GConfValueType list_type;
    int i, len;
    GSList *list;

    if (!PyArg_ParseTupleAndKeywords(args, kwargs, "sOO!:GConfChangeSet.set_list"
                                     , kwlist, &key, &py_list_type,
                                     &PyList_Type, &py_list))
        return NULL;
    if (pyg_enum_get_value(GCONF_TYPE_VALUE_TYPE, py_list_type, (gint *)&list_type))
        return NULL;

    len = PyList_Size(py_list);
    for (i = 0, list = NULL; i < len; i++) {
        PyObject *item = PyList_GET_ITEM(py_list, i);
        if (!pyg_boxed_check(item, GCONF_TYPE_VALUE)) {
            PyErr_SetString(PyExc_TypeError, "list elements must be of type gconf.Value");
            g_slist_free(list);
            return NULL;
        }
        list = g_slist_append(list, pyg_boxed_get(item, GConfValue));
    }
    gconf_change_set_set_list(pyg_boxed_get(self, GConfChangeSet), key, list_type, list);
    g_slist_free(list);
    Py_INCREF(Py_None);
    return Py_None;
}

#line 1794 "gconf.c"


static const PyMethodDef _PyGConfChangeSet_methods[] = {
    { "ref", (PyCFunction)_wrap_gconf_change_set_ref, METH_NOARGS,
      NULL },
    { "unref", (PyCFunction)_wrap_gconf_change_set_unref, METH_NOARGS,
      NULL },
    { "clear", (PyCFunction)_wrap_gconf_change_set_clear, METH_NOARGS,
      NULL },
    { "size", (PyCFunction)_wrap_gconf_change_set_size, METH_NOARGS,
      NULL },
    { "remove", (PyCFunction)_wrap_gconf_change_set_remove, METH_VARARGS|METH_KEYWORDS,
      NULL },
    { "set", (PyCFunction)_wrap_gconf_change_set_set, METH_VARARGS|METH_KEYWORDS,
      NULL },
    { "set_nocopy", (PyCFunction)_wrap_gconf_change_set_set_nocopy, METH_VARARGS|METH_KEYWORDS,
      NULL },
    { "unset", (PyCFunction)_wrap_gconf_change_set_unset, METH_VARARGS|METH_KEYWORDS,
      NULL },
    { "set_float", (PyCFunction)_wrap_gconf_change_set_set_float, METH_VARARGS|METH_KEYWORDS,
      NULL },
    { "set_int", (PyCFunction)_wrap_gconf_change_set_set_int, METH_VARARGS|METH_KEYWORDS,
      NULL },
    { "set_string", (PyCFunction)_wrap_gconf_change_set_set_string, METH_VARARGS|METH_KEYWORDS,
      NULL },
    { "set_bool", (PyCFunction)_wrap_gconf_change_set_set_bool, METH_VARARGS|METH_KEYWORDS,
      NULL },
    { "set_schema", (PyCFunction)_wrap_gconf_change_set_set_schema, METH_VARARGS|METH_KEYWORDS,
      NULL },
    { "set_list", (PyCFunction)_wrap_gconf_change_set_set_list, METH_VARARGS|METH_KEYWORDS,
      NULL },
    { NULL, NULL, 0, NULL }
};

PyTypeObject G_GNUC_INTERNAL PyGConfChangeSet_Type = {
    PyObject_HEAD_INIT(NULL)
    0,                                 /* ob_size */
    "gconf.ChangeSet",                   /* tp_name */
    sizeof(PyGBoxed),          /* tp_basicsize */
    0,                                 /* tp_itemsize */
    /* methods */
    (destructor)0,        /* tp_dealloc */
    (printfunc)0,                      /* tp_print */
    (getattrfunc)0,       /* tp_getattr */
    (setattrfunc)0,       /* tp_setattr */
    (cmpfunc)0,           /* tp_compare */
    (reprfunc)0,             /* tp_repr */
    (PyNumberMethods*)0,     /* tp_as_number */
    (PySequenceMethods*)0, /* tp_as_sequence */
    (PyMappingMethods*)0,   /* tp_as_mapping */
    (hashfunc)0,             /* tp_hash */
    (ternaryfunc)0,          /* tp_call */
    (reprfunc)0,              /* tp_str */
    (getattrofunc)0,     /* tp_getattro */
    (setattrofunc)0,     /* tp_setattro */
    (PyBufferProcs*)0,  /* tp_as_buffer */
    Py_TPFLAGS_DEFAULT | Py_TPFLAGS_BASETYPE,                      /* tp_flags */
    NULL,                        /* Documentation string */
    (traverseproc)0,     /* tp_traverse */
    (inquiry)0,             /* tp_clear */
    (richcmpfunc)0,   /* tp_richcompare */
    0,             /* tp_weaklistoffset */
    (getiterfunc)0,          /* tp_iter */
    (iternextfunc)0,     /* tp_iternext */
    (struct PyMethodDef*)_PyGConfChangeSet_methods, /* tp_methods */
    (struct PyMemberDef*)0,              /* tp_members */
    (struct PyGetSetDef*)0,  /* tp_getset */
    NULL,                              /* tp_base */
    NULL,                              /* tp_dict */
    (descrgetfunc)0,    /* tp_descr_get */
    (descrsetfunc)0,    /* tp_descr_set */
    0,                 /* tp_dictoffset */
    (initproc)_wrap_gconf_change_set_new,             /* tp_init */
    (allocfunc)0,           /* tp_alloc */
    (newfunc)0,               /* tp_new */
    (freefunc)0,             /* tp_free */
    (inquiry)0              /* tp_is_gc */
};



/* ----------- GConfClient ----------- */

static PyObject *
_wrap_gconf_client_add_dir(PyGObject *self, PyObject *args, PyObject *kwargs)
{
    static char *kwlist[] = { "dir", "preload", NULL };
    char *dir;
    GConfClientPreloadType preload;
    GError *err = NULL;
    PyObject *py_preload = NULL;

    if (!PyArg_ParseTupleAndKeywords(args, kwargs,"sO:GConf.Client.add_dir", kwlist, &dir, &py_preload))
        return NULL;
    if (pyg_enum_get_value(GCONF_TYPE_CLIENT_PRELOAD_TYPE, py_preload, (gpointer)&preload))
        return NULL;
    
    gconf_client_add_dir(GCONF_CLIENT(self->obj), dir, preload, &err);
    
    if (pyg_error_check(&err))
        return NULL;
    Py_INCREF(Py_None);
    return Py_None;
}

static PyObject *
_wrap_gconf_client_remove_dir(PyGObject *self, PyObject *args, PyObject *kwargs)
{
    static char *kwlist[] = { "dir", NULL };
    char *dir;
    GError *err = NULL;

    if (!PyArg_ParseTupleAndKeywords(args, kwargs,"s:GConf.Client.remove_dir", kwlist, &dir))
        return NULL;
    
    gconf_client_remove_dir(GCONF_CLIENT(self->obj), dir, &err);
    
    if (pyg_error_check(&err))
        return NULL;
    Py_INCREF(Py_None);
    return Py_None;
}

#line 57 "gconf.override"
void
pygconf_client_notify_add(GConfClient *client,
			  guint        cnxn_id,
			  GConfEntry  *entry,
			  gpointer     user_data)
{
 	PyObject *func;
	PyObject *userdata = NULL;
	PyObject *ret;
	PyObject *tuple = (PyObject*)user_data;
	PyGILState_STATE state;

        state = pyg_gil_state_ensure();

	g_assert(PyTuple_Check(tuple));
        func = PyTuple_GetItem(tuple, 0);
        userdata = PyTuple_GetItem(tuple, 1);

	if (!userdata) {
		ret = PyObject_CallFunction(func, "NNN",
					    pygobject_new((GObject *)client),
					    PyLong_FromUnsignedLong(cnxn_id),
					    pyg_boxed_new(GCONF_TYPE_ENTRY,
							  entry,
							  TRUE, TRUE));
	} else {
		ret = PyObject_CallFunction(func, "NNNO",
					    pygobject_new((GObject *)client),
					    PyLong_FromUnsignedLong(cnxn_id),
					    pyg_boxed_new(GCONF_TYPE_ENTRY,
							  entry,
							  TRUE, TRUE),
					    userdata);		
	}
	
	if (ret == NULL)
            PyErr_Print();
	else
            Py_DECREF(ret);

	pyg_gil_state_release(state);
}
			  
static PyObject *
_wrap_gconf_client_notify_add(PyGObject *self, PyObject *args,
			      PyObject *kwargs)
{
	static char *kwlist[] = { "namespace_section", "func",
				  "user_data", NULL };
	gchar *namespace_section;
	PyObject *callback;
	PyObject *extra = NULL;
	PyObject *data;
	guint retval;
	
	if (!PyArg_ParseTupleAndKeywords(args, kwargs,
					 "sO|O:GConfClient.notify_ad",
					 kwlist, &namespace_section,
					 &callback, &extra)) {
		return NULL;
	}
	
	if (!PyCallable_Check(callback)) {
		PyErr_SetString(PyExc_TypeError, "second arg not callable");
		return NULL;
	}
	
	if (extra) {
		Py_INCREF(extra);
	} else {
		extra = PyTuple_New(0);
	}
	
	data = Py_BuildValue("(ON)", callback, extra);
	
	retval = gconf_client_notify_add(GCONF_CLIENT(self->obj),
					 namespace_section,
					 pygconf_client_notify_add,
					 data,
					 (GFreeFunc)pyg_destroy_notify,
					 NULL);
	
	return PyLong_FromUnsignedLong((unsigned long) retval);
}

#line 2004 "gconf.c"


static PyObject *
_wrap_gconf_client_notify_remove(PyGObject *self, PyObject *args, PyObject *kwargs)
{
    static char *kwlist[] = { "cnxn", NULL };
    PyObject *py_cnxn = NULL;
    guint cnxn = 0;

    if (!PyArg_ParseTupleAndKeywords(args, kwargs,"O:GConf.Client.notify_remove", kwlist, &py_cnxn))
        return NULL;
    if (py_cnxn) {
        if (PyLong_Check(py_cnxn))
            cnxn = PyLong_AsUnsignedLong(py_cnxn);
        else if (PyInt_Check(py_cnxn))
            cnxn = PyInt_AsLong(py_cnxn);
        else
            PyErr_SetString(PyExc_TypeError, "Parameter 'cnxn' must be an int or a long");
        if (PyErr_Occurred())
            return NULL;
    }
    
    gconf_client_notify_remove(GCONF_CLIENT(self->obj), cnxn);
    
    Py_INCREF(Py_None);
    return Py_None;
}

static PyObject *
_wrap_gconf_client_notify(PyGObject *self, PyObject *args, PyObject *kwargs)
{
    static char *kwlist[] = { "key", NULL };
    char *key;

    if (!PyArg_ParseTupleAndKeywords(args, kwargs,"s:GConf.Client.notify", kwlist, &key))
        return NULL;
    
    gconf_client_notify(GCONF_CLIENT(self->obj), key);
    
    Py_INCREF(Py_None);
    return Py_None;
}

static PyObject *
_wrap_gconf_client_set_error_handling(PyGObject *self, PyObject *args, PyObject *kwargs)
{
    static char *kwlist[] = { "mode", NULL };
    GConfClientErrorHandlingMode mode;
    PyObject *py_mode = NULL;

    if (!PyArg_ParseTupleAndKeywords(args, kwargs,"O:GConf.Client.set_error_handling", kwlist, &py_mode))
        return NULL;
    if (pyg_enum_get_value(GCONF_TYPE_CLIENT_ERROR_HANDLING_MODE, py_mode, (gpointer)&mode))
        return NULL;
    
    gconf_client_set_error_handling(GCONF_CLIENT(self->obj), mode);
    
    Py_INCREF(Py_None);
    return Py_None;
}

static PyObject *
_wrap_gconf_client_clear_cache(PyGObject *self)
{
    
    gconf_client_clear_cache(GCONF_CLIENT(self->obj));
    
    Py_INCREF(Py_None);
    return Py_None;
}

static PyObject *
_wrap_gconf_client_preload(PyGObject *self, PyObject *args, PyObject *kwargs)
{
    static char *kwlist[] = { "dirname", "type", NULL };
    char *dirname;
    GConfClientPreloadType type;
    GError *err = NULL;
    PyObject *py_type = NULL;

    if (!PyArg_ParseTupleAndKeywords(args, kwargs,"sO:GConf.Client.preload", kwlist, &dirname, &py_type))
        return NULL;
    if (pyg_enum_get_value(GCONF_TYPE_CLIENT_PRELOAD_TYPE, py_type, (gpointer)&type))
        return NULL;
    
    gconf_client_preload(GCONF_CLIENT(self->obj), dirname, type, &err);
    
    if (pyg_error_check(&err))
        return NULL;
    Py_INCREF(Py_None);
    return Py_None;
}

static PyObject *
_wrap_gconf_client_set(PyGObject *self, PyObject *args, PyObject *kwargs)
{
    static char *kwlist[] = { "key", "val", NULL };
    char *key;
    PyObject *py_val;
    GError *err = NULL;
    GConfValue *val = NULL;

    if (!PyArg_ParseTupleAndKeywords(args, kwargs,"sO:GConf.Client.set", kwlist, &key, &py_val))
        return NULL;
    if (pyg_boxed_check(py_val, GCONF_TYPE_VALUE))
        val = pyg_boxed_get(py_val, GConfValue);
    else {
        PyErr_SetString(PyExc_TypeError, "val should be a GConfValue");
        return NULL;
    }
    
    gconf_client_set(GCONF_CLIENT(self->obj), key, val, &err);
    
    if (pyg_error_check(&err))
        return NULL;
    Py_INCREF(Py_None);
    return Py_None;
}

static PyObject *
_wrap_gconf_client_get(PyGObject *self, PyObject *args, PyObject *kwargs)
{
    static char *kwlist[] = { "key", NULL };
    char *key;
    GError *err = NULL;
    GConfValue *ret;

    if (!PyArg_ParseTupleAndKeywords(args, kwargs,"s:GConf.Client.get", kwlist, &key))
        return NULL;
    
    ret = gconf_client_get(GCONF_CLIENT(self->obj), key, &err);
    
    if (pyg_error_check(&err))
        return NULL;
    /* pyg_boxed_new handles NULL checking */
    return pyg_boxed_new(GCONF_TYPE_VALUE, ret, FALSE, TRUE);
}

static PyObject *
_wrap_gconf_client_get_without_default(PyGObject *self, PyObject *args, PyObject *kwargs)
{
    static char *kwlist[] = { "key", NULL };
    char *key;
    GError *err = NULL;
    GConfValue *ret;

    if (!PyArg_ParseTupleAndKeywords(args, kwargs,"s:GConf.Client.get_without_default", kwlist, &key))
        return NULL;
    
    ret = gconf_client_get_without_default(GCONF_CLIENT(self->obj), key, &err);
    
    if (pyg_error_check(&err))
        return NULL;
    /* pyg_boxed_new handles NULL checking */
    return pyg_boxed_new(GCONF_TYPE_VALUE, ret, FALSE, TRUE);
}

static PyObject *
_wrap_gconf_client_get_entry(PyGObject *self, PyObject *args, PyObject *kwargs)
{
    static char *kwlist[] = { "key", "locale", "use_schema_default", NULL };
    char *key, *locale;
    int use_schema_default;
    GError *err = NULL;
    GConfEntry *ret;

    if (!PyArg_ParseTupleAndKeywords(args, kwargs,"szi:GConf.Client.get_entry", kwlist, &key, &locale, &use_schema_default))
        return NULL;
    
    ret = gconf_client_get_entry(GCONF_CLIENT(self->obj), key, locale, use_schema_default, &err);
    
    if (pyg_error_check(&err))
        return NULL;
    /* pyg_boxed_new handles NULL checking */
    return pyg_boxed_new(GCONF_TYPE_ENTRY, ret, FALSE, TRUE);
}

static PyObject *
_wrap_gconf_client_get_default_from_schema(PyGObject *self, PyObject *args, PyObject *kwargs)
{
    static char *kwlist[] = { "key", NULL };
    char *key;
    GError *err = NULL;
    GConfValue *ret;

    if (!PyArg_ParseTupleAndKeywords(args, kwargs,"s:GConf.Client.get_default_from_schema", kwlist, &key))
        return NULL;
    
    ret = gconf_client_get_default_from_schema(GCONF_CLIENT(self->obj), key, &err);
    
    if (pyg_error_check(&err))
        return NULL;
    /* pyg_boxed_new handles NULL checking */
    return pyg_boxed_new(GCONF_TYPE_VALUE, ret, FALSE, TRUE);
}

static PyObject *
_wrap_gconf_client_unset(PyGObject *self, PyObject *args, PyObject *kwargs)
{
    static char *kwlist[] = { "key", NULL };
    char *key;
    int ret;
    GError *err = NULL;

    if (!PyArg_ParseTupleAndKeywords(args, kwargs,"s:GConf.Client.unset", kwlist, &key))
        return NULL;
    
    ret = gconf_client_unset(GCONF_CLIENT(self->obj), key, &err);
    
    if (pyg_error_check(&err))
        return NULL;
    return PyBool_FromLong(ret);

}

static PyObject *
_wrap_gconf_client_recursive_unset(PyGObject *self, PyObject *args, PyObject *kwargs)
{
    static char *kwlist[] = { "key", "flags", NULL };
    char *key;
    PyObject *py_flags = NULL;
    int ret;
    GError *err = NULL;
    GConfUnsetFlags flags;

    if (!PyArg_ParseTupleAndKeywords(args, kwargs,"sO:GConf.Client.recursive_unset", kwlist, &key, &py_flags))
        return NULL;
    if (pyg_flags_get_value(GCONF_TYPE_UNSET_FLAGS, py_flags, (gpointer)&flags))
        return NULL;
    
    ret = gconf_client_recursive_unset(GCONF_CLIENT(self->obj), key, flags, &err);
    
    if (pyg_error_check(&err))
        return NULL;
    return PyBool_FromLong(ret);

}

#line 144 "gconf.override"
static PyObject *
_wrap_gconf_client_all_entries(PyGObject *self, PyObject *args)
{
	gchar *path;
	GError *err = NULL;
	GSList *values;
	GSList *list;
	PyObject *pylist;
	int i = 0;
	
	if (!PyArg_ParseTuple(args, "s:GConfClient.all_entries", &path)) {
		return NULL;
	}
	    
	values = gconf_client_all_entries(GCONF_CLIENT(self->obj), path, &err);
	if (pyg_error_check(&err)) {
		return NULL;
	}
	    
	pylist = PyTuple_New(g_slist_length(values));
	for (list = values; list; list = list->next) {
		GConfEntry *entry = list->data;
		PyObject *pyentry = pyg_boxed_new(GCONF_TYPE_ENTRY, entry,
						  FALSE, TRUE);
		PyTuple_SetItem(pylist, i++, pyentry);
	}
	
	return pylist;
}

#line 2274 "gconf.c"


#line 176 "gconf.override"
static PyObject *
_wrap_gconf_client_all_dirs(PyGObject *self, PyObject *args)
{
	gchar *path;
	GError *err = NULL;
	GSList *values;
	GSList *list;
	PyObject *pylist;
	int i = 0;
	
	if (!PyArg_ParseTuple(args, "s:GConfClient.all_dirs", &path)) {
		return NULL;
	}
	    
	values = gconf_client_all_dirs(GCONF_CLIENT(self->obj), path, &err);
	if (pyg_error_check(&err)) {
		return NULL;
	}
	    
	pylist = PyTuple_New(g_slist_length(values));
	for (list = values; list; list = list->next) {
		PyObject *pystring = PyString_FromString(list->data);

		PyTuple_SetItem(pylist, i++, pystring);
	}
	
	return pylist;
}

#line 2307 "gconf.c"


static PyObject *
_wrap_gconf_client_suggest_sync(PyGObject *self)
{
    GError *err = NULL;

    
    gconf_client_suggest_sync(GCONF_CLIENT(self->obj), &err);
    
    if (pyg_error_check(&err))
        return NULL;
    Py_INCREF(Py_None);
    return Py_None;
}

static PyObject *
_wrap_gconf_client_dir_exists(PyGObject *self, PyObject *args, PyObject *kwargs)
{
    static char *kwlist[] = { "dir", NULL };
    char *dir;
    int ret;
    GError *err = NULL;

    if (!PyArg_ParseTupleAndKeywords(args, kwargs,"s:GConf.Client.dir_exists", kwlist, &dir))
        return NULL;
    
    ret = gconf_client_dir_exists(GCONF_CLIENT(self->obj), dir, &err);
    
    if (pyg_error_check(&err))
        return NULL;
    return PyBool_FromLong(ret);

}

static PyObject *
_wrap_gconf_client_key_is_writable(PyGObject *self, PyObject *args, PyObject *kwargs)
{
    static char *kwlist[] = { "key", NULL };
    char *key;
    int ret;
    GError *err = NULL;

    if (!PyArg_ParseTupleAndKeywords(args, kwargs,"s:GConf.Client.key_is_writable", kwlist, &key))
        return NULL;
    
    ret = gconf_client_key_is_writable(GCONF_CLIENT(self->obj), key, &err);
    
    if (pyg_error_check(&err))
        return NULL;
    return PyBool_FromLong(ret);

}

static PyObject *
_wrap_gconf_client_get_float(PyGObject *self, PyObject *args, PyObject *kwargs)
{
    static char *kwlist[] = { "key", NULL };
    char *key;
    double ret;
    GError *err = NULL;

    if (!PyArg_ParseTupleAndKeywords(args, kwargs,"s:GConf.Client.get_float", kwlist, &key))
        return NULL;
    
    ret = gconf_client_get_float(GCONF_CLIENT(self->obj), key, &err);
    
    if (pyg_error_check(&err))
        return NULL;
    return PyFloat_FromDouble(ret);
}

static PyObject *
_wrap_gconf_client_get_int(PyGObject *self, PyObject *args, PyObject *kwargs)
{
    static char *kwlist[] = { "key", NULL };
    char *key;
    int ret;
    GError *err = NULL;

    if (!PyArg_ParseTupleAndKeywords(args, kwargs,"s:GConf.Client.get_int", kwlist, &key))
        return NULL;
    
    ret = gconf_client_get_int(GCONF_CLIENT(self->obj), key, &err);
    
    if (pyg_error_check(&err))
        return NULL;
    return PyInt_FromLong(ret);
}

static PyObject *
_wrap_gconf_client_get_string(PyGObject *self, PyObject *args, PyObject *kwargs)
{
    static char *kwlist[] = { "key", NULL };
    char *key;
    gchar *ret;
    GError *err = NULL;

    if (!PyArg_ParseTupleAndKeywords(args, kwargs,"s:GConf.Client.get_string", kwlist, &key))
        return NULL;
    
    ret = gconf_client_get_string(GCONF_CLIENT(self->obj), key, &err);
    
    if (pyg_error_check(&err))
        return NULL;
    if (ret) {
        PyObject *py_ret = PyString_FromString(ret);
        g_free(ret);
        return py_ret;
    }
    Py_INCREF(Py_None);
    return Py_None;
}

static PyObject *
_wrap_gconf_client_get_bool(PyGObject *self, PyObject *args, PyObject *kwargs)
{
    static char *kwlist[] = { "key", NULL };
    char *key;
    int ret;
    GError *err = NULL;

    if (!PyArg_ParseTupleAndKeywords(args, kwargs,"s:GConf.Client.get_bool", kwlist, &key))
        return NULL;
    
    ret = gconf_client_get_bool(GCONF_CLIENT(self->obj), key, &err);
    
    if (pyg_error_check(&err))
        return NULL;
    return PyBool_FromLong(ret);

}

static PyObject *
_wrap_gconf_client_get_schema(PyGObject *self, PyObject *args, PyObject *kwargs)
{
    static char *kwlist[] = { "key", NULL };
    char *key;
    GConfSchema *ret;
    GError *err = NULL;

    if (!PyArg_ParseTupleAndKeywords(args, kwargs,"s:GConf.Client.get_schema", kwlist, &key))
        return NULL;
    
    ret = gconf_client_get_schema(GCONF_CLIENT(self->obj), key, &err);
    
    if (pyg_error_check(&err))
        return NULL;
    /* pyg_boxed_new handles NULL checking */
    return pyg_boxed_new(GCONF_TYPE_SCHEMA, ret, FALSE, TRUE);
}

#line 424 "gconf.override"
    static PyObject *
pygconf_parse_listvalue(GConfValueType gvalue_type, gpointer retloc)
{
    PyObject *retval;
    switch(gvalue_type) {
	case GCONF_VALUE_INT:
	case GCONF_VALUE_BOOL:
	    retval = PyInt_FromLong(GPOINTER_TO_INT(retloc));
	    break;
	case GCONF_VALUE_FLOAT:
	    retval = PyFloat_FromDouble(*(gdouble*)retloc);
	    break;
	case GCONF_VALUE_STRING:
	    retval = PyString_FromString((gchar*)retloc);
	    break;
	case GCONF_VALUE_SCHEMA:
	    retval = pyg_boxed_new(GCONF_TYPE_SCHEMA, (GConfSchema*)retloc, 
		    TRUE, TRUE);
	    break;
	default:
	    /* Should not reach here. get_list should always valid. */
	    PyErr_SetString(PyExc_TypeError, "Unknown GConfValueType.");
	    retval = NULL;
	    break;
    }
    return retval;
}

static PyObject *
_wrap_gconf_client_get_list(PyGObject *self, PyObject *args, PyObject *kwargs)
{
    static char *kwlist[] = { "key", "list_type", NULL };
    char *key;
    PyObject *py_type = NULL;
    PyObject *py_list = NULL;
    GConfValueType lstype;
    GSList *retlist, *ilist;
    gpointer data;
    int lslen, i;

    GError *err = NULL;

    if (!PyArg_ParseTupleAndKeywords(args, kwargs, "sO:GConfClient.get_list",
		kwlist, &key, &py_type))
	return NULL;

    if (pyg_enum_get_value(GCONF_TYPE_VALUE_TYPE, py_type, (gint *)&lstype))
	return NULL;
    
    retlist = gconf_client_get_list(GCONF_CLIENT(self->obj), key,
				    lstype, &err);
    if (pyg_error_check(&err)) {
	return NULL;
    } else if (retlist == NULL) {
	return PyList_New(0);
    }
    
    lslen = g_slist_length(retlist);
    i = 0;
    py_list = PyList_New(lslen);
    for (ilist = retlist; ilist; ilist = ilist->next) {
	PyObject *py_data;
	data = ilist->data;
	py_data = pygconf_parse_listvalue(lstype, data);
	if (!py_data) {
	    g_slist_free(retlist);
	    return NULL;
	}
	PyList_SetItem(py_list, i, py_data);
	i++;
	if (lstype == GCONF_VALUE_SCHEMA)
	    gconf_schema_free(data);
	else if(lstype == GCONF_VALUE_FLOAT || lstype == GCONF_VALUE_STRING)
	    g_free(data);
    }
    g_slist_free(retlist);
    return py_list;
}

#line 2540 "gconf.c"


#line 207 "gconf.override"
/* Return a proper PyObject for retloc based on its type. */
static PyObject *
pygconf_parse_gvalue(GConfValueType gvalue_type, gpointer retloc)
{
    PyObject *retval;
    switch(gvalue_type) {
	case GCONF_VALUE_INT:
	case GCONF_VALUE_BOOL:
	    retval = PyInt_FromLong(*(gint*)retloc);
	    break;
	case GCONF_VALUE_FLOAT:
	    retval = PyFloat_FromDouble(*(gdouble*)retloc);
	    break;
	case GCONF_VALUE_STRING:
        {
            gchar **s = (gchar **) retloc;
            if (*s)
                retval = PyString_FromString(*s);
            else {
                Py_INCREF(Py_None);
                return Py_None;
            }
	    break;
        }
	case GCONF_VALUE_SCHEMA:
	    retval = pyg_boxed_new(GCONF_TYPE_SCHEMA, *(GConfSchema**)retloc, 
		    TRUE, TRUE);
	    break;
	default:
	    PyErr_SetString(PyExc_TypeError, "Unknown GConfValueType.");
	    retval = NULL;
	    break;
    }
    return retval;
}

/* Get the value of a PyObject from its type. */
/* g_new0() on returned pointer, need to free it. */
static gpointer
pygconf_parse_pygvalue(GConfValueType gvalue_type, PyObject *pyvalue)
{
    gpointer retval;
    retval = g_new0(gpointer, 1);
    switch(gvalue_type) {
	case GCONF_VALUE_INT:
	case GCONF_VALUE_BOOL:
	    *(gint*)retval = (gint) PyInt_AsLong(pyvalue);
	    break;
	case GCONF_VALUE_FLOAT:
	    *(gdouble*)retval = PyFloat_AsDouble(pyvalue);
	    break;
	case GCONF_VALUE_STRING:
	    if (!PyString_Check(pyvalue)) {
		PyErr_SetString(PyExc_TypeError,
				"value should be a string");
		g_free(retval);
		return NULL;
	    }
	    *(gchar**)retval = PyString_AsString(pyvalue);
	    break;
	case GCONF_VALUE_SCHEMA:
	    if (pyg_boxed_check(pyvalue, GCONF_TYPE_SCHEMA)) {
		*(GConfSchema**)retval = pyg_boxed_get(pyvalue, GConfSchema);
	    } else {
		PyErr_SetString(PyExc_TypeError,
				"value should be a GConfSchema");
		free(retval);
		retval = NULL;
	    }
	    break;
	default:
	    PyErr_SetString(PyExc_TypeError, "Unknown GConfValueType.");
	    free(retval);
	    retval = NULL;
	    break;
    }
    return retval;
}

static gpointer
pygconf_new_type(GConfValueType t)
{
    gpointer retval;
    switch(t) {
	case GCONF_VALUE_INT:
	case GCONF_VALUE_BOOL:
	    retval = g_new0(gint, 1);
	    break;
	case GCONF_VALUE_FLOAT:
	    retval = g_new0(gdouble, 1);
	    break;
	case GCONF_VALUE_STRING:
	    retval = g_new0(gchar, 1);
	    break;
	case GCONF_VALUE_SCHEMA:
	    retval = gconf_schema_new(); 
	    break;
	default:
	    PyErr_SetString(PyExc_TypeError, "Unknown GConfValueType.");
	    retval = NULL;
	    break;
    }
    return retval;
}

static PyObject *
_wrap_gconf_client_get_pair(PyGObject *self, PyObject *args, PyObject *kwargs)
{
    static char *kwlist[] = { "key", "car_type", "cdr_type", NULL };
    char *key;
    PyObject *pycar_type = NULL, *pycdr_type = NULL;
    PyObject *retcar = NULL, *retcdr = NULL;
    GConfValueType car_type, cdr_type;
    gpointer car_retloc = NULL;
    gpointer cdr_retloc = NULL;
    int ret;

    GError *err = NULL;

    if (!PyArg_ParseTupleAndKeywords(args, kwargs, "sOO:GConfClient.get_pair",
		kwlist, &key, &pycar_type, &pycdr_type))
	return NULL;

    if (pyg_enum_get_value(GCONF_TYPE_VALUE_TYPE,
			   pycar_type, (gint *)&car_type))
	return NULL;
    if (pyg_enum_get_value(GCONF_TYPE_VALUE_TYPE,
			   pycdr_type, (gint *)&cdr_type))
	return NULL;
    
    car_retloc = pygconf_new_type(car_type);
    if (!car_retloc) 
	return NULL;
    cdr_retloc = pygconf_new_type(cdr_type);
    if (!cdr_retloc) {
	if(car_type == GCONF_VALUE_SCHEMA)
	    gconf_schema_free(car_retloc);
	else 
	    g_free(car_retloc);
	return NULL;
    }
	    
    ret = gconf_client_get_pair(GCONF_CLIENT(self->obj), key, car_type, 
	    cdr_type, car_retloc, cdr_retloc, &err);
    if (pyg_error_check(&err))
	return NULL;
    retcar = pygconf_parse_gvalue(car_type, car_retloc);
    retcdr = pygconf_parse_gvalue(cdr_type, cdr_retloc);

    if (car_type != GCONF_VALUE_SCHEMA)
	g_free(car_retloc);
    /* FIXME: gconf_schema_free(car_retloc)? */
    else
	gconf_schema_free(car_retloc);

    if (cdr_type != GCONF_VALUE_SCHEMA)
	g_free(cdr_retloc);
    else
	gconf_schema_free(cdr_retloc);

    if (!retcar || !retcdr)
	return NULL;
    return Py_BuildValue("(NN)", retcar, retcdr);
}

#line 2709 "gconf.c"


static PyObject *
_wrap_gconf_client_set_float(PyGObject *self, PyObject *args, PyObject *kwargs)
{
    static char *kwlist[] = { "key", "val", NULL };
    char *key;
    double val;
    int ret;
    GError *err = NULL;

    if (!PyArg_ParseTupleAndKeywords(args, kwargs,"sd:GConf.Client.set_float", kwlist, &key, &val))
        return NULL;
    
    ret = gconf_client_set_float(GCONF_CLIENT(self->obj), key, val, &err);
    
    if (pyg_error_check(&err))
        return NULL;
    return PyBool_FromLong(ret);

}

static PyObject *
_wrap_gconf_client_set_int(PyGObject *self, PyObject *args, PyObject *kwargs)
{
    static char *kwlist[] = { "key", "val", NULL };
    char *key;
    int val, ret;
    GError *err = NULL;

    if (!PyArg_ParseTupleAndKeywords(args, kwargs,"si:GConf.Client.set_int", kwlist, &key, &val))
        return NULL;
    
    ret = gconf_client_set_int(GCONF_CLIENT(self->obj), key, val, &err);
    
    if (pyg_error_check(&err))
        return NULL;
    return PyBool_FromLong(ret);

}

static PyObject *
_wrap_gconf_client_set_string(PyGObject *self, PyObject *args, PyObject *kwargs)
{
    static char *kwlist[] = { "key", "val", NULL };
    char *key, *val;
    int ret;
    GError *err = NULL;

    if (!PyArg_ParseTupleAndKeywords(args, kwargs,"ss:GConf.Client.set_string", kwlist, &key, &val))
        return NULL;
    
    ret = gconf_client_set_string(GCONF_CLIENT(self->obj), key, val, &err);
    
    if (pyg_error_check(&err))
        return NULL;
    return PyBool_FromLong(ret);

}

static PyObject *
_wrap_gconf_client_set_bool(PyGObject *self, PyObject *args, PyObject *kwargs)
{
    static char *kwlist[] = { "key", "val", NULL };
    char *key;
    int val, ret;
    GError *err = NULL;

    if (!PyArg_ParseTupleAndKeywords(args, kwargs,"si:GConf.Client.set_bool", kwlist, &key, &val))
        return NULL;
    
    ret = gconf_client_set_bool(GCONF_CLIENT(self->obj), key, val, &err);
    
    if (pyg_error_check(&err))
        return NULL;
    return PyBool_FromLong(ret);

}

static PyObject *
_wrap_gconf_client_set_schema(PyGObject *self, PyObject *args, PyObject *kwargs)
{
    static char *kwlist[] = { "key", "val", NULL };
    char *key;
    PyObject *py_val;
    int ret;
    GConfSchema *val = NULL;
    GError *err = NULL;

    if (!PyArg_ParseTupleAndKeywords(args, kwargs,"sO:GConf.Client.set_schema", kwlist, &key, &py_val))
        return NULL;
    if (pyg_boxed_check(py_val, GCONF_TYPE_SCHEMA))
        val = pyg_boxed_get(py_val, GConfSchema);
    else {
        PyErr_SetString(PyExc_TypeError, "val should be a GConfSchema");
        return NULL;
    }
    
    ret = gconf_client_set_schema(GCONF_CLIENT(self->obj), key, val, &err);
    
    if (pyg_error_check(&err))
        return NULL;
    return PyBool_FromLong(ret);

}

#line 505 "gconf.override"
static PyObject *
_wrap_gconf_client_set_list(PyGObject *self, PyObject *args, PyObject *kwargs)
{
    static char *kwlist[] = { "key", "list_type", "list", NULL };
    char *key;
    PyObject *py_type = NULL;
    PyObject *py_list = NULL;
    GSList *clist = NULL;
    GSList *tmplist, *pointlist=NULL;
    GConfValueType list_type;
    int ret, i;
    int retdata; /* Error flag. */
    GError *err = NULL;

    ret = 1;
    retdata = 1;

    if (!PyArg_ParseTupleAndKeywords(args, kwargs, "sOO:GConfClient.set_list",
		kwlist, &key, &py_type, &py_list))
	return NULL;
    if (!PyTuple_Check(py_list) && !PyList_Check(py_list)) {
	PyErr_SetString(PyExc_TypeError,
			"3rd argument should be a sequence type.");
	return NULL;
    }

    if (pyg_enum_get_value(GCONF_TYPE_VALUE_TYPE, py_type, (gint *)&list_type))
	return NULL;
    
    for (i = 0; i < PySequence_Size(py_list) && retdata; i++) {
	gpointer data;
	PyObject *item = PySequence_GetItem(py_list, i);
	data = pygconf_parse_pygvalue(list_type, item);
	Py_XDECREF(item);
	if (data == NULL) {
	    retdata = 0;
	    break;
	}
	/* What to free the list later. */
	pointlist = g_slist_append(pointlist, data);
	switch(list_type){
	    case GCONF_VALUE_INT:
	    case GCONF_VALUE_BOOL:
		clist = g_slist_append(clist, GINT_TO_POINTER(*(gint*)data));
		break;
	    case GCONF_VALUE_FLOAT:
		clist = g_slist_append(clist, (gdouble*)data);
		break;
	    case GCONF_VALUE_STRING:
		clist = g_slist_append(clist, *(gchar**)data);
		break;
	    case GCONF_VALUE_SCHEMA:
		clist = g_slist_append(clist, *(GConfSchema**)data);
		break;
	    default:
		PyErr_SetString(PyExc_TypeError, "Unknown GConfValueType.");
		retdata = 0;
		break;
	}
    }

    if (retdata)
	ret = gconf_client_set_list(GCONF_CLIENT(self->obj), key, list_type,
	    clist, &err);

    for (tmplist = pointlist; tmplist; tmplist = tmplist->next) {
	g_free(tmplist->data);
    }
    g_slist_free(pointlist);
    g_slist_free(clist);

    if (pyg_error_check(&err) || !retdata)
	return NULL;
    return PyInt_FromLong(ret);
}

#line 2893 "gconf.c"


#line 374 "gconf.override"
static PyObject *
_wrap_gconf_client_set_pair(PyGObject *self, PyObject *args, PyObject *kwargs)
{
    static char *kwlist[] = { "key", "car_type", "cdr_type",
			      "car", "cdr",  NULL };
    char *key;
    PyObject *pycar_type = NULL, *pycdr_type = NULL;
    PyObject *pycar = NULL, *pycdr = NULL;

    GConfValueType car_type, cdr_type;
    gpointer car, cdr;
    int ret;
    GError *err = NULL;

    if (!PyArg_ParseTupleAndKeywords(args, kwargs,
				     "sOOOO:GConfClient.set_pair",
				     kwlist, &key, &pycar_type, &pycdr_type,
				     &pycar, &pycdr))
	return NULL;

    if (pyg_enum_get_value(GCONF_TYPE_VALUE_TYPE,
			   pycar_type, (gint *)&car_type))
	return NULL;
    if (pyg_enum_get_value(GCONF_TYPE_VALUE_TYPE,
			   pycdr_type, (gint *)&cdr_type))
	return NULL;
    car = pygconf_parse_pygvalue(car_type, pycar);
    if (!car) 
    	return NULL;
    cdr = pygconf_parse_pygvalue(cdr_type, pycdr);
    if (!cdr) {
	g_free(car);
	return NULL;
    }
	

    ret = gconf_client_set_pair(GCONF_CLIENT(self->obj),
				key, car_type, cdr_type,
				car, cdr, &err);

    g_free(car);
    g_free(cdr);

    if (pyg_error_check(&err))
	return NULL;
    return PyInt_FromLong(ret);
}

#line 2945 "gconf.c"


static PyObject *
_wrap_gconf_client_value_changed(PyGObject *self, PyObject *args, PyObject *kwargs)
{
    static char *kwlist[] = { "key", "value", NULL };
    char *key;
    PyObject *py_value;
    GConfValue *value = NULL;

    if (!PyArg_ParseTupleAndKeywords(args, kwargs,"sO:GConf.Client.value_changed", kwlist, &key, &py_value))
        return NULL;
    if (pyg_boxed_check(py_value, GCONF_TYPE_VALUE))
        value = pyg_boxed_get(py_value, GConfValue);
    else {
        PyErr_SetString(PyExc_TypeError, "value should be a GConfValue");
        return NULL;
    }
    
    gconf_client_value_changed(GCONF_CLIENT(self->obj), key, value);
    
    Py_INCREF(Py_None);
    return Py_None;
}

static PyObject *
_wrap_gconf_client_commit_change_set(PyGObject *self, PyObject *args, PyObject *kwargs)
{
    static char *kwlist[] = { "cs", "remove_committed", NULL };
    PyObject *py_cs;
    int remove_committed, ret;
    GConfChangeSet *cs = NULL;
    GError *err = NULL;

    if (!PyArg_ParseTupleAndKeywords(args, kwargs,"Oi:GConf.Client.commit_change_set", kwlist, &py_cs, &remove_committed))
        return NULL;
    if (pyg_boxed_check(py_cs, GCONF_TYPE_CHANGE_SET))
        cs = pyg_boxed_get(py_cs, GConfChangeSet);
    else {
        PyErr_SetString(PyExc_TypeError, "cs should be a GConfChangeSet");
        return NULL;
    }
    
    ret = gconf_client_commit_change_set(GCONF_CLIENT(self->obj), cs, remove_committed, &err);
    
    if (pyg_error_check(&err))
        return NULL;
    return PyBool_FromLong(ret);

}

static PyObject *
_wrap_gconf_client_reverse_change_set(PyGObject *self, PyObject *args, PyObject *kwargs)
{
    static char *kwlist[] = { "cs", NULL };
    PyObject *py_cs;
    GConfChangeSet *cs = NULL, *ret;
    GError *err = NULL;

    if (!PyArg_ParseTupleAndKeywords(args, kwargs,"O:GConf.Client.reverse_change_set", kwlist, &py_cs))
        return NULL;
    if (pyg_boxed_check(py_cs, GCONF_TYPE_CHANGE_SET))
        cs = pyg_boxed_get(py_cs, GConfChangeSet);
    else {
        PyErr_SetString(PyExc_TypeError, "cs should be a GConfChangeSet");
        return NULL;
    }
    
    ret = gconf_client_reverse_change_set(GCONF_CLIENT(self->obj), cs, &err);
    
    if (pyg_error_check(&err))
        return NULL;
    /* pyg_boxed_new handles NULL checking */
    return pyg_boxed_new(GCONF_TYPE_CHANGE_SET, ret, TRUE, TRUE);
}

#line 736 "gconf.override"
static PyObject *
_wrap_gconf_client_change_set_from_current(PyGObject *self, PyObject *args, PyObject *kwargs)
{
    static char *kwlist[] = { "keys", NULL };
    PyObject *py_list;
    const gchar **keys;
    GError *err = NULL;
    GConfChangeSet *ret;
    int len, i;

    if (!PyArg_ParseTupleAndKeywords(args, kwargs, "O!:GConfClient.change_set_from_current",
                                     kwlist, &PyList_Type, &py_list))
        return NULL;
    len = PyList_Size(py_list);
    keys = g_new(const gchar *, len + 1);
    for (i = 0; i < len; ++i) {
        PyObject *item = PyList_GET_ITEM(py_list, i);
        if (!PyString_Check(item)) {
            g_free(keys);
            PyErr_SetString(PyExc_TypeError, "list elements must be of type str");
            return NULL;
        }
        keys[i] = PyString_AsString(item);
    }
    keys[i] = NULL;
    ret = gconf_client_change_set_from_currentv(GCONF_CLIENT(self->obj), keys, &err);
    g_free(keys);
    if (pyg_error_check(&err))
        return NULL;
    /* pyg_boxed_new handles NULL checking */
    return pyg_boxed_new(GCONF_TYPE_CHANGE_SET, ret, TRUE, TRUE);
}
#line 3055 "gconf.c"


#line 805 "gconf.override"

static PyObject *
_wrap_g_conf_client_get_value(PyGObject *self, PyObject *args, PyObject *kwargs)
{
    static char *kwlist[] = { "key", NULL };
    char *key;
    GError *err = NULL;
    GConfValue *value;
    PyObject *py_ret;

    if (!PyArg_ParseTupleAndKeywords(args, kwargs,"s:GConfClient.get_value", kwlist, &key))
        return NULL;
    
    value = gconf_client_get(GCONF_CLIENT(self->obj), key, &err);
    
    if (pyg_error_check(&err))
        return NULL;

    if (value == NULL) {
        PyErr_Format(PyExc_ValueError, "gconf key %s has no value", key);
        return NULL;
    }

    switch (value->type)
    {
    case GCONF_VALUE_INVALID:
        PyErr_SetString(PyExc_TypeError, "invalid value");
        py_ret = NULL;
        break;

    case GCONF_VALUE_STRING:
        py_ret = PyString_FromString(gconf_value_get_string(value));
        break;
    case GCONF_VALUE_INT:
        py_ret = PyInt_FromLong(gconf_value_get_int(value));
        break;
    case GCONF_VALUE_FLOAT:
        py_ret = PyFloat_FromDouble(gconf_value_get_float(value));
        break;
    case GCONF_VALUE_BOOL:
        py_ret = PyBool_FromLong(gconf_value_get_bool(value));
        break;

    case GCONF_VALUE_SCHEMA:
    case GCONF_VALUE_LIST:
    case GCONF_VALUE_PAIR:
        PyErr_SetString(PyExc_TypeError, "value type not supported yet by this API");
        py_ret = NULL;
        break;
    default:
        py_ret = NULL;
    }
    gconf_value_free(value);
    return py_ret;
}

#line 3115 "gconf.c"


#line 863 "gconf.override"

static PyObject *
_wrap_g_conf_client_set_value(PyGObject *self, PyObject *args, PyObject *kwargs)
{
    static char *kwlist[] = { "key", "val", NULL };
    char *key;
    PyObject *py_val;
    GError *err = NULL;

    if (!PyArg_ParseTupleAndKeywords(args, kwargs,"sO:GConfClient.set_value", kwlist, &key, &py_val))
        return NULL;
    if (pyg_boxed_check(py_val, GCONF_TYPE_VALUE)) {
        gconf_client_set(GCONF_CLIENT(self->obj), key, pyg_boxed_get(py_val, GConfValue), &err);
        if (pyg_error_check(&err))
            return NULL;
    } else {
        if (PyBool_Check(py_val)) {
            gconf_client_set_bool(GCONF_CLIENT(self->obj), key, PyInt_AsLong(py_val), &err);
        } else if (PyInt_Check(py_val)) {
            gconf_client_set_int(GCONF_CLIENT(self->obj), key, PyInt_AsLong(py_val), &err);
        } else if (PyFloat_Check(py_val)) {
            gconf_client_set_float(GCONF_CLIENT(self->obj), key, PyFloat_AsDouble(py_val), &err);
        } else if (PyString_Check(py_val)) {
            gconf_client_set_string(GCONF_CLIENT(self->obj), key, PyString_AsString(py_val), &err);
        } else if (PyUnicode_Check(py_val)) {
            PyObject *utf8_tmp = PyUnicode_AsUTF8String(py_val);
            if (!utf8_tmp)
                return NULL;
            gconf_client_set_string(GCONF_CLIENT(self->obj), key, PyString_AsString(utf8_tmp), &err);
            Py_DECREF(utf8_tmp);
        } else {
            PyErr_SetString(PyExc_TypeError, "value type not supported yet by this API");
            return NULL;
        }
        if (pyg_error_check(&err))
            return NULL;
    }
    
    Py_INCREF(Py_None);
    return Py_None;
}

#line 3161 "gconf.c"


static const PyMethodDef _PyGConfClient_methods[] = {
    { "add_dir", (PyCFunction)_wrap_gconf_client_add_dir, METH_VARARGS|METH_KEYWORDS,
      NULL },
    { "remove_dir", (PyCFunction)_wrap_gconf_client_remove_dir, METH_VARARGS|METH_KEYWORDS,
      NULL },
    { "notify_add", (PyCFunction)_wrap_gconf_client_notify_add, METH_VARARGS|METH_KEYWORDS,
      NULL },
    { "notify_remove", (PyCFunction)_wrap_gconf_client_notify_remove, METH_VARARGS|METH_KEYWORDS,
      NULL },
    { "notify", (PyCFunction)_wrap_gconf_client_notify, METH_VARARGS|METH_KEYWORDS,
      NULL },
    { "set_error_handling", (PyCFunction)_wrap_gconf_client_set_error_handling, METH_VARARGS|METH_KEYWORDS,
      NULL },
    { "clear_cache", (PyCFunction)_wrap_gconf_client_clear_cache, METH_NOARGS,
      NULL },
    { "preload", (PyCFunction)_wrap_gconf_client_preload, METH_VARARGS|METH_KEYWORDS,
      NULL },
    { "set", (PyCFunction)_wrap_gconf_client_set, METH_VARARGS|METH_KEYWORDS,
      NULL },
    { "get", (PyCFunction)_wrap_gconf_client_get, METH_VARARGS|METH_KEYWORDS,
      NULL },
    { "get_without_default", (PyCFunction)_wrap_gconf_client_get_without_default, METH_VARARGS|METH_KEYWORDS,
      NULL },
    { "get_entry", (PyCFunction)_wrap_gconf_client_get_entry, METH_VARARGS|METH_KEYWORDS,
      NULL },
    { "get_default_from_schema", (PyCFunction)_wrap_gconf_client_get_default_from_schema, METH_VARARGS|METH_KEYWORDS,
      NULL },
    { "unset", (PyCFunction)_wrap_gconf_client_unset, METH_VARARGS|METH_KEYWORDS,
      NULL },
    { "recursive_unset", (PyCFunction)_wrap_gconf_client_recursive_unset, METH_VARARGS|METH_KEYWORDS,
      NULL },
    { "all_entries", (PyCFunction)_wrap_gconf_client_all_entries, METH_VARARGS,
      NULL },
    { "all_dirs", (PyCFunction)_wrap_gconf_client_all_dirs, METH_VARARGS,
      NULL },
    { "suggest_sync", (PyCFunction)_wrap_gconf_client_suggest_sync, METH_NOARGS,
      NULL },
    { "dir_exists", (PyCFunction)_wrap_gconf_client_dir_exists, METH_VARARGS|METH_KEYWORDS,
      NULL },
    { "key_is_writable", (PyCFunction)_wrap_gconf_client_key_is_writable, METH_VARARGS|METH_KEYWORDS,
      NULL },
    { "get_float", (PyCFunction)_wrap_gconf_client_get_float, METH_VARARGS|METH_KEYWORDS,
      NULL },
    { "get_int", (PyCFunction)_wrap_gconf_client_get_int, METH_VARARGS|METH_KEYWORDS,
      NULL },
    { "get_string", (PyCFunction)_wrap_gconf_client_get_string, METH_VARARGS|METH_KEYWORDS,
      NULL },
    { "get_bool", (PyCFunction)_wrap_gconf_client_get_bool, METH_VARARGS|METH_KEYWORDS,
      NULL },
    { "get_schema", (PyCFunction)_wrap_gconf_client_get_schema, METH_VARARGS|METH_KEYWORDS,
      NULL },
    { "get_list", (PyCFunction)_wrap_gconf_client_get_list, METH_VARARGS|METH_KEYWORDS,
      NULL },
    { "get_pair", (PyCFunction)_wrap_gconf_client_get_pair, METH_VARARGS|METH_KEYWORDS,
      NULL },
    { "set_float", (PyCFunction)_wrap_gconf_client_set_float, METH_VARARGS|METH_KEYWORDS,
      NULL },
    { "set_int", (PyCFunction)_wrap_gconf_client_set_int, METH_VARARGS|METH_KEYWORDS,
      NULL },
    { "set_string", (PyCFunction)_wrap_gconf_client_set_string, METH_VARARGS|METH_KEYWORDS,
      NULL },
    { "set_bool", (PyCFunction)_wrap_gconf_client_set_bool, METH_VARARGS|METH_KEYWORDS,
      NULL },
    { "set_schema", (PyCFunction)_wrap_gconf_client_set_schema, METH_VARARGS|METH_KEYWORDS,
      NULL },
    { "set_list", (PyCFunction)_wrap_gconf_client_set_list, METH_VARARGS|METH_KEYWORDS,
      NULL },
    { "set_pair", (PyCFunction)_wrap_gconf_client_set_pair, METH_VARARGS|METH_KEYWORDS,
      NULL },
    { "value_changed", (PyCFunction)_wrap_gconf_client_value_changed, METH_VARARGS|METH_KEYWORDS,
      NULL },
    { "commit_change_set", (PyCFunction)_wrap_gconf_client_commit_change_set, METH_VARARGS|METH_KEYWORDS,
      NULL },
    { "reverse_change_set", (PyCFunction)_wrap_gconf_client_reverse_change_set, METH_VARARGS|METH_KEYWORDS,
      NULL },
    { "change_set_from_current", (PyCFunction)_wrap_gconf_client_change_set_from_current, METH_VARARGS,
      NULL },
    { "get_value", (PyCFunction)_wrap_g_conf_client_get_value, METH_VARARGS|METH_KEYWORDS,
      NULL },
    { "set_value", (PyCFunction)_wrap_g_conf_client_set_value, METH_VARARGS|METH_KEYWORDS,
      NULL },
    { NULL, NULL, 0, NULL }
};

#line 41 "gconf.override"

static int
_wrap_gconf_client_tp_init(PyGObject *self, PyObject *args, PyObject *kwargs)
{
    static char *kwlist[] = { NULL };

    if (!PyArg_ParseTupleAndKeywords(args, kwargs, ":gconf.Client.__init__", kwlist)) {
        return -1;
    }
    self->obj = (GObject *) gconf_client_get_default();
    pygobject_register_wrapper((PyObject *)self);
    return 0;
}

#line 3263 "gconf.c"


PyTypeObject G_GNUC_INTERNAL PyGConfClient_Type = {
    PyObject_HEAD_INIT(NULL)
    0,                                 /* ob_size */
    "gconf.Client",                   /* tp_name */
    sizeof(PyGObject),          /* tp_basicsize */
    0,                                 /* tp_itemsize */
    /* methods */
    (destructor)0,        /* tp_dealloc */
    (printfunc)0,                      /* tp_print */
    (getattrfunc)0,       /* tp_getattr */
    (setattrfunc)0,       /* tp_setattr */
    (cmpfunc)0,           /* tp_compare */
    (reprfunc)0,             /* tp_repr */
    (PyNumberMethods*)0,     /* tp_as_number */
    (PySequenceMethods*)0, /* tp_as_sequence */
    (PyMappingMethods*)0,   /* tp_as_mapping */
    (hashfunc)0,             /* tp_hash */
    (ternaryfunc)0,          /* tp_call */
    (reprfunc)0,              /* tp_str */
    (getattrofunc)0,     /* tp_getattro */
    (setattrofunc)0,     /* tp_setattro */
    (PyBufferProcs*)0,  /* tp_as_buffer */
    Py_TPFLAGS_DEFAULT | Py_TPFLAGS_BASETYPE,                      /* tp_flags */
    NULL,                        /* Documentation string */
    (traverseproc)0,     /* tp_traverse */
    (inquiry)0,             /* tp_clear */
    (richcmpfunc)0,   /* tp_richcompare */
    offsetof(PyGObject, weakreflist),             /* tp_weaklistoffset */
    (getiterfunc)0,          /* tp_iter */
    (iternextfunc)0,     /* tp_iternext */
    (struct PyMethodDef*)_PyGConfClient_methods, /* tp_methods */
    (struct PyMemberDef*)0,              /* tp_members */
    (struct PyGetSetDef*)0,  /* tp_getset */
    NULL,                              /* tp_base */
    NULL,                              /* tp_dict */
    (descrgetfunc)0,    /* tp_descr_get */
    (descrsetfunc)0,    /* tp_descr_set */
    offsetof(PyGObject, inst_dict),                 /* tp_dictoffset */
    (initproc)_wrap_gconf_client_tp_init,             /* tp_init */
    (allocfunc)0,           /* tp_alloc */
    (newfunc)0,               /* tp_new */
    (freefunc)0,             /* tp_free */
    (inquiry)0              /* tp_is_gc */
};



/* ----------- functions ----------- */

static PyObject *
_wrap_gconf_client_get_default(PyObject *self)
{
    PyObject *py_ret;
    GConfClient *ret;

    
    ret = gconf_client_get_default();
    
    py_ret = pygobject_new((GObject *)ret);
    if (ret != NULL)
        g_object_unref(ret);
    return py_ret;
}

static PyObject *
_wrap_gconf_client_get_for_engine(PyObject *self, PyObject *args, PyObject *kwargs)
{
    static char *kwlist[] = { "engine", NULL };
    PyObject *py_engine = NULL, *py_ret;
    GConfClient *ret;
    GConfEngine* engine;

    if (!PyArg_ParseTupleAndKeywords(args, kwargs,"O:client_get_for_engine", kwlist, &py_engine))
        return NULL;
    engine = pygconf_engine_from_pyobject (py_engine);
    if (PyErr_Occurred ())
        return NULL;
    
    ret = gconf_client_get_for_engine(engine);
    
    py_ret = pygobject_new((GObject *)ret);
    if (ret != NULL)
        g_object_unref(ret);
    return py_ret;
}

static PyObject *
_wrap_gconf_engine_get_default(PyObject *self)
{
    GConfEngine *ret;

    
    ret = gconf_engine_get_default();
    
    /* pygconf_engine_new() handles NULL checking */
    return pygconf_engine_new (ret);
}

static PyObject *
_wrap_gconf_engine_get_for_address(PyObject *self, PyObject *args, PyObject *kwargs)
{
    static char *kwlist[] = { "address", NULL };
    char *address;
    GConfEngine *ret;
    GError *err = NULL;
    PyObject *py_ret;

    if (!PyArg_ParseTupleAndKeywords(args, kwargs,"s:engine_get_for_address", kwlist, &address))
        return NULL;
    
    ret = gconf_engine_get_for_address(address, &err);
    
    if (pyg_error_check(&err))
        return NULL;
    py_ret = pygconf_engine_new (ret);
    if (ret != NULL)
        gconf_engine_unref (ret);
    return py_ret;
}

#line 907 "gconf.override"
static PyObject *
_wrap_gconf_value_new_from_string(PyObject *self, PyObject *args, PyObject *kwargs)
{
    static char *kwlist[] = { "type", "str", NULL };
    PyObject *py_type = NULL;
    char *str;
    GConfValueType type;
    GError *err = NULL;
    GConfValue *ret;

    if (!PyArg_ParseTupleAndKeywords(args, kwargs, "Os:value_new_from_string", kwlist, &py_type, &str))
        return NULL;
    if (pyg_enum_get_value(GCONF_TYPE_VALUE_TYPE, py_type, (gpointer)&type))
        return NULL;

    if (type == GCONF_VALUE_LIST || type == GCONF_VALUE_PAIR) {
        PyErr_SetString(PyExc_ValueError, "GConf value types LIST and PAIR are not valid for this function");
        return NULL;
    }
    
    ret = gconf_value_new_from_string(type, str, &err);
    
    if (pyg_error_check(&err))
        return NULL;
    /* pyg_boxed_new handles NULL checking */
    return pyg_boxed_new(GCONF_TYPE_VALUE, ret, TRUE, TRUE);
}
#line 3414 "gconf.c"


static PyObject *
_wrap_gconf_entry_new_nocopy(PyObject *self, PyObject *args, PyObject *kwargs)
{
    static char *kwlist[] = { "key", "val", NULL };
    char *key;
    PyObject *py_val;
    GConfValue *val = NULL;
    GConfEntry *ret;

    if (!PyArg_ParseTupleAndKeywords(args, kwargs,"sO:entry_new_nocopy", kwlist, &key, &py_val))
        return NULL;
    if (pyg_boxed_check(py_val, GCONF_TYPE_VALUE))
        val = pyg_boxed_get(py_val, GConfValue);
    else {
        PyErr_SetString(PyExc_TypeError, "val should be a GConfValue");
        return NULL;
    }
    
    ret = gconf_entry_new_nocopy(key, val);
    
    /* pyg_boxed_new handles NULL checking */
    return pyg_boxed_new(GCONF_TYPE_ENTRY, ret, TRUE, TRUE);
}

static PyObject *
_wrap_gconf_key_is_below(PyObject *self, PyObject *args, PyObject *kwargs)
{
    static char *kwlist[] = { "above", "below", NULL };
    char *above, *below;
    int ret;

    if (!PyArg_ParseTupleAndKeywords(args, kwargs,"ss:key_is_below", kwlist, &above, &below))
        return NULL;
    
    ret = gconf_key_is_below(above, below);
    
    return PyBool_FromLong(ret);

}

static PyObject *
_wrap_gconf_concat_dir_and_key(PyObject *self, PyObject *args, PyObject *kwargs)
{
    static char *kwlist[] = { "dir", "key", NULL };
    char *dir, *key;
    gchar *ret;

    if (!PyArg_ParseTupleAndKeywords(args, kwargs,"ss:concat_dir_and_key", kwlist, &dir, &key))
        return NULL;
    
    ret = gconf_concat_dir_and_key(dir, key);
    
    if (ret) {
        PyObject *py_ret = PyString_FromString(ret);
        g_free(ret);
        return py_ret;
    }
    Py_INCREF(Py_None);
    return Py_None;
}

static PyObject *
_wrap_gconf_unique_key(PyObject *self)
{
    gchar *ret;

    
    ret = gconf_unique_key();
    
    if (ret) {
        PyObject *py_ret = PyString_FromString(ret);
        g_free(ret);
        return py_ret;
    }
    Py_INCREF(Py_None);
    return Py_None;
}

static PyObject *
_wrap_gconf_escape_key(PyObject *self, PyObject *args, PyObject *kwargs)
{
    static char *kwlist[] = { "arbitrary_text", "len", NULL };
    char *arbitrary_text;
    int len;
    gchar *ret;

    if (!PyArg_ParseTupleAndKeywords(args, kwargs,"si:escape_key", kwlist, &arbitrary_text, &len))
        return NULL;
    
    ret = gconf_escape_key(arbitrary_text, len);
    
    if (ret) {
        PyObject *py_ret = PyString_FromString(ret);
        g_free(ret);
        return py_ret;
    }
    Py_INCREF(Py_None);
    return Py_None;
}

static PyObject *
_wrap_gconf_unescape_key(PyObject *self, PyObject *args, PyObject *kwargs)
{
    static char *kwlist[] = { "escaped_key", "len", NULL };
    char *escaped_key;
    int len;
    gchar *ret;

    if (!PyArg_ParseTupleAndKeywords(args, kwargs,"si:unescape_key", kwlist, &escaped_key, &len))
        return NULL;
    
    ret = gconf_unescape_key(escaped_key, len);
    
    if (ret) {
        PyObject *py_ret = PyString_FromString(ret);
        g_free(ret);
        return py_ret;
    }
    Py_INCREF(Py_None);
    return Py_None;
}

static PyObject *
_wrap_gconf_debug_shutdown(PyObject *self)
{
    int ret;

    
    ret = gconf_debug_shutdown();
    
    return PyInt_FromLong(ret);
}

static PyObject *
_wrap_gconf_is_initialized(PyObject *self)
{
    int ret;

    
    ret = gconf_is_initialized();
    
    return PyBool_FromLong(ret);

}

const PyMethodDef pygconf_functions[] = {
    { "client_get_default", (PyCFunction)_wrap_gconf_client_get_default, METH_NOARGS,
      NULL },
    { "client_get_for_engine", (PyCFunction)_wrap_gconf_client_get_for_engine, METH_VARARGS|METH_KEYWORDS,
      NULL },
    { "engine_get_default", (PyCFunction)_wrap_gconf_engine_get_default, METH_NOARGS,
      NULL },
    { "engine_get_for_address", (PyCFunction)_wrap_gconf_engine_get_for_address, METH_VARARGS|METH_KEYWORDS,
      NULL },
    { "value_new_from_string", (PyCFunction)_wrap_gconf_value_new_from_string, METH_VARARGS|METH_KEYWORDS,
      NULL },
    { "entry_new_nocopy", (PyCFunction)_wrap_gconf_entry_new_nocopy, METH_VARARGS|METH_KEYWORDS,
      NULL },
    { "key_is_below", (PyCFunction)_wrap_gconf_key_is_below, METH_VARARGS|METH_KEYWORDS,
      NULL },
    { "concat_dir_and_key", (PyCFunction)_wrap_gconf_concat_dir_and_key, METH_VARARGS|METH_KEYWORDS,
      NULL },
    { "unique_key", (PyCFunction)_wrap_gconf_unique_key, METH_NOARGS,
      NULL },
    { "escape_key", (PyCFunction)_wrap_gconf_escape_key, METH_VARARGS|METH_KEYWORDS,
      NULL },
    { "unescape_key", (PyCFunction)_wrap_gconf_unescape_key, METH_VARARGS|METH_KEYWORDS,
      NULL },
    { "debug_shutdown", (PyCFunction)_wrap_gconf_debug_shutdown, METH_NOARGS,
      NULL },
    { "is_initialized", (PyCFunction)_wrap_gconf_is_initialized, METH_NOARGS,
      NULL },
    { NULL, NULL, 0, NULL }
};


/* ----------- enums and flags ----------- */

void
pygconf_add_constants(PyObject *module, const gchar *strip_prefix)
{
#ifdef VERSION
    PyModule_AddStringConstant(module, "__version__", VERSION);
#endif
  pyg_enum_add(module, "ClientPreloadType", strip_prefix, GCONF_TYPE_CLIENT_PRELOAD_TYPE);
  pyg_enum_add(module, "ClientErrorHandlingMode", strip_prefix, GCONF_TYPE_CLIENT_ERROR_HANDLING_MODE);
  pyg_enum_add(module, "Error", strip_prefix, GCONF_TYPE_ERROR);
  pyg_enum_add(module, "ValueType", strip_prefix, GCONF_TYPE_VALUE_TYPE);
  pyg_flags_add(module, "UnsetFlags", strip_prefix, GCONF_TYPE_UNSET_FLAGS);

  if (PyErr_Occurred())
    PyErr_Print();
}

/* initialise stuff extension classes */
void
pygconf_register_classes(PyObject *d)
{
    PyObject *module;

    if ((module = PyImport_ImportModule("gobject")) != NULL) {
        _PyGObject_Type = (PyTypeObject *)PyObject_GetAttrString(module, "GObject");
        if (_PyGObject_Type == NULL) {
            PyErr_SetString(PyExc_ImportError,
                "cannot import name GObject from gobject");
            return ;
        }
    } else {
        PyErr_SetString(PyExc_ImportError,
            "could not import gobject");
        return ;
    }


#line 3631 "gconf.c"
    pyg_register_boxed(d, "Value", GCONF_TYPE_VALUE, &PyGConfValue_Type);
    pyg_register_boxed(d, "Entry", GCONF_TYPE_ENTRY, &PyGConfEntry_Type);
    pyg_register_boxed(d, "Schema", GCONF_TYPE_SCHEMA, &PyGConfSchema_Type);
    pyg_register_boxed(d, "MetaInfo", GCONF_TYPE_METAINFO, &PyGConfMetaInfo_Type);
    pyg_register_boxed(d, "ChangeSet", GCONF_TYPE_CHANGE_SET, &PyGConfChangeSet_Type);
    pygobject_register_class(d, "GConfClient", GCONF_TYPE_CLIENT, &PyGConfClient_Type, Py_BuildValue("(O)", &PyGObject_Type));
}
