/*--------------------------------------------------------------------------*/
/*                                                                          */
/*                         GNAT COMPILER COMPONENTS                         */
/*                                                                          */
/*                                S I N F O                                 */
/*                                                                          */
/*                              C Header File                               */
/*                                                                          */
/*          Copyright (C) 1992-2016, Free Software Foundation, Inc.         */
/*                                                                          */
/* GNAT is free software;  you can  redistribute it  and/or modify it under */
/* terms of the  GNU General Public License as published  by the Free Soft- */
/* ware  Foundation;  either version 3,  or (at your option) any later ver- */
/* sion.  GNAT is distributed in the hope that it will be useful, but WITH- */
/* OUT ANY WARRANTY;  without even the  implied warranty of MERCHANTABILITY */
/* or FITNESS FOR A PARTICULAR PURPOSE.                                     */
/*                                                                          */
/* As a special exception under Section 7 of GPL version 3, you are granted */
/* additional permissions described in the GCC Runtime Library Exception,   */
/* version 3.1, as published by the Free Software Foundation.               */
/*                                                                          */
/* You should have received a copy of the GNU General Public License and    */
/* a copy of the GCC Runtime Library Exception along with this program;     */
/* see the files COPYING3 and COPYING.RUNTIME respectively.  If not, see    */
/* <http://www.gnu.org/licenses/>.                                          */
/*                                                                          */
/* GNAT was originally developed  by the GNAT team at  New York University. */
/* Extensive contributions were provided by Ada Core Technologies Inc.      */
/*                                                                          */
/*--------------------------------------------------------------------------*/

#ifdef __cplusplus
extern "C" {
#endif
      #define N_Unused_At_Start 0
      #define N_At_Clause 1
      #define N_Component_Clause 2
      #define N_Enumeration_Representation_Clause 3
      #define N_Mod_Clause 4
      #define N_Record_Representation_Clause 5
      #define N_Attribute_Definition_Clause 6
      #define N_Empty 7
      #define N_Pragma_Argument_Association 8
      #define N_Error 9
      #define N_Defining_Character_Literal 10
      #define N_Defining_Identifier 11
      #define N_Defining_Operator_Symbol 12
      #define N_Expanded_Name 13
      #define N_Identifier 14
      #define N_Operator_Symbol 15
      #define N_Character_Literal 16
      #define N_Op_Add 17
      #define N_Op_Concat 18
      #define N_Op_Expon 19
      #define N_Op_Subtract 20
      #define N_Op_Divide 21
      #define N_Op_Mod 22
      #define N_Op_Multiply 23
      #define N_Op_Rem 24
      #define N_Op_And 25
      #define N_Op_Eq 26
      #define N_Op_Ge 27
      #define N_Op_Gt 28
      #define N_Op_Le 29
      #define N_Op_Lt 30
      #define N_Op_Ne 31
      #define N_Op_Or 32
      #define N_Op_Xor 33
      #define N_Op_Rotate_Left 34
      #define N_Op_Rotate_Right 35
      #define N_Op_Shift_Left 36
      #define N_Op_Shift_Right 37
      #define N_Op_Shift_Right_Arithmetic 38
      #define N_Op_Abs 39
      #define N_Op_Minus 40
      #define N_Op_Not 41
      #define N_Op_Plus 42
      #define N_Attribute_Reference 43
      #define N_In 44
      #define N_Not_In 45
      #define N_And_Then 46
      #define N_Or_Else 47
      #define N_Function_Call 48
      #define N_Procedure_Call_Statement 49
      #define N_Raise_Constraint_Error 50
      #define N_Raise_Program_Error 51
      #define N_Raise_Storage_Error 52
      #define N_Integer_Literal 53
      #define N_Real_Literal 54
      #define N_String_Literal 55
      #define N_Explicit_Dereference 56
      #define N_Expression_With_Actions 57
      #define N_If_Expression 58
      #define N_Indexed_Component 59
      #define N_Null 60
      #define N_Qualified_Expression 61
      #define N_Quantified_Expression 62
      #define N_Aggregate 63
      #define N_Allocator 64
      #define N_Case_Expression 65
      #define N_Delta_Aggregate 66
      #define N_Extension_Aggregate 67
      #define N_Raise_Expression 68
      #define N_Range 69
      #define N_Reference 70
      #define N_Selected_Component 71
      #define N_Slice 72
      #define N_Target_Name 73
      #define N_Type_Conversion 74
      #define N_Unchecked_Expression 75
      #define N_Unchecked_Type_Conversion 76
      #define N_Subtype_Indication 77
      #define N_Component_Declaration 78
      #define N_Entry_Declaration 79
      #define N_Expression_Function 80
      #define N_Formal_Object_Declaration 81
      #define N_Formal_Type_Declaration 82
      #define N_Full_Type_Declaration 83
      #define N_Incomplete_Type_Declaration 84
      #define N_Iterator_Specification 85
      #define N_Loop_Parameter_Specification 86
      #define N_Object_Declaration 87
      #define N_Protected_Type_Declaration 88
      #define N_Private_Extension_Declaration 89
      #define N_Private_Type_Declaration 90
      #define N_Subtype_Declaration 91
      #define N_Function_Specification 92
      #define N_Procedure_Specification 93
      #define N_Access_Function_Definition 94
      #define N_Access_Procedure_Definition 95
      #define N_Task_Type_Declaration 96
      #define N_Package_Body_Stub 97
      #define N_Protected_Body_Stub 98
      #define N_Subprogram_Body_Stub 99
      #define N_Task_Body_Stub 100
      #define N_Function_Instantiation 101
      #define N_Procedure_Instantiation 102
      #define N_Package_Instantiation 103
      #define N_Package_Body 104
      #define N_Subprogram_Body 105
      #define N_Protected_Body 106
      #define N_Task_Body 107
      #define N_Implicit_Label_Declaration 108
      #define N_Package_Declaration 109
      #define N_Single_Task_Declaration 110
      #define N_Subprogram_Declaration 111
      #define N_Use_Package_Clause 112
      #define N_Generic_Package_Declaration 113
      #define N_Generic_Subprogram_Declaration 114
      #define N_Constrained_Array_Definition 115
      #define N_Unconstrained_Array_Definition 116
      #define N_Exception_Renaming_Declaration 117
      #define N_Object_Renaming_Declaration 118
      #define N_Package_Renaming_Declaration 119
      #define N_Subprogram_Renaming_Declaration 120
      #define N_Generic_Function_Renaming_Declaration 121
      #define N_Generic_Package_Renaming_Declaration 122
      #define N_Generic_Procedure_Renaming_Declaration 123
      #define N_Abort_Statement 124
      #define N_Accept_Statement 125
      #define N_Assignment_Statement 126
      #define N_Asynchronous_Select 127
      #define N_Block_Statement 128
      #define N_Case_Statement 129
      #define N_Code_Statement 130
      #define N_Compound_Statement 131
      #define N_Conditional_Entry_Call 132
      #define N_Delay_Relative_Statement 133
      #define N_Delay_Until_Statement 134
      #define N_Entry_Call_Statement 135
      #define N_Free_Statement 136
      #define N_Goto_Statement 137
      #define N_Loop_Statement 138
      #define N_Null_Statement 139
      #define N_Raise_Statement 140
      #define N_Requeue_Statement 141
      #define N_Simple_Return_Statement 142
      #define N_Extended_Return_Statement 143
      #define N_Selective_Accept 144
      #define N_Timed_Entry_Call 145
      #define N_Exit_Statement 146
      #define N_If_Statement 147
      #define N_Accept_Alternative 148
      #define N_Delay_Alternative 149
      #define N_Elsif_Part 150
      #define N_Entry_Body_Formal_Part 151
      #define N_Iteration_Scheme 152
      #define N_Terminate_Alternative 153
      #define N_Formal_Abstract_Subprogram_Declaration 154
      #define N_Formal_Concrete_Subprogram_Declaration 155
      #define N_Push_Constraint_Error_Label 156
      #define N_Push_Program_Error_Label 157
      #define N_Push_Storage_Error_Label 158
      #define N_Pop_Constraint_Error_Label 159
      #define N_Pop_Program_Error_Label 160
      #define N_Pop_Storage_Error_Label 161
      #define N_SCIL_Dispatch_Table_Tag_Init 162
      #define N_SCIL_Dispatching_Call 163
      #define N_SCIL_Membership_Test 164
      #define N_Abortable_Part 165
      #define N_Abstract_Subprogram_Declaration 166
      #define N_Access_Definition 167
      #define N_Access_To_Object_Definition 168
      #define N_Aspect_Specification 169
      #define N_Case_Expression_Alternative 170
      #define N_Case_Statement_Alternative 171
      #define N_Compilation_Unit 172
      #define N_Compilation_Unit_Aux 173
      #define N_Component_Association 174
      #define N_Component_Definition 175
      #define N_Component_List 176
      #define N_Contract 177
      #define N_Derived_Type_Definition 178
      #define N_Decimal_Fixed_Point_Definition 179
      #define N_Defining_Program_Unit_Name 180
      #define N_Delta_Constraint 181
      #define N_Designator 182
      #define N_Digits_Constraint 183
      #define N_Discriminant_Association 184
      #define N_Discriminant_Specification 185
      #define N_Enumeration_Type_Definition 186
      #define N_Entry_Body 187
      #define N_Entry_Call_Alternative 188
      #define N_Entry_Index_Specification 189
      #define N_Exception_Declaration 190
      #define N_Exception_Handler 191
      #define N_Floating_Point_Definition 192
      #define N_Formal_Decimal_Fixed_Point_Definition 193
      #define N_Formal_Derived_Type_Definition 194
      #define N_Formal_Discrete_Type_Definition 195
      #define N_Formal_Floating_Point_Definition 196
      #define N_Formal_Modular_Type_Definition 197
      #define N_Formal_Ordinary_Fixed_Point_Definition 198
      #define N_Formal_Package_Declaration 199
      #define N_Formal_Private_Type_Definition 200
      #define N_Formal_Incomplete_Type_Definition 201
      #define N_Formal_Signed_Integer_Type_Definition 202
      #define N_Freeze_Entity 203
      #define N_Freeze_Generic_Entity 204
      #define N_Generic_Association 205
      #define N_Handled_Sequence_Of_Statements 206
      #define N_Index_Or_Discriminant_Constraint 207
      #define N_Iterated_Component_Association 208
      #define N_Itype_Reference 209
      #define N_Label 210
      #define N_Modular_Type_Definition 211
      #define N_Number_Declaration 212
      #define N_Ordinary_Fixed_Point_Definition 213
      #define N_Others_Choice 214
      #define N_Package_Specification 215
      #define N_Parameter_Association 216
      #define N_Parameter_Specification 217
      #define N_Pragma 218
      #define N_Protected_Definition 219
      #define N_Range_Constraint 220
      #define N_Real_Range_Specification 221
      #define N_Record_Definition 222
      #define N_Signed_Integer_Type_Definition 223
      #define N_Single_Protected_Declaration 224
      #define N_Subunit 225
      #define N_Task_Definition 226
      #define N_Triggering_Alternative 227
      #define N_Use_Type_Clause 228
      #define N_Validate_Unchecked_Conversion 229
      #define N_Variant 230
      #define N_Variant_Part 231
      #define N_With_Clause 232
      #define N_Unused_At_End 233

      #define Number_Node_Kinds 234
   SUBTYPE (N_Access_To_Subprogram_Definition, Node_Kind, 
      N_Access_Function_Definition,
      N_Access_Procedure_Definition)
   SUBTYPE (N_Array_Type_Definition, Node_Kind, 
      N_Constrained_Array_Definition,
      N_Unconstrained_Array_Definition)
   SUBTYPE (N_Binary_Op, Node_Kind, 
      N_Op_Add,
      N_Op_Shift_Right_Arithmetic)
   SUBTYPE (N_Body_Stub, Node_Kind, 
      N_Package_Body_Stub,
      N_Task_Body_Stub)
   SUBTYPE (N_Declaration, Node_Kind, 
      N_Component_Declaration,
      N_Procedure_Specification)
   SUBTYPE (N_Delay_Statement, Node_Kind, 
      N_Delay_Relative_Statement,
      N_Delay_Until_Statement)
   SUBTYPE (N_Direct_Name, Node_Kind, 
      N_Identifier,
      N_Character_Literal)
   SUBTYPE (N_Entity, Node_Kind, 
      N_Defining_Character_Literal,
      N_Defining_Operator_Symbol)
   SUBTYPE (N_Formal_Subprogram_Declaration, Node_Kind, 
      N_Formal_Abstract_Subprogram_Declaration,
      N_Formal_Concrete_Subprogram_Declaration)
   SUBTYPE (N_Generic_Declaration, Node_Kind, 
      N_Generic_Package_Declaration,
      N_Generic_Subprogram_Declaration)
   SUBTYPE (N_Generic_Instantiation, Node_Kind, 
      N_Function_Instantiation,
      N_Package_Instantiation)
   SUBTYPE (N_Generic_Renaming_Declaration, Node_Kind, 
      N_Generic_Function_Renaming_Declaration,
      N_Generic_Procedure_Renaming_Declaration)
   SUBTYPE (N_Has_Chars, Node_Kind, 
      N_Attribute_Definition_Clause,
      N_Op_Plus)
   SUBTYPE (N_Has_Entity, Node_Kind, 
      N_Expanded_Name,
      N_Attribute_Reference)
   SUBTYPE (N_Has_Etype, Node_Kind, 
      N_Error,
      N_Subtype_Indication)
   SUBTYPE (N_Has_Treat_Fixed_As_Integer, Node_Kind, 
      N_Op_Divide,
      N_Op_Rem)
   SUBTYPE (N_Multiplying_Operator, Node_Kind, 
      N_Op_Divide,
      N_Op_Rem)
   SUBTYPE (N_Later_Decl_Item, Node_Kind, 
      N_Task_Type_Declaration,
      N_Generic_Subprogram_Declaration)
   SUBTYPE (N_Membership_Test, Node_Kind, 
      N_In,
      N_Not_In)
   SUBTYPE (N_Numeric_Or_String_Literal, Node_Kind, 
      N_Integer_Literal,
      N_String_Literal)
   SUBTYPE (N_Op, Node_Kind, 
      N_Op_Add,
      N_Op_Plus)
   SUBTYPE (N_Op_Boolean, Node_Kind, 
      N_Op_And,
      N_Op_Xor)
   SUBTYPE (N_Op_Compare, Node_Kind, 
      N_Op_Eq,
      N_Op_Ne)
   SUBTYPE (N_Op_Shift, Node_Kind, 
      N_Op_Rotate_Left,
      N_Op_Shift_Right_Arithmetic)
   SUBTYPE (N_Proper_Body, Node_Kind, 
      N_Package_Body,
      N_Task_Body)
   SUBTYPE (N_Push_xxx_Label, Node_Kind, 
      N_Push_Constraint_Error_Label,
      N_Push_Storage_Error_Label)
   SUBTYPE (N_Pop_xxx_Label, Node_Kind, 
      N_Pop_Constraint_Error_Label,
      N_Pop_Storage_Error_Label)
   SUBTYPE (N_Push_Pop_xxx_Label, Node_Kind, 
      N_Push_Constraint_Error_Label,
      N_Pop_Storage_Error_Label)
   SUBTYPE (N_Raise_xxx_Error, Node_Kind, 
      N_Raise_Constraint_Error,
      N_Raise_Storage_Error)
   SUBTYPE (N_Renaming_Declaration, Node_Kind, 
      N_Exception_Renaming_Declaration,
      N_Generic_Procedure_Renaming_Declaration)
   SUBTYPE (N_Representation_Clause, Node_Kind, 
      N_At_Clause,
      N_Attribute_Definition_Clause)
   SUBTYPE (N_Short_Circuit, Node_Kind, 
      N_And_Then,
      N_Or_Else)
   SUBTYPE (N_SCIL_Node, Node_Kind, 
      N_SCIL_Dispatch_Table_Tag_Init,
      N_SCIL_Membership_Test)
   SUBTYPE (N_Statement_Other_Than_Procedure_Call, Node_Kind, 
      N_Abort_Statement,
      N_If_Statement)
   SUBTYPE (N_Subprogram_Call, Node_Kind, 
      N_Function_Call,
      N_Procedure_Call_Statement)
   SUBTYPE (N_Subprogram_Instantiation, Node_Kind, 
      N_Function_Instantiation,
      N_Procedure_Instantiation)
   SUBTYPE (N_Has_Condition, Node_Kind, 
      N_Exit_Statement,
      N_Terminate_Alternative)
   SUBTYPE (N_Subexpr, Node_Kind, 
      N_Expanded_Name,
      N_Unchecked_Type_Conversion)
   SUBTYPE (N_Subprogram_Specification, Node_Kind, 
      N_Function_Specification,
      N_Procedure_Specification)
   SUBTYPE (N_Unary_Op, Node_Kind, 
      N_Op_Abs,
      N_Op_Plus)
   SUBTYPE (N_Unit_Body, Node_Kind, 
      N_Package_Body,
      N_Subprogram_Body)
   INLINE Boolean   ABE_Is_Certain                 (Node_Id N)
      { return Flag18 (N); }
   INLINE Boolean   Abort_Present                  (Node_Id N)
      { return Flag15 (N); }
   INLINE Node_Id   Abortable_Part                 (Node_Id N)
      { return Node2 (N); }
   INLINE Boolean   Abstract_Present               (Node_Id N)
      { return Flag4 (N); }
   INLINE List_Id   Accept_Handler_Records         (Node_Id N)
      { return List5 (N); }
   INLINE Node_Id   Accept_Statement               (Node_Id N)
      { return Node2 (N); }
   INLINE Node_Id   Access_Definition              (Node_Id N)
      { return Node3 (N); }
   INLINE Node_Id   Access_To_Subprogram_Definition (Node_Id N)
      { return Node3 (N); }
   INLINE Elist_Id  Access_Types_To_Process        (Node_Id N)
      { return Elist2 (N); }
   INLINE List_Id   Actions                        (Node_Id N)
      { return List1 (N); }
   INLINE Node_Id   Activation_Chain_Entity        (Node_Id N)
      { return Node3 (N); }
   INLINE Boolean   Acts_As_Spec                   (Node_Id N)
      { return Flag4 (N); }
   INLINE Node_Id   Actual_Designated_Subtype      (Node_Id N)
      { return Node4 (N); }
   INLINE Boolean   Address_Warning_Posted         (Node_Id N)
      { return Flag18 (N); }
   INLINE Node_Id   Aggregate_Bounds               (Node_Id N)
      { return Node3 (N); }
   INLINE Boolean   Aliased_Present                (Node_Id N)
      { return Flag4 (N); }
   INLINE Boolean   All_Others                     (Node_Id N)
      { return Flag11 (N); }
   INLINE Boolean   All_Present                    (Node_Id N)
      { return Flag15 (N); }
   INLINE List_Id   Alternatives                   (Node_Id N)
      { return List4 (N); }
   INLINE Node_Id   Ancestor_Part                  (Node_Id N)
      { return Node3 (N); }
   INLINE Boolean   Atomic_Sync_Required           (Node_Id N)
      { return Flag14 (N); }
   INLINE Node_Id   Array_Aggregate                (Node_Id N)
      { return Node3 (N); }
   INLINE Node_Id   Aspect_Rep_Item                (Node_Id N)
      { return Node2 (N); }
   INLINE Boolean   Assignment_OK                  (Node_Id N)
      { return Flag15 (N); }
   INLINE Node_Id   Associated_Node                (Node_Id N)
      { return Node4 (N); }
   INLINE Node_Id   At_End_Proc                    (Node_Id N)
      { return Node1 (N); }
   INLINE Name_Id   Attribute_Name                 (Node_Id N)
      { return Name2 (N); }
   INLINE Node_Id   Aux_Decls_Node                 (Node_Id N)
      { return Node5 (N); }
   INLINE Boolean   Backwards_OK                   (Node_Id N)
      { return Flag6 (N); }
   INLINE Boolean   Bad_Is_Detected                (Node_Id N)
      { return Flag15 (N); }
   INLINE Boolean   By_Ref                         (Node_Id N)
      { return Flag5 (N); }
   INLINE Boolean   Body_Required                  (Node_Id N)
      { return Flag13 (N); }
   INLINE Node_Id   Body_To_Inline                 (Node_Id N)
      { return Node3 (N); }
   INLINE Boolean   Box_Present                    (Node_Id N)
      { return Flag15 (N); }
   INLINE Uint      Char_Literal_Value             (Node_Id N)
      { return Uint2 (N); }
   INLINE Name_Id   Chars                          (Node_Id N)
      { return Name1 (N); }
   INLINE Boolean   Check_Address_Alignment        (Node_Id N)
      { return Flag11 (N); }
   INLINE Node_Id   Choice_Parameter               (Node_Id N)
      { return Node2 (N); }
   INLINE List_Id   Choices                        (Node_Id N)
      { return List1 (N); }
   INLINE Boolean   Class_Present                  (Node_Id N)
      { return Flag6 (N); }
   INLINE Node_Id   Classifications                (Node_Id N)
      { return Node3 (N); }
   INLINE List_Id   Cleanup_Actions                (Node_Id N)
      { return List5 (N); }
   INLINE Boolean   Comes_From_Extended_Return_Statement (Node_Id N)
      { return Flag18 (N); }
   INLINE Boolean   Compile_Time_Known_Aggregate   (Node_Id N)
      { return Flag18 (N); }
   INLINE List_Id   Component_Associations         (Node_Id N)
      { return List2 (N); }
   INLINE List_Id   Component_Clauses              (Node_Id N)
      { return List3 (N); }
   INLINE Node_Id   Component_Definition           (Node_Id N)
      { return Node4 (N); }
   INLINE List_Id   Component_Items                (Node_Id N)
      { return List3 (N); }
   INLINE Node_Id   Component_List                 (Node_Id N)
      { return Node1 (N); }
   INLINE Node_Id   Component_Name                 (Node_Id N)
      { return Node1 (N); }
   INLINE Boolean   Componentwise_Assignment       (Node_Id N)
      { return Flag14 (N); }
   INLINE Node_Id   Condition                      (Node_Id N)
      { return Node1 (N); }
   INLINE List_Id   Condition_Actions              (Node_Id N)
      { return List3 (N); }
   INLINE List_Id   Config_Pragmas                 (Node_Id N)
      { return List4 (N); }
   INLINE Boolean   Constant_Present               (Node_Id N)
      { return Flag17 (N); }
   INLINE Node_Id   Constraint                     (Node_Id N)
      { return Node3 (N); }
   INLINE List_Id   Constraints                    (Node_Id N)
      { return List1 (N); }
   INLINE Boolean   Context_Installed              (Node_Id N)
      { return Flag13 (N); }
   INLINE Boolean   Context_Pending                (Node_Id N)
      { return Flag16 (N); }
   INLINE List_Id   Context_Items                  (Node_Id N)
      { return List1 (N); }
   INLINE Node_Id   Contract_Test_Cases            (Node_Id N)
      { return Node2 (N); }
   INLINE Node_Id   Controlling_Argument           (Node_Id N)
      { return Node1 (N); }
   INLINE Boolean   Conversion_OK                  (Node_Id N)
      { return Flag14 (N); }
   INLINE Boolean   Convert_To_Return_False        (Node_Id N)
      { return Flag13 (N); }
   INLINE Node_Id   Corresponding_Aspect           (Node_Id N)
      { return Node3 (N); }
   INLINE Node_Id   Corresponding_Body             (Node_Id N)
      { return Node5 (N); }
   INLINE Node_Id   Corresponding_Formal_Spec      (Node_Id N)
      { return Node3 (N); }
   INLINE Node_Id   Corresponding_Generic_Association (Node_Id N)
      { return Node5 (N); }
   INLINE Uint      Corresponding_Integer_Value    (Node_Id N)
      { return Uint4 (N); }
   INLINE Entity_Id Corresponding_Spec             (Node_Id N)
      { return Node5 (N); }
   INLINE Node_Id   Corresponding_Spec_Of_Stub     (Node_Id N)
      { return Node2 (N); }
   INLINE Node_Id   Corresponding_Stub             (Node_Id N)
      { return Node3 (N); }
   INLINE Entity_Id Dcheck_Function                (Node_Id N)
      { return Node5 (N); }
   INLINE List_Id   Declarations                   (Node_Id N)
      { return List2 (N); }
   INLINE Node_Id   Default_Expression             (Node_Id N)
      { return Node5 (N); }
   INLINE Node_Id   Default_Storage_Pool           (Node_Id N)
      { return Node3 (N); }
   INLINE Node_Id   Default_Name                   (Node_Id N)
      { return Node2 (N); }
   INLINE Entity_Id Defining_Identifier            (Node_Id N)
      { return Node1 (N); }
   INLINE Node_Id   Defining_Unit_Name             (Node_Id N)
      { return Node1 (N); }
   INLINE Node_Id   Delay_Alternative              (Node_Id N)
      { return Node4 (N); }
   INLINE Node_Id   Delay_Statement                (Node_Id N)
      { return Node2 (N); }
   INLINE Node_Id   Delta_Expression               (Node_Id N)
      { return Node3 (N); }
   INLINE Node_Id   Digits_Expression              (Node_Id N)
      { return Node2 (N); }
   INLINE Boolean   Discr_Check_Funcs_Built        (Node_Id N)
      { return Flag11 (N); }
   INLINE List_Id   Discrete_Choices               (Node_Id N)
      { return List4 (N); }
   INLINE Node_Id   Discrete_Range                 (Node_Id N)
      { return Node4 (N); }
   INLINE Node_Id   Discrete_Subtype_Definition    (Node_Id N)
      { return Node4 (N); }
   INLINE List_Id   Discrete_Subtype_Definitions   (Node_Id N)
      { return List2 (N); }
   INLINE List_Id   Discriminant_Specifications    (Node_Id N)
      { return List4 (N); }
   INLINE Node_Id   Discriminant_Type              (Node_Id N)
      { return Node5 (N); }
   INLINE Boolean   Do_Accessibility_Check         (Node_Id N)
      { return Flag13 (N); }
   INLINE Boolean   Do_Discriminant_Check          (Node_Id N)
      { return Flag1 (N); }
   INLINE Boolean   Do_Division_Check              (Node_Id N)
      { return Flag13 (N); }
   INLINE Boolean   Do_Length_Check                (Node_Id N)
      { return Flag4 (N); }
   INLINE Boolean   Do_Overflow_Check              (Node_Id N)
      { return Flag17 (N); }
   INLINE Boolean   Do_Range_Check                 (Node_Id N)
      { return Flag9 (N); }
   INLINE Boolean   Do_Storage_Check               (Node_Id N)
      { return Flag17 (N); }
   INLINE Boolean   Do_Tag_Check                   (Node_Id N)
      { return Flag13 (N); }
   INLINE Boolean   Elaborate_All_Desirable        (Node_Id N)
      { return Flag9 (N); }
   INLINE Boolean   Elaborate_All_Present          (Node_Id N)
      { return Flag14 (N); }
   INLINE Boolean   Elaborate_Desirable            (Node_Id N)
      { return Flag11 (N); }
   INLINE Boolean   Elaborate_Present              (Node_Id N)
      { return Flag4 (N); }
   INLINE List_Id   Else_Actions                   (Node_Id N)
      { return List3 (N); }
   INLINE List_Id   Else_Statements                (Node_Id N)
      { return List4 (N); }
   INLINE List_Id   Elsif_Parts                    (Node_Id N)
      { return List3 (N); }
   INLINE Node_Id   Enclosing_Variant              (Node_Id N)
      { return Node2 (N); }
   INLINE Node_Id   End_Label                      (Node_Id N)
      { return Node4 (N); }
   INLINE Uint      End_Span                       (Node_Id N)
      { return Uint5 (N); }
   INLINE Node_Id   Entity                         (Node_Id N)
      { return Node4 (N); }
   INLINE Node_Id   Entity_Or_Associated_Node      (Node_Id N)
      { return Node4 (N); }
   INLINE Node_Id   Entry_Body_Formal_Part         (Node_Id N)
      { return Node5 (N); }
   INLINE Node_Id   Entry_Call_Alternative         (Node_Id N)
      { return Node1 (N); }
   INLINE Node_Id   Entry_Call_Statement           (Node_Id N)
      { return Node1 (N); }
   INLINE Node_Id   Entry_Direct_Name              (Node_Id N)
      { return Node1 (N); }
   INLINE Node_Id   Entry_Index                    (Node_Id N)
      { return Node5 (N); }
   INLINE Node_Id   Entry_Index_Specification      (Node_Id N)
      { return Node4 (N); }
   INLINE Node_Id   Etype                          (Node_Id N)
      { return Node5 (N); }
   INLINE List_Id   Exception_Choices              (Node_Id N)
      { return List4 (N); }
   INLINE List_Id   Exception_Handlers             (Node_Id N)
      { return List5 (N); }
   INLINE Boolean   Exception_Junk                 (Node_Id N)
      { return Flag8 (N); }
   INLINE Node_Id   Exception_Label                (Node_Id N)
      { return Node5 (N); }
   INLINE Node_Id   Explicit_Actual_Parameter      (Node_Id N)
      { return Node3 (N); }
   INLINE Boolean   Expansion_Delayed              (Node_Id N)
      { return Flag11 (N); }
   INLINE Node_Id   Explicit_Generic_Actual_Parameter (Node_Id N)
      { return Node1 (N); }
   INLINE Node_Id   Expression                     (Node_Id N)
      { return Node3 (N); }
   INLINE Node_Id   Expression_Copy                (Node_Id N)
      { return Node2 (N); }
   INLINE List_Id   Expressions                    (Node_Id N)
      { return List1 (N); }
   INLINE Node_Id   First_Bit                      (Node_Id N)
      { return Node3 (N); }
   INLINE Entity_Id First_Inlined_Subprogram       (Node_Id N)
      { return Node3 (N); }
   INLINE Boolean   First_Name                     (Node_Id N)
      { return Flag5 (N); }
   INLINE Node_Id   First_Named_Actual             (Node_Id N)
      { return Node4 (N); }
   INLINE Node_Id   First_Real_Statement           (Node_Id N)
      { return Node2 (N); }
   INLINE Entity_Id First_Subtype_Link             (Node_Id N)
      { return Node5 (N); }
   INLINE Boolean   Float_Truncate                 (Node_Id N)
      { return Flag11 (N); }
   INLINE Node_Id   Formal_Type_Definition         (Node_Id N)
      { return Node3 (N); }
   INLINE Boolean   Forwards_OK                    (Node_Id N)
      { return Flag5 (N); }
   INLINE Boolean   From_Aspect_Specification      (Node_Id N)
      { return Flag13 (N); }
   INLINE Boolean   From_At_End                    (Node_Id N)
      { return Flag4 (N); }
   INLINE Boolean   From_At_Mod                    (Node_Id N)
      { return Flag4 (N); }
   INLINE Boolean   From_Conditional_Expression    (Node_Id N)
      { return Flag1 (N); }
   INLINE Boolean   From_Default                   (Node_Id N)
      { return Flag6 (N); }
   INLINE Node_Id   Generalized_Indexing           (Node_Id N)
      { return Node4 (N); }
   INLINE List_Id   Generic_Associations           (Node_Id N)
      { return List3 (N); }
   INLINE List_Id   Generic_Formal_Declarations    (Node_Id N)
      { return List2 (N); }
   INLINE Node_Id   Generic_Parent                 (Node_Id N)
      { return Node5 (N); }
   INLINE Node_Id   Generic_Parent_Type            (Node_Id N)
      { return Node4 (N); }
   INLINE Node_Id   Handled_Statement_Sequence     (Node_Id N)
      { return Node4 (N); }
   INLINE Node_Id   Handler_List_Entry             (Node_Id N)
      { return Node2 (N); }
   INLINE Boolean   Has_Created_Identifier         (Node_Id N)
      { return Flag15 (N); }
   INLINE Boolean   Has_Dereference_Action         (Node_Id N)
      { return Flag13 (N); }
   INLINE Boolean   Has_Dynamic_Length_Check       (Node_Id N)
      { return Flag10 (N); }
   INLINE Boolean   Has_Dynamic_Range_Check        (Node_Id N)
      { return Flag12 (N); }
   INLINE Boolean   Has_Init_Expression            (Node_Id N)
      { return Flag14 (N); }
   INLINE Boolean   Has_Local_Raise                (Node_Id N)
      { return Flag8 (N); }
   INLINE Boolean   Has_No_Elaboration_Code        (Node_Id N)
      { return Flag17 (N); }
   INLINE Boolean   Has_Pragma_Suppress_All        (Node_Id N)
      { return Flag14 (N); }
   INLINE Boolean   Has_Private_View               (Node_Id N)
      { return Flag11 (N); }
   INLINE Boolean   Has_Relative_Deadline_Pragma   (Node_Id N)
      { return Flag9 (N); }
   INLINE Boolean   Has_Self_Reference             (Node_Id N)
      { return Flag13 (N); }
   INLINE Boolean   Has_SP_Choice                  (Node_Id N)
      { return Flag15 (N); }
   INLINE Boolean   Has_Storage_Size_Pragma        (Node_Id N)
      { return Flag5 (N); }
   INLINE Boolean   Has_Target_Names               (Node_Id N)
      { return Flag8 (N); }
   INLINE Boolean   Has_Wide_Character             (Node_Id N)
      { return Flag11 (N); }
   INLINE Boolean   Has_Wide_Wide_Character        (Node_Id N)
      { return Flag13 (N); }
   INLINE Boolean   Header_Size_Added              (Node_Id N)
      { return Flag11 (N); }
   INLINE Elist_Id  Hidden_By_Use_Clause           (Node_Id N)
      { return Elist4 (N); }
   INLINE Node_Id   High_Bound                     (Node_Id N)
      { return Node2 (N); }
   INLINE Node_Id   Identifier                     (Node_Id N)
      { return Node1 (N); }
   INLINE List_Id   Interface_List                 (Node_Id N)
      { return List2 (N); }
   INLINE Boolean   Interface_Present              (Node_Id N)
      { return Flag16 (N); }
   INLINE Boolean   Implicit_With                  (Node_Id N)
      { return Flag16 (N); }
   INLINE Boolean   Implicit_With_From_Instantiation (Node_Id N)
      { return Flag12 (N); }
   INLINE Boolean   Import_Interface_Present       (Node_Id N)
      { return Flag16 (N); }
   INLINE Boolean   In_Present                     (Node_Id N)
      { return Flag15 (N); }
   INLINE Boolean   Includes_Infinities            (Node_Id N)
      { return Flag11 (N); }
   INLINE Node_Id   Incomplete_View                (Node_Id N)
      { return Node2 (N); }
   INLINE Boolean   Inherited_Discriminant         (Node_Id N)
      { return Flag13 (N); }
   INLINE Node_Id   Instance_Spec                  (Node_Id N)
      { return Node5 (N); }
   INLINE Uint      Intval                         (Node_Id N)
      { return Uint3 (N); }
   INLINE Boolean   Is_Abort_Block                 (Node_Id N)
      { return Flag4 (N); }
   INLINE Boolean   Is_Accessibility_Actual        (Node_Id N)
      { return Flag13 (N); }
   INLINE Boolean   Is_Analyzed_Pragma             (Node_Id N)
      { return Flag5 (N); }
   INLINE Boolean   Is_Asynchronous_Call_Block     (Node_Id N)
      { return Flag7 (N); }
   INLINE Boolean   Is_Boolean_Aspect              (Node_Id N)
      { return Flag16 (N); }
   INLINE Boolean   Is_Checked                     (Node_Id N)
      { return Flag11 (N); }
   INLINE Boolean   Is_Checked_Ghost_Pragma        (Node_Id N)
      { return Flag3 (N); }
   INLINE Boolean   Is_Component_Left_Opnd         (Node_Id N)
      { return Flag13 (N); }
   INLINE Boolean   Is_Component_Right_Opnd        (Node_Id N)
      { return Flag14 (N); }
   INLINE Boolean   Is_Controlling_Actual          (Node_Id N)
      { return Flag16 (N); }
   INLINE Boolean   Is_Delayed_Aspect              (Node_Id N)
      { return Flag14 (N); }
   INLINE Boolean   Is_Disabled                    (Node_Id N)
      { return Flag15 (N); }
   INLINE Boolean   Is_Dynamic_Coextension         (Node_Id N)
      { return Flag18 (N); }
   INLINE Boolean   Is_Elsif                       (Node_Id N)
      { return Flag13 (N); }
   INLINE Boolean   Is_Entry_Barrier_Function      (Node_Id N)
      { return Flag8 (N); }
   INLINE Boolean   Is_Expanded_Build_In_Place_Call (Node_Id N)
      { return Flag11 (N); }
   INLINE Boolean   Is_Expanded_Contract           (Node_Id N)
      { return Flag1 (N); }
   INLINE Boolean   Is_Finalization_Wrapper        (Node_Id N)
      { return Flag9 (N); }
   INLINE Boolean   Is_Folded_In_Parser            (Node_Id N)
      { return Flag4 (N); }
   INLINE Boolean   Is_Generic_Contract_Pragma     (Node_Id N)
      { return Flag2 (N); }
   INLINE Boolean   Is_Ignored                     (Node_Id N)
      { return Flag9 (N); }
   INLINE Boolean   Is_Ignored_Ghost_Pragma        (Node_Id N)
      { return Flag8 (N); }
   INLINE Boolean   Is_In_Discriminant_Check       (Node_Id N)
      { return Flag11 (N); }
   INLINE Boolean   Is_Inherited_Pragma            (Node_Id N)
      { return Flag4 (N); }
   INLINE Boolean   Is_Machine_Number              (Node_Id N)
      { return Flag11 (N); }
   INLINE Boolean   Is_Null_Loop                   (Node_Id N)
      { return Flag16 (N); }
   INLINE Boolean   Is_Overloaded                  (Node_Id N)
      { return Flag5 (N); }
   INLINE Boolean   Is_Power_Of_2_For_Shift        (Node_Id N)
      { return Flag13 (N); }
   INLINE Boolean   Is_Prefixed_Call               (Node_Id N)
      { return Flag17 (N); }
   INLINE Boolean   Is_Protected_Subprogram_Body   (Node_Id N)
      { return Flag7 (N); }
   INLINE Boolean   Is_Qualified_Universal_Literal (Node_Id N)
      { return Flag4 (N); }
   INLINE Boolean   Is_Static_Coextension          (Node_Id N)
      { return Flag14 (N); }
   INLINE Boolean   Is_Static_Expression           (Node_Id N)
      { return Flag6 (N); }
   INLINE Boolean   Is_Subprogram_Descriptor       (Node_Id N)
      { return Flag16 (N); }
   INLINE Boolean   Is_Task_Allocation_Block       (Node_Id N)
      { return Flag6 (N); }
   INLINE Boolean   Is_Task_Body_Procedure         (Node_Id N)
      { return Flag1 (N); }
   INLINE Boolean   Is_Task_Master                 (Node_Id N)
      { return Flag5 (N); }
   INLINE Node_Id   Iteration_Scheme               (Node_Id N)
      { return Node2 (N); }
   INLINE Node_Id   Iterator_Specification         (Node_Id N)
      { return Node2 (N); }
   INLINE Entity_Id Itype                          (Node_Id N)
      { return Node1 (N); }
   INLINE Boolean   Kill_Range_Check               (Node_Id N)
      { return Flag11 (N); }
   INLINE Node_Id   Label_Construct                (Node_Id N)
      { return Node2 (N); }
   INLINE Node_Id   Left_Opnd                      (Node_Id N)
      { return Node2 (N); }
   INLINE Node_Id   Last_Bit                       (Node_Id N)
      { return Node4 (N); }
   INLINE Boolean   Last_Name                      (Node_Id N)
      { return Flag6 (N); }
   INLINE Node_Id   Library_Unit                   (Node_Id N)
      { return Node4 (N); }
   INLINE Boolean   Limited_View_Installed         (Node_Id N)
      { return Flag18 (N); }
   INLINE Boolean   Limited_Present                (Node_Id N)
      { return Flag17 (N); }
   INLINE List_Id   Literals                       (Node_Id N)
      { return List1 (N); }
   INLINE Boolean   Local_Raise_Not_OK             (Node_Id N)
      { return Flag7 (N); }
   INLINE Elist_Id  Local_Raise_Statements         (Node_Id N)
      { return Elist1 (N); }
   INLINE List_Id   Loop_Actions                   (Node_Id N)
      { return List2 (N); }
   INLINE Node_Id   Loop_Parameter_Specification   (Node_Id N)
      { return Node4 (N); }
   INLINE Node_Id   Low_Bound                      (Node_Id N)
      { return Node1 (N); }
   INLINE Node_Id   Mod_Clause                     (Node_Id N)
      { return Node2 (N); }
   INLINE Boolean   More_Ids                       (Node_Id N)
      { return Flag5 (N); }
   INLINE Boolean   Must_Be_Byte_Aligned           (Node_Id N)
      { return Flag14 (N); }
   INLINE Boolean   Must_Not_Freeze                (Node_Id N)
      { return Flag8 (N); }
   INLINE Boolean   Must_Not_Override              (Node_Id N)
      { return Flag15 (N); }
   INLINE Boolean   Must_Override                  (Node_Id N)
      { return Flag14 (N); }
   INLINE Node_Id   Name                           (Node_Id N)
      { return Node2 (N); }
   INLINE List_Id   Names                          (Node_Id N)
      { return List2 (N); }
   INLINE Node_Id   Next_Entity                    (Node_Id N)
      { return Node2 (N); }
   INLINE Node_Id   Next_Exit_Statement            (Node_Id N)
      { return Node3 (N); }
   INLINE Node_Id   Next_Implicit_With             (Node_Id N)
      { return Node3 (N); }
   INLINE Node_Id   Next_Named_Actual              (Node_Id N)
      { return Node4 (N); }
   INLINE Node_Id   Next_Pragma                    (Node_Id N)
      { return Node1 (N); }
   INLINE Node_Id   Next_Rep_Item                  (Node_Id N)
      { return Node5 (N); }
   INLINE Node_Id   Next_Use_Clause                (Node_Id N)
      { return Node3 (N); }
   INLINE Boolean   No_Ctrl_Actions                (Node_Id N)
      { return Flag7 (N); }
   INLINE Boolean   No_Elaboration_Check           (Node_Id N)
      { return Flag14 (N); }
   INLINE Boolean   No_Entities_Ref_In_Spec        (Node_Id N)
      { return Flag8 (N); }
   INLINE Boolean   No_Initialization              (Node_Id N)
      { return Flag13 (N); }
   INLINE Boolean   No_Minimize_Eliminate          (Node_Id N)
      { return Flag17 (N); }
   INLINE Boolean   No_Side_Effect_Removal         (Node_Id N)
      { return Flag1 (N); }
   INLINE Boolean   No_Truncation                  (Node_Id N)
      { return Flag17 (N); }
   INLINE Boolean   Non_Aliased_Prefix             (Node_Id N)
      { return Flag18 (N); }
   INLINE Boolean   Null_Present                   (Node_Id N)
      { return Flag13 (N); }
   INLINE Boolean   Null_Excluding_Subtype         (Node_Id N)
      { return Flag16 (N); }
   INLINE Boolean   Null_Exclusion_Present         (Node_Id N)
      { return Flag11 (N); }
   INLINE Boolean   Null_Exclusion_In_Return_Present (Node_Id N)
      { return Flag14 (N); }
   INLINE Boolean   Null_Record_Present            (Node_Id N)
      { return Flag17 (N); }
   INLINE Node_Id   Object_Definition              (Node_Id N)
      { return Node4 (N); }
   INLINE Boolean   Of_Present                     (Node_Id N)
      { return Flag16 (N); }
   INLINE Node_Id   Original_Discriminant          (Node_Id N)
      { return Node2 (N); }
   INLINE Entity_Id Original_Entity                (Node_Id N)
      { return Node2 (N); }
   INLINE List_Id   Others_Discrete_Choices        (Node_Id N)
      { return List1 (N); }
   INLINE Boolean   Out_Present                    (Node_Id N)
      { return Flag17 (N); }
   INLINE List_Id   Parameter_Associations         (Node_Id N)
      { return List3 (N); }
   INLINE List_Id   Parameter_Specifications       (Node_Id N)
      { return List3 (N); }
   INLINE Node_Id   Parameter_Type                 (Node_Id N)
      { return Node2 (N); }
   INLINE Node_Id   Parent_Spec                    (Node_Id N)
      { return Node4 (N); }
   INLINE Node_Id   Position                       (Node_Id N)
      { return Node2 (N); }
   INLINE List_Id   Pragma_Argument_Associations   (Node_Id N)
      { return List2 (N); }
   INLINE Node_Id   Pragma_Identifier              (Node_Id N)
      { return Node4 (N); }
   INLINE List_Id   Pragmas_After                  (Node_Id N)
      { return List5 (N); }
   INLINE List_Id   Pragmas_Before                 (Node_Id N)
      { return List4 (N); }
   INLINE Node_Id   Pre_Post_Conditions            (Node_Id N)
      { return Node1 (N); }
   INLINE Node_Id   Prefix                         (Node_Id N)
      { return Node3 (N); }
   INLINE Node_Id   Premature_Use                  (Node_Id N)
      { return Node5 (N); }
   INLINE Uint      Present_Expr                   (Node_Id N)
      { return Uint3 (N); }
   INLINE Boolean   Prev_Ids                       (Node_Id N)
      { return Flag6 (N); }
   INLINE Boolean   Print_In_Hex                   (Node_Id N)
      { return Flag13 (N); }
   INLINE List_Id   Private_Declarations           (Node_Id N)
      { return List3 (N); }
   INLINE Boolean   Private_Present                (Node_Id N)
      { return Flag15 (N); }
   INLINE Node_Id   Procedure_To_Call              (Node_Id N)
      { return Node2 (N); }
   INLINE Node_Id   Proper_Body                    (Node_Id N)
      { return Node1 (N); }
   INLINE Node_Id   Protected_Definition           (Node_Id N)
      { return Node3 (N); }
   INLINE Boolean   Protected_Present              (Node_Id N)
      { return Flag6 (N); }
   INLINE Boolean   Raises_Constraint_Error        (Node_Id N)
      { return Flag7 (N); }
   INLINE Node_Id   Range_Constraint               (Node_Id N)
      { return Node4 (N); }
   INLINE Node_Id   Range_Expression               (Node_Id N)
      { return Node4 (N); }
   INLINE Node_Id   Real_Range_Specification       (Node_Id N)
      { return Node4 (N); }
   INLINE Ureal     Realval                        (Node_Id N)
      { return Ureal3 (N); }
   INLINE Uint      Reason                         (Node_Id N)
      { return Uint3 (N); }
   INLINE Node_Id   Record_Extension_Part          (Node_Id N)
      { return Node3 (N); }
   INLINE Boolean   Redundant_Use                  (Node_Id N)
      { return Flag13 (N); }
   INLINE Node_Id   Renaming_Exception             (Node_Id N)
      { return Node2 (N); }
   INLINE Node_Id   Result_Definition              (Node_Id N)
      { return Node4 (N); }
   INLINE List_Id   Return_Object_Declarations     (Node_Id N)
      { return List3 (N); }
   INLINE Node_Id   Return_Statement_Entity        (Node_Id N)
      { return Node5 (N); }
   INLINE Boolean   Reverse_Present                (Node_Id N)
      { return Flag15 (N); }
   INLINE Node_Id   Right_Opnd                     (Node_Id N)
      { return Node3 (N); }
   INLINE Boolean   Rounded_Result                 (Node_Id N)
      { return Flag18 (N); }
   INLINE Node_Id   SCIL_Controlling_Tag           (Node_Id N)
      { return Node5 (N); }
   INLINE Node_Id   SCIL_Entity                    (Node_Id N)
      { return Node4 (N); }
   INLINE Node_Id   SCIL_Tag_Value                 (Node_Id N)
      { return Node5 (N); }
   INLINE Node_Id   SCIL_Target_Prim               (Node_Id N)
      { return Node2 (N); }
   INLINE Node_Id   Scope                          (Node_Id N)
      { return Node3 (N); }
   INLINE List_Id   Select_Alternatives            (Node_Id N)
      { return List1 (N); }
   INLINE Node_Id   Selector_Name                  (Node_Id N)
      { return Node2 (N); }
   INLINE List_Id   Selector_Names                 (Node_Id N)
      { return List1 (N); }
   INLINE Boolean   Shift_Count_OK                 (Node_Id N)
      { return Flag4 (N); }
   INLINE Entity_Id Source_Type                    (Node_Id N)
      { return Node1 (N); }
   INLINE Node_Id   Specification                  (Node_Id N)
      { return Node1 (N); }
   INLINE Boolean   Split_PPC                      (Node_Id N)
      { return Flag17 (N); }
   INLINE List_Id   Statements                     (Node_Id N)
      { return List3 (N); }
   INLINE Node_Id   Storage_Pool                   (Node_Id N)
      { return Node1 (N); }
   INLINE Node_Id   Subpool_Handle_Name            (Node_Id N)
      { return Node4 (N); }
   INLINE String_Id Strval                         (Node_Id N)
      { return Str3 (N); }
   INLINE Node_Id   Subtype_Indication             (Node_Id N)
      { return Node5 (N); }
   INLINE Node_Id   Subtype_Mark                   (Node_Id N)
      { return Node4 (N); }
   INLINE List_Id   Subtype_Marks                  (Node_Id N)
      { return List2 (N); }
   INLINE Boolean   Suppress_Assignment_Checks     (Node_Id N)
      { return Flag18 (N); }
   INLINE Boolean   Suppress_Loop_Warnings         (Node_Id N)
      { return Flag17 (N); }
   INLINE Boolean   Synchronized_Present           (Node_Id N)
      { return Flag7 (N); }
   INLINE Boolean   Tagged_Present                 (Node_Id N)
      { return Flag15 (N); }
   INLINE Entity_Id Target_Type                    (Node_Id N)
      { return Node2 (N); }
   INLINE Node_Id   Task_Definition                (Node_Id N)
      { return Node3 (N); }
   INLINE Boolean   Task_Present                   (Node_Id N)
      { return Flag5 (N); }
   INLINE List_Id   Then_Actions                   (Node_Id N)
      { return List2 (N); }
   INLINE List_Id   Then_Statements                (Node_Id N)
      { return List2 (N); }
   INLINE Boolean   Treat_Fixed_As_Integer         (Node_Id N)
      { return Flag14 (N); }
   INLINE Node_Id   Triggering_Alternative         (Node_Id N)
      { return Node1 (N); }
   INLINE Node_Id   Triggering_Statement           (Node_Id N)
      { return Node1 (N); }
   INLINE Elist_Id  TSS_Elist                      (Node_Id N)
      { return Elist3 (N); }
   INLINE Node_Id   Type_Definition                (Node_Id N)
      { return Node3 (N); }
   INLINE Boolean   Uneval_Old_Accept              (Node_Id N)
      { return Flag7 (N); }
   INLINE Boolean   Uneval_Old_Warn                (Node_Id N)
      { return Flag18 (N); }
   INLINE Node_Id   Unit                           (Node_Id N)
      { return Node2 (N); }
   INLINE Boolean   Unknown_Discriminants_Present  (Node_Id N)
      { return Flag13 (N); }
   INLINE Boolean   Unreferenced_In_Spec           (Node_Id N)
      { return Flag7 (N); }
   INLINE Node_Id   Variant_Part                   (Node_Id N)
      { return Node4 (N); }
   INLINE List_Id   Variants                       (Node_Id N)
      { return List1 (N); }
   INLINE List_Id   Visible_Declarations           (Node_Id N)
      { return List2 (N); }
   INLINE Node_Id   Uninitialized_Variable         (Node_Id N)
      { return Node3 (N); }
   INLINE Elist_Id  Used_Operations                (Node_Id N)
      { return Elist5 (N); }
   INLINE Boolean   Was_Expression_Function        (Node_Id N)
      { return Flag18 (N); }
   INLINE Boolean   Was_Originally_Stub            (Node_Id N)
      { return Flag13 (N); }
   INLINE Node_Id   Withed_Body                    (Node_Id N)
      { return Node1 (N); }

#ifdef __cplusplus
}
#endif
