// auto generated tests from cfg/posix.cfg
//
// Generated by command:
// ./generate_cfg_tests cfg/posix.cfg > generated-cfg-tests-posix.cpp
//
// Recommended cppcheck command line:
// $ cppcheck --enable=warning,information --inline-suppr --platform=unix64 generated-cfg-tests-posix.cpp
// => 'unmatched suppression' warnings are false negatives.
//

void test__a64l__noreturn() {
  int x = 1;
  if (cond) { x=100; result = a64l(arg1); }
  // cppcheck-suppress shiftTooManyBits
  x = 1 << x;
}

void test__a64l__useretval() {
  // cppcheck-suppress ignoredReturnValue
  a64l(arg1);
}

void test__a64l__leakignore() {
  char *p = malloc(10); *p=0;
  result = a64l(p);
  // cppcheck-suppress memleak
}

void test__a64l__arg1__notnull() {
  // cppcheck-suppress nullPointer
  result = a64l(NULL);
}

void test__a64l__arg1__notuninit() {
  int x[10];
  // cppcheck-suppress uninitvar
  result = a64l(x);
}

void test__l64a__noreturn() {
  int x = 1;
  if (cond) { x=100; result = l64a(arg1); }
  // cppcheck-suppress shiftTooManyBits
  x = 1 << x;
}

void test__l64a__useretval() {
  // cppcheck-suppress ignoredReturnValue
  l64a(arg1);
}

void test__l64a__leakignore() {
  char *p = malloc(10); *p=0;
  result = l64a(p);
  // cppcheck-suppress memleak
}

void test__l64a__arg1__notuninit() {
  int x;
  // cppcheck-suppress uninitvar
  result = l64a(x);
}

void test__accept__noreturn() {
  int x = 1;
  if (cond) { x=100; accept(arg1, arg2, arg3); }
  // cppcheck-suppress shiftTooManyBits
  x = 1 << x;
}

void test__accept__leakignore() {
  char *p = malloc(10); *p=0;
  accept(p, arg2, arg3);
  // cppcheck-suppress memleak
}

void test__accept__arg1__notuninit() {
  int x;
  // cppcheck-suppress uninitvar
  accept(x, arg2, arg3);
}

void test__accept__arg2__notuninit() {
  int x;
  // cppcheck-suppress uninitvar
  accept(arg1, x, arg3);
}

void test__accept__arg3__notuninit() {
  int x;
  // cppcheck-suppress uninitvar
  accept(arg1, arg2, x);
}

void test__access__noreturn() {
  int x = 1;
  if (cond) { x=100; result = access(arg1, arg2); }
  // cppcheck-suppress shiftTooManyBits
  x = 1 << x;
}

void test__access__useretval() {
  // cppcheck-suppress ignoredReturnValue
  access(arg1, arg2);
}

void test__access__leakignore() {
  char *p = malloc(10); *p=0;
  result = access(p, arg2);
  // cppcheck-suppress memleak
}

void test__access__arg1__notnull() {
  // cppcheck-suppress nullPointer
  result = access(NULL, arg2);
}

void test__access__arg1__notuninit() {
  int x[10];
  // cppcheck-suppress uninitvar
  result = access(x, arg2);
}

void test__access__arg2__notuninit() {
  int x;
  // cppcheck-suppress uninitvar
  result = access(arg1, x);
}

void test__adjtime__noreturn() {
  int x = 1;
  if (cond) { x=100; adjtime(arg1, arg2); }
  // cppcheck-suppress shiftTooManyBits
  x = 1 << x;
}

void test__adjtime__leakignore() {
  char *p = malloc(10); *p=0;
  adjtime(p, arg2);
  // cppcheck-suppress memleak
}

void test__adjtime__arg1__notuninit() {
  int x;
  // cppcheck-suppress uninitvar
  adjtime(x, arg2);
}

void test__gettimeofday__noreturn() {
  int x = 1;
  if (cond) { x=100; gettimeofday(arg1, arg2); }
  // cppcheck-suppress shiftTooManyBits
  x = 1 << x;
}

void test__gettimeofday__leakignore() {
  char *p = malloc(10); *p=0;
  gettimeofday(p, arg2);
  // cppcheck-suppress memleak
}

void test__settimeofday__noreturn() {
  int x = 1;
  if (cond) { x=100; settimeofday(arg1, arg2); }
  // cppcheck-suppress shiftTooManyBits
  x = 1 << x;
}

void test__settimeofday__leakignore() {
  char *p = malloc(10); *p=0;
  settimeofday(p, arg2);
  // cppcheck-suppress memleak
}

void test__settimeofday__arg1__notuninit() {
  int x;
  // cppcheck-suppress uninitvar
  settimeofday(x, arg2);
}

void test__settimeofday__arg2__notuninit() {
  int x;
  // cppcheck-suppress uninitvar
  settimeofday(arg1, x);
}

void test__FD_CLR__noreturn() {
  int x = 1;
  if (cond) { x=100; FD_CLR(arg1, arg2); }
  // cppcheck-suppress shiftTooManyBits
  x = 1 << x;
}

void test__FD_CLR__leakignore() {
  char *p = malloc(10); *p=0;
  FD_CLR(p, arg2);
  // cppcheck-suppress memleak
}

void test__FD_CLR__arg1__notuninit() {
  int x;
  // cppcheck-suppress uninitvar
  FD_CLR(x, arg2);
}

void test__FD_CLR__arg2__notnull() {
  // cppcheck-suppress nullPointer
  FD_CLR(arg1, NULL);
}

void test__FD_ISSET__noreturn() {
  int x = 1;
  if (cond) { x=100; FD_ISSET(arg1, arg2); }
  // cppcheck-suppress shiftTooManyBits
  x = 1 << x;
}

void test__FD_ISSET__leakignore() {
  char *p = malloc(10); *p=0;
  FD_ISSET(p, arg2);
  // cppcheck-suppress memleak
}

void test__FD_ISSET__arg1__notuninit() {
  int x;
  // cppcheck-suppress uninitvar
  FD_ISSET(x, arg2);
}

void test__FD_ISSET__arg2__notnull() {
  // cppcheck-suppress nullPointer
  FD_ISSET(arg1, NULL);
}

void test__FD_SET__noreturn() {
  int x = 1;
  if (cond) { x=100; FD_SET(arg1, arg2); }
  // cppcheck-suppress shiftTooManyBits
  x = 1 << x;
}

void test__FD_SET__leakignore() {
  char *p = malloc(10); *p=0;
  FD_SET(p, arg2);
  // cppcheck-suppress memleak
}

void test__FD_SET__arg1__notuninit() {
  int x;
  // cppcheck-suppress uninitvar
  FD_SET(x, arg2);
}

void test__FD_SET__arg2__notnull() {
  // cppcheck-suppress nullPointer
  FD_SET(arg1, NULL);
}

void test__FD_ZERO__noreturn() {
  int x = 1;
  if (cond) { x=100; FD_ZERO(arg1); }
  // cppcheck-suppress shiftTooManyBits
  x = 1 << x;
}

void test__FD_ZERO__leakignore() {
  char *p = malloc(10); *p=0;
  FD_ZERO(p);
  // cppcheck-suppress memleak
}

void test__FD_ZERO__arg1__notnull() {
  // cppcheck-suppress nullPointer
  FD_ZERO(NULL);
}

void test__fdatasync__noreturn() {
  int x = 1;
  if (cond) { x=100; fdatasync(arg1); }
  // cppcheck-suppress shiftTooManyBits
  x = 1 << x;
}

void test__fdatasync__leakignore() {
  char *p = malloc(10); *p=0;
  fdatasync(p);
  // cppcheck-suppress memleak
}

void test__fdatasync__arg1__notuninit() {
  int x;
  // cppcheck-suppress uninitvar
  fdatasync(x);
}

void test__fnmatch__noreturn() {
  int x = 1;
  if (cond) { x=100; result = fnmatch(arg1, arg2, arg3); }
  // cppcheck-suppress shiftTooManyBits
  x = 1 << x;
}

void test__fnmatch__useretval() {
  // cppcheck-suppress ignoredReturnValue
  fnmatch(arg1, arg2, arg3);
}

void test__fnmatch__pure(int arg1,int arg2,int arg3) {
  // cppcheck-suppress incorrectLogicOperator
  if ((fnmatch(arg1, arg2, arg3) > 10) || (fnmatch(arg1, arg2, arg3) < 100)) {}
}

void test__fnmatch__leakignore() {
  char *p = malloc(10); *p=0;
  result = fnmatch(p, arg2, arg3);
  // cppcheck-suppress memleak
}

void test__fnmatch__arg1__notnull() {
  // cppcheck-suppress nullPointer
  result = fnmatch(NULL, arg2, arg3);
}

void test__fnmatch__arg1__notuninit() {
  int x[10];
  // cppcheck-suppress uninitvar
  result = fnmatch(x, arg2, arg3);
}

void test__fnmatch__arg2__notnull() {
  // cppcheck-suppress nullPointer
  result = fnmatch(arg1, NULL, arg3);
}

void test__fnmatch__arg2__notuninit() {
  int x[10];
  // cppcheck-suppress uninitvar
  result = fnmatch(arg1, x, arg3);
}

void test__fnmatch__arg3__notuninit() {
  int x;
  // cppcheck-suppress uninitvar
  result = fnmatch(arg1, arg2, x);
}

void test__fsync__noreturn() {
  int x = 1;
  if (cond) { x=100; fsync(arg1); }
  // cppcheck-suppress shiftTooManyBits
  x = 1 << x;
}

void test__fsync__leakignore() {
  char *p = malloc(10); *p=0;
  fsync(p);
  // cppcheck-suppress memleak
}

void test__fsync__arg1__notuninit() {
  int x;
  // cppcheck-suppress uninitvar
  fsync(x);
}

void test__truncate__noreturn() {
  int x = 1;
  if (cond) { x=100; truncate(arg1, arg2); }
  // cppcheck-suppress shiftTooManyBits
  x = 1 << x;
}

void test__truncate__leakignore() {
  char *p = malloc(10); *p=0;
  truncate(p, arg2);
  // cppcheck-suppress memleak
}

void test__truncate__arg1__notnull() {
  // cppcheck-suppress nullPointer
  truncate(NULL, arg2);
}

void test__truncate__arg1__notuninit() {
  int x[10];
  // cppcheck-suppress uninitvar
  truncate(x, arg2);
}

void test__truncate__arg2__notuninit() {
  int x;
  // cppcheck-suppress uninitvar
  truncate(arg1, x);
}

void test__ftruncate__noreturn() {
  int x = 1;
  if (cond) { x=100; ftruncate(arg1, arg2); }
  // cppcheck-suppress shiftTooManyBits
  x = 1 << x;
}

void test__ftruncate__leakignore() {
  char *p = malloc(10); *p=0;
  ftruncate(p, arg2);
  // cppcheck-suppress memleak
}

void test__ftruncate__arg1__notuninit() {
  int x;
  // cppcheck-suppress uninitvar
  ftruncate(x, arg2);
}

void test__ftruncate__arg2__notuninit() {
  int x;
  // cppcheck-suppress uninitvar
  ftruncate(arg1, x);
}

void test__flock__noreturn() {
  int x = 1;
  if (cond) { x=100; flock(arg1, arg2); }
  // cppcheck-suppress shiftTooManyBits
  x = 1 << x;
}

void test__flock__leakignore() {
  char *p = malloc(10); *p=0;
  flock(p, arg2);
  // cppcheck-suppress memleak
}

void test__flock__arg1__notuninit() {
  int x;
  // cppcheck-suppress uninitvar
  flock(x, arg2);
}

void test__flock__arg2__notuninit() {
  int x;
  // cppcheck-suppress uninitvar
  flock(arg1, x);
}

void test__symlink__noreturn() {
  int x = 1;
  if (cond) { x=100; symlink(arg1, arg2); }
  // cppcheck-suppress shiftTooManyBits
  x = 1 << x;
}

void test__symlink__leakignore() {
  char *p = malloc(10); *p=0;
  symlink(p, arg2);
  // cppcheck-suppress memleak
}

void test__symlink__arg1__notnull() {
  // cppcheck-suppress nullPointer
  symlink(NULL, arg2);
}

void test__symlink__arg1__notuninit() {
  int x[10];
  // cppcheck-suppress uninitvar
  symlink(x, arg2);
}

void test__symlink__arg2__notnull() {
  // cppcheck-suppress nullPointer
  symlink(arg1, NULL);
}

void test__symlink__arg2__notuninit() {
  int x[10];
  // cppcheck-suppress uninitvar
  symlink(arg1, x);
}

void test__open__noreturn() {
  int x = 1;
  if (cond) { x=100; open(arg1, arg2, arg3); }
  // cppcheck-suppress shiftTooManyBits
  x = 1 << x;
}

void test__open__arg1__notnull() {
  // cppcheck-suppress nullPointer
  open(NULL, arg2, arg3);
}

void test__open__arg1__notuninit() {
  int x[10];
  // cppcheck-suppress uninitvar
  open(x, arg2, arg3);
}

void test__open__arg2__notuninit() {
  int x;
  // cppcheck-suppress uninitvar
  open(arg1, x, arg3);
}

void test__open__arg3__notuninit() {
  int x;
  // cppcheck-suppress uninitvar
  open(arg1, arg2, x);
}

void test__creat__noreturn() {
  int x = 1;
  if (cond) { x=100; result = creat(arg1, arg2); }
  // cppcheck-suppress shiftTooManyBits
  x = 1 << x;
}

void test__creat__useretval() {
  // cppcheck-suppress ignoredReturnValue
  creat(arg1, arg2);
}

void test__creat__arg1__notnull() {
  // cppcheck-suppress nullPointer
  result = creat(NULL, arg2);
}

void test__creat__arg1__notuninit() {
  int x[10];
  // cppcheck-suppress uninitvar
  result = creat(x, arg2);
}

void test__creat__arg2__notuninit() {
  int x;
  // cppcheck-suppress uninitvar
  result = creat(arg1, x);
}

void test__sleep__noreturn() {
  int x = 1;
  if (cond) { x=100; sleep(arg1); }
  // cppcheck-suppress shiftTooManyBits
  x = 1 << x;
}

void test__sleep__leakignore() {
  char *p = malloc(10); *p=0;
  sleep(p);
  // cppcheck-suppress memleak
}

void test__sleep__arg1__notbool() {
  // cppcheck-suppress invalidFunctionArgBool
  sleep(!x);
}

void test__sleep__arg1__notuninit() {
  int x;
  // cppcheck-suppress uninitvar
  sleep(x);
}

void test__usleep__noreturn() {
  int x = 1;
  if (cond) { x=100; usleep(arg1); }
  // cppcheck-suppress shiftTooManyBits
  x = 1 << x;
}

void test__usleep__leakignore() {
  char *p = malloc(10); *p=0;
  usleep(p);
  // cppcheck-suppress memleak
}

void test__usleep__arg1__notbool() {
  // cppcheck-suppress invalidFunctionArgBool
  usleep(!x);
}

void test___exit__noreturn() {
  int x = 1;
  if (cond) { x=100; _exit(arg1); }
  // cppcheck-suppress shiftTooManyBits
  x = 1 << x;
}

void test___exit__arg1__notuninit() {
  int x;
  // cppcheck-suppress uninitvar
  _exit(x);
}

void test__faccessat__noreturn() {
  int x = 1;
  if (cond) { x=100; faccessat(arg1, arg2, arg3, arg4); }
  // cppcheck-suppress shiftTooManyBits
  x = 1 << x;
}

void test__faccessat__leakignore() {
  char *p = malloc(10); *p=0;
  faccessat(p, arg2, arg3, arg4);
  // cppcheck-suppress memleak
}

void test__faccessat__arg1__notuninit() {
  int x;
  // cppcheck-suppress uninitvar
  faccessat(x, arg2, arg3, arg4);
}

void test__faccessat__arg2__notnull() {
  // cppcheck-suppress nullPointer
  faccessat(arg1, NULL, arg3, arg4);
}

void test__faccessat__arg2__notuninit() {
  int x[10];
  // cppcheck-suppress uninitvar
  faccessat(arg1, x, arg3, arg4);
}

void test__faccessat__arg3__notuninit() {
  int x;
  // cppcheck-suppress uninitvar
  faccessat(arg1, arg2, x, arg4);
}

void test__faccessat__arg4__notuninit() {
  int x;
  // cppcheck-suppress uninitvar
  faccessat(arg1, arg2, arg3, x);
}

void test__acct__noreturn() {
  int x = 1;
  if (cond) { x=100; acct(arg1); }
  // cppcheck-suppress shiftTooManyBits
  x = 1 << x;
}

void test__acct__leakignore() {
  char *p = malloc(10); *p=0;
  acct(p);
  // cppcheck-suppress memleak
}

void test__acct__arg1__notuninit() {
  int x;
  // cppcheck-suppress uninitvar
  acct(x);
}

void test__alarm__noreturn() {
  int x = 1;
  if (cond) { x=100; alarm(arg1); }
  // cppcheck-suppress shiftTooManyBits
  x = 1 << x;
}

void test__alarm__leakignore() {
  char *p = malloc(10); *p=0;
  alarm(p);
  // cppcheck-suppress memleak
}

void test__alarm__arg1__notuninit() {
  int x;
  // cppcheck-suppress uninitvar
  alarm(x);
}

void test__getrpcent__noreturn() {
  int x = 1;
  if (cond) { x=100; result = getrpcent(); }
  // cppcheck-suppress shiftTooManyBits
  x = 1 << x;
}

void test__getrpcent__useretval() {
  // cppcheck-suppress ignoredReturnValue
  getrpcent();
}

void test__getrpcent__leakignore() {
  char *p = malloc(10); *p=0;
  result = getrpcent();
  // cppcheck-suppress memleak
}

void test__getrpcbyname__noreturn() {
  int x = 1;
  if (cond) { x=100; result = getrpcbyname(arg1); }
  // cppcheck-suppress shiftTooManyBits
  x = 1 << x;
}

void test__getrpcbyname__useretval() {
  // cppcheck-suppress ignoredReturnValue
  getrpcbyname(arg1);
}

void test__getrpcbyname__leakignore() {
  char *p = malloc(10); *p=0;
  result = getrpcbyname(p);
  // cppcheck-suppress memleak
}

void test__getrpcbyname__arg1__notnull() {
  // cppcheck-suppress nullPointer
  result = getrpcbyname(NULL);
}

void test__getrpcbyname__arg1__notuninit() {
  int x[10];
  // cppcheck-suppress uninitvar
  result = getrpcbyname(x);
}

void test__getrpcbynumber__noreturn() {
  int x = 1;
  if (cond) { x=100; result = getrpcbynumber(arg1); }
  // cppcheck-suppress shiftTooManyBits
  x = 1 << x;
}

void test__getrpcbynumber__useretval() {
  // cppcheck-suppress ignoredReturnValue
  getrpcbynumber(arg1);
}

void test__getrpcbynumber__leakignore() {
  char *p = malloc(10); *p=0;
  result = getrpcbynumber(p);
  // cppcheck-suppress memleak
}

void test__getrpcbynumber__arg1__notuninit() {
  int x;
  // cppcheck-suppress uninitvar
  result = getrpcbynumber(x);
}

void test__getprotoent__noreturn() {
  int x = 1;
  if (cond) { x=100; result = getprotoent(); }
  // cppcheck-suppress shiftTooManyBits
  x = 1 << x;
}

void test__getprotoent__useretval() {
  // cppcheck-suppress ignoredReturnValue
  getprotoent();
}

void test__getprotoent__leakignore() {
  char *p = malloc(10); *p=0;
  result = getprotoent();
  // cppcheck-suppress memleak
}

void test__getprotobyname__noreturn() {
  int x = 1;
  if (cond) { x=100; result = getprotobyname(arg1); }
  // cppcheck-suppress shiftTooManyBits
  x = 1 << x;
}

void test__getprotobyname__useretval() {
  // cppcheck-suppress ignoredReturnValue
  getprotobyname(arg1);
}

void test__getprotobyname__leakignore() {
  char *p = malloc(10); *p=0;
  result = getprotobyname(p);
  // cppcheck-suppress memleak
}

void test__getprotobyname__arg1__notnull() {
  // cppcheck-suppress nullPointer
  result = getprotobyname(NULL);
}

void test__getprotobyname__arg1__notuninit() {
  int x[10];
  // cppcheck-suppress uninitvar
  result = getprotobyname(x);
}

void test__getprotobynumber__noreturn() {
  int x = 1;
  if (cond) { x=100; result = getprotobynumber(arg1); }
  // cppcheck-suppress shiftTooManyBits
  x = 1 << x;
}

void test__getprotobynumber__useretval() {
  // cppcheck-suppress ignoredReturnValue
  getprotobynumber(arg1);
}

void test__getprotobynumber__leakignore() {
  char *p = malloc(10); *p=0;
  result = getprotobynumber(p);
  // cppcheck-suppress memleak
}

void test__getprotobynumber__arg1__notuninit() {
  int x;
  // cppcheck-suppress uninitvar
  result = getprotobynumber(x);
}

void test__getservent__noreturn() {
  int x = 1;
  if (cond) { x=100; result = getservent(); }
  // cppcheck-suppress shiftTooManyBits
  x = 1 << x;
}

void test__getservent__useretval() {
  // cppcheck-suppress ignoredReturnValue
  getservent();
}

void test__getservent__leakignore() {
  char *p = malloc(10); *p=0;
  result = getservent();
  // cppcheck-suppress memleak
}

void test__getservbyname__noreturn() {
  int x = 1;
  if (cond) { x=100; result = getservbyname(arg1, arg2); }
  // cppcheck-suppress shiftTooManyBits
  x = 1 << x;
}

void test__getservbyname__useretval() {
  // cppcheck-suppress ignoredReturnValue
  getservbyname(arg1, arg2);
}

void test__getservbyname__leakignore() {
  char *p = malloc(10); *p=0;
  result = getservbyname(p, arg2);
  // cppcheck-suppress memleak
}

void test__getservbyname__arg1__notnull() {
  // cppcheck-suppress nullPointer
  result = getservbyname(NULL, arg2);
}

void test__getservbyname__arg1__notuninit() {
  int x[10];
  // cppcheck-suppress uninitvar
  result = getservbyname(x, arg2);
}

void test__getservbyname__arg2__notuninit() {
  int x;
  // cppcheck-suppress uninitvar
  result = getservbyname(arg1, x);
}

void test__getservbyport__noreturn() {
  int x = 1;
  if (cond) { x=100; result = getservbyport(arg1, arg2); }
  // cppcheck-suppress shiftTooManyBits
  x = 1 << x;
}

void test__getservbyport__useretval() {
  // cppcheck-suppress ignoredReturnValue
  getservbyport(arg1, arg2);
}

void test__getservbyport__leakignore() {
  char *p = malloc(10); *p=0;
  result = getservbyport(p, arg2);
  // cppcheck-suppress memleak
}

void test__getservbyport__arg1__notuninit() {
  int x;
  // cppcheck-suppress uninitvar
  result = getservbyport(x, arg2);
}

void test__getservbyport__arg2__notuninit() {
  int x;
  // cppcheck-suppress uninitvar
  result = getservbyport(arg1, x);
}

void test__getnetent__noreturn() {
  int x = 1;
  if (cond) { x=100; result = getnetent(); }
  // cppcheck-suppress shiftTooManyBits
  x = 1 << x;
}

void test__getnetent__useretval() {
  // cppcheck-suppress ignoredReturnValue
  getnetent();
}

void test__getnetent__leakignore() {
  char *p = malloc(10); *p=0;
  result = getnetent();
  // cppcheck-suppress memleak
}

void test__getnetbyname__noreturn() {
  int x = 1;
  if (cond) { x=100; result = getnetbyname(arg1); }
  // cppcheck-suppress shiftTooManyBits
  x = 1 << x;
}

void test__getnetbyname__useretval() {
  // cppcheck-suppress ignoredReturnValue
  getnetbyname(arg1);
}

void test__getnetbyname__leakignore() {
  char *p = malloc(10); *p=0;
  result = getnetbyname(p);
  // cppcheck-suppress memleak
}

void test__getnetbyname__arg1__notnull() {
  // cppcheck-suppress nullPointer
  result = getnetbyname(NULL);
}

void test__getnetbyname__arg1__notuninit() {
  int x[10];
  // cppcheck-suppress uninitvar
  result = getnetbyname(x);
}

void test__getnetbyaddr__noreturn() {
  int x = 1;
  if (cond) { x=100; result = getnetbyaddr(arg1, arg2); }
  // cppcheck-suppress shiftTooManyBits
  x = 1 << x;
}

void test__getnetbyaddr__useretval() {
  // cppcheck-suppress ignoredReturnValue
  getnetbyaddr(arg1, arg2);
}

void test__getnetbyaddr__leakignore() {
  char *p = malloc(10); *p=0;
  result = getnetbyaddr(p, arg2);
  // cppcheck-suppress memleak
}

void test__getnetbyaddr__arg1__notuninit() {
  int x;
  // cppcheck-suppress uninitvar
  result = getnetbyaddr(x, arg2);
}

void test__getnetbyaddr__arg2__notuninit() {
  int x;
  // cppcheck-suppress uninitvar
  result = getnetbyaddr(arg1, x);
}

void test__gethostent__noreturn() {
  int x = 1;
  if (cond) { x=100; result = gethostent(); }
  // cppcheck-suppress shiftTooManyBits
  x = 1 << x;
}

void test__gethostent__useretval() {
  // cppcheck-suppress ignoredReturnValue
  gethostent();
}

void test__gethostent__leakignore() {
  char *p = malloc(10); *p=0;
  result = gethostent();
  // cppcheck-suppress memleak
}

void test__gethostbyname__noreturn() {
  int x = 1;
  if (cond) { x=100; result = gethostbyname(arg1); }
  // cppcheck-suppress shiftTooManyBits
  x = 1 << x;
}

void test__gethostbyname__useretval() {
  // cppcheck-suppress ignoredReturnValue
  gethostbyname(arg1);
}

void test__gethostbyname__leakignore() {
  char *p = malloc(10); *p=0;
  result = gethostbyname(p);
  // cppcheck-suppress memleak
}

void test__gethostbyname__arg1__notnull() {
  // cppcheck-suppress nullPointer
  result = gethostbyname(NULL);
}

void test__gethostbyname__arg1__notuninit() {
  int x[10];
  // cppcheck-suppress uninitvar
  result = gethostbyname(x);
}

void test__gethostbyname2__noreturn() {
  int x = 1;
  if (cond) { x=100; result = gethostbyname2(arg1, arg2); }
  // cppcheck-suppress shiftTooManyBits
  x = 1 << x;
}

void test__gethostbyname2__useretval() {
  // cppcheck-suppress ignoredReturnValue
  gethostbyname2(arg1, arg2);
}

void test__gethostbyname2__leakignore() {
  char *p = malloc(10); *p=0;
  result = gethostbyname2(p, arg2);
  // cppcheck-suppress memleak
}

void test__gethostbyname2__arg1__notnull() {
  // cppcheck-suppress nullPointer
  result = gethostbyname2(NULL, arg2);
}

void test__gethostbyname2__arg1__notuninit() {
  int x[10];
  // cppcheck-suppress uninitvar
  result = gethostbyname2(x, arg2);
}

void test__gethostbyname2__arg2__notuninit() {
  int x;
  // cppcheck-suppress uninitvar
  result = gethostbyname2(arg1, x);
}

void test__gethostbyaddr__noreturn() {
  int x = 1;
  if (cond) { x=100; result = gethostbyaddr(arg1, arg2, arg3); }
  // cppcheck-suppress shiftTooManyBits
  x = 1 << x;
}

void test__gethostbyaddr__useretval() {
  // cppcheck-suppress ignoredReturnValue
  gethostbyaddr(arg1, arg2, arg3);
}

void test__gethostbyaddr__leakignore() {
  char *p = malloc(10); *p=0;
  result = gethostbyaddr(p, arg2, arg3);
  // cppcheck-suppress memleak
}

void test__gethostbyaddr__arg1__notnull() {
  // cppcheck-suppress nullPointer
  result = gethostbyaddr(NULL, arg2, arg3);
}

void test__gethostbyaddr__arg1__notuninit() {
  int x[10];
  // cppcheck-suppress uninitvar
  result = gethostbyaddr(x, arg2, arg3);
}

void test__gethostbyaddr__arg2__notuninit() {
  int x;
  // cppcheck-suppress uninitvar
  result = gethostbyaddr(arg1, x, arg3);
}

void test__gethostbyaddr__arg3__notuninit() {
  int x;
  // cppcheck-suppress uninitvar
  result = gethostbyaddr(arg1, arg2, x);
}

void test__brk__noreturn() {
  int x = 1;
  if (cond) { x=100; brk(arg1); }
  // cppcheck-suppress shiftTooManyBits
  x = 1 << x;
}

void test__brk__leakignore() {
  char *p = malloc(10); *p=0;
  brk(p);
  // cppcheck-suppress memleak
}

void test__brk__arg1__notnull() {
  // cppcheck-suppress nullPointer
  brk(NULL);
}

void test__sbrk__noreturn() {
  int x = 1;
  if (cond) { x=100; sbrk(arg1); }
  // cppcheck-suppress shiftTooManyBits
  x = 1 << x;
}

void test__sbrk__leakignore() {
  char *p = malloc(10); *p=0;
  sbrk(p);
  // cppcheck-suppress memleak
}

void test__sbrk__arg1__notuninit() {
  int x;
  // cppcheck-suppress uninitvar
  sbrk(x);
}

void test__closedir__noreturn() {
  int x = 1;
  if (cond) { x=100; closedir(arg1); }
  // cppcheck-suppress shiftTooManyBits
  x = 1 << x;
}

void test__closedir__arg1__notbool() {
  // cppcheck-suppress invalidFunctionArgBool
  closedir(!x);
}

void test__closedir__arg1__notnull() {
  // cppcheck-suppress nullPointer
  closedir(NULL);
}

void test__closedir__arg1__notuninit() {
  int x[10];
  // cppcheck-suppress uninitvar
  closedir(x);
}

void test__strfry__noreturn() {
  int x = 1;
  if (cond) { x=100; strfry(arg1); }
  // cppcheck-suppress shiftTooManyBits
  x = 1 << x;
}

void test__strfry__arg1__notnull() {
  // cppcheck-suppress nullPointer
  strfry(NULL);
}

void test__strsep__noreturn() {
  int x = 1;
  if (cond) { x=100; strsep(arg1, arg2); }
  // cppcheck-suppress shiftTooManyBits
  x = 1 << x;
}

void test__strsep__leakignore() {
  char *p = malloc(10); *p=0;
  strsep(p, arg2);
  // cppcheck-suppress memleak
}

void test__strsep__arg1__notnull() {
  // cppcheck-suppress nullPointer
  strsep(NULL, arg2);
}

void test__strsep__arg1__notuninit() {
  int x[10];
  // cppcheck-suppress uninitvar
  strsep(x, arg2);
}

void test__strsep__arg2__notnull() {
  // cppcheck-suppress nullPointer
  strsep(arg1, NULL);
}

void test__strsep__arg2__notuninit() {
  int x[10];
  // cppcheck-suppress uninitvar
  strsep(arg1, x);
}

void test__strdup__noreturn() {
  int x = 1;
  if (cond) { x=100; strdup(arg1); }
  // cppcheck-suppress shiftTooManyBits
  x = 1 << x;
}

void test__strdup__arg1__notnull() {
  // cppcheck-suppress nullPointer
  strdup(NULL);
}

void test__strdup__arg1__notuninit() {
  int x[10];
  // cppcheck-suppress uninitvar
  strdup(x);
}

void test__strndup__noreturn() {
  int x = 1;
  if (cond) { x=100; strndup(arg1, arg2); }
  // cppcheck-suppress shiftTooManyBits
  x = 1 << x;
}

void test__strndup__arg1__notnull() {
  // cppcheck-suppress nullPointer
  strndup(NULL, arg2);
}

void test__strndup__arg1__notuninit() {
  int x[10];
  // cppcheck-suppress uninitvar
  strndup(x, arg2);
}

void test__strndup__arg2__notuninit() {
  int x;
  // cppcheck-suppress uninitvar
  strndup(arg1, x);
}

void test__wcsdup__noreturn() {
  int x = 1;
  if (cond) { x=100; wcsdup(arg1); }
  // cppcheck-suppress shiftTooManyBits
  x = 1 << x;
}

void test__wcsdup__arg1__notnull() {
  // cppcheck-suppress nullPointer
  wcsdup(NULL);
}

void test__wcsdup__arg1__notuninit() {
  int x[10];
  // cppcheck-suppress uninitvar
  wcsdup(x);
}

void test__mkstemp__noreturn() {
  int x = 1;
  if (cond) { x=100; mkstemp(arg1); }
  // cppcheck-suppress shiftTooManyBits
  x = 1 << x;
}

void test__mkstemp__leakignore() {
  char *p = malloc(10); *p=0;
  mkstemp(p);
  // cppcheck-suppress memleak
}

void test__mkstemp__arg1__notnull() {
  // cppcheck-suppress nullPointer
  mkstemp(NULL);
}

void test__mkstemp__arg1__notuninit() {
  int x[10];
  // cppcheck-suppress uninitvar
  mkstemp(x);
}

void test__mkdtemp__noreturn() {
  int x = 1;
  if (cond) { x=100; mkdtemp(arg1); }
  // cppcheck-suppress shiftTooManyBits
  x = 1 << x;
}

void test__mkdtemp__leakignore() {
  char *p = malloc(10); *p=0;
  mkdtemp(p);
  // cppcheck-suppress memleak
}

void test__mkdtemp__arg1__notnull() {
  // cppcheck-suppress nullPointer
  mkdtemp(NULL);
}

void test__mkdtemp__arg1__notuninit() {
  int x[10];
  // cppcheck-suppress uninitvar
  mkdtemp(x);
}

void test__mktemp__noreturn() {
  int x = 1;
  if (cond) { x=100; result = mktemp(arg1); }
  // cppcheck-suppress shiftTooManyBits
  x = 1 << x;
}

void test__mktemp__useretval() {
  // cppcheck-suppress ignoredReturnValue
  mktemp(arg1);
}

void test__mktemp__leakignore() {
  char *p = malloc(10); *p=0;
  result = mktemp(p);
  // cppcheck-suppress memleak
}

void test__mktemp__arg1__notnull() {
  // cppcheck-suppress nullPointer
  result = mktemp(NULL);
}

void test__mktemp__arg1__notuninit() {
  int x[10];
  // cppcheck-suppress uninitvar
  result = mktemp(x);
}

void test__getcwd__noreturn() {
  int x = 1;
  if (cond) { x=100; getcwd(arg1, arg2); }
  // cppcheck-suppress shiftTooManyBits
  x = 1 << x;
}

void test__getcwd__leakignore() {
  char *p = malloc(10); *p=0;
  getcwd(p, arg2);
  // cppcheck-suppress memleak
}

void test__getcwd__arg1__notuninit() {
  int x;
  // cppcheck-suppress uninitvar
  getcwd(x, arg2);
}

void test__getcwd__arg2__notuninit() {
  int x;
  // cppcheck-suppress uninitvar
  getcwd(arg1, x);
}

void test__mkdir__noreturn() {
  int x = 1;
  if (cond) { x=100; mkdir(arg1, arg2); }
  // cppcheck-suppress shiftTooManyBits
  x = 1 << x;
}

void test__mkdir__leakignore() {
  char *p = malloc(10); *p=0;
  mkdir(p, arg2);
  // cppcheck-suppress memleak
}

void test__mkdir__arg1__notnull() {
  // cppcheck-suppress nullPointer
  mkdir(NULL, arg2);
}

void test__mkdir__arg1__notuninit() {
  int x[10];
  // cppcheck-suppress uninitvar
  mkdir(x, arg2);
}

void test__mkdir__arg2__notuninit() {
  int x;
  // cppcheck-suppress uninitvar
  mkdir(arg1, x);
}

void test__rmdir__noreturn() {
  int x = 1;
  if (cond) { x=100; rmdir(arg1); }
  // cppcheck-suppress shiftTooManyBits
  x = 1 << x;
}

void test__rmdir__leakignore() {
  char *p = malloc(10); *p=0;
  rmdir(p);
  // cppcheck-suppress memleak
}

void test__rmdir__arg1__notnull() {
  // cppcheck-suppress nullPointer
  rmdir(NULL);
}

void test__rmdir__arg1__notuninit() {
  int x[10];
  // cppcheck-suppress uninitvar
  rmdir(x);
}

void test__chdir__noreturn() {
  int x = 1;
  if (cond) { x=100; chdir(arg1); }
  // cppcheck-suppress shiftTooManyBits
  x = 1 << x;
}

void test__chdir__leakignore() {
  char *p = malloc(10); *p=0;
  chdir(p);
  // cppcheck-suppress memleak
}

void test__chdir__arg1__notnull() {
  // cppcheck-suppress nullPointer
  chdir(NULL);
}

void test__chdir__arg1__notuninit() {
  int x[10];
  // cppcheck-suppress uninitvar
  chdir(x);
}

void test__chroot__noreturn() {
  int x = 1;
  if (cond) { x=100; chroot(arg1); }
  // cppcheck-suppress shiftTooManyBits
  x = 1 << x;
}

void test__chroot__leakignore() {
  char *p = malloc(10); *p=0;
  chroot(p);
  // cppcheck-suppress memleak
}

void test__chroot__arg1__notnull() {
  // cppcheck-suppress nullPointer
  chroot(NULL);
}

void test__chroot__arg1__notuninit() {
  int x[10];
  // cppcheck-suppress uninitvar
  chroot(x);
}

void test__link__noreturn() {
  int x = 1;
  if (cond) { x=100; link(arg1, arg2); }
  // cppcheck-suppress shiftTooManyBits
  x = 1 << x;
}

void test__link__leakignore() {
  char *p = malloc(10); *p=0;
  link(p, arg2);
  // cppcheck-suppress memleak
}

void test__link__arg1__notnull() {
  // cppcheck-suppress nullPointer
  link(NULL, arg2);
}

void test__link__arg1__notuninit() {
  int x[10];
  // cppcheck-suppress uninitvar
  link(x, arg2);
}

void test__link__arg2__notnull() {
  // cppcheck-suppress nullPointer
  link(arg1, NULL);
}

void test__link__arg2__notuninit() {
  int x[10];
  // cppcheck-suppress uninitvar
  link(arg1, x);
}

void test__unlink__noreturn() {
  int x = 1;
  if (cond) { x=100; unlink(arg1); }
  // cppcheck-suppress shiftTooManyBits
  x = 1 << x;
}

void test__unlink__leakignore() {
  char *p = malloc(10); *p=0;
  unlink(p);
  // cppcheck-suppress memleak
}

void test__unlink__arg1__notnull() {
  // cppcheck-suppress nullPointer
  unlink(NULL);
}

void test__unlink__arg1__notuninit() {
  int x[10];
  // cppcheck-suppress uninitvar
  unlink(x);
}

void test__stat__noreturn() {
  int x = 1;
  if (cond) { x=100; stat(arg1, arg2); }
  // cppcheck-suppress shiftTooManyBits
  x = 1 << x;
}

void test__stat__leakignore() {
  char *p = malloc(10); *p=0;
  stat(p, arg2);
  // cppcheck-suppress memleak
}

void test__stat__arg1__notnull() {
  // cppcheck-suppress nullPointer
  stat(NULL, arg2);
}

void test__stat__arg1__notuninit() {
  int x[10];
  // cppcheck-suppress uninitvar
  stat(x, arg2);
}

void test__stat__arg2__notnull() {
  // cppcheck-suppress nullPointer
  stat(arg1, NULL);
}

void test__lstat__noreturn() {
  int x = 1;
  if (cond) { x=100; lstat(arg1, arg2); }
  // cppcheck-suppress shiftTooManyBits
  x = 1 << x;
}

void test__lstat__leakignore() {
  char *p = malloc(10); *p=0;
  lstat(p, arg2);
  // cppcheck-suppress memleak
}

void test__lstat__arg1__notnull() {
  // cppcheck-suppress nullPointer
  lstat(NULL, arg2);
}

void test__lstat__arg1__notuninit() {
  int x[10];
  // cppcheck-suppress uninitvar
  lstat(x, arg2);
}

void test__lstat__arg2__notnull() {
  // cppcheck-suppress nullPointer
  lstat(arg1, NULL);
}

void test__fstat__noreturn() {
  int x = 1;
  if (cond) { x=100; fstat(arg1, arg2); }
  // cppcheck-suppress shiftTooManyBits
  x = 1 << x;
}

void test__fstat__leakignore() {
  char *p = malloc(10); *p=0;
  fstat(p, arg2);
  // cppcheck-suppress memleak
}

void test__fstat__arg1__notuninit() {
  int x;
  // cppcheck-suppress uninitvar
  fstat(x, arg2);
}

void test__fstat__arg2__notnull() {
  // cppcheck-suppress nullPointer
  fstat(arg1, NULL);
}

void test__chmod__noreturn() {
  int x = 1;
  if (cond) { x=100; chmod(arg1, arg2); }
  // cppcheck-suppress shiftTooManyBits
  x = 1 << x;
}

void test__chmod__leakignore() {
  char *p = malloc(10); *p=0;
  chmod(p, arg2);
  // cppcheck-suppress memleak
}

void test__chmod__arg1__notnull() {
  // cppcheck-suppress nullPointer
  chmod(NULL, arg2);
}

void test__chmod__arg1__notuninit() {
  int x[10];
  // cppcheck-suppress uninitvar
  chmod(x, arg2);
}

void test__chmod__arg2__notuninit() {
  int x;
  // cppcheck-suppress uninitvar
  chmod(arg1, x);
}

void test__fchmod__noreturn() {
  int x = 1;
  if (cond) { x=100; fchmod(arg1, arg2); }
  // cppcheck-suppress shiftTooManyBits
  x = 1 << x;
}

void test__fchmod__leakignore() {
  char *p = malloc(10); *p=0;
  fchmod(p, arg2);
  // cppcheck-suppress memleak
}

void test__fchmod__arg1__notuninit() {
  int x;
  // cppcheck-suppress uninitvar
  fchmod(x, arg2);
}

void test__fchmod__arg2__notuninit() {
  int x;
  // cppcheck-suppress uninitvar
  fchmod(arg1, x);
}

void test__chown__noreturn() {
  int x = 1;
  if (cond) { x=100; chown(arg1, arg2, arg3); }
  // cppcheck-suppress shiftTooManyBits
  x = 1 << x;
}

void test__chown__leakignore() {
  char *p = malloc(10); *p=0;
  chown(p, arg2, arg3);
  // cppcheck-suppress memleak
}

void test__chown__arg1__notnull() {
  // cppcheck-suppress nullPointer
  chown(NULL, arg2, arg3);
}

void test__chown__arg1__notuninit() {
  int x[10];
  // cppcheck-suppress uninitvar
  chown(x, arg2, arg3);
}

void test__chown__arg2__notuninit() {
  int x;
  // cppcheck-suppress uninitvar
  chown(arg1, x, arg3);
}

void test__chown__arg3__notuninit() {
  int x;
  // cppcheck-suppress uninitvar
  chown(arg1, arg2, x);
}

void test__lchown__noreturn() {
  int x = 1;
  if (cond) { x=100; lchown(arg1, arg2, arg3); }
  // cppcheck-suppress shiftTooManyBits
  x = 1 << x;
}

void test__lchown__leakignore() {
  char *p = malloc(10); *p=0;
  lchown(p, arg2, arg3);
  // cppcheck-suppress memleak
}

void test__lchown__arg1__notnull() {
  // cppcheck-suppress nullPointer
  lchown(NULL, arg2, arg3);
}

void test__lchown__arg1__notuninit() {
  int x[10];
  // cppcheck-suppress uninitvar
  lchown(x, arg2, arg3);
}

void test__lchown__arg2__notuninit() {
  int x;
  // cppcheck-suppress uninitvar
  lchown(arg1, x, arg3);
}

void test__lchown__arg3__notuninit() {
  int x;
  // cppcheck-suppress uninitvar
  lchown(arg1, arg2, x);
}

void test__fchown__noreturn() {
  int x = 1;
  if (cond) { x=100; fchown(arg1, arg2, arg3); }
  // cppcheck-suppress shiftTooManyBits
  x = 1 << x;
}

void test__fchown__leakignore() {
  char *p = malloc(10); *p=0;
  fchown(p, arg2, arg3);
  // cppcheck-suppress memleak
}

void test__fchown__arg1__notuninit() {
  int x;
  // cppcheck-suppress uninitvar
  fchown(x, arg2, arg3);
}

void test__fchown__arg2__notuninit() {
  int x;
  // cppcheck-suppress uninitvar
  fchown(arg1, x, arg3);
}

void test__fchown__arg3__notuninit() {
  int x;
  // cppcheck-suppress uninitvar
  fchown(arg1, arg2, x);
}

void test__times__noreturn() {
  int x = 1;
  if (cond) { x=100; times(arg1); }
  // cppcheck-suppress shiftTooManyBits
  x = 1 << x;
}

void test__times__leakignore() {
  char *p = malloc(10); *p=0;
  times(p);
  // cppcheck-suppress memleak
}

void test__times__arg1__notuninit() {
  int x;
  // cppcheck-suppress uninitvar
  times(x);
}

void test__utime__noreturn() {
  int x = 1;
  if (cond) { x=100; utime(arg1, arg2); }
  // cppcheck-suppress shiftTooManyBits
  x = 1 << x;
}

void test__utime__leakignore() {
  char *p = malloc(10); *p=0;
  utime(p, arg2);
  // cppcheck-suppress memleak
}

void test__utime__arg1__notnull() {
  // cppcheck-suppress nullPointer
  utime(NULL, arg2);
}

void test__utime__arg1__notuninit() {
  int x[10];
  // cppcheck-suppress uninitvar
  utime(x, arg2);
}

void test__utime__arg2__notuninit() {
  int x;
  // cppcheck-suppress uninitvar
  utime(arg1, x);
}

void test__utimes__noreturn() {
  int x = 1;
  if (cond) { x=100; utimes(arg1, arg2); }
  // cppcheck-suppress shiftTooManyBits
  x = 1 << x;
}

void test__utimes__leakignore() {
  char *p = malloc(10); *p=0;
  utimes(p, arg2);
  // cppcheck-suppress memleak
}

void test__utimes__arg1__notnull() {
  // cppcheck-suppress nullPointer
  utimes(NULL, arg2);
}

void test__utimes__arg1__notuninit() {
  int x[10];
  // cppcheck-suppress uninitvar
  utimes(x, arg2);
}

void test__utimes__arg2__notuninit() {
  int x;
  // cppcheck-suppress uninitvar
  utimes(arg1, x);
}

void test__opendir__noreturn() {
  int x = 1;
  if (cond) { x=100; result = opendir(arg1); }
  // cppcheck-suppress shiftTooManyBits
  x = 1 << x;
}

void test__opendir__useretval() {
  // cppcheck-suppress ignoredReturnValue
  opendir(arg1);
}

void test__opendir__arg1__notnull() {
  // cppcheck-suppress nullPointer
  result = opendir(NULL);
}

void test__opendir__arg1__notuninit() {
  int x[10];
  // cppcheck-suppress uninitvar
  result = opendir(x);
}

void test__fdopendir__noreturn() {
  int x = 1;
  if (cond) { x=100; result = fdopendir(arg1); }
  // cppcheck-suppress shiftTooManyBits
  x = 1 << x;
}

void test__fdopendir__useretval() {
  // cppcheck-suppress ignoredReturnValue
  fdopendir(arg1);
}

void test__fdopendir__arg1__notuninit() {
  int x;
  // cppcheck-suppress uninitvar
  result = fdopendir(x);
}

void test__isatty__noreturn() {
  int x = 1;
  if (cond) { x=100; result = isatty(arg1); }
  // cppcheck-suppress shiftTooManyBits
  x = 1 << x;
}

void test__isatty__useretval() {
  // cppcheck-suppress ignoredReturnValue
  isatty(arg1);
}

void test__isatty__leakignore() {
  char *p = malloc(10); *p=0;
  result = isatty(p);
  // cppcheck-suppress memleak
}

void test__isatty__arg1__notuninit() {
  int x;
  // cppcheck-suppress uninitvar
  result = isatty(x);
}

void test__popen__noreturn() {
  int x = 1;
  if (cond) { x=100; result = popen(arg1, arg2); }
  // cppcheck-suppress shiftTooManyBits
  x = 1 << x;
}

void test__popen__useretval() {
  // cppcheck-suppress ignoredReturnValue
  popen(arg1, arg2);
}

void test__popen__arg1__notnull() {
  // cppcheck-suppress nullPointer
  result = popen(NULL, arg2);
}

void test__popen__arg1__notuninit() {
  int x[10];
  // cppcheck-suppress uninitvar
  result = popen(x, arg2);
}

void test__popen__arg2__notnull() {
  // cppcheck-suppress nullPointer
  result = popen(arg1, NULL);
}

void test__popen__arg2__notuninit() {
  int x[10];
  // cppcheck-suppress uninitvar
  result = popen(arg1, x);
}

void test__pclose__noreturn() {
  int x = 1;
  if (cond) { x=100; pclose(arg1); }
  // cppcheck-suppress shiftTooManyBits
  x = 1 << x;
}

void test__pclose__arg1__notnull() {
  // cppcheck-suppress nullPointer
  pclose(NULL);
}

void test__pclose__arg1__notuninit() {
  int x[10];
  // cppcheck-suppress uninitvar
  pclose(x);
}

void test__socket__noreturn() {
  int x = 1;
  if (cond) { x=100; socket(arg1, arg2, arg3); }
  // cppcheck-suppress shiftTooManyBits
  x = 1 << x;
}

void test__socket__arg1__notuninit() {
  int x;
  // cppcheck-suppress uninitvar
  socket(x, arg2, arg3);
}

void test__socket__arg2__notuninit() {
  int x;
  // cppcheck-suppress uninitvar
  socket(arg1, x, arg3);
}

void test__socket__arg3__notuninit() {
  int x;
  // cppcheck-suppress uninitvar
  socket(arg1, arg2, x);
}

void test__nice__noreturn() {
  int x = 1;
  if (cond) { x=100; nice(arg1); }
  // cppcheck-suppress shiftTooManyBits
  x = 1 << x;
}

void test__nice__leakignore() {
  char *p = malloc(10); *p=0;
  nice(p);
  // cppcheck-suppress memleak
}

void test__nice__arg1__notuninit() {
  int x;
  // cppcheck-suppress uninitvar
  nice(x);
}

void test__pause__noreturn() {
  int x = 1;
  if (cond) { x=100; pause(); }
  // cppcheck-suppress shiftTooManyBits
  x = 1 << x;
}

void test__pause__leakignore() {
  char *p = malloc(10); *p=0;
  pause();
  // cppcheck-suppress memleak
}

void test__close__noreturn() {
  int x = 1;
  if (cond) { x=100; close(arg1); }
  // cppcheck-suppress shiftTooManyBits
  x = 1 << x;
}

void test__close__arg1__notuninit() {
  int x;
  // cppcheck-suppress uninitvar
  close(x);
}

void test__confstr__noreturn() {
  int x = 1;
  if (cond) { x=100; confstr(arg1, arg2, arg3); }
  // cppcheck-suppress shiftTooManyBits
  x = 1 << x;
}

void test__confstr__leakignore() {
  char *p = malloc(10); *p=0;
  confstr(p, arg2, arg3);
  // cppcheck-suppress memleak
}

void test__confstr__arg1__notuninit() {
  int x;
  // cppcheck-suppress uninitvar
  confstr(x, arg2, arg3);
}

void test__confstr__arg2__notuninit() {
  int x;
  // cppcheck-suppress uninitvar
  confstr(arg1, x, arg3);
}

void test__confstr__arg3__notuninit() {
  int x;
  // cppcheck-suppress uninitvar
  confstr(arg1, arg2, x);
}

void test__fpathconf__noreturn() {
  int x = 1;
  if (cond) { x=100; fpathconf(arg1, arg2); }
  // cppcheck-suppress shiftTooManyBits
  x = 1 << x;
}

void test__fpathconf__leakignore() {
  char *p = malloc(10); *p=0;
  fpathconf(p, arg2);
  // cppcheck-suppress memleak
}

void test__fpathconf__arg1__notuninit() {
  int x;
  // cppcheck-suppress uninitvar
  fpathconf(x, arg2);
}

void test__fpathconf__arg2__notuninit() {
  int x;
  // cppcheck-suppress uninitvar
  fpathconf(arg1, x);
}

void test__pathconf__noreturn() {
  int x = 1;
  if (cond) { x=100; pathconf(arg1, arg2); }
  // cppcheck-suppress shiftTooManyBits
  x = 1 << x;
}

void test__pathconf__leakignore() {
  char *p = malloc(10); *p=0;
  pathconf(p, arg2);
  // cppcheck-suppress memleak
}

void test__pathconf__arg1__notnull() {
  // cppcheck-suppress nullPointer
  pathconf(NULL, arg2);
}

void test__pathconf__arg1__notuninit() {
  int x[10];
  // cppcheck-suppress uninitvar
  pathconf(x, arg2);
}

void test__pathconf__arg2__notuninit() {
  int x;
  // cppcheck-suppress uninitvar
  pathconf(arg1, x);
}

void test__sysconf__noreturn() {
  int x = 1;
  if (cond) { x=100; sysconf(arg1); }
  // cppcheck-suppress shiftTooManyBits
  x = 1 << x;
}

void test__sysconf__leakignore() {
  char *p = malloc(10); *p=0;
  sysconf(p);
  // cppcheck-suppress memleak
}

void test__sysconf__arg1__notuninit() {
  int x;
  // cppcheck-suppress uninitvar
  sysconf(x);
}

void test__fdopen__noreturn() {
  int x = 1;
  if (cond) { x=100; result = fdopen(arg1, arg2); }
  // cppcheck-suppress shiftTooManyBits
  x = 1 << x;
}

void test__fdopen__useretval() {
  // cppcheck-suppress ignoredReturnValue
  fdopen(arg1, arg2);
}

void test__fdopen__arg1__notuninit() {
  int x;
  // cppcheck-suppress uninitvar
  result = fdopen(x, arg2);
}

void test__fdopen__arg2__notnull() {
  // cppcheck-suppress nullPointer
  result = fdopen(arg1, NULL);
}

void test__fdopen__arg2__notuninit() {
  int x[10];
  // cppcheck-suppress uninitvar
  result = fdopen(arg1, x);
}

void test__random__noreturn() {
  int x = 1;
  if (cond) { x=100; result = random(); }
  // cppcheck-suppress shiftTooManyBits
  x = 1 << x;
}

void test__random__useretval() {
  // cppcheck-suppress ignoredReturnValue
  random();
}

void test__srandom__noreturn() {
  int x = 1;
  if (cond) { x=100; srandom(arg1); }
  // cppcheck-suppress shiftTooManyBits
  x = 1 << x;
}

void test__rewinddir__noreturn() {
  int x = 1;
  if (cond) { x=100; rewinddir(arg1); }
  // cppcheck-suppress shiftTooManyBits
  x = 1 << x;
}

void test__rewinddir__leakignore() {
  char *p = malloc(10); *p=0;
  rewinddir(p);
  // cppcheck-suppress memleak
}

void test__rewinddir__arg1__notnull() {
  // cppcheck-suppress nullPointer
  rewinddir(NULL);
}

void test__rewinddir__arg1__notuninit() {
  int x[10];
  // cppcheck-suppress uninitvar
  rewinddir(x);
}

void test__seekdir__noreturn() {
  int x = 1;
  if (cond) { x=100; seekdir(arg1, arg2); }
  // cppcheck-suppress shiftTooManyBits
  x = 1 << x;
}

void test__seekdir__leakignore() {
  char *p = malloc(10); *p=0;
  seekdir(p, arg2);
  // cppcheck-suppress memleak
}

void test__seekdir__arg1__notnull() {
  // cppcheck-suppress nullPointer
  seekdir(NULL, arg2);
}

void test__seekdir__arg1__notuninit() {
  int x[10];
  // cppcheck-suppress uninitvar
  seekdir(x, arg2);
}

void test__seekdir__arg2__notuninit() {
  int x;
  // cppcheck-suppress uninitvar
  seekdir(arg1, x);
}

void test__rand_r__noreturn() {
  int x = 1;
  if (cond) { x=100; rand_r(arg1); }
  // cppcheck-suppress shiftTooManyBits
  x = 1 << x;
}

void test__rand_r__leakignore() {
  char *p = malloc(10); *p=0;
  rand_r(p);
  // cppcheck-suppress memleak
}

void test__rand_r__arg1__notnull() {
  // cppcheck-suppress nullPointer
  rand_r(NULL);
}

void test__strcasecmp__noreturn() {
  int x = 1;
  if (cond) { x=100; strcasecmp(arg1, arg2); }
  // cppcheck-suppress shiftTooManyBits
  x = 1 << x;
}

void test__strcasecmp__pure(int arg1,int arg2) {
  // cppcheck-suppress incorrectLogicOperator
  if ((strcasecmp(arg1, arg2) > 10) || (strcasecmp(arg1, arg2) < 100)) {}
}

void test__strcasecmp__leakignore() {
  char *p = malloc(10); *p=0;
  strcasecmp(p, arg2);
  // cppcheck-suppress memleak
}

void test__strcasecmp__arg1__notnull() {
  // cppcheck-suppress nullPointer
  strcasecmp(NULL, arg2);
}

void test__strcasecmp__arg1__notuninit() {
  int x[10];
  // cppcheck-suppress uninitvar
  strcasecmp(x, arg2);
}

void test__strcasecmp__arg2__notnull() {
  // cppcheck-suppress nullPointer
  strcasecmp(arg1, NULL);
}

void test__strcasecmp__arg2__notuninit() {
  int x[10];
  // cppcheck-suppress uninitvar
  strcasecmp(arg1, x);
}

void test__strncasecmp__noreturn() {
  int x = 1;
  if (cond) { x=100; strncasecmp(arg1, arg2, arg3); }
  // cppcheck-suppress shiftTooManyBits
  x = 1 << x;
}

void test__strncasecmp__pure(int arg1,int arg2,int arg3) {
  // cppcheck-suppress incorrectLogicOperator
  if ((strncasecmp(arg1, arg2, arg3) > 10) || (strncasecmp(arg1, arg2, arg3) < 100)) {}
}

void test__strncasecmp__leakignore() {
  char *p = malloc(10); *p=0;
  strncasecmp(p, arg2, arg3);
  // cppcheck-suppress memleak
}

void test__strncasecmp__arg1__notnull() {
  // cppcheck-suppress nullPointer
  strncasecmp(NULL, arg2, arg3);
}

void test__strncasecmp__arg1__notuninit() {
  int x[10];
  // cppcheck-suppress uninitvar
  strncasecmp(x, arg2, arg3);
}

void test__strncasecmp__arg2__notnull() {
  // cppcheck-suppress nullPointer
  strncasecmp(arg1, NULL, arg3);
}

void test__strncasecmp__arg2__notuninit() {
  int x[10];
  // cppcheck-suppress uninitvar
  strncasecmp(arg1, x, arg3);
}

void test__strncasecmp__arg3__notbool() {
  // cppcheck-suppress invalidFunctionArgBool
  strncasecmp(arg1, arg2, !x);
}

void test__read__leakignore() {
  char *p = malloc(10); *p=0;
  read(p, arg2, arg3);
  // cppcheck-suppress memleak
}

void test__read__arg1__notuninit() {
  int x;
  // cppcheck-suppress uninitvar
  read(x, arg2, arg3);
}

void test__read__arg3__notuninit() {
  int x;
  // cppcheck-suppress uninitvar
  read(arg1, arg2, x);
}

void test__write__noreturn() {
  int x = 1;
  if (cond) { x=100; write(arg1, arg2, arg3); }
  // cppcheck-suppress shiftTooManyBits
  x = 1 << x;
}

void test__write__leakignore() {
  char *p = malloc(10); *p=0;
  write(p, arg2, arg3);
  // cppcheck-suppress memleak
}

void test__write__arg1__notuninit() {
  int x;
  // cppcheck-suppress uninitvar
  write(x, arg2, arg3);
}

void test__write__arg2__notuninit() {
  int x;
  // cppcheck-suppress uninitvar
  write(arg1, x, arg3);
}

void test__write__arg3__notuninit() {
  int x;
  // cppcheck-suppress uninitvar
  write(arg1, arg2, x);
}

void test__recv__arg1__notuninit() {
  int x;
  // cppcheck-suppress uninitvar
  recv(x, arg2, arg3, arg4);
}

void test__recv__arg3__notuninit() {
  int x;
  // cppcheck-suppress uninitvar
  recv(arg1, arg2, x, arg4);
}

void test__recv__arg4__notuninit() {
  int x;
  // cppcheck-suppress uninitvar
  recv(arg1, arg2, arg3, x);
}

void test__recvfrom__arg1__notuninit() {
  int x;
  // cppcheck-suppress uninitvar
  recvfrom(x, arg2, arg3, arg4, arg5, arg6);
}

void test__recvfrom__arg3__notuninit() {
  int x;
  // cppcheck-suppress uninitvar
  recvfrom(arg1, arg2, x, arg4, arg5, arg6);
}

void test__recvfrom__arg4__notuninit() {
  int x;
  // cppcheck-suppress uninitvar
  recvfrom(arg1, arg2, arg3, x, arg5, arg6);
}

void test__recvmsg__arg1__notuninit() {
  int x;
  // cppcheck-suppress uninitvar
  recvmsg(x, arg2, arg3);
}

void test__recvmsg__arg3__notuninit() {
  int x;
  // cppcheck-suppress uninitvar
  recvmsg(arg1, arg2, x);
}

void test__send__arg1__notuninit() {
  int x;
  // cppcheck-suppress uninitvar
  send(x, arg2, arg3, arg4);
}

void test__send__arg3__notuninit() {
  int x;
  // cppcheck-suppress uninitvar
  send(arg1, arg2, x, arg4);
}

void test__send__arg4__notuninit() {
  int x;
  // cppcheck-suppress uninitvar
  send(arg1, arg2, arg3, x);
}

void test__sendto__arg1__notuninit() {
  int x;
  // cppcheck-suppress uninitvar
  sendto(x, arg2, arg3, arg4, arg5, arg6);
}

void test__sendto__arg3__notuninit() {
  int x;
  // cppcheck-suppress uninitvar
  sendto(arg1, arg2, x, arg4, arg5, arg6);
}

void test__sendto__arg4__notuninit() {
  int x;
  // cppcheck-suppress uninitvar
  sendto(arg1, arg2, arg3, x, arg5, arg6);
}

void test__sendmsg__arg1__notuninit() {
  int x;
  // cppcheck-suppress uninitvar
  sendmsg(x, arg2, arg3);
}

void test__sendmsg__arg2__notuninit() {
  int x;
  // cppcheck-suppress uninitvar
  sendmsg(arg1, x, arg3);
}

void test__sendmsg__arg3__notuninit() {
  int x;
  // cppcheck-suppress uninitvar
  sendmsg(arg1, arg2, x);
}

void test__mmap__noreturn() {
  int x = 1;
  if (cond) { x=100; result = mmap(arg1, arg2, arg3, arg4, arg5, arg6); }
  // cppcheck-suppress shiftTooManyBits
  x = 1 << x;
}

void test__mmap__useretval() {
  // cppcheck-suppress ignoredReturnValue
  mmap(arg1, arg2, arg3, arg4, arg5, arg6);
}

void test__mmap__leakignore() {
  char *p = malloc(10); *p=0;
  result = mmap(p, arg2, arg3, arg4, arg5, arg6);
  // cppcheck-suppress memleak
}

void test__mmap__arg1__notuninit() {
  int x;
  // cppcheck-suppress uninitvar
  result = mmap(x, arg2, arg3, arg4, arg5, arg6);
}

void test__mmap__arg2__notuninit() {
  int x;
  // cppcheck-suppress uninitvar
  result = mmap(arg1, x, arg3, arg4, arg5, arg6);
}

void test__mmap__arg3__notuninit() {
  int x;
  // cppcheck-suppress uninitvar
  result = mmap(arg1, arg2, x, arg4, arg5, arg6);
}

void test__mmap__arg4__notuninit() {
  int x;
  // cppcheck-suppress uninitvar
  result = mmap(arg1, arg2, arg3, x, arg5, arg6);
}

void test__mmap__arg5__notuninit() {
  int x;
  // cppcheck-suppress uninitvar
  result = mmap(arg1, arg2, arg3, arg4, x, arg6);
}

void test__mmap__arg6__notuninit() {
  int x;
  // cppcheck-suppress uninitvar
  result = mmap(arg1, arg2, arg3, arg4, arg5, x);
}

void test__mmap64__noreturn() {
  int x = 1;
  if (cond) { x=100; result = mmap64(arg1, arg2, arg3, arg4, arg5, arg6); }
  // cppcheck-suppress shiftTooManyBits
  x = 1 << x;
}

void test__mmap64__useretval() {
  // cppcheck-suppress ignoredReturnValue
  mmap64(arg1, arg2, arg3, arg4, arg5, arg6);
}

void test__mmap64__leakignore() {
  char *p = malloc(10); *p=0;
  result = mmap64(p, arg2, arg3, arg4, arg5, arg6);
  // cppcheck-suppress memleak
}

void test__mmap64__arg1__notuninit() {
  int x;
  // cppcheck-suppress uninitvar
  result = mmap64(x, arg2, arg3, arg4, arg5, arg6);
}

void test__mmap64__arg2__notuninit() {
  int x;
  // cppcheck-suppress uninitvar
  result = mmap64(arg1, x, arg3, arg4, arg5, arg6);
}

void test__mmap64__arg3__notuninit() {
  int x;
  // cppcheck-suppress uninitvar
  result = mmap64(arg1, arg2, x, arg4, arg5, arg6);
}

void test__mmap64__arg4__notuninit() {
  int x;
  // cppcheck-suppress uninitvar
  result = mmap64(arg1, arg2, arg3, x, arg5, arg6);
}

void test__mmap64__arg5__notuninit() {
  int x;
  // cppcheck-suppress uninitvar
  result = mmap64(arg1, arg2, arg3, arg4, x, arg6);
}

void test__mmap64__arg6__notuninit() {
  int x;
  // cppcheck-suppress uninitvar
  result = mmap64(arg1, arg2, arg3, arg4, arg5, x);
}

void test__munmap__noreturn() {
  int x = 1;
  if (cond) { x=100; munmap(arg1, arg2); }
  // cppcheck-suppress shiftTooManyBits
  x = 1 << x;
}

void test__munmap__arg1__notnull() {
  // cppcheck-suppress nullPointer
  munmap(NULL, arg2);
}

void test__munmap__arg1__notuninit() {
  int x[10];
  // cppcheck-suppress uninitvar
  munmap(x, arg2);
}

void test__munmap__arg2__notuninit() {
  int x;
  // cppcheck-suppress uninitvar
  munmap(arg1, x);
}

void test__openlog__noreturn() {
  int x = 1;
  if (cond) { x=100; openlog(arg1, arg2, arg3); }
  // cppcheck-suppress shiftTooManyBits
  x = 1 << x;
}

void test__openlog__leakignore() {
  char *p = malloc(10); *p=0;
  openlog(p, arg2, arg3);
  // cppcheck-suppress memleak
}

void test__openlog__arg1__notuninit() {
  int x;
  // cppcheck-suppress uninitvar
  openlog(x, arg2, arg3);
}

void test__openlog__arg2__notuninit() {
  int x;
  // cppcheck-suppress uninitvar
  openlog(arg1, x, arg3);
}

void test__openlog__arg3__notuninit() {
  int x;
  // cppcheck-suppress uninitvar
  openlog(arg1, arg2, x);
}

void test__fcntl__noreturn() {
  int x = 1;
  if (cond) { x=100; fcntl(arg1, arg2); }
  // cppcheck-suppress shiftTooManyBits
  x = 1 << x;
}

void test__fcntl__leakignore() {
  char *p = malloc(10); *p=0;
  fcntl(p, arg2);
  // cppcheck-suppress memleak
}

void test__fcntl__arg1__notuninit() {
  int x;
  // cppcheck-suppress uninitvar
  fcntl(x, arg2);
}

void test__fcntl__arg2__notuninit() {
  int x;
  // cppcheck-suppress uninitvar
  fcntl(arg1, x);
}

void test__ioctl__noreturn() {
  int x = 1;
  if (cond) { x=100; ioctl(arg1, arg2); }
  // cppcheck-suppress shiftTooManyBits
  x = 1 << x;
}

void test__ioctl__leakignore() {
  char *p = malloc(10); *p=0;
  ioctl(p, arg2);
  // cppcheck-suppress memleak
}

void test__ioctl__arg1__notuninit() {
  int x;
  // cppcheck-suppress uninitvar
  ioctl(x, arg2);
}

void test__ioctl__arg2__notuninit() {
  int x;
  // cppcheck-suppress uninitvar
  ioctl(arg1, x);
}

void test__syslog__noreturn() {
  int x = 1;
  if (cond) { x=100; syslog(arg1, arg2); }
  // cppcheck-suppress shiftTooManyBits
  x = 1 << x;
}

void test__syslog__leakignore() {
  char *p = malloc(10); *p=0;
  syslog(p, arg2);
  // cppcheck-suppress memleak
}

void test__syslog__arg1__notuninit() {
  int x;
  // cppcheck-suppress uninitvar
  syslog(x, arg2);
}

void test__vsyslog__noreturn() {
  int x = 1;
  if (cond) { x=100; vsyslog(arg1, arg2); }
  // cppcheck-suppress shiftTooManyBits
  x = 1 << x;
}

void test__vsyslog__leakignore() {
  char *p = malloc(10); *p=0;
  vsyslog(p, arg2);
  // cppcheck-suppress memleak
}

void test__vsyslog__arg1__notuninit() {
  int x;
  // cppcheck-suppress uninitvar
  vsyslog(x, arg2);
}

void test__getgid__noreturn() {
  int x = 1;
  if (cond) { x=100; result = getgid(); }
  // cppcheck-suppress shiftTooManyBits
  x = 1 << x;
}

void test__getgid__useretval() {
  // cppcheck-suppress ignoredReturnValue
  getgid();
}

void test__getegid__noreturn() {
  int x = 1;
  if (cond) { x=100; result = getegid(); }
  // cppcheck-suppress shiftTooManyBits
  x = 1 << x;
}

void test__getegid__useretval() {
  // cppcheck-suppress ignoredReturnValue
  getegid();
}

void test__getuid__noreturn() {
  int x = 1;
  if (cond) { x=100; result = getuid(); }
  // cppcheck-suppress shiftTooManyBits
  x = 1 << x;
}

void test__getuid__useretval() {
  // cppcheck-suppress ignoredReturnValue
  getuid();
}

void test__getuid__leakignore() {
  char *p = malloc(10); *p=0;
  result = getuid();
  // cppcheck-suppress memleak
}

void test__getsid__noreturn() {
  int x = 1;
  if (cond) { x=100; result = getsid(arg1); }
  // cppcheck-suppress shiftTooManyBits
  x = 1 << x;
}

void test__getsid__useretval() {
  // cppcheck-suppress ignoredReturnValue
  getsid(arg1);
}

void test__getsid__leakignore() {
  char *p = malloc(10); *p=0;
  result = getsid(p);
  // cppcheck-suppress memleak
}

void test__getsid__arg1__notuninit() {
  int x;
  // cppcheck-suppress uninitvar
  result = getsid(x);
}

void test__geteuid__noreturn() {
  int x = 1;
  if (cond) { x=100; result = geteuid(); }
  // cppcheck-suppress shiftTooManyBits
  x = 1 << x;
}

void test__geteuid__useretval() {
  // cppcheck-suppress ignoredReturnValue
  geteuid();
}

void test__geteuid__leakignore() {
  char *p = malloc(10); *p=0;
  result = geteuid();
  // cppcheck-suppress memleak
}

void test__getppid__noreturn() {
  int x = 1;
  if (cond) { x=100; result = getppid(); }
  // cppcheck-suppress shiftTooManyBits
  x = 1 << x;
}

void test__getppid__useretval() {
  // cppcheck-suppress ignoredReturnValue
  getppid();
}

void test__getppid__leakignore() {
  char *p = malloc(10); *p=0;
  result = getppid();
  // cppcheck-suppress memleak
}

void test__getpid__noreturn() {
  int x = 1;
  if (cond) { x=100; result = getpid(); }
  // cppcheck-suppress shiftTooManyBits
  x = 1 << x;
}

void test__getpid__useretval() {
  // cppcheck-suppress ignoredReturnValue
  getpid();
}

void test__getpid__leakignore() {
  char *p = malloc(10); *p=0;
  result = getpid();
  // cppcheck-suppress memleak
}

void test__getpgrp__noreturn() {
  int x = 1;
  if (cond) { x=100; result = getpgrp(); }
  // cppcheck-suppress shiftTooManyBits
  x = 1 << x;
}

void test__getpgrp__useretval() {
  // cppcheck-suppress ignoredReturnValue
  getpgrp();
}

void test__getpgrp__leakignore() {
  char *p = malloc(10); *p=0;
  result = getpgrp();
  // cppcheck-suppress memleak
}

void test__getpgid__noreturn() {
  int x = 1;
  if (cond) { x=100; result = getpgid(arg1); }
  // cppcheck-suppress shiftTooManyBits
  x = 1 << x;
}

void test__getpgid__useretval() {
  // cppcheck-suppress ignoredReturnValue
  getpgid(arg1);
}

void test__getpgid__leakignore() {
  char *p = malloc(10); *p=0;
  result = getpgid(p);
  // cppcheck-suppress memleak
}

void test__getpgid__arg1__notuninit() {
  int x;
  // cppcheck-suppress uninitvar
  result = getpgid(x);
}

void test__setuid__noreturn() {
  int x = 1;
  if (cond) { x=100; result = setuid(arg1); }
  // cppcheck-suppress shiftTooManyBits
  x = 1 << x;
}

void test__setuid__useretval() {
  // cppcheck-suppress ignoredReturnValue
  setuid(arg1);
}

void test__setuid__leakignore() {
  char *p = malloc(10); *p=0;
  result = setuid(p);
  // cppcheck-suppress memleak
}

void test__setuid__arg1__notuninit() {
  int x;
  // cppcheck-suppress uninitvar
  result = setuid(x);
}

void test__seteuid__noreturn() {
  int x = 1;
  if (cond) { x=100; result = seteuid(arg1); }
  // cppcheck-suppress shiftTooManyBits
  x = 1 << x;
}

void test__seteuid__useretval() {
  // cppcheck-suppress ignoredReturnValue
  seteuid(arg1);
}

void test__seteuid__leakignore() {
  char *p = malloc(10); *p=0;
  result = seteuid(p);
  // cppcheck-suppress memleak
}

void test__seteuid__arg1__notuninit() {
  int x;
  // cppcheck-suppress uninitvar
  result = seteuid(x);
}

void test__setgid__noreturn() {
  int x = 1;
  if (cond) { x=100; result = setgid(arg1); }
  // cppcheck-suppress shiftTooManyBits
  x = 1 << x;
}

void test__setgid__useretval() {
  // cppcheck-suppress ignoredReturnValue
  setgid(arg1);
}

void test__setgid__leakignore() {
  char *p = malloc(10); *p=0;
  result = setgid(p);
  // cppcheck-suppress memleak
}

void test__setgid__arg1__notuninit() {
  int x;
  // cppcheck-suppress uninitvar
  result = setgid(x);
}

void test__setegid__noreturn() {
  int x = 1;
  if (cond) { x=100; result = setegid(arg1); }
  // cppcheck-suppress shiftTooManyBits
  x = 1 << x;
}

void test__setegid__useretval() {
  // cppcheck-suppress ignoredReturnValue
  setegid(arg1);
}

void test__setegid__leakignore() {
  char *p = malloc(10); *p=0;
  result = setegid(p);
  // cppcheck-suppress memleak
}

void test__setegid__arg1__notuninit() {
  int x;
  // cppcheck-suppress uninitvar
  result = setegid(x);
}

void test__setpgid__noreturn() {
  int x = 1;
  if (cond) { x=100; setpgid(arg1, arg2); }
  // cppcheck-suppress shiftTooManyBits
  x = 1 << x;
}

void test__setpgid__arg1__notuninit() {
  int x;
  // cppcheck-suppress uninitvar
  setpgid(x, arg2);
}

void test__setpgid__arg2__notuninit() {
  int x;
  // cppcheck-suppress uninitvar
  setpgid(arg1, x);
}

void test__pipe__noreturn() {
  int x = 1;
  if (cond) { x=100; pipe(); }
  // cppcheck-suppress shiftTooManyBits
  x = 1 << x;
}

void test__setpgrp__noreturn() {
  int x = 1;
  if (cond) { x=100; setpgrp(); }
  // cppcheck-suppress shiftTooManyBits
  x = 1 << x;
}

void test__setregid__noreturn() {
  int x = 1;
  if (cond) { x=100; setregid(arg1, arg2); }
  // cppcheck-suppress shiftTooManyBits
  x = 1 << x;
}

void test__setregid__arg1__notuninit() {
  int x;
  // cppcheck-suppress uninitvar
  setregid(x, arg2);
}

void test__setregid__arg2__notuninit() {
  int x;
  // cppcheck-suppress uninitvar
  setregid(arg1, x);
}

void test__setreuid__noreturn() {
  int x = 1;
  if (cond) { x=100; setreuid(arg1, arg2); }
  // cppcheck-suppress shiftTooManyBits
  x = 1 << x;
}

void test__setreuid__arg1__notuninit() {
  int x;
  // cppcheck-suppress uninitvar
  setreuid(x, arg2);
}

void test__setreuid__arg2__notuninit() {
  int x;
  // cppcheck-suppress uninitvar
  setreuid(arg1, x);
}

void test__setfsuid__noreturn() {
  int x = 1;
  if (cond) { x=100; setfsuid(arg1); }
  // cppcheck-suppress shiftTooManyBits
  x = 1 << x;
}

void test__setfsuid__leakignore() {
  char *p = malloc(10); *p=0;
  setfsuid(p);
  // cppcheck-suppress memleak
}

void test__setfsuid__arg1__notuninit() {
  int x;
  // cppcheck-suppress uninitvar
  setfsuid(x);
}

void test__setfsgid__noreturn() {
  int x = 1;
  if (cond) { x=100; setfsgid(arg1); }
  // cppcheck-suppress shiftTooManyBits
  x = 1 << x;
}

void test__setfsgid__leakignore() {
  char *p = malloc(10); *p=0;
  setfsgid(p);
  // cppcheck-suppress memleak
}

void test__setfsgid__arg1__notuninit() {
  int x;
  // cppcheck-suppress uninitvar
  setfsgid(x);
}

void test__setsid__noreturn() {
  int x = 1;
  if (cond) { x=100; setsid(); }
  // cppcheck-suppress shiftTooManyBits
  x = 1 << x;
}

void test__getwd__noreturn() {
  int x = 1;
  if (cond) { x=100; getwd(arg1); }
  // cppcheck-suppress shiftTooManyBits
  x = 1 << x;
}

void test__getwd__leakignore() {
  char *p = malloc(10); *p=0;
  getwd(p);
  // cppcheck-suppress memleak
}

void test__getwd__arg1__notnull() {
  // cppcheck-suppress nullPointer
  getwd(NULL);
}

void test__htonl__noreturn() {
  int x = 1;
  if (cond) { x=100; htonl(arg1); }
  // cppcheck-suppress shiftTooManyBits
  x = 1 << x;
}

void test__htonl__arg1__notuninit() {
  int x;
  // cppcheck-suppress uninitvar
  htonl(x);
}

void test__htons__noreturn() {
  int x = 1;
  if (cond) { x=100; htons(arg1); }
  // cppcheck-suppress shiftTooManyBits
  x = 1 << x;
}

void test__htons__arg1__notuninit() {
  int x;
  // cppcheck-suppress uninitvar
  htons(x);
}

void test__ntohl__noreturn() {
  int x = 1;
  if (cond) { x=100; ntohl(arg1); }
  // cppcheck-suppress shiftTooManyBits
  x = 1 << x;
}

void test__ntohl__arg1__notuninit() {
  int x;
  // cppcheck-suppress uninitvar
  ntohl(x);
}

void test__ntohs__noreturn() {
  int x = 1;
  if (cond) { x=100; ntohs(arg1); }
  // cppcheck-suppress shiftTooManyBits
  x = 1 << x;
}

void test__ntohs__arg1__notuninit() {
  int x;
  // cppcheck-suppress uninitvar
  ntohs(x);
}

void test__mq_close__noreturn() {
  int x = 1;
  if (cond) { x=100; mq_close(arg1); }
  // cppcheck-suppress shiftTooManyBits
  x = 1 << x;
}

void test__mq_close__arg1__notuninit() {
  int x;
  // cppcheck-suppress uninitvar
  mq_close(x);
}

void test__mq_getattr__noreturn() {
  int x = 1;
  if (cond) { x=100; mq_getattr(arg1, arg2); }
  // cppcheck-suppress shiftTooManyBits
  x = 1 << x;
}

void test__mq_getattr__arg1__notuninit() {
  int x;
  // cppcheck-suppress uninitvar
  mq_getattr(x, arg2);
}

void test__mq_notify__noreturn() {
  int x = 1;
  if (cond) { x=100; mq_notify(arg1, arg2); }
  // cppcheck-suppress shiftTooManyBits
  x = 1 << x;
}

void test__mq_notify__arg1__notnull() {
  // cppcheck-suppress nullPointer
  mq_notify(NULL, arg2);
}

void test__mq_notify__arg1__notuninit() {
  int x[10];
  // cppcheck-suppress uninitvar
  mq_notify(x, arg2);
}

void test__mq_open__noreturn() {
  int x = 1;
  if (cond) { x=100; mq_open(); }
  // cppcheck-suppress shiftTooManyBits
  x = 1 << x;
}

void test__mq_receive__noreturn() {
  int x = 1;
  if (cond) { x=100; mq_receive(arg1, arg2, arg3, arg4); }
  // cppcheck-suppress shiftTooManyBits
  x = 1 << x;
}

void test__mq_receive__arg1__notuninit() {
  int x;
  // cppcheck-suppress uninitvar
  mq_receive(x, arg2, arg3, arg4);
}

void test__mq_send__noreturn() {
  int x = 1;
  if (cond) { x=100; mq_send(arg1, arg2, arg3, arg4); }
  // cppcheck-suppress shiftTooManyBits
  x = 1 << x;
}

void test__mq_send__arg1__notuninit() {
  int x;
  // cppcheck-suppress uninitvar
  mq_send(x, arg2, arg3, arg4);
}

void test__mq_setattr__noreturn() {
  int x = 1;
  if (cond) { x=100; mq_setattr(arg1, arg2, arg3); }
  // cppcheck-suppress shiftTooManyBits
  x = 1 << x;
}

void test__mq_setattr__arg1__notuninit() {
  int x;
  // cppcheck-suppress uninitvar
  mq_setattr(x, arg2, arg3);
}

void test__mq_timedreceive__noreturn() {
  int x = 1;
  if (cond) { x=100; mq_timedreceive(arg1, arg2, arg3, arg4, arg5); }
  // cppcheck-suppress shiftTooManyBits
  x = 1 << x;
}

void test__mq_timedreceive__arg1__notuninit() {
  int x;
  // cppcheck-suppress uninitvar
  mq_timedreceive(x, arg2, arg3, arg4, arg5);
}

void test__mq_timedsend__noreturn() {
  int x = 1;
  if (cond) { x=100; mq_timedsend(arg1, arg2, arg3, arg4, arg5); }
  // cppcheck-suppress shiftTooManyBits
  x = 1 << x;
}

void test__mq_timedsend__arg1__notuninit() {
  int x;
  // cppcheck-suppress uninitvar
  mq_timedsend(x, arg2, arg3, arg4, arg5);
}

void test__mq_unlink__noreturn() {
  int x = 1;
  if (cond) { x=100; mq_unlink(arg1); }
  // cppcheck-suppress shiftTooManyBits
  x = 1 << x;
}

void test__mq_unlink__arg1__notnull() {
  // cppcheck-suppress nullPointer
  mq_unlink(NULL);
}

void test__mq_unlink__arg1__notuninit() {
  int x[10];
  // cppcheck-suppress uninitvar
  mq_unlink(x);
}

void test__dbm_clearerr__noreturn() {
  int x = 1;
  if (cond) { x=100; dbm_clearerr(arg1); }
  // cppcheck-suppress shiftTooManyBits
  x = 1 << x;
}

void test__dbm_clearerr__arg1__notnull() {
  // cppcheck-suppress nullPointer
  dbm_clearerr(NULL);
}

void test__dbm_clearerr__arg1__notuninit() {
  int x[10];
  // cppcheck-suppress uninitvar
  dbm_clearerr(x);
}

void test__dbm_close__noreturn() {
  int x = 1;
  if (cond) { x=100; dbm_close(arg1); }
  // cppcheck-suppress shiftTooManyBits
  x = 1 << x;
}

void test__dbm_close__arg1__notnull() {
  // cppcheck-suppress nullPointer
  dbm_close(NULL);
}

void test__dbm_close__arg1__notuninit() {
  int x[10];
  // cppcheck-suppress uninitvar
  dbm_close(x);
}

void test__dbm_delete__noreturn() {
  int x = 1;
  if (cond) { x=100; dbm_delete(arg1, arg2); }
  // cppcheck-suppress shiftTooManyBits
  x = 1 << x;
}

void test__dbm_delete__arg1__notnull() {
  // cppcheck-suppress nullPointer
  dbm_delete(NULL, arg2);
}

void test__dbm_delete__arg1__notuninit() {
  int x[10];
  // cppcheck-suppress uninitvar
  dbm_delete(x, arg2);
}

void test__dbm_delete__arg2__notuninit() {
  int x;
  // cppcheck-suppress uninitvar
  dbm_delete(arg1, x);
}

void test__dbm_error__noreturn() {
  int x = 1;
  if (cond) { x=100; result = dbm_error(arg1); }
  // cppcheck-suppress shiftTooManyBits
  x = 1 << x;
}

void test__dbm_error__useretval() {
  // cppcheck-suppress ignoredReturnValue
  dbm_error(arg1);
}

void test__dbm_error__arg1__notnull() {
  // cppcheck-suppress nullPointer
  result = dbm_error(NULL);
}

void test__dbm_error__arg1__notuninit() {
  int x[10];
  // cppcheck-suppress uninitvar
  result = dbm_error(x);
}

void test__dbm_fetch__noreturn() {
  int x = 1;
  if (cond) { x=100; result = dbm_fetch(arg1, arg2); }
  // cppcheck-suppress shiftTooManyBits
  x = 1 << x;
}

void test__dbm_fetch__useretval() {
  // cppcheck-suppress ignoredReturnValue
  dbm_fetch(arg1, arg2);
}

void test__dbm_fetch__arg1__notnull() {
  // cppcheck-suppress nullPointer
  result = dbm_fetch(NULL, arg2);
}

void test__dbm_fetch__arg1__notuninit() {
  int x[10];
  // cppcheck-suppress uninitvar
  result = dbm_fetch(x, arg2);
}

void test__dbm_fetch__arg2__notuninit() {
  int x;
  // cppcheck-suppress uninitvar
  result = dbm_fetch(arg1, x);
}

void test__dbm_firstkey__noreturn() {
  int x = 1;
  if (cond) { x=100; result = dbm_firstkey(arg1); }
  // cppcheck-suppress shiftTooManyBits
  x = 1 << x;
}

void test__dbm_firstkey__useretval() {
  // cppcheck-suppress ignoredReturnValue
  dbm_firstkey(arg1);
}

void test__dbm_firstkey__arg1__notnull() {
  // cppcheck-suppress nullPointer
  result = dbm_firstkey(NULL);
}

void test__dbm_firstkey__arg1__notuninit() {
  int x[10];
  // cppcheck-suppress uninitvar
  result = dbm_firstkey(x);
}

void test__dbm_nextkey__noreturn() {
  int x = 1;
  if (cond) { x=100; result = dbm_nextkey(arg1); }
  // cppcheck-suppress shiftTooManyBits
  x = 1 << x;
}

void test__dbm_nextkey__useretval() {
  // cppcheck-suppress ignoredReturnValue
  dbm_nextkey(arg1);
}

void test__dbm_nextkey__arg1__notnull() {
  // cppcheck-suppress nullPointer
  result = dbm_nextkey(NULL);
}

void test__dbm_nextkey__arg1__notuninit() {
  int x[10];
  // cppcheck-suppress uninitvar
  result = dbm_nextkey(x);
}

void test__dbm_open__noreturn() {
  int x = 1;
  if (cond) { x=100; dbm_open(arg1, arg2, arg3); }
  // cppcheck-suppress shiftTooManyBits
  x = 1 << x;
}

void test__dbm_open__arg1__notnull() {
  // cppcheck-suppress nullPointer
  dbm_open(NULL, arg2, arg3);
}

void test__dbm_open__arg1__notuninit() {
  int x[10];
  // cppcheck-suppress uninitvar
  dbm_open(x, arg2, arg3);
}

void test__dbm_open__arg2__notuninit() {
  int x;
  // cppcheck-suppress uninitvar
  dbm_open(arg1, x, arg3);
}

void test__dbm_open__arg3__notuninit() {
  int x;
  // cppcheck-suppress uninitvar
  dbm_open(arg1, arg2, x);
}

void test__dbm_store__noreturn() {
  int x = 1;
  if (cond) { x=100; dbm_store(arg1, arg2, arg3, arg4); }
  // cppcheck-suppress shiftTooManyBits
  x = 1 << x;
}

void test__dbm_store__arg1__notnull() {
  // cppcheck-suppress nullPointer
  dbm_store(NULL, arg2, arg3, arg4);
}

void test__dbm_store__arg1__notuninit() {
  int x[10];
  // cppcheck-suppress uninitvar
  dbm_store(x, arg2, arg3, arg4);
}

void test__dbm_store__arg2__notuninit() {
  int x;
  // cppcheck-suppress uninitvar
  dbm_store(arg1, x, arg3, arg4);
}

void test__dbm_store__arg3__notuninit() {
  int x;
  // cppcheck-suppress uninitvar
  dbm_store(arg1, arg2, x, arg4);
}

void test__dbm_store__arg4__notuninit() {
  int x;
  // cppcheck-suppress uninitvar
  dbm_store(arg1, arg2, arg3, x);
}

void test__freeaddrinfo__noreturn() {
  int x = 1;
  if (cond) { x=100; freeaddrinfo(arg1); }
  // cppcheck-suppress shiftTooManyBits
  x = 1 << x;
}

void test__freeaddrinfo__arg1__notnull() {
  // cppcheck-suppress nullPointer
  freeaddrinfo(NULL);
}

void test__freeaddrinfo__arg1__notuninit() {
  int x[10];
  // cppcheck-suppress uninitvar
  freeaddrinfo(x);
}

void test__getaddrinfo__noreturn() {
  int x = 1;
  if (cond) { x=100; getaddrinfo(arg1, arg2, arg3, arg4); }
  // cppcheck-suppress shiftTooManyBits
  x = 1 << x;
}

void test__getaddrinfo__arg1__notuninit() {
  int x;
  // cppcheck-suppress uninitvar
  getaddrinfo(x, arg2, arg3, arg4);
}

void test__getaddrinfo__arg2__notuninit() {
  int x;
  // cppcheck-suppress uninitvar
  getaddrinfo(arg1, x, arg3, arg4);
}

void test__getaddrinfo__arg3__notuninit() {
  int x;
  // cppcheck-suppress uninitvar
  getaddrinfo(arg1, arg2, x, arg4);
}

void test__getaddrinfo__arg4__notuninit() {
  int x;
  // cppcheck-suppress uninitvar
  getaddrinfo(arg1, arg2, arg3, x);
}

void test__endhostent__noreturn() {
  int x = 1;
  if (cond) { x=100; endhostent(); }
  // cppcheck-suppress shiftTooManyBits
  x = 1 << x;
}

void test__sethostent__noreturn() {
  int x = 1;
  if (cond) { x=100; sethostent(arg1); }
  // cppcheck-suppress shiftTooManyBits
  x = 1 << x;
}

void test__sethostent__arg1__notuninit() {
  int x;
  // cppcheck-suppress uninitvar
  sethostent(x);
}

void test__uname__noreturn() {
  int x = 1;
  if (cond) { x=100; uname(arg1); }
  // cppcheck-suppress shiftTooManyBits
  x = 1 << x;
}

void test__uname__arg1__notnull() {
  // cppcheck-suppress nullPointer
  uname(NULL);
}

void test__endpwent__noreturn() {
  int x = 1;
  if (cond) { x=100; endpwent(); }
  // cppcheck-suppress shiftTooManyBits
  x = 1 << x;
}

void test__getpwent__noreturn() {
  int x = 1;
  if (cond) { x=100; result = getpwent(); }
  // cppcheck-suppress shiftTooManyBits
  x = 1 << x;
}

void test__getpwent__useretval() {
  // cppcheck-suppress ignoredReturnValue
  getpwent();
}

void test__getpwnam__noreturn() {
  int x = 1;
  if (cond) { x=100; result = getpwnam(arg1); }
  // cppcheck-suppress shiftTooManyBits
  x = 1 << x;
}

void test__getpwnam__useretval() {
  // cppcheck-suppress ignoredReturnValue
  getpwnam(arg1);
}

void test__getpwnam__arg1__notuninit() {
  int x;
  // cppcheck-suppress uninitvar
  result = getpwnam(x);
}

void test__strtok_r__noreturn() {
  int x = 1;
  if (cond) { x=100; strtok_r(arg1, arg2, arg3); }
  // cppcheck-suppress shiftTooManyBits
  x = 1 << x;
}

void test__strtok_r__pure(int arg1,int arg2,int arg3) {
  // cppcheck-suppress incorrectLogicOperator
  if ((strtok_r(arg1, arg2, arg3) > 10) || (strtok_r(arg1, arg2, arg3) < 100)) {}
}

void test__strtok_r__leakignore() {
  char *p = malloc(10); *p=0;
  strtok_r(p, arg2, arg3);
  // cppcheck-suppress memleak
}

void test__strtok_r__arg1__notuninit() {
  int x;
  // cppcheck-suppress uninitvar
  strtok_r(x, arg2, arg3);
}

void test__strtok_r__arg2__notnull() {
  // cppcheck-suppress nullPointer
  strtok_r(arg1, NULL, arg3);
}

void test__strtok_r__arg2__notuninit() {
  int x[10];
  // cppcheck-suppress uninitvar
  strtok_r(arg1, x, arg3);
}

void test__strtok_r__arg3__notnull() {
  // cppcheck-suppress nullPointer
  strtok_r(arg1, arg2, NULL);
}

void test__getpwnam_r__noreturn() {
  int x = 1;
  if (cond) { x=100; result = getpwnam_r(arg1, arg2, arg3, arg4, arg5); }
  // cppcheck-suppress shiftTooManyBits
  x = 1 << x;
}

void test__getpwnam_r__useretval() {
  // cppcheck-suppress ignoredReturnValue
  getpwnam_r(arg1, arg2, arg3, arg4, arg5);
}

void test__getpwnam_r__arg1__notuninit() {
  int x;
  // cppcheck-suppress uninitvar
  result = getpwnam_r(x, arg2, arg3, arg4, arg5);
}

void test__getpwnam_r__arg4__notuninit() {
  int x;
  // cppcheck-suppress uninitvar
  result = getpwnam_r(arg1, arg2, arg3, x, arg5);
}

void test__getpwuid__noreturn() {
  int x = 1;
  if (cond) { x=100; result = getpwuid(arg1); }
  // cppcheck-suppress shiftTooManyBits
  x = 1 << x;
}

void test__getpwuid__useretval() {
  // cppcheck-suppress ignoredReturnValue
  getpwuid(arg1);
}

void test__getpwuid__arg1__notuninit() {
  int x;
  // cppcheck-suppress uninitvar
  result = getpwuid(x);
}

void test__getpwuid_r__noreturn() {
  int x = 1;
  if (cond) { x=100; getpwuid_r(arg1, arg2, arg3, arg4, arg5); }
  // cppcheck-suppress shiftTooManyBits
  x = 1 << x;
}

void test__getpwuid_r__arg1__notuninit() {
  int x;
  // cppcheck-suppress uninitvar
  getpwuid_r(x, arg2, arg3, arg4, arg5);
}

void test__getpwuid_r__arg4__notuninit() {
  int x;
  // cppcheck-suppress uninitvar
  getpwuid_r(arg1, arg2, arg3, x, arg5);
}

void test__setpwent__noreturn() {
  int x = 1;
  if (cond) { x=100; setpwent(); }
  // cppcheck-suppress shiftTooManyBits
  x = 1 << x;
}

void test__catclose__noreturn() {
  int x = 1;
  if (cond) { x=100; catclose(arg1); }
  // cppcheck-suppress shiftTooManyBits
  x = 1 << x;
}

void test__catclose__arg1__notuninit() {
  int x;
  // cppcheck-suppress uninitvar
  catclose(x);
}

void test__catgets__noreturn() {
  int x = 1;
  if (cond) { x=100; result = catgets(arg1, arg2, arg3, arg4); }
  // cppcheck-suppress shiftTooManyBits
  x = 1 << x;
}

void test__catgets__useretval() {
  // cppcheck-suppress ignoredReturnValue
  catgets(arg1, arg2, arg3, arg4);
}

void test__catgets__arg1__notuninit() {
  int x;
  // cppcheck-suppress uninitvar
  result = catgets(x, arg2, arg3, arg4);
}

void test__catgets__arg2__notuninit() {
  int x;
  // cppcheck-suppress uninitvar
  result = catgets(arg1, x, arg3, arg4);
}

void test__catgets__arg3__notuninit() {
  int x;
  // cppcheck-suppress uninitvar
  result = catgets(arg1, arg2, x, arg4);
}

void test__catgets__arg4__notuninit() {
  int x;
  // cppcheck-suppress uninitvar
  result = catgets(arg1, arg2, arg3, x);
}

void test__catopen__noreturn() {
  int x = 1;
  if (cond) { x=100; catopen(arg1, arg2); }
  // cppcheck-suppress shiftTooManyBits
  x = 1 << x;
}

void test__catopen__arg1__notnull() {
  // cppcheck-suppress nullPointer
  catopen(NULL, arg2);
}

void test__catopen__arg1__notuninit() {
  int x[10];
  // cppcheck-suppress uninitvar
  catopen(x, arg2);
}

void test__catopen__arg2__notuninit() {
  int x;
  // cppcheck-suppress uninitvar
  catopen(arg1, x);
}

void test__poll__noreturn() {
  int x = 1;
  if (cond) { x=100; poll(arg1, arg2, arg3); }
  // cppcheck-suppress shiftTooManyBits
  x = 1 << x;
}

void test__poll__arg1__notuninit() {
  int x;
  // cppcheck-suppress uninitvar
  poll(x, arg2, arg3);
}

void test__poll__arg2__notuninit() {
  int x;
  // cppcheck-suppress uninitvar
  poll(arg1, x, arg3);
}

void test__poll__arg3__notuninit() {
  int x;
  // cppcheck-suppress uninitvar
  poll(arg1, arg2, x);
}

void test__regcomp__noreturn() {
  int x = 1;
  if (cond) { x=100; regcomp(arg1, arg2, arg3); }
  // cppcheck-suppress shiftTooManyBits
  x = 1 << x;
}

void test__regcomp__arg1__notnull() {
  // cppcheck-suppress nullPointer
  regcomp(NULL, arg2, arg3);
}

void test__regcomp__arg2__notuninit() {
  int x;
  // cppcheck-suppress uninitvar
  regcomp(arg1, x, arg3);
}

void test__regcomp__arg3__notuninit() {
  int x;
  // cppcheck-suppress uninitvar
  regcomp(arg1, arg2, x);
}

void test__regerror__noreturn() {
  int x = 1;
  if (cond) { x=100; regerror(arg1, arg2, arg3, arg4); }
  // cppcheck-suppress shiftTooManyBits
  x = 1 << x;
}

void test__regerror__arg1__notuninit() {
  int x;
  // cppcheck-suppress uninitvar
  regerror(x, arg2, arg3, arg4);
}

void test__regerror__arg2__notuninit() {
  int x;
  // cppcheck-suppress uninitvar
  regerror(arg1, x, arg3, arg4);
}

void test__regerror__arg4__notuninit() {
  int x;
  // cppcheck-suppress uninitvar
  regerror(arg1, arg2, arg3, x);
}

void test__regexec__noreturn() {
  int x = 1;
  if (cond) { x=100; regexec(arg1, arg2, arg3, arg4, arg5); }
  // cppcheck-suppress shiftTooManyBits
  x = 1 << x;
}

void test__regexec__arg1__notnull() {
  // cppcheck-suppress nullPointer
  regexec(NULL, arg2, arg3, arg4, arg5);
}

void test__regexec__arg1__notuninit() {
  int x[10];
  // cppcheck-suppress uninitvar
  regexec(x, arg2, arg3, arg4, arg5);
}

void test__regexec__arg2__notnull() {
  // cppcheck-suppress nullPointer
  regexec(arg1, NULL, arg3, arg4, arg5);
}

void test__regexec__arg2__notuninit() {
  int x[10];
  // cppcheck-suppress uninitvar
  regexec(arg1, x, arg3, arg4, arg5);
}

void test__regexec__arg3__notuninit() {
  int x;
  // cppcheck-suppress uninitvar
  regexec(arg1, arg2, x, arg4, arg5);
}

void test__regexec__arg4__notuninit() {
  int x;
  // cppcheck-suppress uninitvar
  regexec(arg1, arg2, arg3, x, arg5);
}

void test__regexec__arg5__notuninit() {
  int x;
  // cppcheck-suppress uninitvar
  regexec(arg1, arg2, arg3, arg4, x);
}

void test__regfree__noreturn() {
  int x = 1;
  if (cond) { x=100; regfree(arg1); }
  // cppcheck-suppress shiftTooManyBits
  x = 1 << x;
}

void test__regfree__arg1__notnull() {
  // cppcheck-suppress nullPointer
  regfree(NULL);
}

void test__regfree__arg1__notuninit() {
  int x[10];
  // cppcheck-suppress uninitvar
  regfree(x);
}

void test__sched_get_priority_max__noreturn() {
  int x = 1;
  if (cond) { x=100; sched_get_priority_max(arg1); }
  // cppcheck-suppress shiftTooManyBits
  x = 1 << x;
}

void test__sched_get_priority_max__arg1__notuninit() {
  int x;
  // cppcheck-suppress uninitvar
  sched_get_priority_max(x);
}

void test__sched_get_priority_min__noreturn() {
  int x = 1;
  if (cond) { x=100; sched_get_priority_min(arg1); }
  // cppcheck-suppress shiftTooManyBits
  x = 1 << x;
}

void test__sched_get_priority_min__arg1__notuninit() {
  int x;
  // cppcheck-suppress uninitvar
  sched_get_priority_min(x);
}

void test__sched_getparam__noreturn() {
  int x = 1;
  if (cond) { x=100; sched_getparam(arg1, arg2); }
  // cppcheck-suppress shiftTooManyBits
  x = 1 << x;
}

void test__sched_getparam__arg1__notuninit() {
  int x;
  // cppcheck-suppress uninitvar
  sched_getparam(x, arg2);
}

void test__sched_getparam__arg2__notnull() {
  // cppcheck-suppress nullPointer
  sched_getparam(arg1, NULL);
}

void test__sched_getscheduler__noreturn() {
  int x = 1;
  if (cond) { x=100; sched_getscheduler(arg1); }
  // cppcheck-suppress shiftTooManyBits
  x = 1 << x;
}

void test__sched_getscheduler__arg1__notuninit() {
  int x;
  // cppcheck-suppress uninitvar
  sched_getscheduler(x);
}

void test__sched_rr_get_interval__noreturn() {
  int x = 1;
  if (cond) { x=100; sched_rr_get_interval(arg1, arg2); }
  // cppcheck-suppress shiftTooManyBits
  x = 1 << x;
}

void test__sched_rr_get_interval__arg1__notuninit() {
  int x;
  // cppcheck-suppress uninitvar
  sched_rr_get_interval(x, arg2);
}

void test__sched_rr_get_interval__arg2__notnull() {
  // cppcheck-suppress nullPointer
  sched_rr_get_interval(arg1, NULL);
}

void test__sched_setparam__noreturn() {
  int x = 1;
  if (cond) { x=100; sched_setparam(arg1, arg2); }
  // cppcheck-suppress shiftTooManyBits
  x = 1 << x;
}

void test__sched_setparam__arg1__notuninit() {
  int x;
  // cppcheck-suppress uninitvar
  sched_setparam(x, arg2);
}

void test__sched_setparam__arg2__notuninit() {
  int x;
  // cppcheck-suppress uninitvar
  sched_setparam(arg1, x);
}

void test__sched_setscheduler__noreturn() {
  int x = 1;
  if (cond) { x=100; sched_setscheduler(arg1, arg2, arg3); }
  // cppcheck-suppress shiftTooManyBits
  x = 1 << x;
}

void test__sched_setscheduler__arg1__notuninit() {
  int x;
  // cppcheck-suppress uninitvar
  sched_setscheduler(x, arg2, arg3);
}

void test__sched_setscheduler__arg2__notuninit() {
  int x;
  // cppcheck-suppress uninitvar
  sched_setscheduler(arg1, x, arg3);
}

void test__sched_setscheduler__arg3__notuninit() {
  int x;
  // cppcheck-suppress uninitvar
  sched_setscheduler(arg1, arg2, x);
}

void test__sched_yield__noreturn() {
  int x = 1;
  if (cond) { x=100; sched_yield(); }
  // cppcheck-suppress shiftTooManyBits
  x = 1 << x;
}

void test__ecvt__noreturn() {
  int x = 1;
  if (cond) { x=100; ecvt(arg1, arg2, arg3, arg4); }
  // cppcheck-suppress shiftTooManyBits
  x = 1 << x;
}

void test__ecvt__arg1__notuninit() {
  int x;
  // cppcheck-suppress uninitvar
  ecvt(x, arg2, arg3, arg4);
}

void test__ecvt__arg2__notuninit() {
  int x;
  // cppcheck-suppress uninitvar
  ecvt(arg1, x, arg3, arg4);
}

void test__ecvt__arg3__notnull() {
  // cppcheck-suppress nullPointer
  ecvt(arg1, arg2, NULL, arg4);
}

void test__ecvt__arg4__notnull() {
  // cppcheck-suppress nullPointer
  ecvt(arg1, arg2, arg3, NULL);
}

void test__fcvt__noreturn() {
  int x = 1;
  if (cond) { x=100; fcvt(arg1, arg2, arg3, arg4); }
  // cppcheck-suppress shiftTooManyBits
  x = 1 << x;
}

void test__fcvt__arg1__notuninit() {
  int x;
  // cppcheck-suppress uninitvar
  fcvt(x, arg2, arg3, arg4);
}

void test__fcvt__arg2__notuninit() {
  int x;
  // cppcheck-suppress uninitvar
  fcvt(arg1, x, arg3, arg4);
}

void test__fcvt__arg3__notnull() {
  // cppcheck-suppress nullPointer
  fcvt(arg1, arg2, NULL, arg4);
}

void test__fcvt__arg4__notnull() {
  // cppcheck-suppress nullPointer
  fcvt(arg1, arg2, arg3, NULL);
}

void test__gcvt__noreturn() {
  int x = 1;
  if (cond) { x=100; gcvt(arg1, arg2, arg3); }
  // cppcheck-suppress shiftTooManyBits
  x = 1 << x;
}

void test__gcvt__arg1__notuninit() {
  int x;
  // cppcheck-suppress uninitvar
  gcvt(x, arg2, arg3);
}

void test__gcvt__arg2__notuninit() {
  int x;
  // cppcheck-suppress uninitvar
  gcvt(arg1, x, arg3);
}

void test__gcvt__arg3__notnull() {
  // cppcheck-suppress nullPointer
  gcvt(arg1, arg2, NULL);
}

void test__lseek__noreturn() {
  int x = 1;
  if (cond) { x=100; lseek(arg1, arg2, arg3); }
  // cppcheck-suppress shiftTooManyBits
  x = 1 << x;
}

void test__lseek__leakignore() {
  char *p = malloc(10); *p=0;
  lseek(p, arg2, arg3);
  // cppcheck-suppress memleak
}

void test__lseek__arg1__notuninit() {
  int x;
  // cppcheck-suppress uninitvar
  lseek(x, arg2, arg3);
}

void test__lseek__arg2__notuninit() {
  int x;
  // cppcheck-suppress uninitvar
  lseek(arg1, x, arg3);
}

void test__lseek__arg3__notuninit() {
  int x;
  // cppcheck-suppress uninitvar
  lseek(arg1, arg2, x);
}

void test__nanosleep__noreturn() {
  int x = 1;
  if (cond) { x=100; nanosleep(arg1, arg2); }
  // cppcheck-suppress shiftTooManyBits
  x = 1 << x;
}

void test__nanosleep__leakignore() {
  char *p = malloc(10); *p=0;
  nanosleep(p, arg2);
  // cppcheck-suppress memleak
}

void test__nanosleep__arg1__notnull() {
  // cppcheck-suppress nullPointer
  nanosleep(NULL, arg2);
}

void test__setkey__noreturn() {
  int x = 1;
  if (cond) { x=100; setkey(arg1); }
  // cppcheck-suppress shiftTooManyBits
  x = 1 << x;
}

void test__setkey__leakignore() {
  char *p = malloc(10); *p=0;
  setkey(p);
  // cppcheck-suppress memleak
}

void test__setkey__arg1__notnull() {
  // cppcheck-suppress nullPointer
  setkey(NULL);
}

void test__setkey__arg1__notuninit() {
  int x[10];
  // cppcheck-suppress uninitvar
  setkey(x);
}

void test__getpass__noreturn() {
  int x = 1;
  if (cond) { x=100; getpass(arg1); }
  // cppcheck-suppress shiftTooManyBits
  x = 1 << x;
}

void test__getpass__leakignore() {
  char *p = malloc(10); *p=0;
  getpass(p);
  // cppcheck-suppress memleak
}

void test__getpass__arg1__notnull() {
  // cppcheck-suppress nullPointer
  getpass(NULL);
}

void test__drand48__noreturn() {
  int x = 1;
  if (cond) { x=100; result = drand48(); }
  // cppcheck-suppress shiftTooManyBits
  x = 1 << x;
}

void test__drand48__useretval() {
  // cppcheck-suppress ignoredReturnValue
  drand48();
}

void test__putenv__noreturn() {
  int x = 1;
  if (cond) { x=100; putenv(arg1); }
  // cppcheck-suppress shiftTooManyBits
  x = 1 << x;
}

void test__putenv__arg1__notnull() {
  // cppcheck-suppress nullPointer
  putenv(NULL);
}

void test__putenv__arg1__notuninit() {
  int x[10];
  // cppcheck-suppress uninitvar
  putenv(x);
}

void test__setenv__noreturn() {
  int x = 1;
  if (cond) { x=100; setenv(arg1, arg2, arg3); }
  // cppcheck-suppress shiftTooManyBits
  x = 1 << x;
}

void test__setenv__arg1__notnull() {
  // cppcheck-suppress nullPointer
  setenv(NULL, arg2, arg3);
}

void test__setenv__arg1__notuninit() {
  int x[10];
  // cppcheck-suppress uninitvar
  setenv(x, arg2, arg3);
}

void test__setenv__arg2__notnull() {
  // cppcheck-suppress nullPointer
  setenv(arg1, NULL, arg3);
}

void test__setenv__arg2__notuninit() {
  int x[10];
  // cppcheck-suppress uninitvar
  setenv(arg1, x, arg3);
}

void test__setenv__arg3__notuninit() {
  int x;
  // cppcheck-suppress uninitvar
  setenv(arg1, arg2, x);
}

void test__unsetenv__noreturn() {
  int x = 1;
  if (cond) { x=100; unsetenv(arg1); }
  // cppcheck-suppress shiftTooManyBits
  x = 1 << x;
}

void test__unsetenv__arg1__notnull() {
  // cppcheck-suppress nullPointer
  unsetenv(NULL);
}

void test__unsetenv__arg1__notuninit() {
  int x[10];
  // cppcheck-suppress uninitvar
  unsetenv(x);
}

void test__localtime__noreturn() {
  int x = 1;
  if (cond) { x=100; localtime(arg1); }
  // cppcheck-suppress shiftTooManyBits
  x = 1 << x;
}

void test__localtime__leakignore() {
  char *p = malloc(10); *p=0;
  localtime(p);
  // cppcheck-suppress memleak
}

void test__localtime__arg1__notnull() {
  // cppcheck-suppress nullPointer
  localtime(NULL);
}

void test__localtime__arg1__notuninit() {
  int x[10];
  // cppcheck-suppress uninitvar
  localtime(x);
}

void test__std__localtime__noreturn() {
  int x = 1;
  if (cond) { x=100; std::localtime(arg1); }
  // cppcheck-suppress shiftTooManyBits
  x = 1 << x;
}

void test__std__localtime__arg1__notnull() {
  // cppcheck-suppress nullPointer
  std::localtime(NULL);
}

void test__std__localtime__arg1__notuninit() {
  int x[10];
  // cppcheck-suppress uninitvar
  std::localtime(x);
}

void test__localtime_r__noreturn() {
  int x = 1;
  if (cond) { x=100; localtime_r(arg1, arg2); }
  // cppcheck-suppress shiftTooManyBits
  x = 1 << x;
}

void test__localtime_r__leakignore() {
  char *p = malloc(10); *p=0;
  localtime_r(p, arg2);
  // cppcheck-suppress memleak
}

void test__localtime_r__arg1__notnull() {
  // cppcheck-suppress nullPointer
  localtime_r(NULL, arg2);
}

void test__localtime_r__arg1__notuninit() {
  int x[10];
  // cppcheck-suppress uninitvar
  localtime_r(x, arg2);
}

void test__localtime_r__arg2__notnull() {
  // cppcheck-suppress nullPointer
  localtime_r(arg1, NULL);
}

void test__readdir__noreturn() {
  int x = 1;
  if (cond) { x=100; readdir(arg1); }
  // cppcheck-suppress shiftTooManyBits
  x = 1 << x;
}

void test__readdir__leakignore() {
  char *p = malloc(10); *p=0;
  readdir(p);
  // cppcheck-suppress memleak
}

void test__readdir__arg1__notnull() {
  // cppcheck-suppress nullPointer
  readdir(NULL);
}

void test__readdir__arg1__notuninit() {
  int x[10];
  // cppcheck-suppress uninitvar
  readdir(x);
}

void test__readdir_r__noreturn() {
  int x = 1;
  if (cond) { x=100; readdir_r(arg1, arg2, arg3); }
  // cppcheck-suppress shiftTooManyBits
  x = 1 << x;
}

void test__readdir_r__leakignore() {
  char *p = malloc(10); *p=0;
  readdir_r(p, arg2, arg3);
  // cppcheck-suppress memleak
}

void test__readdir_r__arg1__notnull() {
  // cppcheck-suppress nullPointer
  readdir_r(NULL, arg2, arg3);
}

void test__readdir_r__arg1__notuninit() {
  int x[10];
  // cppcheck-suppress uninitvar
  readdir_r(x, arg2, arg3);
}

void test__readdir_r__arg2__notnull() {
  // cppcheck-suppress nullPointer
  readdir_r(arg1, NULL, arg3);
}

void test__readdir_r__arg3__notnull() {
  // cppcheck-suppress nullPointer
  readdir_r(arg1, arg2, NULL);
}

void test__readlink__noreturn() {
  int x = 1;
  if (cond) { x=100; readlink(arg1, arg2, arg3); }
  // cppcheck-suppress shiftTooManyBits
  x = 1 << x;
}

void test__readlink__leakignore() {
  char *p = malloc(10); *p=0;
  readlink(p, arg2, arg3);
  // cppcheck-suppress memleak
}

void test__readlink__arg1__notnull() {
  // cppcheck-suppress nullPointer
  readlink(NULL, arg2, arg3);
}

void test__readlink__arg1__notuninit() {
  int x[10];
  // cppcheck-suppress uninitvar
  readlink(x, arg2, arg3);
}

void test__readlink__arg2__notnull() {
  // cppcheck-suppress nullPointer
  readlink(arg1, NULL, arg3);
}

void test__readlink__arg3__notuninit() {
  int x;
  // cppcheck-suppress uninitvar
  readlink(arg1, arg2, x);
}

void test__readlinkat__noreturn() {
  int x = 1;
  if (cond) { x=100; readlinkat(arg1, arg2, arg3, arg4); }
  // cppcheck-suppress shiftTooManyBits
  x = 1 << x;
}

void test__readlinkat__leakignore() {
  char *p = malloc(10); *p=0;
  readlinkat(p, arg2, arg3, arg4);
  // cppcheck-suppress memleak
}

void test__readlinkat__arg1__notuninit() {
  int x;
  // cppcheck-suppress uninitvar
  readlinkat(x, arg2, arg3, arg4);
}

void test__readlinkat__arg2__notnull() {
  // cppcheck-suppress nullPointer
  readlinkat(arg1, NULL, arg3, arg4);
}

void test__readlinkat__arg2__notuninit() {
  int x[10];
  // cppcheck-suppress uninitvar
  readlinkat(arg1, x, arg3, arg4);
}

void test__readlinkat__arg3__notnull() {
  // cppcheck-suppress nullPointer
  readlinkat(arg1, arg2, NULL, arg4);
}

void test__readlinkat__arg4__notuninit() {
  int x;
  // cppcheck-suppress uninitvar
  readlinkat(arg1, arg2, arg3, x);
}

void test__asctime_r__noreturn() {
  int x = 1;
  if (cond) { x=100; asctime_r(arg1, arg2); }
  // cppcheck-suppress shiftTooManyBits
  x = 1 << x;
}

void test__asctime_r__leakignore() {
  char *p = malloc(10); *p=0;
  asctime_r(p, arg2);
  // cppcheck-suppress memleak
}

void test__asctime_r__arg1__notnull() {
  // cppcheck-suppress nullPointer
  asctime_r(NULL, arg2);
}

void test__asctime_r__arg1__notuninit() {
  int x[10];
  // cppcheck-suppress uninitvar
  asctime_r(x, arg2);
}

void test__asctime_r__arg2__notnull() {
  // cppcheck-suppress nullPointer
  asctime_r(arg1, NULL);
}

void test__ctime_r__noreturn() {
  int x = 1;
  if (cond) { x=100; ctime_r(arg1, arg2); }
  // cppcheck-suppress shiftTooManyBits
  x = 1 << x;
}

void test__ctime_r__leakignore() {
  char *p = malloc(10); *p=0;
  ctime_r(p, arg2);
  // cppcheck-suppress memleak
}

void test__ctime_r__arg1__notnull() {
  // cppcheck-suppress nullPointer
  ctime_r(NULL, arg2);
}

void test__ctime_r__arg1__notuninit() {
  int x[10];
  // cppcheck-suppress uninitvar
  ctime_r(x, arg2);
}

void test__ctime_r__arg2__notnull() {
  // cppcheck-suppress nullPointer
  ctime_r(arg1, NULL);
}

void test__gmtime_r__noreturn() {
  int x = 1;
  if (cond) { x=100; gmtime_r(arg1, arg2); }
  // cppcheck-suppress shiftTooManyBits
  x = 1 << x;
}

void test__gmtime_r__leakignore() {
  char *p = malloc(10); *p=0;
  gmtime_r(p, arg2);
  // cppcheck-suppress memleak
}

void test__gmtime_r__arg1__notnull() {
  // cppcheck-suppress nullPointer
  gmtime_r(NULL, arg2);
}

void test__gmtime_r__arg1__notuninit() {
  int x[10];
  // cppcheck-suppress uninitvar
  gmtime_r(x, arg2);
}

void test__gmtime_r__arg2__notnull() {
  // cppcheck-suppress nullPointer
  gmtime_r(arg1, NULL);
}

void test__gmtime__noreturn() {
  int x = 1;
  if (cond) { x=100; result = gmtime(arg1); }
  // cppcheck-suppress shiftTooManyBits
  x = 1 << x;
}

void test__gmtime__useretval() {
  // cppcheck-suppress ignoredReturnValue
  gmtime(arg1);
}

void test__gmtime__leakignore() {
  char *p = malloc(10); *p=0;
  result = gmtime(p);
  // cppcheck-suppress memleak
}

void test__gmtime__arg1__notnull() {
  // cppcheck-suppress nullPointer
  result = gmtime(NULL);
}

void test__gmtime__arg1__notuninit() {
  int x[10];
  // cppcheck-suppress uninitvar
  result = gmtime(x);
}

void test__clock_settime__noreturn() {
  int x = 1;
  if (cond) { x=100; clock_settime(arg1, arg2); }
  // cppcheck-suppress shiftTooManyBits
  x = 1 << x;
}

void test__clock_settime__arg1__notuninit() {
  int x;
  // cppcheck-suppress uninitvar
  clock_settime(x, arg2);
}

void test__clock_settime__arg2__notuninit() {
  int x;
  // cppcheck-suppress uninitvar
  clock_settime(arg1, x);
}

void test__killpg__noreturn() {
  int x = 1;
  if (cond) { x=100; killpg(arg1, arg2); }
  // cppcheck-suppress shiftTooManyBits
  x = 1 << x;
}

void test__killpg__arg1__notuninit() {
  int x;
  // cppcheck-suppress uninitvar
  killpg(x, arg2);
}

void test__killpg__arg2__notuninit() {
  int x;
  // cppcheck-suppress uninitvar
  killpg(arg1, x);
}

void test__kill__noreturn() {
  int x = 1;
  if (cond) { x=100; kill(arg1, arg2); }
  // cppcheck-suppress shiftTooManyBits
  x = 1 << x;
}

void test__kill__arg1__notuninit() {
  int x;
  // cppcheck-suppress uninitvar
  kill(x, arg2);
}

void test__kill__arg2__notuninit() {
  int x;
  // cppcheck-suppress uninitvar
  kill(arg1, x);
}

void test__clock_gettime__noreturn() {
  int x = 1;
  if (cond) { x=100; clock_gettime(arg1, arg2); }
  // cppcheck-suppress shiftTooManyBits
  x = 1 << x;
}

void test__clock_gettime__arg1__notuninit() {
  int x;
  // cppcheck-suppress uninitvar
  clock_gettime(x, arg2);
}

void test__clock_gettime__arg2__notnull() {
  // cppcheck-suppress nullPointer
  clock_gettime(arg1, NULL);
}

void test__clock_getres__noreturn() {
  int x = 1;
  if (cond) { x=100; clock_getres(arg1, arg2); }
  // cppcheck-suppress shiftTooManyBits
  x = 1 << x;
}

void test__clock_getres__arg1__notuninit() {
  int x;
  // cppcheck-suppress uninitvar
  clock_getres(x, arg2);
}

void test__tmpnam__noreturn() {
  int x = 1;
  if (cond) { x=100; tmpnam(arg1); }
  // cppcheck-suppress shiftTooManyBits
  x = 1 << x;
}

void test__tmpnam__leakignore() {
  char *p = malloc(10); *p=0;
  tmpnam(p);
  // cppcheck-suppress memleak
}

void test__tmpnam__arg1__notuninit() {
  int x;
  // cppcheck-suppress uninitvar
  tmpnam(x);
}

void test__tmpnam_r__noreturn() {
  int x = 1;
  if (cond) { x=100; tmpnam_r(arg1); }
  // cppcheck-suppress shiftTooManyBits
  x = 1 << x;
}

void test__tmpnam_r__leakignore() {
  char *p = malloc(10); *p=0;
  tmpnam_r(p);
  // cppcheck-suppress memleak
}

void test__tmpnam_r__arg1__notuninit() {
  int x;
  // cppcheck-suppress uninitvar
  tmpnam_r(x);
}

void test__makecontext__noreturn() {
  int x = 1;
  if (cond) { x=100; makecontext(arg1, arg2, arg3); }
  // cppcheck-suppress shiftTooManyBits
  x = 1 << x;
}

void test__makecontext__leakignore() {
  char *p = malloc(10); *p=0;
  makecontext(p, arg2, arg3);
  // cppcheck-suppress memleak
}

void test__makecontext__arg1__notnull() {
  // cppcheck-suppress nullPointer
  makecontext(NULL, arg2, arg3);
}

void test__makecontext__arg2__notnull() {
  // cppcheck-suppress nullPointer
  makecontext(arg1, NULL, arg3);
}

void test__makecontext__arg2__notuninit() {
  int x[10];
  // cppcheck-suppress uninitvar
  makecontext(arg1, x, arg3);
}

void test__makecontext__arg3__notuninit() {
  int x;
  // cppcheck-suppress uninitvar
  makecontext(arg1, arg2, x);
}

void test__swapcontext__noreturn() {
  int x = 1;
  if (cond) { x=100; swapcontext(arg1, arg2); }
  // cppcheck-suppress shiftTooManyBits
  x = 1 << x;
}

void test__swapcontext__leakignore() {
  char *p = malloc(10); *p=0;
  swapcontext(p, arg2);
  // cppcheck-suppress memleak
}

void test__swapcontext__arg1__notnull() {
  // cppcheck-suppress nullPointer
  swapcontext(NULL, arg2);
}

void test__swapcontext__arg2__notnull() {
  // cppcheck-suppress nullPointer
  swapcontext(arg1, NULL);
}

void test__getcontext__noreturn() {
  int x = 1;
  if (cond) { x=100; getcontext(arg1); }
  // cppcheck-suppress shiftTooManyBits
  x = 1 << x;
}

void test__getcontext__leakignore() {
  char *p = malloc(10); *p=0;
  getcontext(p);
  // cppcheck-suppress memleak
}

void test__getcontext__arg1__notnull() {
  // cppcheck-suppress nullPointer
  getcontext(NULL);
}

void test__ualarm__noreturn() {
  int x = 1;
  if (cond) { x=100; ualarm(arg1, arg2); }
  // cppcheck-suppress shiftTooManyBits
  x = 1 << x;
}

void test__ualarm__leakignore() {
  char *p = malloc(10); *p=0;
  ualarm(p, arg2);
  // cppcheck-suppress memleak
}

void test__ualarm__arg1__notuninit() {
  int x;
  // cppcheck-suppress uninitvar
  ualarm(x, arg2);
}

void test__ualarm__arg2__notuninit() {
  int x;
  // cppcheck-suppress uninitvar
  ualarm(arg1, x);
}

void test__scalb__noreturn() {
  int x = 1;
  if (cond) { x=100; result = scalb(arg1, arg2); }
  // cppcheck-suppress shiftTooManyBits
  x = 1 << x;
}

void test__scalb__useretval() {
  // cppcheck-suppress ignoredReturnValue
  scalb(arg1, arg2);
}

void test__scalb__leakignore() {
  char *p = malloc(10); *p=0;
  result = scalb(p, arg2);
  // cppcheck-suppress memleak
}

void test__scalb__arg1__notuninit() {
  int x;
  // cppcheck-suppress uninitvar
  result = scalb(x, arg2);
}

void test__scalb__arg2__notuninit() {
  int x;
  // cppcheck-suppress uninitvar
  result = scalb(arg1, x);
}

void test__bcopy__noreturn() {
  int x = 1;
  if (cond) { x=100; bcopy(arg1, arg2, arg3); }
  // cppcheck-suppress shiftTooManyBits
  x = 1 << x;
}

void test__bcopy__leakignore() {
  char *p = malloc(10); *p=0;
  bcopy(p, arg2, arg3);
  // cppcheck-suppress memleak
}

void test__bcopy__arg1__notnull() {
  // cppcheck-suppress nullPointer
  bcopy(NULL, arg2, arg3);
}

void test__bcopy__arg1__notuninit() {
  int x[10];
  // cppcheck-suppress uninitvar
  bcopy(x, arg2, arg3);
}

void test__bcopy__arg2__notnull() {
  // cppcheck-suppress nullPointer
  bcopy(arg1, NULL, arg3);
}

void test__bcopy__arg3__notuninit() {
  int x;
  // cppcheck-suppress uninitvar
  bcopy(arg1, arg2, x);
}

void test__bcmp__noreturn() {
  int x = 1;
  if (cond) { x=100; result = bcmp(arg1, arg2, arg3); }
  // cppcheck-suppress shiftTooManyBits
  x = 1 << x;
}

void test__bcmp__useretval() {
  // cppcheck-suppress ignoredReturnValue
  bcmp(arg1, arg2, arg3);
}

void test__bcmp__leakignore() {
  char *p = malloc(10); *p=0;
  result = bcmp(p, arg2, arg3);
  // cppcheck-suppress memleak
}

void test__bcmp__arg1__notnull() {
  // cppcheck-suppress nullPointer
  result = bcmp(NULL, arg2, arg3);
}

void test__bcmp__arg1__notuninit() {
  int x[10];
  // cppcheck-suppress uninitvar
  result = bcmp(x, arg2, arg3);
}

void test__bcmp__arg2__notnull() {
  // cppcheck-suppress nullPointer
  result = bcmp(arg1, NULL, arg3);
}

void test__bcmp__arg2__notuninit() {
  int x[10];
  // cppcheck-suppress uninitvar
  result = bcmp(arg1, x, arg3);
}

void test__bcmp__arg3__notuninit() {
  int x;
  // cppcheck-suppress uninitvar
  result = bcmp(arg1, arg2, x);
}

void test__bzero__noreturn() {
  int x = 1;
  if (cond) { x=100; bzero(arg1, arg2); }
  // cppcheck-suppress shiftTooManyBits
  x = 1 << x;
}

void test__bzero__leakignore() {
  char *p = malloc(10); *p=0;
  bzero(p, arg2);
  // cppcheck-suppress memleak
}

void test__bzero__arg1__notnull() {
  // cppcheck-suppress nullPointer
  bzero(NULL, arg2);
}

void test__bzero__arg2__notuninit() {
  int x;
  // cppcheck-suppress uninitvar
  bzero(arg1, x);
}

void test__ftime__noreturn() {
  int x = 1;
  if (cond) { x=100; ftime(arg1); }
  // cppcheck-suppress shiftTooManyBits
  x = 1 << x;
}

void test__ftime__leakignore() {
  char *p = malloc(10); *p=0;
  ftime(p);
  // cppcheck-suppress memleak
}

void test__ftime__arg1__notuninit() {
  int x;
  // cppcheck-suppress uninitvar
  ftime(x);
}

void test__wcswcs__noreturn() {
  int x = 1;
  if (cond) { x=100; result = wcswcs(arg1, arg2); }
  // cppcheck-suppress shiftTooManyBits
  x = 1 << x;
}

void test__wcswcs__useretval() {
  // cppcheck-suppress ignoredReturnValue
  wcswcs(arg1, arg2);
}

void test__wcswcs__leakignore() {
  char *p = malloc(10); *p=0;
  result = wcswcs(p, arg2);
  // cppcheck-suppress memleak
}

void test__wcswcs__arg1__notnull() {
  // cppcheck-suppress nullPointer
  result = wcswcs(NULL, arg2);
}

void test__wcswcs__arg1__notuninit() {
  int x[10];
  // cppcheck-suppress uninitvar
  result = wcswcs(x, arg2);
}

void test__wcswcs__arg2__notnull() {
  // cppcheck-suppress nullPointer
  result = wcswcs(arg1, NULL);
}

void test__wcswcs__arg2__notuninit() {
  int x[10];
  // cppcheck-suppress uninitvar
  result = wcswcs(arg1, x);
}

void test__stpcpy__noreturn() {
  int x = 1;
  if (cond) { x=100; stpcpy(arg1, arg2); }
  // cppcheck-suppress shiftTooManyBits
  x = 1 << x;
}

void test__stpcpy__leakignore() {
  char *p = malloc(10); *p=0;
  stpcpy(p, arg2);
  // cppcheck-suppress memleak
}

void test__stpcpy__arg1__notnull() {
  // cppcheck-suppress nullPointer
  stpcpy(NULL, arg2);
}

void test__stpcpy__arg2__notnull() {
  // cppcheck-suppress nullPointer
  stpcpy(arg1, NULL);
}

void test__stpcpy__arg2__notuninit() {
  int x[10];
  // cppcheck-suppress uninitvar
  stpcpy(arg1, x);
}

void test__index__noreturn() {
  int x = 1;
  if (cond) { x=100; result = index(arg1, arg2); }
  // cppcheck-suppress shiftTooManyBits
  x = 1 << x;
}

void test__index__useretval() {
  // cppcheck-suppress ignoredReturnValue
  index(arg1, arg2);
}

void test__index__leakignore() {
  char *p = malloc(10); *p=0;
  result = index(p, arg2);
  // cppcheck-suppress memleak
}

void test__index__arg1__notnull() {
  // cppcheck-suppress nullPointer
  result = index(NULL, arg2);
}

void test__index__arg1__notuninit() {
  int x[10];
  // cppcheck-suppress uninitvar
  result = index(x, arg2);
}

void test__index__arg2__notuninit() {
  int x;
  // cppcheck-suppress uninitvar
  result = index(arg1, x);
}

void test__rindex__noreturn() {
  int x = 1;
  if (cond) { x=100; result = rindex(arg1, arg2); }
  // cppcheck-suppress shiftTooManyBits
  x = 1 << x;
}

void test__rindex__useretval() {
  // cppcheck-suppress ignoredReturnValue
  rindex(arg1, arg2);
}

void test__rindex__leakignore() {
  char *p = malloc(10); *p=0;
  result = rindex(p, arg2);
  // cppcheck-suppress memleak
}

void test__rindex__arg1__notnull() {
  // cppcheck-suppress nullPointer
  result = rindex(NULL, arg2);
}

void test__rindex__arg1__notuninit() {
  int x[10];
  // cppcheck-suppress uninitvar
  result = rindex(x, arg2);
}

void test__rindex__arg2__notuninit() {
  int x;
  // cppcheck-suppress uninitvar
  result = rindex(arg1, x);
}

void test__bsd_signal__noreturn() {
  int x = 1;
  if (cond) { x=100; bsd_signal(arg1, arg2); }
  // cppcheck-suppress shiftTooManyBits
  x = 1 << x;
}

void test__bsd_signal__leakignore() {
  char *p = malloc(10); *p=0;
  bsd_signal(p, arg2);
  // cppcheck-suppress memleak
}

void test__bsd_signal__arg1__notuninit() {
  int x;
  // cppcheck-suppress uninitvar
  bsd_signal(x, arg2);
}

void test__bsd_signal__arg2__notuninit() {
  int x;
  // cppcheck-suppress uninitvar
  bsd_signal(arg1, x);
}

void test__fork__noreturn() {
  int x = 1;
  if (cond) { x=100; fork(); }
  // cppcheck-suppress shiftTooManyBits
  x = 1 << x;
}

void test__fork__leakignore() {
  char *p = malloc(10); *p=0;
  fork();
  // cppcheck-suppress memleak
}

void test__vfork__noreturn() {
  int x = 1;
  if (cond) { x=100; vfork(); }
  // cppcheck-suppress shiftTooManyBits
  x = 1 << x;
}

void test__vfork__leakignore() {
  char *p = malloc(10); *p=0;
  vfork();
  // cppcheck-suppress memleak
}

void test__pthread_atfork__noreturn() {
  int x = 1;
  if (cond) { x=100; pthread_atfork(arg1, arg2, arg3); }
  // cppcheck-suppress shiftTooManyBits
  x = 1 << x;
}

void test__pthread_atfork__leakignore() {
  char *p = malloc(10); *p=0;
  pthread_atfork(p, arg2, arg3);
  // cppcheck-suppress memleak
}

void test__pthread_create__noreturn() {
  int x = 1;
  if (cond) { x=100; pthread_create(arg1, arg2, arg3, arg4); }
  // cppcheck-suppress shiftTooManyBits
  x = 1 << x;
}

void test__pthread_create__arg1__notnull() {
  // cppcheck-suppress nullPointer
  pthread_create(NULL, arg2, arg3, arg4);
}

void test__pthread_create__arg3__notnull() {
  // cppcheck-suppress nullPointer
  pthread_create(arg1, arg2, NULL, arg4);
}

void test__pthread_detach__noreturn() {
  int x = 1;
  if (cond) { x=100; pthread_detach(arg1); }
  // cppcheck-suppress shiftTooManyBits
  x = 1 << x;
}

void test__pthread_detach__arg1__notuninit() {
  int x;
  // cppcheck-suppress uninitvar
  pthread_detach(x);
}

void test__pthread_equal__noreturn() {
  int x = 1;
  if (cond) { x=100; result = pthread_equal(arg1, arg2); }
  // cppcheck-suppress shiftTooManyBits
  x = 1 << x;
}

void test__pthread_equal__useretval() {
  // cppcheck-suppress ignoredReturnValue
  pthread_equal(arg1, arg2);
}

void test__pthread_equal__arg1__notuninit() {
  int x;
  // cppcheck-suppress uninitvar
  result = pthread_equal(x, arg2);
}

void test__pthread_equal__arg2__notuninit() {
  int x;
  // cppcheck-suppress uninitvar
  result = pthread_equal(arg1, x);
}

void test__pthread_exit__noreturn() {
  int x = 1;
  if (cond) { x=100; pthread_exit(arg1); }
  // cppcheck-suppress shiftTooManyBits
  x = 1 << x;
}

void test__pthread_join__noreturn() {
  int x = 1;
  if (cond) { x=100; pthread_join(arg1, arg2); }
  // cppcheck-suppress shiftTooManyBits
  x = 1 << x;
}

void test__pthread_join__arg1__notuninit() {
  int x;
  // cppcheck-suppress uninitvar
  pthread_join(x, arg2);
}

void test__pthread_kill__noreturn() {
  int x = 1;
  if (cond) { x=100; pthread_kill(arg1, arg2); }
  // cppcheck-suppress shiftTooManyBits
  x = 1 << x;
}

void test__pthread_kill__arg1__notuninit() {
  int x;
  // cppcheck-suppress uninitvar
  pthread_kill(x, arg2);
}

void test__pthread_kill__arg2__notuninit() {
  int x;
  // cppcheck-suppress uninitvar
  pthread_kill(arg1, x);
}

void test__pthread_self__noreturn() {
  int x = 1;
  if (cond) { x=100; result = pthread_self(); }
  // cppcheck-suppress shiftTooManyBits
  x = 1 << x;
}

void test__pthread_self__useretval() {
  // cppcheck-suppress ignoredReturnValue
  pthread_self();
}

void test__pthread_attr_destroy__noreturn() {
  int x = 1;
  if (cond) { x=100; pthread_attr_destroy(arg1); }
  // cppcheck-suppress shiftTooManyBits
  x = 1 << x;
}

void test__pthread_attr_destroy__arg1__notnull() {
  // cppcheck-suppress nullPointer
  pthread_attr_destroy(NULL);
}

void test__pthread_attr_init__noreturn() {
  int x = 1;
  if (cond) { x=100; pthread_attr_init(arg1); }
  // cppcheck-suppress shiftTooManyBits
  x = 1 << x;
}

void test__pthread_attr_init__arg1__notnull() {
  // cppcheck-suppress nullPointer
  pthread_attr_init(NULL);
}

void test__pthread_attr_setstackaddr__noreturn() {
  int x = 1;
  if (cond) { x=100; pthread_attr_setstackaddr(arg1, arg2); }
  // cppcheck-suppress shiftTooManyBits
  x = 1 << x;
}

void test__pthread_attr_setstackaddr__leakignore() {
  char *p = malloc(10); *p=0;
  pthread_attr_setstackaddr(p, arg2);
  // cppcheck-suppress memleak
}

void test__pthread_attr_setstackaddr__arg1__notnull() {
  // cppcheck-suppress nullPointer
  pthread_attr_setstackaddr(NULL, arg2);
}

void test__pthread_attr_setstackaddr__arg1__notuninit() {
  int x[10];
  // cppcheck-suppress uninitvar
  pthread_attr_setstackaddr(x, arg2);
}

void test__pthread_attr_setstackaddr__arg2__notnull() {
  // cppcheck-suppress nullPointer
  pthread_attr_setstackaddr(arg1, NULL);
}

void test__pthread_attr_setstackaddr__arg2__notuninit() {
  int x[10];
  // cppcheck-suppress uninitvar
  pthread_attr_setstackaddr(arg1, x);
}

void test__pthread_attr_getstackaddr__noreturn() {
  int x = 1;
  if (cond) { x=100; pthread_attr_getstackaddr(arg1, arg2); }
  // cppcheck-suppress shiftTooManyBits
  x = 1 << x;
}

void test__pthread_attr_getstackaddr__leakignore() {
  char *p = malloc(10); *p=0;
  pthread_attr_getstackaddr(p, arg2);
  // cppcheck-suppress memleak
}

void test__pthread_attr_getstackaddr__arg1__notnull() {
  // cppcheck-suppress nullPointer
  pthread_attr_getstackaddr(NULL, arg2);
}

void test__pthread_attr_getstackaddr__arg1__notuninit() {
  int x[10];
  // cppcheck-suppress uninitvar
  pthread_attr_getstackaddr(x, arg2);
}

void test__pthread_attr_getstackaddr__arg2__notnull() {
  // cppcheck-suppress nullPointer
  pthread_attr_getstackaddr(arg1, NULL);
}

void test__tempnam__noreturn() {
  int x = 1;
  if (cond) { x=100; result = tempnam(arg1, arg2); }
  // cppcheck-suppress shiftTooManyBits
  x = 1 << x;
}

void test__tempnam__useretval() {
  // cppcheck-suppress ignoredReturnValue
  tempnam(arg1, arg2);
}

void test__tempnam__leakignore() {
  char *p = malloc(10); *p=0;
  result = tempnam(p, arg2);
  // cppcheck-suppress memleak
}

void test__tempnam__arg1__notuninit() {
  int x;
  // cppcheck-suppress uninitvar
  result = tempnam(x, arg2);
}

void test__tempnam__arg2__notuninit() {
  int x;
  // cppcheck-suppress uninitvar
  result = tempnam(arg1, x);
}

void test__crypt__noreturn() {
  int x = 1;
  if (cond) { x=100; result = crypt(arg1, arg2); }
  // cppcheck-suppress shiftTooManyBits
  x = 1 << x;
}

void test__crypt__useretval() {
  // cppcheck-suppress ignoredReturnValue
  crypt(arg1, arg2);
}

void test__crypt__leakignore() {
  char *p = malloc(10); *p=0;
  result = crypt(p, arg2);
  // cppcheck-suppress memleak
}

void test__crypt__arg1__notnull() {
  // cppcheck-suppress nullPointer
  result = crypt(NULL, arg2);
}

void test__crypt__arg1__notuninit() {
  int x[10];
  // cppcheck-suppress uninitvar
  result = crypt(x, arg2);
}

void test__crypt__arg2__notnull() {
  // cppcheck-suppress nullPointer
  result = crypt(arg1, NULL);
}

void test__crypt__arg2__notuninit() {
  int x[10];
  // cppcheck-suppress uninitvar
  result = crypt(arg1, x);
}

void test__ttyname__noreturn() {
  int x = 1;
  if (cond) { x=100; result = ttyname(arg1); }
  // cppcheck-suppress shiftTooManyBits
  x = 1 << x;
}

void test__ttyname__useretval() {
  // cppcheck-suppress ignoredReturnValue
  ttyname(arg1);
}

void test__ttyname__leakignore() {
  char *p = malloc(10); *p=0;
  result = ttyname(p);
  // cppcheck-suppress memleak
}

void test__ttyname__arg1__notuninit() {
  int x;
  // cppcheck-suppress uninitvar
  result = ttyname(x);
}

void test__getspnam__noreturn() {
  int x = 1;
  if (cond) { x=100; result = getspnam(arg1); }
  // cppcheck-suppress shiftTooManyBits
  x = 1 << x;
}

void test__getspnam__useretval() {
  // cppcheck-suppress ignoredReturnValue
  getspnam(arg1);
}

void test__getspnam__leakignore() {
  char *p = malloc(10); *p=0;
  result = getspnam(p);
  // cppcheck-suppress memleak
}

void test__getspnam__arg1__notnull() {
  // cppcheck-suppress nullPointer
  result = getspnam(NULL);
}

void test__getspnam__arg1__notuninit() {
  int x[10];
  // cppcheck-suppress uninitvar
  result = getspnam(x);
}

void test__getspent__noreturn() {
  int x = 1;
  if (cond) { x=100; result = getspent(); }
  // cppcheck-suppress shiftTooManyBits
  x = 1 << x;
}

void test__getspent__useretval() {
  // cppcheck-suppress ignoredReturnValue
  getspent();
}

void test__getspent__leakignore() {
  char *p = malloc(10); *p=0;
  result = getspent();
  // cppcheck-suppress memleak
}

void test__fgetspent__noreturn() {
  int x = 1;
  if (cond) { x=100; result = fgetspent(arg1); }
  // cppcheck-suppress shiftTooManyBits
  x = 1 << x;
}

void test__fgetspent__useretval() {
  // cppcheck-suppress ignoredReturnValue
  fgetspent(arg1);
}

void test__fgetspent__leakignore() {
  char *p = malloc(10); *p=0;
  result = fgetspent(p);
  // cppcheck-suppress memleak
}

void test__fgetspent__arg1__notnull() {
  // cppcheck-suppress nullPointer
  result = fgetspent(NULL);
}

void test__fgetspent__arg1__notuninit() {
  int x[10];
  // cppcheck-suppress uninitvar
  result = fgetspent(x);
}

void test__sgetspent__noreturn() {
  int x = 1;
  if (cond) { x=100; result = sgetspent(arg1); }
  // cppcheck-suppress shiftTooManyBits
  x = 1 << x;
}

void test__sgetspent__useretval() {
  // cppcheck-suppress ignoredReturnValue
  sgetspent(arg1);
}

void test__sgetspent__leakignore() {
  char *p = malloc(10); *p=0;
  result = sgetspent(p);
  // cppcheck-suppress memleak
}

void test__sgetspent__arg1__notnull() {
  // cppcheck-suppress nullPointer
  result = sgetspent(NULL);
}

void test__sgetspent__arg1__notuninit() {
  int x[10];
  // cppcheck-suppress uninitvar
  result = sgetspent(x);
}

void test__fgetpwent__noreturn() {
  int x = 1;
  if (cond) { x=100; result = fgetpwent(arg1); }
  // cppcheck-suppress shiftTooManyBits
  x = 1 << x;
}

void test__fgetpwent__useretval() {
  // cppcheck-suppress ignoredReturnValue
  fgetpwent(arg1);
}

void test__fgetpwent__leakignore() {
  char *p = malloc(10); *p=0;
  result = fgetpwent(p);
  // cppcheck-suppress memleak
}

void test__fgetpwent__arg1__notnull() {
  // cppcheck-suppress nullPointer
  result = fgetpwent(NULL);
}

void test__fgetpwent__arg1__notuninit() {
  int x[10];
  // cppcheck-suppress uninitvar
  result = fgetpwent(x);
}

void test__getgrent__noreturn() {
  int x = 1;
  if (cond) { x=100; result = getgrent(); }
  // cppcheck-suppress shiftTooManyBits
  x = 1 << x;
}

void test__getgrent__useretval() {
  // cppcheck-suppress ignoredReturnValue
  getgrent();
}

void test__getgrent__leakignore() {
  char *p = malloc(10); *p=0;
  result = getgrent();
  // cppcheck-suppress memleak
}

void test__getgrent_r__noreturn() {
  int x = 1;
  if (cond) { x=100; result = getgrent_r(arg1, arg2, arg3, arg4); }
  // cppcheck-suppress shiftTooManyBits
  x = 1 << x;
}

void test__getgrent_r__useretval() {
  // cppcheck-suppress ignoredReturnValue
  getgrent_r(arg1, arg2, arg3, arg4);
}

void test__getgrent_r__leakignore() {
  char *p = malloc(10); *p=0;
  result = getgrent_r(p, arg2, arg3, arg4);
  // cppcheck-suppress memleak
}

void test__getgrent_r__arg2__notuninit() {
  int x;
  // cppcheck-suppress uninitvar
  result = getgrent_r(arg1, x, arg3, arg4);
}

void test__getgrent_r__arg3__notuninit() {
  int x;
  // cppcheck-suppress uninitvar
  result = getgrent_r(arg1, arg2, x, arg4);
}

void test__fgetgrent__noreturn() {
  int x = 1;
  if (cond) { x=100; result = fgetgrent(arg1); }
  // cppcheck-suppress shiftTooManyBits
  x = 1 << x;
}

void test__fgetgrent__useretval() {
  // cppcheck-suppress ignoredReturnValue
  fgetgrent(arg1);
}

void test__fgetgrent__leakignore() {
  char *p = malloc(10); *p=0;
  result = fgetgrent(p);
  // cppcheck-suppress memleak
}

void test__fgetgrent__arg1__notnull() {
  // cppcheck-suppress nullPointer
  result = fgetgrent(NULL);
}

void test__fgetgrent__arg1__notuninit() {
  int x[10];
  // cppcheck-suppress uninitvar
  result = fgetgrent(x);
}

void test__getnetgrent__noreturn() {
  int x = 1;
  if (cond) { x=100; getnetgrent(arg1, arg2, arg3); }
  // cppcheck-suppress shiftTooManyBits
  x = 1 << x;
}

void test__getnetgrent__leakignore() {
  char *p = malloc(10); *p=0;
  getnetgrent(p, arg2, arg3);
  // cppcheck-suppress memleak
}

void test__getnetgrent__arg1__notnull() {
  // cppcheck-suppress nullPointer
  getnetgrent(NULL, arg2, arg3);
}

void test__getnetgrent__arg2__notnull() {
  // cppcheck-suppress nullPointer
  getnetgrent(arg1, NULL, arg3);
}

void test__getnetgrent__arg3__notnull() {
  // cppcheck-suppress nullPointer
  getnetgrent(arg1, arg2, NULL);
}

void test__getgrnam__noreturn() {
  int x = 1;
  if (cond) { x=100; result = getgrnam(arg1); }
  // cppcheck-suppress shiftTooManyBits
  x = 1 << x;
}

void test__getgrnam__useretval() {
  // cppcheck-suppress ignoredReturnValue
  getgrnam(arg1);
}

void test__getgrnam__leakignore() {
  char *p = malloc(10); *p=0;
  result = getgrnam(p);
  // cppcheck-suppress memleak
}

void test__getgrnam__arg1__notnull() {
  // cppcheck-suppress nullPointer
  result = getgrnam(NULL);
}

void test__getgrnam__arg1__notuninit() {
  int x[10];
  // cppcheck-suppress uninitvar
  result = getgrnam(x);
}

void test__getgrgid__noreturn() {
  int x = 1;
  if (cond) { x=100; result = getgrgid(arg1); }
  // cppcheck-suppress shiftTooManyBits
  x = 1 << x;
}

void test__getgrgid__useretval() {
  // cppcheck-suppress ignoredReturnValue
  getgrgid(arg1);
}

void test__getgrgid__leakignore() {
  char *p = malloc(10); *p=0;
  result = getgrgid(p);
  // cppcheck-suppress memleak
}

void test__getgrgid__arg1__notuninit() {
  int x;
  // cppcheck-suppress uninitvar
  result = getgrgid(x);
}

void test__getlogin__noreturn() {
  int x = 1;
  if (cond) { x=100; result = getlogin(); }
  // cppcheck-suppress shiftTooManyBits
  x = 1 << x;
}

void test__getlogin__useretval() {
  // cppcheck-suppress ignoredReturnValue
  getlogin();
}

void test__getlogin__leakignore() {
  char *p = malloc(10); *p=0;
  result = getlogin();
  // cppcheck-suppress memleak
}

void test__ctermid__noreturn() {
  int x = 1;
  if (cond) { x=100; ctermid(arg1); }
  // cppcheck-suppress shiftTooManyBits
  x = 1 << x;
}

void test__ctermid__leakignore() {
  char *p = malloc(10); *p=0;
  ctermid(p);
  // cppcheck-suppress memleak
}

void test__realpath__noreturn() {
  int x = 1;
  if (cond) { x=100; realpath(arg1, arg2); }
  // cppcheck-suppress shiftTooManyBits
  x = 1 << x;
}

void test__realpath__leakignore() {
  char *p = malloc(10); *p=0;
  realpath(p, arg2);
  // cppcheck-suppress memleak
}

void test__realpath__arg1__notnull() {
  // cppcheck-suppress nullPointer
  realpath(NULL, arg2);
}

void test__realpath__arg1__notuninit() {
  int x[10];
  // cppcheck-suppress uninitvar
  realpath(x, arg2);
}

void test__fileno__noreturn() {
  int x = 1;
  if (cond) { x=100; result = fileno(arg1); }
  // cppcheck-suppress shiftTooManyBits
  x = 1 << x;
}

void test__fileno__useretval() {
  // cppcheck-suppress ignoredReturnValue
  fileno(arg1);
}

void test__fileno__leakignore() {
  char *p = malloc(10); *p=0;
  result = fileno(p);
  // cppcheck-suppress memleak
}

void test__fileno__arg1__notnull() {
  // cppcheck-suppress nullPointer
  result = fileno(NULL);
}

void test__fileno__arg1__notuninit() {
  int x[10];
  // cppcheck-suppress uninitvar
  result = fileno(x);
}

void test__fseeko__noreturn() {
  int x = 1;
  if (cond) { x=100; fseeko(arg1, arg2, arg3); }
  // cppcheck-suppress shiftTooManyBits
  x = 1 << x;
}

void test__fseeko__leakignore() {
  char *p = malloc(10); *p=0;
  fseeko(p, arg2, arg3);
  // cppcheck-suppress memleak
}

void test__fseeko__arg1__notnull() {
  // cppcheck-suppress nullPointer
  fseeko(NULL, arg2, arg3);
}

void test__fseeko__arg1__notuninit() {
  int x[10];
  // cppcheck-suppress uninitvar
  fseeko(x, arg2, arg3);
}

void test__fseeko__arg2__notuninit() {
  int x;
  // cppcheck-suppress uninitvar
  fseeko(arg1, x, arg3);
}

void test__fseeko__arg3__notuninit() {
  int x;
  // cppcheck-suppress uninitvar
  fseeko(arg1, arg2, x);
}

void test__ftello__noreturn() {
  int x = 1;
  if (cond) { x=100; result = ftello(arg1); }
  // cppcheck-suppress shiftTooManyBits
  x = 1 << x;
}

void test__ftello__useretval() {
  // cppcheck-suppress ignoredReturnValue
  ftello(arg1);
}

void test__ftello__leakignore() {
  char *p = malloc(10); *p=0;
  result = ftello(p);
  // cppcheck-suppress memleak
}

void test__ftello__arg1__notnull() {
  // cppcheck-suppress nullPointer
  result = ftello(NULL);
}

void test__ftello__arg1__notuninit() {
  int x[10];
  // cppcheck-suppress uninitvar
  result = ftello(x);
}

void test__execv__noreturn() {
  int x = 1;
  if (cond) { x=100; execv(arg1, arg2); }
  // cppcheck-suppress shiftTooManyBits
  x = 1 << x;
}

void test__execv__leakignore() {
  char *p = malloc(10); *p=0;
  execv(p, arg2);
  // cppcheck-suppress memleak
}

void test__execv__arg1__notnull() {
  // cppcheck-suppress nullPointer
  execv(NULL, arg2);
}

void test__execv__arg1__notuninit() {
  int x[10];
  // cppcheck-suppress uninitvar
  execv(x, arg2);
}

void test__execv__arg2__notuninit() {
  int x;
  // cppcheck-suppress uninitvar
  execv(arg1, x);
}

void test__execvp__noreturn() {
  int x = 1;
  if (cond) { x=100; execvp(arg1, arg2); }
  // cppcheck-suppress shiftTooManyBits
  x = 1 << x;
}

void test__execvp__leakignore() {
  char *p = malloc(10); *p=0;
  execvp(p, arg2);
  // cppcheck-suppress memleak
}

void test__execvp__arg1__notnull() {
  // cppcheck-suppress nullPointer
  execvp(NULL, arg2);
}

void test__execvp__arg1__notuninit() {
  int x[10];
  // cppcheck-suppress uninitvar
  execvp(x, arg2);
}

void test__execvp__arg2__notuninit() {
  int x;
  // cppcheck-suppress uninitvar
  execvp(arg1, x);
}

void test__wait__noreturn() {
  int x = 1;
  if (cond) { x=100; wait(arg1); }
  // cppcheck-suppress shiftTooManyBits
  x = 1 << x;
}

void test__wait__leakignore() {
  char *p = malloc(10); *p=0;
  wait(p);
  // cppcheck-suppress memleak
}

void test__waitpid__noreturn() {
  int x = 1;
  if (cond) { x=100; waitpid(arg1, arg2, arg3); }
  // cppcheck-suppress shiftTooManyBits
  x = 1 << x;
}

void test__waitpid__leakignore() {
  char *p = malloc(10); *p=0;
  waitpid(p, arg2, arg3);
  // cppcheck-suppress memleak
}

void test__waitpid__arg1__notuninit() {
  int x;
  // cppcheck-suppress uninitvar
  waitpid(x, arg2, arg3);
}

void test__waitpid__arg3__notuninit() {
  int x;
  // cppcheck-suppress uninitvar
  waitpid(arg1, arg2, x);
}

void test__strnlen__noreturn() {
  int x = 1;
  if (cond) { x=100; result = strnlen(arg1, arg2); }
  // cppcheck-suppress shiftTooManyBits
  x = 1 << x;
}

void test__strnlen__useretval() {
  // cppcheck-suppress ignoredReturnValue
  strnlen(arg1, arg2);
}

void test__strnlen__leakignore() {
  char *p = malloc(10); *p=0;
  result = strnlen(p, arg2);
  // cppcheck-suppress memleak
}

void test__strnlen__arg1__notnull() {
  // cppcheck-suppress nullPointer
  result = strnlen(NULL, arg2);
}

void test__strnlen__arg1__notuninit() {
  int x[10];
  // cppcheck-suppress uninitvar
  result = strnlen(x, arg2);
}

void test__strnlen__arg2__notuninit() {
  int x;
  // cppcheck-suppress uninitvar
  result = strnlen(arg1, x);
}

void test__wcsnlen__noreturn() {
  int x = 1;
  if (cond) { x=100; result = wcsnlen(arg1, arg2); }
  // cppcheck-suppress shiftTooManyBits
  x = 1 << x;
}

void test__wcsnlen__useretval() {
  // cppcheck-suppress ignoredReturnValue
  wcsnlen(arg1, arg2);
}

void test__wcsnlen__leakignore() {
  char *p = malloc(10); *p=0;
  result = wcsnlen(p, arg2);
  // cppcheck-suppress memleak
}

void test__wcsnlen__arg1__notnull() {
  // cppcheck-suppress nullPointer
  result = wcsnlen(NULL, arg2);
}

void test__wcsnlen__arg1__notuninit() {
  int x[10];
  // cppcheck-suppress uninitvar
  result = wcsnlen(x, arg2);
}

void test__wcsnlen__arg2__notuninit() {
  int x;
  // cppcheck-suppress uninitvar
  result = wcsnlen(arg1, x);
}

void test__ffs__noreturn() {
  int x = 1;
  if (cond) { x=100; result = ffs(arg1); }
  // cppcheck-suppress shiftTooManyBits
  x = 1 << x;
}

void test__ffs__useretval() {
  // cppcheck-suppress ignoredReturnValue
  ffs(arg1);
}

void test__ffs__leakignore() {
  char *p = malloc(10); *p=0;
  result = ffs(p);
  // cppcheck-suppress memleak
}

void test__ffs__arg1__notuninit() {
  int x;
  // cppcheck-suppress uninitvar
  result = ffs(x);
}

void test__shmctl__noreturn() {
  int x = 1;
  if (cond) { x=100; shmctl(arg1, arg2); }
  // cppcheck-suppress shiftTooManyBits
  x = 1 << x;
}

void test__shmctl__leakignore() {
  char *p = malloc(10); *p=0;
  shmctl(p, arg2);
  // cppcheck-suppress memleak
}

void test__shmctl__arg1__notuninit() {
  int x;
  // cppcheck-suppress uninitvar
  shmctl(x, arg2);
}

void test__shmctl__arg2__notuninit() {
  int x;
  // cppcheck-suppress uninitvar
  shmctl(arg1, x);
}

void test__shmget__noreturn() {
  int x = 1;
  if (cond) { x=100; shmget(arg1, arg2, arg3); }
  // cppcheck-suppress shiftTooManyBits
  x = 1 << x;
}

void test__shmget__leakignore() {
  char *p = malloc(10); *p=0;
  shmget(p, arg2, arg3);
  // cppcheck-suppress memleak
}

void test__shmget__arg1__notuninit() {
  int x;
  // cppcheck-suppress uninitvar
  shmget(x, arg2, arg3);
}

void test__shmget__arg2__notuninit() {
  int x;
  // cppcheck-suppress uninitvar
  shmget(arg1, x, arg3);
}

void test__shmget__arg3__notuninit() {
  int x;
  // cppcheck-suppress uninitvar
  shmget(arg1, arg2, x);
}

void test__shmat__noreturn() {
  int x = 1;
  if (cond) { x=100; shmat(arg1, arg2, arg3); }
  // cppcheck-suppress shiftTooManyBits
  x = 1 << x;
}

void test__shmat__leakignore() {
  char *p = malloc(10); *p=0;
  shmat(p, arg2, arg3);
  // cppcheck-suppress memleak
}

void test__shmat__arg1__notuninit() {
  int x;
  // cppcheck-suppress uninitvar
  shmat(x, arg2, arg3);
}

void test__shmat__arg3__notuninit() {
  int x;
  // cppcheck-suppress uninitvar
  shmat(arg1, arg2, x);
}

void test__shmdt__noreturn() {
  int x = 1;
  if (cond) { x=100; shmdt(arg1); }
  // cppcheck-suppress shiftTooManyBits
  x = 1 << x;
}

void test__shmdt__leakignore() {
  char *p = malloc(10); *p=0;
  shmdt(p);
  // cppcheck-suppress memleak
}

void test__getrlimit__noreturn() {
  int x = 1;
  if (cond) { x=100; getrlimit(arg1, arg2); }
  // cppcheck-suppress shiftTooManyBits
  x = 1 << x;
}

void test__getrlimit__leakignore() {
  char *p = malloc(10); *p=0;
  getrlimit(p, arg2);
  // cppcheck-suppress memleak
}

void test__getrlimit__arg1__notuninit() {
  int x;
  // cppcheck-suppress uninitvar
  getrlimit(x, arg2);
}

void test__getrlimit__arg2__notnull() {
  // cppcheck-suppress nullPointer
  getrlimit(arg1, NULL);
}

void test__setrlimit__noreturn() {
  int x = 1;
  if (cond) { x=100; setrlimit(arg1, arg2); }
  // cppcheck-suppress shiftTooManyBits
  x = 1 << x;
}

void test__setrlimit__leakignore() {
  char *p = malloc(10); *p=0;
  setrlimit(p, arg2);
  // cppcheck-suppress memleak
}

void test__setrlimit__arg1__notuninit() {
  int x;
  // cppcheck-suppress uninitvar
  setrlimit(x, arg2);
}

void test__setrlimit__arg2__notnull() {
  // cppcheck-suppress nullPointer
  setrlimit(arg1, NULL);
}

void test__setrlimit__arg2__notuninit() {
  int x[10];
  // cppcheck-suppress uninitvar
  setrlimit(arg1, x);
}

void test__glob__noreturn() {
  int x = 1;
  if (cond) { x=100; glob(arg1, arg2, arg3, arg4); }
  // cppcheck-suppress shiftTooManyBits
  x = 1 << x;
}

void test__glob__arg1__notnull() {
  // cppcheck-suppress nullPointer
  glob(NULL, arg2, arg3, arg4);
}

void test__glob__arg1__notuninit() {
  int x[10];
  // cppcheck-suppress uninitvar
  glob(x, arg2, arg3, arg4);
}

void test__glob__arg2__notuninit() {
  int x;
  // cppcheck-suppress uninitvar
  glob(arg1, x, arg3, arg4);
}

void test__glob__arg3__notuninit() {
  int x;
  // cppcheck-suppress uninitvar
  glob(arg1, arg2, x, arg4);
}

void test__glob__arg4__notnull() {
  // cppcheck-suppress nullPointer
  glob(arg1, arg2, arg3, NULL);
}

void test__globfree__noreturn() {
  int x = 1;
  if (cond) { x=100; globfree(arg1); }
  // cppcheck-suppress shiftTooManyBits
  x = 1 << x;
}

void test__globfree__arg1__notnull() {
  // cppcheck-suppress nullPointer
  globfree(NULL);
}

void test__globfree__arg1__notuninit() {
  int x[10];
  // cppcheck-suppress uninitvar
  globfree(x);
}

void test__wcpncpy__noreturn() {
  int x = 1;
  if (cond) { x=100; wcpncpy(arg1, arg2, arg3); }
  // cppcheck-suppress shiftTooManyBits
  x = 1 << x;
}

void test__wcpncpy__leakignore() {
  char *p = malloc(10); *p=0;
  wcpncpy(p, arg2, arg3);
  // cppcheck-suppress memleak
}

void test__wcpncpy__arg1__notnull() {
  // cppcheck-suppress nullPointer
  wcpncpy(NULL, arg2, arg3);
}

void test__wcpncpy__arg2__notnull() {
  // cppcheck-suppress nullPointer
  wcpncpy(arg1, NULL, arg3);
}

void test__wcpncpy__arg2__notuninit() {
  int x[10];
  // cppcheck-suppress uninitvar
  wcpncpy(arg1, x, arg3);
}

void test__wcpncpy__arg3__notbool() {
  // cppcheck-suppress invalidFunctionArgBool
  wcpncpy(arg1, arg2, !x);
}

void test__wcpncpy__arg3__notuninit() {
  int x;
  // cppcheck-suppress uninitvar
  wcpncpy(arg1, arg2, x);
}

void test__stpncpy__noreturn() {
  int x = 1;
  if (cond) { x=100; stpncpy(arg1, arg2, arg3); }
  // cppcheck-suppress shiftTooManyBits
  x = 1 << x;
}

void test__stpncpy__leakignore() {
  char *p = malloc(10); *p=0;
  stpncpy(p, arg2, arg3);
  // cppcheck-suppress memleak
}

void test__stpncpy__arg1__notnull() {
  // cppcheck-suppress nullPointer
  stpncpy(NULL, arg2, arg3);
}

void test__stpncpy__arg2__notnull() {
  // cppcheck-suppress nullPointer
  stpncpy(arg1, NULL, arg3);
}

void test__stpncpy__arg2__notuninit() {
  int x[10];
  // cppcheck-suppress uninitvar
  stpncpy(arg1, x, arg3);
}

void test__stpncpy__arg3__notbool() {
  // cppcheck-suppress invalidFunctionArgBool
  stpncpy(arg1, arg2, !x);
}

void test__stpncpy__arg3__notuninit() {
  int x;
  // cppcheck-suppress uninitvar
  stpncpy(arg1, arg2, x);
}

void test__memccpy__noreturn() {
  int x = 1;
  if (cond) { x=100; memccpy(arg1, arg2, arg3, arg4); }
  // cppcheck-suppress shiftTooManyBits
  x = 1 << x;
}

void test__memccpy__leakignore() {
  char *p = malloc(10); *p=0;
  memccpy(p, arg2, arg3, arg4);
  // cppcheck-suppress memleak
}

void test__memccpy__arg1__notnull() {
  // cppcheck-suppress nullPointer
  memccpy(NULL, arg2, arg3, arg4);
}

void test__memccpy__arg2__notnull() {
  // cppcheck-suppress nullPointer
  memccpy(arg1, NULL, arg3, arg4);
}

void test__memccpy__arg2__notuninit() {
  int x[10];
  // cppcheck-suppress uninitvar
  memccpy(arg1, x, arg3, arg4);
}

void test__memccpy__arg3__notuninit() {
  int x;
  // cppcheck-suppress uninitvar
  memccpy(arg1, arg2, x, arg4);
}

void test__memccpy__arg4__notuninit() {
  int x;
  // cppcheck-suppress uninitvar
  memccpy(arg1, arg2, arg3, x);
}

void test__getopt__noreturn() {
  int x = 1;
  if (cond) { x=100; getopt(arg1, arg2, arg3); }
  // cppcheck-suppress shiftTooManyBits
  x = 1 << x;
}

void test__getopt__leakignore() {
  char *p = malloc(10); *p=0;
  getopt(p, arg2, arg3);
  // cppcheck-suppress memleak
}

void test__getopt__arg1__notuninit() {
  int x;
  // cppcheck-suppress uninitvar
  getopt(x, arg2, arg3);
}

void test__getopt__arg2__notnull() {
  // cppcheck-suppress nullPointer
  getopt(arg1, NULL, arg3);
}

void test__getopt__arg2__notuninit() {
  int x[10];
  // cppcheck-suppress uninitvar
  getopt(arg1, x, arg3);
}

void test__getopt__arg3__notnull() {
  // cppcheck-suppress nullPointer
  getopt(arg1, arg2, NULL);
}

void test__getopt__arg3__notuninit() {
  int x[10];
  // cppcheck-suppress uninitvar
  getopt(arg1, arg2, x);
}

void test__getitimer__noreturn() {
  int x = 1;
  if (cond) { x=100; getitimer(arg1, arg2); }
  // cppcheck-suppress shiftTooManyBits
  x = 1 << x;
}

void test__getitimer__leakignore() {
  char *p = malloc(10); *p=0;
  getitimer(p, arg2);
  // cppcheck-suppress memleak
}

void test__getitimer__arg1__notuninit() {
  int x;
  // cppcheck-suppress uninitvar
  getitimer(x, arg2);
}

void test__getitimer__arg2__notnull() {
  // cppcheck-suppress nullPointer
  getitimer(arg1, NULL);
}

void test__getitimer__arg2__notuninit() {
  int x[10];
  // cppcheck-suppress uninitvar
  getitimer(arg1, x);
}

void test__setitimer__noreturn() {
  int x = 1;
  if (cond) { x=100; setitimer(arg1, arg2, arg3); }
  // cppcheck-suppress shiftTooManyBits
  x = 1 << x;
}

void test__setitimer__leakignore() {
  char *p = malloc(10); *p=0;
  setitimer(p, arg2, arg3);
  // cppcheck-suppress memleak
}

void test__setitimer__arg1__notuninit() {
  int x;
  // cppcheck-suppress uninitvar
  setitimer(x, arg2, arg3);
}

void test__setitimer__arg2__notuninit() {
  int x;
  // cppcheck-suppress uninitvar
  setitimer(arg1, x, arg3);
}

void test__setitimer__arg3__notuninit() {
  int x;
  // cppcheck-suppress uninitvar
  setitimer(arg1, arg2, x);
}

void test__sigaction__noreturn() {
  int x = 1;
  if (cond) { x=100; sigaction(arg1, arg2, arg3); }
  // cppcheck-suppress shiftTooManyBits
  x = 1 << x;
}

void test__sigaction__leakignore() {
  char *p = malloc(10); *p=0;
  sigaction(p, arg2, arg3);
  // cppcheck-suppress memleak
}

void test__sigaction__arg1__notuninit() {
  int x;
  // cppcheck-suppress uninitvar
  sigaction(x, arg2, arg3);
}

void test__sigaltstack__noreturn() {
  int x = 1;
  if (cond) { x=100; sigaltstack(arg1, arg2); }
  // cppcheck-suppress shiftTooManyBits
  x = 1 << x;
}

void test__sigaltstack__leakignore() {
  char *p = malloc(10); *p=0;
  sigaltstack(p, arg2);
  // cppcheck-suppress memleak
}

void test__sigaltstack__arg1__notuninit() {
  int x;
  // cppcheck-suppress uninitvar
  sigaltstack(x, arg2);
}

void test__siglongjmp__noreturn() {
  int x = 1;
  if (cond) { x=100; siglongjmp(arg1, arg2); }
  // cppcheck-suppress shiftTooManyBits
  x = 1 << x;
}

void test__siglongjmp__arg1__notuninit() {
  int x;
  // cppcheck-suppress uninitvar
  siglongjmp(x, arg2);
}

void test__siglongjmp__arg2__notuninit() {
  int x;
  // cppcheck-suppress uninitvar
  siglongjmp(arg1, x);
}

void test___longjmp__noreturn() {
  int x = 1;
  if (cond) { x=100; _longjmp(arg1, arg2); }
  // cppcheck-suppress shiftTooManyBits
  x = 1 << x;
}

void test___longjmp__arg1__notuninit() {
  int x;
  // cppcheck-suppress uninitvar
  _longjmp(x, arg2);
}

void test___longjmp__arg2__notuninit() {
  int x;
  // cppcheck-suppress uninitvar
  _longjmp(arg1, x);
}

void test__sigsetjmp__noreturn() {
  int x = 1;
  if (cond) { x=100; sigsetjmp(arg1, arg2); }
  // cppcheck-suppress shiftTooManyBits
  x = 1 << x;
}

void test__sigsetjmp__arg2__notuninit() {
  int x;
  // cppcheck-suppress uninitvar
  sigsetjmp(arg1, x);
}

void test___setjmp__noreturn() {
  int x = 1;
  if (cond) { x=100; _setjmp(arg1, arg2); }
  // cppcheck-suppress shiftTooManyBits
  x = 1 << x;
}

void test___setjmp__arg2__notuninit() {
  int x;
  // cppcheck-suppress uninitvar
  _setjmp(arg1, x);
}

void test__sigsuspend__noreturn() {
  int x = 1;
  if (cond) { x=100; sigsuspend(arg1); }
  // cppcheck-suppress shiftTooManyBits
  x = 1 << x;
}

void test__sigsuspend__leakignore() {
  char *p = malloc(10); *p=0;
  sigsuspend(p);
  // cppcheck-suppress memleak
}

void test__sigsuspend__arg1__notnull() {
  // cppcheck-suppress nullPointer
  sigsuspend(NULL);
}

void test__pthread_sigmask__noreturn() {
  int x = 1;
  if (cond) { x=100; pthread_sigmask(arg1, arg2, arg3); }
  // cppcheck-suppress shiftTooManyBits
  x = 1 << x;
}

void test__pthread_sigmask__arg1__notuninit() {
  int x;
  // cppcheck-suppress uninitvar
  pthread_sigmask(x, arg2, arg3);
}

void test__pthread_sigmask__arg2__notuninit() {
  int x;
  // cppcheck-suppress uninitvar
  pthread_sigmask(arg1, x, arg3);
}

void test__pthread_sigmask__arg3__notuninit() {
  int x;
  // cppcheck-suppress uninitvar
  pthread_sigmask(arg1, arg2, x);
}

void test__sigprocmask__noreturn() {
  int x = 1;
  if (cond) { x=100; sigprocmask(arg1, arg2, arg3); }
  // cppcheck-suppress shiftTooManyBits
  x = 1 << x;
}

void test__sigprocmask__arg1__notuninit() {
  int x;
  // cppcheck-suppress uninitvar
  sigprocmask(x, arg2, arg3);
}

void test__sigprocmask__arg2__notuninit() {
  int x;
  // cppcheck-suppress uninitvar
  sigprocmask(arg1, x, arg3);
}

void test__sigprocmask__arg3__notuninit() {
  int x;
  // cppcheck-suppress uninitvar
  sigprocmask(arg1, arg2, x);
}

void test__getrusage__noreturn() {
  int x = 1;
  if (cond) { x=100; getrusage(arg1, arg2); }
  // cppcheck-suppress shiftTooManyBits
  x = 1 << x;
}

void test__getrusage__leakignore() {
  char *p = malloc(10); *p=0;
  getrusage(p, arg2);
  // cppcheck-suppress memleak
}

void test__getrusage__arg1__notuninit() {
  int x;
  // cppcheck-suppress uninitvar
  getrusage(x, arg2);
}

void test__getrusage__arg2__notnull() {
  // cppcheck-suppress nullPointer
  getrusage(arg1, NULL);
}

void test__sigemptyset__noreturn() {
  int x = 1;
  if (cond) { x=100; sigemptyset(arg1); }
  // cppcheck-suppress shiftTooManyBits
  x = 1 << x;
}

void test__sigemptyset__leakignore() {
  char *p = malloc(10); *p=0;
  sigemptyset(p);
  // cppcheck-suppress memleak
}

void test__sigemptyset__arg1__notnull() {
  // cppcheck-suppress nullPointer
  sigemptyset(NULL);
}

void test__sigfillset__noreturn() {
  int x = 1;
  if (cond) { x=100; sigfillset(arg1); }
  // cppcheck-suppress shiftTooManyBits
  x = 1 << x;
}

void test__sigfillset__leakignore() {
  char *p = malloc(10); *p=0;
  sigfillset(p);
  // cppcheck-suppress memleak
}

void test__sigfillset__arg1__notnull() {
  // cppcheck-suppress nullPointer
  sigfillset(NULL);
}

void test__sigaddset__noreturn() {
  int x = 1;
  if (cond) { x=100; sigaddset(arg1, arg2); }
  // cppcheck-suppress shiftTooManyBits
  x = 1 << x;
}

void test__sigaddset__leakignore() {
  char *p = malloc(10); *p=0;
  sigaddset(p, arg2);
  // cppcheck-suppress memleak
}

void test__sigaddset__arg1__notnull() {
  // cppcheck-suppress nullPointer
  sigaddset(NULL, arg2);
}

void test__sigaddset__arg2__notuninit() {
  int x;
  // cppcheck-suppress uninitvar
  sigaddset(arg1, x);
}

void test__sigdelset__noreturn() {
  int x = 1;
  if (cond) { x=100; sigdelset(arg1, arg2); }
  // cppcheck-suppress shiftTooManyBits
  x = 1 << x;
}

void test__sigdelset__leakignore() {
  char *p = malloc(10); *p=0;
  sigdelset(p, arg2);
  // cppcheck-suppress memleak
}

void test__sigdelset__arg1__notnull() {
  // cppcheck-suppress nullPointer
  sigdelset(NULL, arg2);
}

void test__sigdelset__arg2__notuninit() {
  int x;
  // cppcheck-suppress uninitvar
  sigdelset(arg1, x);
}

void test__sigismember__noreturn() {
  int x = 1;
  if (cond) { x=100; sigismember(arg1, arg2); }
  // cppcheck-suppress shiftTooManyBits
  x = 1 << x;
}

void test__sigismember__leakignore() {
  char *p = malloc(10); *p=0;
  sigismember(p, arg2);
  // cppcheck-suppress memleak
}

void test__sigismember__arg1__notnull() {
  // cppcheck-suppress nullPointer
  sigismember(NULL, arg2);
}

void test__sigismember__arg2__notuninit() {
  int x;
  // cppcheck-suppress uninitvar
  sigismember(arg1, x);
}

void test__posix_spawn__noreturn() {
  int x = 1;
  if (cond) { x=100; posix_spawn(arg1, arg2, arg3, arg4, arg5, arg6); }
  // cppcheck-suppress shiftTooManyBits
  x = 1 << x;
}

void test__posix_spawn__leakignore() {
  char *p = malloc(10); *p=0;
  posix_spawn(p, arg2, arg3, arg4, arg5, arg6);
  // cppcheck-suppress memleak
}

void test__posix_spawnp__noreturn() {
  int x = 1;
  if (cond) { x=100; posix_spawnp(arg1, arg2, arg3, arg4, arg5, arg6); }
  // cppcheck-suppress shiftTooManyBits
  x = 1 << x;
}

void test__posix_spawnp__leakignore() {
  char *p = malloc(10); *p=0;
  posix_spawnp(p, arg2, arg3, arg4, arg5, arg6);
  // cppcheck-suppress memleak
}

void test__msgctl__noreturn() {
  int x = 1;
  if (cond) { x=100; msgctl(arg1, arg2, arg3); }
  // cppcheck-suppress shiftTooManyBits
  x = 1 << x;
}

void test__msgctl__leakignore() {
  char *p = malloc(10); *p=0;
  msgctl(p, arg2, arg3);
  // cppcheck-suppress memleak
}

void test__msgctl__arg1__notuninit() {
  int x;
  // cppcheck-suppress uninitvar
  msgctl(x, arg2, arg3);
}

void test__msgctl__arg2__notuninit() {
  int x;
  // cppcheck-suppress uninitvar
  msgctl(arg1, x, arg3);
}

void test__msgctl__arg3__notuninit() {
  int x;
  // cppcheck-suppress uninitvar
  msgctl(arg1, arg2, x);
}

void test__msgget__noreturn() {
  int x = 1;
  if (cond) { x=100; result = msgget(arg1, arg2); }
  // cppcheck-suppress shiftTooManyBits
  x = 1 << x;
}

void test__msgget__useretval() {
  // cppcheck-suppress ignoredReturnValue
  msgget(arg1, arg2);
}

void test__msgget__arg1__notuninit() {
  int x;
  // cppcheck-suppress uninitvar
  result = msgget(x, arg2);
}

void test__msgget__arg2__notuninit() {
  int x;
  // cppcheck-suppress uninitvar
  result = msgget(arg1, x);
}

void test__msgrcv__noreturn() {
  int x = 1;
  if (cond) { x=100; msgrcv(arg1, arg2, arg3, arg4, arg5); }
  // cppcheck-suppress shiftTooManyBits
  x = 1 << x;
}

void test__msgrcv__leakignore() {
  char *p = malloc(10); *p=0;
  msgrcv(p, arg2, arg3, arg4, arg5);
  // cppcheck-suppress memleak
}

void test__msgrcv__arg1__notuninit() {
  int x;
  // cppcheck-suppress uninitvar
  msgrcv(x, arg2, arg3, arg4, arg5);
}

void test__msgrcv__arg2__notnull() {
  // cppcheck-suppress nullPointer
  msgrcv(arg1, NULL, arg3, arg4, arg5);
}

void test__msgrcv__arg3__notuninit() {
  int x;
  // cppcheck-suppress uninitvar
  msgrcv(arg1, arg2, x, arg4, arg5);
}

void test__msgrcv__arg4__notuninit() {
  int x;
  // cppcheck-suppress uninitvar
  msgrcv(arg1, arg2, arg3, x, arg5);
}

void test__msgrcv__arg5__notuninit() {
  int x;
  // cppcheck-suppress uninitvar
  msgrcv(arg1, arg2, arg3, arg4, x);
}

void test__msgsnd__noreturn() {
  int x = 1;
  if (cond) { x=100; msgsnd(arg1, arg2, arg3, arg4); }
  // cppcheck-suppress shiftTooManyBits
  x = 1 << x;
}

void test__msgsnd__leakignore() {
  char *p = malloc(10); *p=0;
  msgsnd(p, arg2, arg3, arg4);
  // cppcheck-suppress memleak
}

void test__msgsnd__arg1__notuninit() {
  int x;
  // cppcheck-suppress uninitvar
  msgsnd(x, arg2, arg3, arg4);
}

void test__msgsnd__arg2__notnull() {
  // cppcheck-suppress nullPointer
  msgsnd(arg1, NULL, arg3, arg4);
}

void test__msgsnd__arg3__notuninit() {
  int x;
  // cppcheck-suppress uninitvar
  msgsnd(arg1, arg2, x, arg4);
}

void test__msgsnd__arg4__notuninit() {
  int x;
  // cppcheck-suppress uninitvar
  msgsnd(arg1, arg2, arg3, x);
}

void test__tcflow__noreturn() {
  int x = 1;
  if (cond) { x=100; tcflow(arg1, arg2); }
  // cppcheck-suppress shiftTooManyBits
  x = 1 << x;
}

void test__tcflow__leakignore() {
  char *p = malloc(10); *p=0;
  tcflow(p, arg2);
  // cppcheck-suppress memleak
}

void test__tcflow__arg1__notuninit() {
  int x;
  // cppcheck-suppress uninitvar
  tcflow(x, arg2);
}

void test__tcflow__arg2__notuninit() {
  int x;
  // cppcheck-suppress uninitvar
  tcflow(arg1, x);
}

void test__tcflush__noreturn() {
  int x = 1;
  if (cond) { x=100; tcflush(arg1, arg2); }
  // cppcheck-suppress shiftTooManyBits
  x = 1 << x;
}

void test__tcflush__leakignore() {
  char *p = malloc(10); *p=0;
  tcflush(p, arg2);
  // cppcheck-suppress memleak
}

void test__tcflush__arg1__notuninit() {
  int x;
  // cppcheck-suppress uninitvar
  tcflush(x, arg2);
}

void test__tcflush__arg2__notuninit() {
  int x;
  // cppcheck-suppress uninitvar
  tcflush(arg1, x);
}

void test__tcsendbreak__noreturn() {
  int x = 1;
  if (cond) { x=100; tcsendbreak(arg1, arg2); }
  // cppcheck-suppress shiftTooManyBits
  x = 1 << x;
}

void test__tcsendbreak__leakignore() {
  char *p = malloc(10); *p=0;
  tcsendbreak(p, arg2);
  // cppcheck-suppress memleak
}

void test__tcsendbreak__arg1__notuninit() {
  int x;
  // cppcheck-suppress uninitvar
  tcsendbreak(x, arg2);
}

void test__tcsendbreak__arg2__notnull() {
  // cppcheck-suppress nullPointer
  tcsendbreak(arg1, NULL);
}

void test__tcgetattr__noreturn() {
  int x = 1;
  if (cond) { x=100; tcgetattr(arg1, arg2); }
  // cppcheck-suppress shiftTooManyBits
  x = 1 << x;
}

void test__tcgetattr__leakignore() {
  char *p = malloc(10); *p=0;
  tcgetattr(p, arg2);
  // cppcheck-suppress memleak
}

void test__tcgetattr__arg1__notuninit() {
  int x;
  // cppcheck-suppress uninitvar
  tcgetattr(x, arg2);
}

void test__tcgetattr__arg2__notnull() {
  // cppcheck-suppress nullPointer
  tcgetattr(arg1, NULL);
}

void test__tcsetattr__noreturn() {
  int x = 1;
  if (cond) { x=100; tcsetattr(arg1, arg2, arg3); }
  // cppcheck-suppress shiftTooManyBits
  x = 1 << x;
}

void test__tcsetattr__leakignore() {
  char *p = malloc(10); *p=0;
  tcsetattr(p, arg2, arg3);
  // cppcheck-suppress memleak
}

void test__tcsetattr__arg1__notuninit() {
  int x;
  // cppcheck-suppress uninitvar
  tcsetattr(x, arg2, arg3);
}

void test__tcsetattr__arg2__notuninit() {
  int x;
  // cppcheck-suppress uninitvar
  tcsetattr(arg1, x, arg3);
}

void test__tcsetattr__arg3__notnull() {
  // cppcheck-suppress nullPointer
  tcsetattr(arg1, arg2, NULL);
}

void test__tcsetattr__arg3__notuninit() {
  int x[10];
  // cppcheck-suppress uninitvar
  tcsetattr(arg1, arg2, x);
}

void test__cfsetospeed__noreturn() {
  int x = 1;
  if (cond) { x=100; cfsetospeed(arg1, arg2); }
  // cppcheck-suppress shiftTooManyBits
  x = 1 << x;
}

void test__cfsetospeed__leakignore() {
  char *p = malloc(10); *p=0;
  cfsetospeed(p, arg2);
  // cppcheck-suppress memleak
}

void test__cfsetospeed__arg1__notnull() {
  // cppcheck-suppress nullPointer
  cfsetospeed(NULL, arg2);
}

void test__cfsetospeed__arg1__notuninit() {
  int x[10];
  // cppcheck-suppress uninitvar
  cfsetospeed(x, arg2);
}

void test__cfsetospeed__arg2__notuninit() {
  int x;
  // cppcheck-suppress uninitvar
  cfsetospeed(arg1, x);
}

void test__cfsetispeed__noreturn() {
  int x = 1;
  if (cond) { x=100; cfsetispeed(arg1, arg2); }
  // cppcheck-suppress shiftTooManyBits
  x = 1 << x;
}

void test__cfsetispeed__leakignore() {
  char *p = malloc(10); *p=0;
  cfsetispeed(p, arg2);
  // cppcheck-suppress memleak
}

void test__cfsetispeed__arg1__notnull() {
  // cppcheck-suppress nullPointer
  cfsetispeed(NULL, arg2);
}

void test__cfsetispeed__arg1__notuninit() {
  int x[10];
  // cppcheck-suppress uninitvar
  cfsetispeed(x, arg2);
}

void test__cfsetispeed__arg2__notuninit() {
  int x;
  // cppcheck-suppress uninitvar
  cfsetispeed(arg1, x);
}

void test__tcdrain__noreturn() {
  int x = 1;
  if (cond) { x=100; tcdrain(arg1); }
  // cppcheck-suppress shiftTooManyBits
  x = 1 << x;
}

void test__tcdrain__leakignore() {
  char *p = malloc(10); *p=0;
  tcdrain(p);
  // cppcheck-suppress memleak
}

void test__tcdrain__arg1__notuninit() {
  int x;
  // cppcheck-suppress uninitvar
  tcdrain(x);
}

void test__swab__noreturn() {
  int x = 1;
  if (cond) { x=100; swab(arg1, arg2, arg3); }
  // cppcheck-suppress shiftTooManyBits
  x = 1 << x;
}

void test__swab__leakignore() {
  char *p = malloc(10); *p=0;
  swab(p, arg2, arg3);
  // cppcheck-suppress memleak
}

void test__swab__arg1__notuninit() {
  int x;
  // cppcheck-suppress uninitvar
  swab(x, arg2, arg3);
}

void test__swab__arg2__notnull() {
  // cppcheck-suppress nullPointer
  swab(arg1, NULL, arg3);
}

void test__swab__arg2__notuninit() {
  int x[10];
  // cppcheck-suppress uninitvar
  swab(arg1, x, arg3);
}

void test__swab__arg3__notnull() {
  // cppcheck-suppress nullPointer
  swab(arg1, arg2, NULL);
}

void test__swab__arg3__notuninit() {
  int x[10];
  // cppcheck-suppress uninitvar
  swab(arg1, arg2, x);
}

void test__sync__noreturn() {
  int x = 1;
  if (cond) { x=100; sync(); }
  // cppcheck-suppress shiftTooManyBits
  x = 1 << x;
}

