/* TweetModel.c generated by valac 0.34.6, the Vala compiler
 * generated from TweetModel.vala, do not modify */

/*  This file is part of corebird, a Gtk+ linux Twitter client.
 *  Copyright (C) 2013 Timm Bäder
 *
 *  corebird is free software: you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation, either version 3 of the License, or
 *  (at your option) any later version.
 *
 *  corebird is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with corebird.  If not, see <http://www.gnu.org/licenses/>.
 */

#include <glib.h>
#include <glib-object.h>
#include <gio/gio.h>
#include "CbTweet.h"


#define TYPE_TWEET_MODEL (tweet_model_get_type ())
#define TWEET_MODEL(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_TWEET_MODEL, TweetModel))
#define TWEET_MODEL_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_TWEET_MODEL, TweetModelClass))
#define IS_TWEET_MODEL(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_TWEET_MODEL))
#define IS_TWEET_MODEL_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_TWEET_MODEL))
#define TWEET_MODEL_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_TWEET_MODEL, TweetModelClass))

typedef struct _TweetModel TweetModel;
typedef struct _TweetModelClass TweetModelClass;
typedef struct _TweetModelPrivate TweetModelPrivate;
#define _g_ptr_array_unref0(var) ((var == NULL) ? NULL : (var = (g_ptr_array_unref (var), NULL)))
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))
#define _vala_assert(expr, msg) if G_LIKELY (expr) ; else g_assertion_message_expr (G_LOG_DOMAIN, __FILE__, __LINE__, G_STRFUNC, msg);
#define _vala_return_if_fail(expr, msg) if G_LIKELY (expr) ; else { g_return_if_fail_warning (G_LOG_DOMAIN, G_STRFUNC, msg); return; }
#define _vala_return_val_if_fail(expr, msg, val) if G_LIKELY (expr) ; else { g_return_if_fail_warning (G_LOG_DOMAIN, G_STRFUNC, msg); return val; }
#define _vala_warn_if_fail(expr, msg) if G_LIKELY (expr) ; else g_warn_message (G_LOG_DOMAIN, __FILE__, __LINE__, G_STRFUNC, msg);

struct _TweetModel {
	GObject parent_instance;
	TweetModelPrivate * priv;
	GPtrArray* hidden_tweets;
};

struct _TweetModelClass {
	GObjectClass parent_class;
};

struct _TweetModelPrivate {
	GPtrArray* tweets;
	gint64 min_id;
	gint64 max_id;
};


static gpointer tweet_model_parent_class = NULL;
static GListModelInterface* tweet_model_g_list_model_parent_iface = NULL;

GType tweet_model_get_type (void) G_GNUC_CONST;
#define TWEET_MODEL_GET_PRIVATE(o) (G_TYPE_INSTANCE_GET_PRIVATE ((o), TYPE_TWEET_MODEL, TweetModelPrivate))
enum  {
	TWEET_MODEL_DUMMY_PROPERTY,
	TWEET_MODEL_LOWEST_ID,
	TWEET_MODEL_GREATEST_ID
};
static void _g_object_unref0_ (gpointer var);
static GType tweet_model_real_get_item_type (GListModel* base);
static GObject* tweet_model_real_get_item (GListModel* base, guint index);
static guint tweet_model_real_get_n_items (GListModel* base);
static void tweet_model_hide_tweet_internal (TweetModel* self, CbTweet* t, guint pos);
static void tweet_model_show_tweet_internal (TweetModel* self, CbTweet* t);
static void tweet_model_insert_sorted (TweetModel* self, CbTweet* tweet);
gboolean tweet_model_set_tweet_flag (TweetModel* self, CbTweet* t, CbTweetState flag);
gboolean tweet_model_unset_tweet_flag (TweetModel* self, CbTweet* t, CbTweetState flag);
static void tweet_model_remove_at_pos (TweetModel* self, gint pos);
void tweet_model_add (TweetModel* self, CbTweet* tweet);
void tweet_model_remove_last_n_visible (TweetModel* self, guint amount);
void tweet_model_clear (TweetModel* self);
void tweet_model_remove_tweet (TweetModel* self, CbTweet* t);
void tweet_model_toggle_flag_on_tweet (TweetModel* self, gint64 user_id, CbTweetState reason, gboolean active);
void tweet_model_toggle_flag_on_retweet (TweetModel* self, gint64 user_id, CbTweetState reason, gboolean active);
gboolean tweet_model_contains_id (TweetModel* self, gint64 tweet_id);
void tweet_model_remove_tweets_above (TweetModel* self, gint64 id);
CbTweet* tweet_model_get_from_id (TweetModel* self, gint64 id, gint diff);
gboolean tweet_model_delete_id (TweetModel* self, gint64 id, gboolean* seen);
TweetModel* tweet_model_new (void);
TweetModel* tweet_model_construct (GType object_type);
gint64 tweet_model_get_lowest_id (TweetModel* self);
gint64 tweet_model_get_greatest_id (TweetModel* self);
static void tweet_model_finalize (GObject* obj);
static void _vala_tweet_model_get_property (GObject * object, guint property_id, GValue * value, GParamSpec * pspec);


static void _g_object_unref0_ (gpointer var) {
	(var == NULL) ? NULL : (var = (g_object_unref (var), NULL));
}


static GType tweet_model_real_get_item_type (GListModel* base) {
	TweetModel * self;
	GType result = 0UL;
	self = G_TYPE_CHECK_INSTANCE_CAST (base, TYPE_TWEET_MODEL, TweetModel);
	result = CB_TYPE_TWEET;
	return result;
}


static gint g_ptr_array_get_length (GPtrArray* self) {
	gint result;
	guint _tmp0_ = 0U;
	g_return_val_if_fail (self != NULL, 0);
	_tmp0_ = self->len;
	result = (gint) _tmp0_;
	return result;
}


static void g_ptr_array_set_length (GPtrArray* self, gint value) {
	gint _tmp0_ = 0;
	g_return_if_fail (self != NULL);
	_tmp0_ = value;
	g_ptr_array_set_size (self, _tmp0_);
}


static gpointer _g_object_ref0 (gpointer self) {
	return self ? g_object_ref (self) : NULL;
}


static GObject* tweet_model_real_get_item (GListModel* base, guint index) {
	TweetModel * self;
	GObject* result = NULL;
	guint _tmp0_ = 0U;
	guint _tmp1_ = 0U;
	GPtrArray* _tmp2_ = NULL;
	gint _tmp3_ = 0;
	gint _tmp4_ = 0;
	GPtrArray* _tmp5_ = NULL;
	guint _tmp6_ = 0U;
	gconstpointer _tmp7_ = NULL;
	GObject* _tmp8_ = NULL;
	self = G_TYPE_CHECK_INSTANCE_CAST (base, TYPE_TWEET_MODEL, TweetModel);
	_tmp0_ = index;
	_vala_assert (_tmp0_ >= ((guint) 0), "index >= 0");
	_tmp1_ = index;
	_tmp2_ = self->priv->tweets;
	_tmp3_ = g_ptr_array_get_length (_tmp2_);
	_tmp4_ = _tmp3_;
	_vala_assert (_tmp1_ < ((guint) _tmp4_), "index <  tweets.length");
	_tmp5_ = self->priv->tweets;
	_tmp6_ = index;
	_tmp7_ = g_ptr_array_index (_tmp5_, (guint) ((gint) _tmp6_));
	_tmp8_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_CAST ((CbTweet*) _tmp7_, G_TYPE_OBJECT, GObject));
	result = _tmp8_;
	return result;
}


static guint tweet_model_real_get_n_items (GListModel* base) {
	TweetModel * self;
	guint result = 0U;
	GPtrArray* _tmp0_ = NULL;
	gint _tmp1_ = 0;
	gint _tmp2_ = 0;
	self = G_TYPE_CHECK_INSTANCE_CAST (base, TYPE_TWEET_MODEL, TweetModel);
	_tmp0_ = self->priv->tweets;
	_tmp1_ = g_ptr_array_get_length (_tmp0_);
	_tmp2_ = _tmp1_;
	result = (guint) _tmp2_;
	return result;
}


/**
   * Removes @t from the list of tweets and adds it to the list of hidden tweets,
   * updates the min/max id fields.
   */
static void tweet_model_hide_tweet_internal (TweetModel* self, CbTweet* t, guint pos) {
	GPtrArray* _tmp0_ = NULL;
	CbTweet* _tmp1_ = NULL;
	GPtrArray* _tmp2_ = NULL;
	CbTweet* _tmp3_ = NULL;
	CbTweet* _tmp4_ = NULL;
	gint64 id = 0LL;
	CbTweet* _tmp5_ = NULL;
	gint64 _tmp6_ = 0LL;
	gint64 _tmp7_ = 0LL;
	gint64 _tmp8_ = 0LL;
	gint64 _tmp18_ = 0LL;
	gint64 _tmp19_ = 0LL;
	g_return_if_fail (IS_TWEET_MODEL (self));
	g_return_if_fail (CB_IS_TWEET (t));
	_tmp0_ = self->priv->tweets;
	_tmp1_ = t;
	g_ptr_array_remove (_tmp0_, _tmp1_);
	_tmp2_ = self->hidden_tweets;
	_tmp3_ = t;
	_tmp4_ = _g_object_ref0 (_tmp3_);
	g_ptr_array_add (_tmp2_, _tmp4_);
	_tmp5_ = t;
	_tmp6_ = _tmp5_->id;
	id = _tmp6_;
	_tmp7_ = id;
	_tmp8_ = self->priv->max_id;
	if (_tmp7_ == _tmp8_) {
		GPtrArray* _tmp9_ = NULL;
		gint _tmp10_ = 0;
		gint _tmp11_ = 0;
		_tmp9_ = self->priv->tweets;
		_tmp10_ = g_ptr_array_get_length (_tmp9_);
		_tmp11_ = _tmp10_;
		if (_tmp11_ > 0) {
			guint p = 0U;
			guint _tmp12_ = 0U;
			gint _tmp13_ = 0;
			GPtrArray* _tmp14_ = NULL;
			guint _tmp15_ = 0U;
			gconstpointer _tmp16_ = NULL;
			gint64 _tmp17_ = 0LL;
			_tmp12_ = pos;
			_tmp13_ = MAX (((gint) _tmp12_) - 1, 0);
			p = (guint) _tmp13_;
			_tmp14_ = self->priv->tweets;
			_tmp15_ = p;
			_tmp16_ = g_ptr_array_index (_tmp14_, _tmp15_);
			_tmp17_ = ((CbTweet*) _tmp16_)->id;
			self->priv->max_id = _tmp17_;
		} else {
			self->priv->max_id = G_MININT64;
		}
	}
	_tmp18_ = id;
	_tmp19_ = self->priv->min_id;
	if (_tmp18_ == _tmp19_) {
		GPtrArray* _tmp20_ = NULL;
		gint _tmp21_ = 0;
		gint _tmp22_ = 0;
		_tmp20_ = self->priv->tweets;
		_tmp21_ = g_ptr_array_get_length (_tmp20_);
		_tmp22_ = _tmp21_;
		if (_tmp22_ > 0) {
			guint p = 0U;
			guint _tmp23_ = 0U;
			GPtrArray* _tmp24_ = NULL;
			gint _tmp25_ = 0;
			gint _tmp26_ = 0;
			guint _tmp27_ = 0U;
			GPtrArray* _tmp28_ = NULL;
			guint _tmp29_ = 0U;
			gconstpointer _tmp30_ = NULL;
			gint64 _tmp31_ = 0LL;
			_tmp23_ = pos;
			_tmp24_ = self->priv->tweets;
			_tmp25_ = g_ptr_array_get_length (_tmp24_);
			_tmp26_ = _tmp25_;
			_tmp27_ = MIN (_tmp23_ + 1, (guint) (_tmp26_ - 1));
			p = _tmp27_;
			_tmp28_ = self->priv->tweets;
			_tmp29_ = p;
			_tmp30_ = g_ptr_array_index (_tmp28_, _tmp29_);
			_tmp31_ = ((CbTweet*) _tmp30_)->id;
			self->priv->min_id = _tmp31_;
		} else {
			self->priv->min_id = G_MAXINT64;
		}
	}
}


static void tweet_model_show_tweet_internal (TweetModel* self, CbTweet* t) {
	GPtrArray* _tmp0_ = NULL;
	CbTweet* _tmp1_ = NULL;
	CbTweet* _tmp2_ = NULL;
	CbTweet* _tmp3_ = NULL;
	gint64 _tmp4_ = 0LL;
	gint64 _tmp5_ = 0LL;
	CbTweet* _tmp8_ = NULL;
	gint64 _tmp9_ = 0LL;
	gint64 _tmp10_ = 0LL;
	g_return_if_fail (IS_TWEET_MODEL (self));
	g_return_if_fail (CB_IS_TWEET (t));
	_tmp0_ = self->hidden_tweets;
	_tmp1_ = t;
	g_ptr_array_remove (_tmp0_, _tmp1_);
	_tmp2_ = t;
	tweet_model_insert_sorted (self, _tmp2_);
	_tmp3_ = t;
	_tmp4_ = _tmp3_->id;
	_tmp5_ = self->priv->max_id;
	if (_tmp4_ > _tmp5_) {
		CbTweet* _tmp6_ = NULL;
		gint64 _tmp7_ = 0LL;
		_tmp6_ = t;
		_tmp7_ = _tmp6_->id;
		self->priv->max_id = _tmp7_;
	}
	_tmp8_ = t;
	_tmp9_ = _tmp8_->id;
	_tmp10_ = self->priv->min_id;
	if (_tmp9_ < _tmp10_) {
		CbTweet* _tmp11_ = NULL;
		gint64 _tmp12_ = 0LL;
		_tmp11_ = t;
		_tmp12_ = _tmp11_->id;
		self->priv->min_id = _tmp12_;
	}
}


/**
   * Returns true if a tweet was hidden, false otherwise.
   */
gboolean tweet_model_set_tweet_flag (TweetModel* self, CbTweet* t, CbTweetState flag) {
	gboolean result = FALSE;
	CbTweet* _tmp0_ = NULL;
	gboolean _tmp1_ = FALSE;
	g_return_val_if_fail (IS_TWEET_MODEL (self), FALSE);
	g_return_val_if_fail (CB_IS_TWEET (t), FALSE);
	_tmp0_ = t;
	_tmp1_ = cb_tweet_is_hidden (_tmp0_);
	if (_tmp1_) {
		CbTweet* _tmp2_ = NULL;
		CbTweetState _tmp3_ = 0;
		_tmp2_ = t;
		_tmp3_ = flag;
		cb_tweet_set_flag (_tmp2_, (guint) _tmp3_);
	} else {
		CbTweet* _tmp4_ = NULL;
		CbTweetState _tmp5_ = 0;
		CbTweet* _tmp6_ = NULL;
		gboolean _tmp7_ = FALSE;
		_tmp4_ = t;
		_tmp5_ = flag;
		cb_tweet_set_flag (_tmp4_, (guint) _tmp5_);
		_tmp6_ = t;
		_tmp7_ = cb_tweet_is_hidden (_tmp6_);
		if (_tmp7_) {
			{
				guint i = 0U;
				i = (guint) 0;
				{
					gboolean _tmp8_ = FALSE;
					_tmp8_ = TRUE;
					while (TRUE) {
						guint _tmp10_ = 0U;
						GPtrArray* _tmp11_ = NULL;
						gint _tmp12_ = 0;
						gint _tmp13_ = 0;
						GPtrArray* _tmp14_ = NULL;
						guint _tmp15_ = 0U;
						gconstpointer _tmp16_ = NULL;
						CbTweet* _tmp17_ = NULL;
						if (!_tmp8_) {
							guint _tmp9_ = 0U;
							_tmp9_ = i;
							i = _tmp9_ + 1;
						}
						_tmp8_ = FALSE;
						_tmp10_ = i;
						_tmp11_ = self->priv->tweets;
						_tmp12_ = g_ptr_array_get_length (_tmp11_);
						_tmp13_ = _tmp12_;
						if (!(_tmp10_ < ((guint) _tmp13_))) {
							break;
						}
						_tmp14_ = self->priv->tweets;
						_tmp15_ = i;
						_tmp16_ = g_ptr_array_index (_tmp14_, _tmp15_);
						_tmp17_ = t;
						if (((CbTweet*) _tmp16_) == _tmp17_) {
							GPtrArray* _tmp18_ = NULL;
							guint _tmp19_ = 0U;
							gconstpointer _tmp20_ = NULL;
							guint _tmp21_ = 0U;
							guint _tmp22_ = 0U;
							_tmp18_ = self->priv->tweets;
							_tmp19_ = i;
							_tmp20_ = g_ptr_array_index (_tmp18_, _tmp19_);
							_tmp21_ = i;
							tweet_model_hide_tweet_internal (self, (CbTweet*) _tmp20_, _tmp21_);
							_tmp22_ = i;
							g_list_model_items_changed (G_TYPE_CHECK_INSTANCE_CAST (self, g_list_model_get_type (), GListModel), _tmp22_, (guint) 1, (guint) 0);
							result = TRUE;
							return result;
						}
					}
				}
			}
		}
	}
	result = FALSE;
	return result;
}


gboolean tweet_model_unset_tweet_flag (TweetModel* self, CbTweet* t, CbTweetState flag) {
	gboolean result = FALSE;
	CbTweet* _tmp0_ = NULL;
	gboolean _tmp1_ = FALSE;
	g_return_val_if_fail (IS_TWEET_MODEL (self), FALSE);
	g_return_val_if_fail (CB_IS_TWEET (t), FALSE);
	_tmp0_ = t;
	_tmp1_ = cb_tweet_is_hidden (_tmp0_);
	if (_tmp1_) {
		CbTweet* _tmp2_ = NULL;
		CbTweetState _tmp3_ = 0;
		CbTweet* _tmp4_ = NULL;
		gboolean _tmp5_ = FALSE;
		_tmp2_ = t;
		_tmp3_ = flag;
		cb_tweet_unset_flag (_tmp2_, (guint) _tmp3_);
		_tmp4_ = t;
		_tmp5_ = cb_tweet_is_hidden (_tmp4_);
		if (!_tmp5_) {
			{
				guint i = 0U;
				i = (guint) 0;
				{
					gboolean _tmp6_ = FALSE;
					_tmp6_ = TRUE;
					while (TRUE) {
						guint _tmp8_ = 0U;
						GPtrArray* _tmp9_ = NULL;
						gint _tmp10_ = 0;
						gint _tmp11_ = 0;
						GPtrArray* _tmp12_ = NULL;
						guint _tmp13_ = 0U;
						gconstpointer _tmp14_ = NULL;
						CbTweet* _tmp15_ = NULL;
						if (!_tmp6_) {
							guint _tmp7_ = 0U;
							_tmp7_ = i;
							i = _tmp7_ + 1;
						}
						_tmp6_ = FALSE;
						_tmp8_ = i;
						_tmp9_ = self->hidden_tweets;
						_tmp10_ = g_ptr_array_get_length (_tmp9_);
						_tmp11_ = _tmp10_;
						if (!(_tmp8_ < ((guint) _tmp11_))) {
							break;
						}
						_tmp12_ = self->hidden_tweets;
						_tmp13_ = i;
						_tmp14_ = g_ptr_array_index (_tmp12_, _tmp13_);
						_tmp15_ = t;
						if (((CbTweet*) _tmp14_) == _tmp15_) {
							GPtrArray* _tmp16_ = NULL;
							guint _tmp17_ = 0U;
							gconstpointer _tmp18_ = NULL;
							_tmp16_ = self->hidden_tweets;
							_tmp17_ = i;
							_tmp18_ = g_ptr_array_index (_tmp16_, _tmp17_);
							tweet_model_show_tweet_internal (self, (CbTweet*) _tmp18_);
							result = TRUE;
							return result;
						}
					}
				}
			}
		}
	} else {
		CbTweet* _tmp19_ = NULL;
		CbTweetState _tmp20_ = 0;
		_tmp19_ = t;
		_tmp20_ = flag;
		cb_tweet_unset_flag (_tmp19_, (guint) _tmp20_);
	}
	result = FALSE;
	return result;
}


static void tweet_model_remove_at_pos (TweetModel* self, gint pos) {
	gint64 id = 0LL;
	GPtrArray* _tmp0_ = NULL;
	gint _tmp1_ = 0;
	gconstpointer _tmp2_ = NULL;
	gint64 _tmp3_ = 0LL;
	GPtrArray* _tmp4_ = NULL;
	gint _tmp5_ = 0;
	gint64 _tmp22_ = 0LL;
	gint64 _tmp23_ = 0LL;
	gint64 _tmp33_ = 0LL;
	gint64 _tmp34_ = 0LL;
	g_return_if_fail (IS_TWEET_MODEL (self));
	_tmp0_ = self->priv->tweets;
	_tmp1_ = pos;
	_tmp2_ = g_ptr_array_index (_tmp0_, (guint) _tmp1_);
	_tmp3_ = ((CbTweet*) _tmp2_)->id;
	id = _tmp3_;
	_tmp4_ = self->priv->tweets;
	_tmp5_ = pos;
	g_ptr_array_remove_index (_tmp4_, (guint) _tmp5_);
	{
		gint i = 0;
		i = 0;
		{
			gboolean _tmp6_ = FALSE;
			_tmp6_ = TRUE;
			while (TRUE) {
				gint _tmp8_ = 0;
				GPtrArray* _tmp9_ = NULL;
				gint _tmp10_ = 0;
				gint _tmp11_ = 0;
				CbTweet* tweet = NULL;
				GPtrArray* _tmp12_ = NULL;
				gint _tmp13_ = 0;
				gconstpointer _tmp14_ = NULL;
				CbTweet* _tmp15_ = NULL;
				CbTweet* _tmp16_ = NULL;
				gint64 _tmp17_ = 0LL;
				gint64 _tmp18_ = 0LL;
				if (!_tmp6_) {
					gint _tmp7_ = 0;
					_tmp7_ = i;
					i = _tmp7_ + 1;
				}
				_tmp6_ = FALSE;
				_tmp8_ = i;
				_tmp9_ = self->hidden_tweets;
				_tmp10_ = g_ptr_array_get_length (_tmp9_);
				_tmp11_ = _tmp10_;
				if (!(_tmp8_ < _tmp11_)) {
					break;
				}
				_tmp12_ = self->hidden_tweets;
				_tmp13_ = i;
				_tmp14_ = g_ptr_array_index (_tmp12_, (guint) _tmp13_);
				_tmp15_ = _g_object_ref0 ((CbTweet*) _tmp14_);
				tweet = _tmp15_;
				_tmp16_ = tweet;
				_tmp17_ = _tmp16_->id;
				_tmp18_ = id;
				if (_tmp17_ > _tmp18_) {
					GPtrArray* _tmp19_ = NULL;
					CbTweet* _tmp20_ = NULL;
					gint _tmp21_ = 0;
					_tmp19_ = self->hidden_tweets;
					_tmp20_ = tweet;
					g_ptr_array_remove (_tmp19_, _tmp20_);
					_tmp21_ = i;
					i = _tmp21_ - 1;
				}
				_g_object_unref0 (tweet);
			}
		}
	}
	_tmp22_ = id;
	_tmp23_ = self->priv->max_id;
	if (_tmp22_ == _tmp23_) {
		GPtrArray* _tmp24_ = NULL;
		gint _tmp25_ = 0;
		gint _tmp26_ = 0;
		_tmp24_ = self->priv->tweets;
		_tmp25_ = g_ptr_array_get_length (_tmp24_);
		_tmp26_ = _tmp25_;
		if (_tmp26_ > 0) {
			gint p = 0;
			gint _tmp27_ = 0;
			gint _tmp28_ = 0;
			GPtrArray* _tmp29_ = NULL;
			gint _tmp30_ = 0;
			gconstpointer _tmp31_ = NULL;
			gint64 _tmp32_ = 0LL;
			_tmp27_ = pos;
			_tmp28_ = MAX (_tmp27_ - 1, 0);
			p = _tmp28_;
			_tmp29_ = self->priv->tweets;
			_tmp30_ = p;
			_tmp31_ = g_ptr_array_index (_tmp29_, (guint) _tmp30_);
			_tmp32_ = ((CbTweet*) _tmp31_)->id;
			self->priv->max_id = _tmp32_;
		} else {
			self->priv->max_id = G_MININT64;
		}
	}
	_tmp33_ = id;
	_tmp34_ = self->priv->min_id;
	if (_tmp33_ == _tmp34_) {
		GPtrArray* _tmp35_ = NULL;
		gint _tmp36_ = 0;
		gint _tmp37_ = 0;
		_tmp35_ = self->priv->tweets;
		_tmp36_ = g_ptr_array_get_length (_tmp35_);
		_tmp37_ = _tmp36_;
		if (_tmp37_ > 0) {
			gint p = 0;
			gint _tmp38_ = 0;
			GPtrArray* _tmp39_ = NULL;
			gint _tmp40_ = 0;
			gint _tmp41_ = 0;
			gint _tmp42_ = 0;
			GPtrArray* _tmp43_ = NULL;
			gint _tmp44_ = 0;
			gconstpointer _tmp45_ = NULL;
			gint64 _tmp46_ = 0LL;
			_tmp38_ = pos;
			_tmp39_ = self->priv->tweets;
			_tmp40_ = g_ptr_array_get_length (_tmp39_);
			_tmp41_ = _tmp40_;
			_tmp42_ = MIN (_tmp38_ + 1, _tmp41_ - 1);
			p = _tmp42_;
			_tmp43_ = self->priv->tweets;
			_tmp44_ = p;
			_tmp45_ = g_ptr_array_index (_tmp43_, (guint) _tmp44_);
			_tmp46_ = ((CbTweet*) _tmp45_)->id;
			self->priv->min_id = _tmp46_;
		} else {
			self->priv->min_id = G_MAXINT64;
		}
	}
}


static void tweet_model_insert_sorted (TweetModel* self, CbTweet* tweet) {
	gint insert_pos = 0;
	CbTweet* _tmp0_ = NULL;
	gint64 _tmp1_ = 0LL;
	gint64 _tmp2_ = 0LL;
	gint _tmp42_ = 0;
	GPtrArray* _tmp43_ = NULL;
	gint _tmp44_ = 0;
	CbTweet* _tmp45_ = NULL;
	CbTweet* _tmp46_ = NULL;
	gint _tmp47_ = 0;
	g_return_if_fail (IS_TWEET_MODEL (self));
	g_return_if_fail (CB_IS_TWEET (tweet));
	insert_pos = -1;
	_tmp0_ = tweet;
	_tmp1_ = _tmp0_->id;
	_tmp2_ = self->priv->max_id;
	if (_tmp1_ > _tmp2_) {
		insert_pos = 0;
	} else {
		CbTweet* _tmp3_ = NULL;
		gint64 _tmp4_ = 0LL;
		gint64 _tmp5_ = 0LL;
		_tmp3_ = tweet;
		_tmp4_ = _tmp3_->id;
		_tmp5_ = self->priv->min_id;
		if (_tmp4_ < _tmp5_) {
			GPtrArray* _tmp6_ = NULL;
			gint _tmp7_ = 0;
			gint _tmp8_ = 0;
			_tmp6_ = self->priv->tweets;
			_tmp7_ = g_ptr_array_get_length (_tmp6_);
			_tmp8_ = _tmp7_;
			insert_pos = _tmp8_;
		} else {
			gint64 half = 0LL;
			gint64 _tmp9_ = 0LL;
			gint64 _tmp10_ = 0LL;
			CbTweet* _tmp11_ = NULL;
			gint64 _tmp12_ = 0LL;
			gint64 _tmp13_ = 0LL;
			gint64 _tmp14_ = 0LL;
			_tmp9_ = self->priv->max_id;
			_tmp10_ = self->priv->min_id;
			half = (_tmp9_ - _tmp10_) / 2;
			_tmp11_ = tweet;
			_tmp12_ = _tmp11_->id;
			_tmp13_ = self->priv->min_id;
			_tmp14_ = half;
			if (_tmp12_ > (_tmp13_ + _tmp14_)) {
				{
					gint i = 0;
					gint p = 0;
					GPtrArray* _tmp15_ = NULL;
					gint _tmp16_ = 0;
					gint _tmp17_ = 0;
					i = 0;
					_tmp15_ = self->priv->tweets;
					_tmp16_ = g_ptr_array_get_length (_tmp15_);
					_tmp17_ = _tmp16_;
					p = _tmp17_;
					{
						gboolean _tmp18_ = FALSE;
						_tmp18_ = TRUE;
						while (TRUE) {
							gint _tmp20_ = 0;
							gint _tmp21_ = 0;
							GPtrArray* _tmp22_ = NULL;
							gint _tmp23_ = 0;
							gconstpointer _tmp24_ = NULL;
							gint64 _tmp25_ = 0LL;
							CbTweet* _tmp26_ = NULL;
							gint64 _tmp27_ = 0LL;
							if (!_tmp18_) {
								gint _tmp19_ = 0;
								_tmp19_ = i;
								i = _tmp19_ + 1;
							}
							_tmp18_ = FALSE;
							_tmp20_ = i;
							_tmp21_ = p;
							if (!(_tmp20_ < _tmp21_)) {
								break;
							}
							_tmp22_ = self->priv->tweets;
							_tmp23_ = i;
							_tmp24_ = g_ptr_array_index (_tmp22_, (guint) _tmp23_);
							_tmp25_ = ((CbTweet*) _tmp24_)->id;
							_tmp26_ = tweet;
							_tmp27_ = _tmp26_->id;
							if (_tmp25_ <= _tmp27_) {
								gint _tmp28_ = 0;
								_tmp28_ = i;
								insert_pos = _tmp28_;
								break;
							}
						}
					}
				}
			} else {
				{
					gint i = 0;
					GPtrArray* _tmp29_ = NULL;
					gint _tmp30_ = 0;
					gint _tmp31_ = 0;
					_tmp29_ = self->priv->tweets;
					_tmp30_ = g_ptr_array_get_length (_tmp29_);
					_tmp31_ = _tmp30_;
					i = _tmp31_ - 1;
					{
						gboolean _tmp32_ = FALSE;
						_tmp32_ = TRUE;
						while (TRUE) {
							gint _tmp34_ = 0;
							GPtrArray* _tmp35_ = NULL;
							gint _tmp36_ = 0;
							gconstpointer _tmp37_ = NULL;
							gint64 _tmp38_ = 0LL;
							CbTweet* _tmp39_ = NULL;
							gint64 _tmp40_ = 0LL;
							if (!_tmp32_) {
								gint _tmp33_ = 0;
								_tmp33_ = i;
								i = _tmp33_ - 1;
							}
							_tmp32_ = FALSE;
							_tmp34_ = i;
							if (!(_tmp34_ >= 0)) {
								break;
							}
							_tmp35_ = self->priv->tweets;
							_tmp36_ = i;
							_tmp37_ = g_ptr_array_index (_tmp35_, (guint) _tmp36_);
							_tmp38_ = ((CbTweet*) _tmp37_)->id;
							_tmp39_ = tweet;
							_tmp40_ = _tmp39_->id;
							if (_tmp38_ >= _tmp40_) {
								gint _tmp41_ = 0;
								_tmp41_ = i;
								insert_pos = _tmp41_ + 1;
								break;
							}
						}
					}
				}
			}
		}
	}
	_tmp42_ = insert_pos;
	_vala_assert (_tmp42_ != -1, "insert_pos != -1");
	_tmp43_ = self->priv->tweets;
	_tmp44_ = insert_pos;
	_tmp45_ = tweet;
	_tmp46_ = _g_object_ref0 (_tmp45_);
	g_ptr_array_insert (_tmp43_, _tmp44_, _tmp46_);
	_tmp47_ = insert_pos;
	g_list_model_items_changed (G_TYPE_CHECK_INSTANCE_CAST (self, g_list_model_get_type (), GListModel), (guint) _tmp47_, (guint) 0, (guint) 1);
}


void tweet_model_add (TweetModel* self, CbTweet* tweet) {
	CbTweet* _tmp0_ = NULL;
	gint64 _tmp1_ = 0LL;
	CbTweet* _tmp2_ = NULL;
	gboolean _tmp3_ = FALSE;
	g_return_if_fail (IS_TWEET_MODEL (self));
	g_return_if_fail (CB_IS_TWEET (tweet));
	_tmp0_ = tweet;
	_tmp1_ = _tmp0_->id;
	_vala_assert (_tmp1_ > ((gint64) 0), "tweet.id > 0");
	_tmp2_ = tweet;
	_tmp3_ = cb_tweet_is_hidden (_tmp2_);
	if (_tmp3_) {
		GPtrArray* _tmp4_ = NULL;
		CbTweet* _tmp5_ = NULL;
		CbTweet* _tmp6_ = NULL;
		_tmp4_ = self->hidden_tweets;
		_tmp5_ = tweet;
		_tmp6_ = _g_object_ref0 (_tmp5_);
		g_ptr_array_add (_tmp4_, _tmp6_);
	} else {
		CbTweet* _tmp7_ = NULL;
		CbTweet* _tmp8_ = NULL;
		gint64 _tmp9_ = 0LL;
		gint64 _tmp10_ = 0LL;
		CbTweet* _tmp13_ = NULL;
		gint64 _tmp14_ = 0LL;
		gint64 _tmp15_ = 0LL;
		_tmp7_ = tweet;
		tweet_model_insert_sorted (self, _tmp7_);
		_tmp8_ = tweet;
		_tmp9_ = _tmp8_->id;
		_tmp10_ = self->priv->max_id;
		if (_tmp9_ > _tmp10_) {
			CbTweet* _tmp11_ = NULL;
			gint64 _tmp12_ = 0LL;
			_tmp11_ = tweet;
			_tmp12_ = _tmp11_->id;
			self->priv->max_id = _tmp12_;
		}
		_tmp13_ = tweet;
		_tmp14_ = _tmp13_->id;
		_tmp15_ = self->priv->min_id;
		if (_tmp14_ < _tmp15_) {
			CbTweet* _tmp16_ = NULL;
			gint64 _tmp17_ = 0LL;
			_tmp16_ = tweet;
			_tmp17_ = _tmp16_->id;
			self->priv->min_id = _tmp17_;
		}
	}
}


void tweet_model_remove_last_n_visible (TweetModel* self, guint amount) {
	guint _tmp0_ = 0U;
	GPtrArray* _tmp1_ = NULL;
	gint _tmp2_ = 0;
	gint _tmp3_ = 0;
	guint n_removed = 0U;
	gint size_before = 0;
	GPtrArray* _tmp4_ = NULL;
	gint _tmp5_ = 0;
	gint _tmp6_ = 0;
	gint index = 0;
	GPtrArray* _tmp7_ = NULL;
	gint _tmp8_ = 0;
	gint _tmp9_ = 0;
	gint removed = 0;
	gint _tmp17_ = 0;
	GPtrArray* _tmp18_ = NULL;
	gint _tmp19_ = 0;
	gint _tmp20_ = 0;
	gint _tmp21_ = 0;
	g_return_if_fail (IS_TWEET_MODEL (self));
	_tmp0_ = amount;
	_tmp1_ = self->priv->tweets;
	_tmp2_ = g_ptr_array_get_length (_tmp1_);
	_tmp3_ = _tmp2_;
	_vala_assert (_tmp0_ <= ((guint) _tmp3_), "amount <= tweets.length");
	n_removed = (guint) 0;
	_tmp4_ = self->priv->tweets;
	_tmp5_ = g_ptr_array_get_length (_tmp4_);
	_tmp6_ = _tmp5_;
	size_before = _tmp6_;
	_tmp7_ = self->priv->tweets;
	_tmp8_ = g_ptr_array_get_length (_tmp7_);
	_tmp9_ = _tmp8_;
	index = _tmp9_ - 1;
	while (TRUE) {
		gboolean _tmp10_ = FALSE;
		gint _tmp11_ = 0;
		gint _tmp14_ = 0;
		gint _tmp15_ = 0;
		guint _tmp16_ = 0U;
		_tmp11_ = index;
		if (_tmp11_ >= 0) {
			guint _tmp12_ = 0U;
			guint _tmp13_ = 0U;
			_tmp12_ = n_removed;
			_tmp13_ = amount;
			_tmp10_ = _tmp12_ < _tmp13_;
		} else {
			_tmp10_ = FALSE;
		}
		if (!_tmp10_) {
			break;
		}
		_tmp14_ = index;
		tweet_model_remove_at_pos (self, _tmp14_);
		_tmp15_ = index;
		index = _tmp15_ - 1;
		_tmp16_ = n_removed;
		n_removed = _tmp16_ + 1;
	}
	_tmp17_ = size_before;
	_tmp18_ = self->priv->tweets;
	_tmp19_ = g_ptr_array_get_length (_tmp18_);
	_tmp20_ = _tmp19_;
	removed = _tmp17_ - _tmp20_;
	_tmp21_ = size_before;
	g_list_model_items_changed (G_TYPE_CHECK_INSTANCE_CAST (self, g_list_model_get_type (), GListModel), (guint) (_tmp21_ - removed), (guint) removed, (guint) 0);
}


void tweet_model_clear (TweetModel* self) {
	gint s = 0;
	GPtrArray* _tmp0_ = NULL;
	gint _tmp1_ = 0;
	gint _tmp2_ = 0;
	GPtrArray* _tmp3_ = NULL;
	GPtrArray* _tmp4_ = NULL;
	gint _tmp5_ = 0;
	gint _tmp6_ = 0;
	GPtrArray* _tmp7_ = NULL;
	GPtrArray* _tmp8_ = NULL;
	gint _tmp9_ = 0;
	gint _tmp10_ = 0;
	g_return_if_fail (IS_TWEET_MODEL (self));
	_tmp0_ = self->priv->tweets;
	_tmp1_ = g_ptr_array_get_length (_tmp0_);
	_tmp2_ = _tmp1_;
	s = _tmp2_;
	_tmp3_ = self->priv->tweets;
	_tmp4_ = self->priv->tweets;
	_tmp5_ = g_ptr_array_get_length (_tmp4_);
	_tmp6_ = _tmp5_;
	g_ptr_array_remove_range (_tmp3_, (guint) 0, (guint) _tmp6_);
	_tmp7_ = self->hidden_tweets;
	_tmp8_ = self->hidden_tweets;
	_tmp9_ = g_ptr_array_get_length (_tmp8_);
	_tmp10_ = _tmp9_;
	g_ptr_array_remove_range (_tmp7_, (guint) 0, (guint) _tmp10_);
	self->priv->min_id = G_MAXINT64;
	self->priv->max_id = G_MININT64;
	g_list_model_items_changed (G_TYPE_CHECK_INSTANCE_CAST (self, g_list_model_get_type (), GListModel), (guint) 0, (guint) s, (guint) 0);
}


void tweet_model_remove_tweet (TweetModel* self, CbTweet* t) {
	CbTweet* _tmp0_ = NULL;
	gboolean _tmp1_ = FALSE;
	g_return_if_fail (IS_TWEET_MODEL (self));
	g_return_if_fail (CB_IS_TWEET (t));
	_tmp0_ = t;
	_tmp1_ = cb_tweet_is_hidden (_tmp0_);
	if (_tmp1_) {
		{
			gint i = 0;
			i = 0;
			{
				gboolean _tmp2_ = FALSE;
				_tmp2_ = TRUE;
				while (TRUE) {
					gint _tmp4_ = 0;
					GPtrArray* _tmp5_ = NULL;
					gint _tmp6_ = 0;
					gint _tmp7_ = 0;
					CbTweet* tweet = NULL;
					GPtrArray* _tmp8_ = NULL;
					gint _tmp9_ = 0;
					gconstpointer _tmp10_ = NULL;
					CbTweet* _tmp11_ = NULL;
					CbTweet* _tmp12_ = NULL;
					CbTweet* _tmp13_ = NULL;
					if (!_tmp2_) {
						gint _tmp3_ = 0;
						_tmp3_ = i;
						i = _tmp3_ + 1;
					}
					_tmp2_ = FALSE;
					_tmp4_ = i;
					_tmp5_ = self->hidden_tweets;
					_tmp6_ = g_ptr_array_get_length (_tmp5_);
					_tmp7_ = _tmp6_;
					if (!(_tmp4_ < _tmp7_)) {
						break;
					}
					_tmp8_ = self->hidden_tweets;
					_tmp9_ = i;
					_tmp10_ = g_ptr_array_index (_tmp8_, (guint) _tmp9_);
					_tmp11_ = _g_object_ref0 ((CbTweet*) _tmp10_);
					tweet = _tmp11_;
					_tmp12_ = t;
					_tmp13_ = tweet;
					if (_tmp12_ == _tmp13_) {
						GPtrArray* _tmp14_ = NULL;
						CbTweet* _tmp15_ = NULL;
						_tmp14_ = self->hidden_tweets;
						_tmp15_ = t;
						g_ptr_array_remove (_tmp14_, _tmp15_);
						_g_object_unref0 (tweet);
						break;
					}
					_g_object_unref0 (tweet);
				}
			}
		}
	} else {
		gint pos = 0;
		gint _tmp29_ = 0;
		gint _tmp30_ = 0;
		GPtrArray* _tmp31_ = NULL;
		gint _tmp32_ = 0;
		gint _tmp33_ = 0;
		pos = 0;
		{
			gint i = 0;
			i = 0;
			{
				gboolean _tmp16_ = FALSE;
				_tmp16_ = TRUE;
				while (TRUE) {
					gint _tmp18_ = 0;
					GPtrArray* _tmp19_ = NULL;
					gint _tmp20_ = 0;
					gint _tmp21_ = 0;
					CbTweet* tweet = NULL;
					GPtrArray* _tmp22_ = NULL;
					gint _tmp23_ = 0;
					gconstpointer _tmp24_ = NULL;
					CbTweet* _tmp25_ = NULL;
					CbTweet* _tmp26_ = NULL;
					CbTweet* _tmp27_ = NULL;
					if (!_tmp16_) {
						gint _tmp17_ = 0;
						_tmp17_ = i;
						i = _tmp17_ + 1;
					}
					_tmp16_ = FALSE;
					_tmp18_ = i;
					_tmp19_ = self->priv->tweets;
					_tmp20_ = g_ptr_array_get_length (_tmp19_);
					_tmp21_ = _tmp20_;
					if (!(_tmp18_ < _tmp21_)) {
						break;
					}
					_tmp22_ = self->priv->tweets;
					_tmp23_ = i;
					_tmp24_ = g_ptr_array_index (_tmp22_, (guint) _tmp23_);
					_tmp25_ = _g_object_ref0 ((CbTweet*) _tmp24_);
					tweet = _tmp25_;
					_tmp26_ = t;
					_tmp27_ = tweet;
					if (_tmp26_ == _tmp27_) {
						gint _tmp28_ = 0;
						_tmp28_ = i;
						pos = _tmp28_;
						_g_object_unref0 (tweet);
						break;
					}
					_g_object_unref0 (tweet);
				}
			}
		}
		_tmp29_ = pos;
		tweet_model_remove_at_pos (self, _tmp29_);
		_tmp30_ = pos;
		g_list_model_items_changed (G_TYPE_CHECK_INSTANCE_CAST (self, g_list_model_get_type (), GListModel), (guint) _tmp30_, (guint) 1, (guint) 0);
		_tmp31_ = self->priv->tweets;
		_tmp32_ = g_ptr_array_get_length (_tmp31_);
		_tmp33_ = _tmp32_;
		if (_tmp33_ == 0) {
			GPtrArray* _tmp34_ = NULL;
			GPtrArray* _tmp35_ = NULL;
			gint _tmp36_ = 0;
			gint _tmp37_ = 0;
			_tmp34_ = self->hidden_tweets;
			_tmp35_ = self->hidden_tweets;
			_tmp36_ = g_ptr_array_get_length (_tmp35_);
			_tmp37_ = _tmp36_;
			g_ptr_array_remove_range (_tmp34_, (guint) 0, (guint) _tmp37_);
		} else {
			{
				gint i = 0;
				i = 0;
				{
					gboolean _tmp38_ = FALSE;
					_tmp38_ = TRUE;
					while (TRUE) {
						gint _tmp40_ = 0;
						GPtrArray* _tmp41_ = NULL;
						gint _tmp42_ = 0;
						gint _tmp43_ = 0;
						CbTweet* tweet = NULL;
						GPtrArray* _tmp44_ = NULL;
						gint _tmp45_ = 0;
						gconstpointer _tmp46_ = NULL;
						CbTweet* _tmp47_ = NULL;
						CbTweet* _tmp48_ = NULL;
						gint64 _tmp49_ = 0LL;
						CbTweet* _tmp50_ = NULL;
						gint64 _tmp51_ = 0LL;
						if (!_tmp38_) {
							gint _tmp39_ = 0;
							_tmp39_ = i;
							i = _tmp39_ + 1;
						}
						_tmp38_ = FALSE;
						_tmp40_ = i;
						_tmp41_ = self->hidden_tweets;
						_tmp42_ = g_ptr_array_get_length (_tmp41_);
						_tmp43_ = _tmp42_;
						if (!(_tmp40_ < _tmp43_)) {
							break;
						}
						_tmp44_ = self->hidden_tweets;
						_tmp45_ = i;
						_tmp46_ = g_ptr_array_index (_tmp44_, (guint) _tmp45_);
						_tmp47_ = _g_object_ref0 ((CbTweet*) _tmp46_);
						tweet = _tmp47_;
						_tmp48_ = tweet;
						_tmp49_ = _tmp48_->id;
						_tmp50_ = t;
						_tmp51_ = _tmp50_->id;
						if (_tmp49_ > _tmp51_) {
							GPtrArray* _tmp52_ = NULL;
							CbTweet* _tmp53_ = NULL;
							gint _tmp54_ = 0;
							_tmp52_ = self->hidden_tweets;
							_tmp53_ = tweet;
							g_ptr_array_remove (_tmp52_, _tmp53_);
							_tmp54_ = i;
							i = _tmp54_ - 1;
						}
						_g_object_unref0 (tweet);
					}
				}
			}
		}
	}
}


void tweet_model_toggle_flag_on_tweet (TweetModel* self, gint64 user_id, CbTweetState reason, gboolean active) {
	g_return_if_fail (IS_TWEET_MODEL (self));
	{
		gint i = 0;
		i = 0;
		{
			gboolean _tmp0_ = FALSE;
			_tmp0_ = TRUE;
			while (TRUE) {
				gint _tmp2_ = 0;
				GPtrArray* _tmp3_ = NULL;
				gint _tmp4_ = 0;
				gint _tmp5_ = 0;
				CbTweet* tweet = NULL;
				GPtrArray* _tmp6_ = NULL;
				gint _tmp7_ = 0;
				gconstpointer _tmp8_ = NULL;
				CbTweet* _tmp9_ = NULL;
				CbTweet* _tmp10_ = NULL;
				gint64 _tmp11_ = 0LL;
				gint64 _tmp12_ = 0LL;
				if (!_tmp0_) {
					gint _tmp1_ = 0;
					_tmp1_ = i;
					i = _tmp1_ + 1;
				}
				_tmp0_ = FALSE;
				_tmp2_ = i;
				_tmp3_ = self->priv->tweets;
				_tmp4_ = g_ptr_array_get_length (_tmp3_);
				_tmp5_ = _tmp4_;
				if (!(_tmp2_ < _tmp5_)) {
					break;
				}
				_tmp6_ = self->priv->tweets;
				_tmp7_ = i;
				_tmp8_ = g_ptr_array_index (_tmp6_, (guint) _tmp7_);
				_tmp9_ = _g_object_ref0 ((CbTweet*) _tmp8_);
				tweet = _tmp9_;
				_tmp10_ = tweet;
				_tmp11_ = cb_tweet_get_user_id (_tmp10_);
				_tmp12_ = user_id;
				if (_tmp11_ == _tmp12_) {
					gboolean _tmp13_ = FALSE;
					_tmp13_ = active;
					if (_tmp13_) {
						CbTweet* _tmp14_ = NULL;
						CbTweetState _tmp15_ = 0;
						gboolean _tmp16_ = FALSE;
						_tmp14_ = tweet;
						_tmp15_ = reason;
						_tmp16_ = tweet_model_set_tweet_flag (self, _tmp14_, _tmp15_);
						if (_tmp16_) {
							gint _tmp17_ = 0;
							_tmp17_ = i;
							i = _tmp17_ - 1;
						}
					} else {
						CbTweet* _tmp18_ = NULL;
						CbTweetState _tmp19_ = 0;
						gboolean _tmp20_ = FALSE;
						_tmp18_ = tweet;
						_tmp19_ = reason;
						_tmp20_ = tweet_model_unset_tweet_flag (self, _tmp18_, _tmp19_);
						if (_tmp20_) {
							gint _tmp21_ = 0;
							_tmp21_ = i;
							i = _tmp21_ - 1;
						}
					}
				}
				_g_object_unref0 (tweet);
			}
		}
	}
	{
		gint i = 0;
		i = 0;
		{
			gboolean _tmp22_ = FALSE;
			_tmp22_ = TRUE;
			while (TRUE) {
				gint _tmp24_ = 0;
				GPtrArray* _tmp25_ = NULL;
				gint _tmp26_ = 0;
				gint _tmp27_ = 0;
				CbTweet* tweet = NULL;
				GPtrArray* _tmp28_ = NULL;
				gint _tmp29_ = 0;
				gconstpointer _tmp30_ = NULL;
				CbTweet* _tmp31_ = NULL;
				CbTweet* _tmp32_ = NULL;
				gint64 _tmp33_ = 0LL;
				gint64 _tmp34_ = 0LL;
				if (!_tmp22_) {
					gint _tmp23_ = 0;
					_tmp23_ = i;
					i = _tmp23_ + 1;
				}
				_tmp22_ = FALSE;
				_tmp24_ = i;
				_tmp25_ = self->hidden_tweets;
				_tmp26_ = g_ptr_array_get_length (_tmp25_);
				_tmp27_ = _tmp26_;
				if (!(_tmp24_ < _tmp27_)) {
					break;
				}
				_tmp28_ = self->hidden_tweets;
				_tmp29_ = i;
				_tmp30_ = g_ptr_array_index (_tmp28_, (guint) _tmp29_);
				_tmp31_ = _g_object_ref0 ((CbTweet*) _tmp30_);
				tweet = _tmp31_;
				_tmp32_ = tweet;
				_tmp33_ = cb_tweet_get_user_id (_tmp32_);
				_tmp34_ = user_id;
				if (_tmp33_ == _tmp34_) {
					gboolean _tmp35_ = FALSE;
					_tmp35_ = active;
					if (_tmp35_) {
						CbTweet* _tmp36_ = NULL;
						CbTweetState _tmp37_ = 0;
						gboolean _tmp38_ = FALSE;
						_tmp36_ = tweet;
						_tmp37_ = reason;
						_tmp38_ = tweet_model_set_tweet_flag (self, _tmp36_, _tmp37_);
						if (_tmp38_) {
							gint _tmp39_ = 0;
							_tmp39_ = i;
							i = _tmp39_ - 1;
						}
					} else {
						CbTweet* _tmp40_ = NULL;
						CbTweetState _tmp41_ = 0;
						gboolean _tmp42_ = FALSE;
						_tmp40_ = tweet;
						_tmp41_ = reason;
						_tmp42_ = tweet_model_unset_tweet_flag (self, _tmp40_, _tmp41_);
						if (_tmp42_) {
							gint _tmp43_ = 0;
							_tmp43_ = i;
							i = _tmp43_ - 1;
						}
					}
				}
				_g_object_unref0 (tweet);
			}
		}
	}
}


/**
   * Hides all tweets where the given user is the RETWEETER
   */
void tweet_model_toggle_flag_on_retweet (TweetModel* self, gint64 user_id, CbTweetState reason, gboolean active) {
	g_return_if_fail (IS_TWEET_MODEL (self));
	{
		gint i = 0;
		i = 0;
		{
			gboolean _tmp0_ = FALSE;
			_tmp0_ = TRUE;
			while (TRUE) {
				gint _tmp2_ = 0;
				GPtrArray* _tmp3_ = NULL;
				gint _tmp4_ = 0;
				gint _tmp5_ = 0;
				CbTweet* tweet = NULL;
				GPtrArray* _tmp6_ = NULL;
				gint _tmp7_ = 0;
				gconstpointer _tmp8_ = NULL;
				CbTweet* _tmp9_ = NULL;
				gboolean _tmp10_ = FALSE;
				CbTweet* _tmp11_ = NULL;
				CbMiniTweet* _tmp12_ = NULL;
				if (!_tmp0_) {
					gint _tmp1_ = 0;
					_tmp1_ = i;
					i = _tmp1_ + 1;
				}
				_tmp0_ = FALSE;
				_tmp2_ = i;
				_tmp3_ = self->priv->tweets;
				_tmp4_ = g_ptr_array_get_length (_tmp3_);
				_tmp5_ = _tmp4_;
				if (!(_tmp2_ < _tmp5_)) {
					break;
				}
				_tmp6_ = self->priv->tweets;
				_tmp7_ = i;
				_tmp8_ = g_ptr_array_index (_tmp6_, (guint) _tmp7_);
				_tmp9_ = _g_object_ref0 ((CbTweet*) _tmp8_);
				tweet = _tmp9_;
				_tmp11_ = tweet;
				_tmp12_ = _tmp11_->retweeted_tweet;
				if (_tmp12_ != NULL) {
					CbTweet* _tmp13_ = NULL;
					CbMiniTweet _tmp14_ = {0};
					CbUserIdentity _tmp15_ = {0};
					gint64 _tmp16_ = 0LL;
					gint64 _tmp17_ = 0LL;
					_tmp13_ = tweet;
					_tmp14_ = _tmp13_->source_tweet;
					_tmp15_ = _tmp14_.author;
					_tmp16_ = _tmp15_.id;
					_tmp17_ = user_id;
					_tmp10_ = _tmp16_ == _tmp17_;
				} else {
					_tmp10_ = FALSE;
				}
				if (_tmp10_) {
					gboolean _tmp18_ = FALSE;
					_tmp18_ = active;
					if (_tmp18_) {
						CbTweet* _tmp19_ = NULL;
						CbTweetState _tmp20_ = 0;
						gboolean _tmp21_ = FALSE;
						_tmp19_ = tweet;
						_tmp20_ = reason;
						_tmp21_ = tweet_model_set_tweet_flag (self, _tmp19_, _tmp20_);
						if (_tmp21_) {
							gint _tmp22_ = 0;
							_tmp22_ = i;
							i = _tmp22_ - 1;
						}
					} else {
						CbTweet* _tmp23_ = NULL;
						CbTweetState _tmp24_ = 0;
						gboolean _tmp25_ = FALSE;
						_tmp23_ = tweet;
						_tmp24_ = reason;
						_tmp25_ = tweet_model_unset_tweet_flag (self, _tmp23_, _tmp24_);
						if (_tmp25_) {
							gint _tmp26_ = 0;
							_tmp26_ = i;
							i = _tmp26_ - 1;
						}
					}
				}
				_g_object_unref0 (tweet);
			}
		}
	}
	{
		gint i = 0;
		i = 0;
		{
			gboolean _tmp27_ = FALSE;
			_tmp27_ = TRUE;
			while (TRUE) {
				gint _tmp29_ = 0;
				GPtrArray* _tmp30_ = NULL;
				gint _tmp31_ = 0;
				gint _tmp32_ = 0;
				CbTweet* tweet = NULL;
				GPtrArray* _tmp33_ = NULL;
				gint _tmp34_ = 0;
				gconstpointer _tmp35_ = NULL;
				CbTweet* _tmp36_ = NULL;
				gboolean _tmp37_ = FALSE;
				CbTweet* _tmp38_ = NULL;
				CbMiniTweet* _tmp39_ = NULL;
				if (!_tmp27_) {
					gint _tmp28_ = 0;
					_tmp28_ = i;
					i = _tmp28_ + 1;
				}
				_tmp27_ = FALSE;
				_tmp29_ = i;
				_tmp30_ = self->hidden_tweets;
				_tmp31_ = g_ptr_array_get_length (_tmp30_);
				_tmp32_ = _tmp31_;
				if (!(_tmp29_ < _tmp32_)) {
					break;
				}
				_tmp33_ = self->hidden_tweets;
				_tmp34_ = i;
				_tmp35_ = g_ptr_array_index (_tmp33_, (guint) _tmp34_);
				_tmp36_ = _g_object_ref0 ((CbTweet*) _tmp35_);
				tweet = _tmp36_;
				_tmp38_ = tweet;
				_tmp39_ = _tmp38_->retweeted_tweet;
				if (_tmp39_ != NULL) {
					CbTweet* _tmp40_ = NULL;
					CbMiniTweet _tmp41_ = {0};
					CbUserIdentity _tmp42_ = {0};
					gint64 _tmp43_ = 0LL;
					gint64 _tmp44_ = 0LL;
					_tmp40_ = tweet;
					_tmp41_ = _tmp40_->source_tweet;
					_tmp42_ = _tmp41_.author;
					_tmp43_ = _tmp42_.id;
					_tmp44_ = user_id;
					_tmp37_ = _tmp43_ == _tmp44_;
				} else {
					_tmp37_ = FALSE;
				}
				if (_tmp37_) {
					gboolean _tmp45_ = FALSE;
					_tmp45_ = active;
					if (_tmp45_) {
						CbTweet* _tmp46_ = NULL;
						CbTweetState _tmp47_ = 0;
						gboolean _tmp48_ = FALSE;
						_tmp46_ = tweet;
						_tmp47_ = reason;
						_tmp48_ = tweet_model_set_tweet_flag (self, _tmp46_, _tmp47_);
						if (_tmp48_) {
							gint _tmp49_ = 0;
							_tmp49_ = i;
							i = _tmp49_ - 1;
						}
					} else {
						CbTweet* _tmp50_ = NULL;
						CbTweetState _tmp51_ = 0;
						gboolean _tmp52_ = FALSE;
						_tmp50_ = tweet;
						_tmp51_ = reason;
						_tmp52_ = tweet_model_unset_tweet_flag (self, _tmp50_, _tmp51_);
						if (_tmp52_) {
							gint _tmp53_ = 0;
							_tmp53_ = i;
							i = _tmp53_ - 1;
						}
					}
				}
				_g_object_unref0 (tweet);
			}
		}
	}
}


gboolean tweet_model_contains_id (TweetModel* self, gint64 tweet_id) {
	gboolean result = FALSE;
	g_return_val_if_fail (IS_TWEET_MODEL (self), FALSE);
	{
		gint i = 0;
		i = 0;
		{
			gboolean _tmp0_ = FALSE;
			_tmp0_ = TRUE;
			while (TRUE) {
				gint _tmp2_ = 0;
				GPtrArray* _tmp3_ = NULL;
				gint _tmp4_ = 0;
				gint _tmp5_ = 0;
				CbTweet* tweet = NULL;
				GPtrArray* _tmp6_ = NULL;
				gint _tmp7_ = 0;
				gconstpointer _tmp8_ = NULL;
				CbTweet* _tmp9_ = NULL;
				CbTweet* _tmp10_ = NULL;
				gint64 _tmp11_ = 0LL;
				gint64 _tmp12_ = 0LL;
				if (!_tmp0_) {
					gint _tmp1_ = 0;
					_tmp1_ = i;
					i = _tmp1_ + 1;
				}
				_tmp0_ = FALSE;
				_tmp2_ = i;
				_tmp3_ = self->priv->tweets;
				_tmp4_ = g_ptr_array_get_length (_tmp3_);
				_tmp5_ = _tmp4_;
				if (!(_tmp2_ < _tmp5_)) {
					break;
				}
				_tmp6_ = self->priv->tweets;
				_tmp7_ = i;
				_tmp8_ = g_ptr_array_index (_tmp6_, (guint) _tmp7_);
				_tmp9_ = _g_object_ref0 ((CbTweet*) _tmp8_);
				tweet = _tmp9_;
				_tmp10_ = tweet;
				_tmp11_ = _tmp10_->id;
				_tmp12_ = tweet_id;
				if (_tmp11_ == _tmp12_) {
					result = TRUE;
					_g_object_unref0 (tweet);
					return result;
				}
				_g_object_unref0 (tweet);
			}
		}
	}
	result = FALSE;
	return result;
}


void tweet_model_remove_tweets_above (TweetModel* self, gint64 id) {
	g_return_if_fail (IS_TWEET_MODEL (self));
	while (TRUE) {
		gboolean _tmp0_ = FALSE;
		GPtrArray* _tmp1_ = NULL;
		gint _tmp2_ = 0;
		gint _tmp3_ = 0;
		_tmp1_ = self->priv->tweets;
		_tmp2_ = g_ptr_array_get_length (_tmp1_);
		_tmp3_ = _tmp2_;
		if (_tmp3_ > 0) {
			GPtrArray* _tmp4_ = NULL;
			gconstpointer _tmp5_ = NULL;
			gint64 _tmp6_ = 0LL;
			gint64 _tmp7_ = 0LL;
			_tmp4_ = self->priv->tweets;
			_tmp5_ = g_ptr_array_index (_tmp4_, (guint) 0);
			_tmp6_ = ((CbTweet*) _tmp5_)->id;
			_tmp7_ = id;
			_tmp0_ = _tmp6_ >= _tmp7_;
		} else {
			_tmp0_ = FALSE;
		}
		if (!_tmp0_) {
			break;
		}
		tweet_model_remove_at_pos (self, 0);
		g_list_model_items_changed (G_TYPE_CHECK_INSTANCE_CAST (self, g_list_model_get_type (), GListModel), (guint) 0, (guint) 1, (guint) 0);
	}
}


CbTweet* tweet_model_get_from_id (TweetModel* self, gint64 id, gint diff) {
	CbTweet* result = NULL;
	g_return_val_if_fail (IS_TWEET_MODEL (self), NULL);
	{
		gint i = 0;
		i = 0;
		{
			gboolean _tmp0_ = FALSE;
			_tmp0_ = TRUE;
			while (TRUE) {
				gint _tmp2_ = 0;
				GPtrArray* _tmp3_ = NULL;
				gint _tmp4_ = 0;
				gint _tmp5_ = 0;
				GPtrArray* _tmp6_ = NULL;
				gint _tmp7_ = 0;
				gconstpointer _tmp8_ = NULL;
				gint64 _tmp9_ = 0LL;
				gint64 _tmp10_ = 0LL;
				if (!_tmp0_) {
					gint _tmp1_ = 0;
					_tmp1_ = i;
					i = _tmp1_ + 1;
				}
				_tmp0_ = FALSE;
				_tmp2_ = i;
				_tmp3_ = self->priv->tweets;
				_tmp4_ = g_ptr_array_get_length (_tmp3_);
				_tmp5_ = _tmp4_;
				if (!(_tmp2_ < _tmp5_)) {
					break;
				}
				_tmp6_ = self->priv->tweets;
				_tmp7_ = i;
				_tmp8_ = g_ptr_array_index (_tmp6_, (guint) _tmp7_);
				_tmp9_ = ((CbTweet*) _tmp8_)->id;
				_tmp10_ = id;
				if (_tmp9_ == _tmp10_) {
					gboolean _tmp11_ = FALSE;
					gint _tmp12_ = 0;
					gint _tmp13_ = 0;
					GPtrArray* _tmp14_ = NULL;
					gint _tmp15_ = 0;
					gint _tmp16_ = 0;
					_tmp12_ = i;
					_tmp13_ = diff;
					_tmp14_ = self->priv->tweets;
					_tmp15_ = g_ptr_array_get_length (_tmp14_);
					_tmp16_ = _tmp15_;
					if ((_tmp12_ + _tmp13_) < _tmp16_) {
						gint _tmp17_ = 0;
						gint _tmp18_ = 0;
						_tmp17_ = i;
						_tmp18_ = diff;
						_tmp11_ = (_tmp17_ + _tmp18_) >= 0;
					} else {
						_tmp11_ = FALSE;
					}
					if (_tmp11_) {
						GPtrArray* _tmp19_ = NULL;
						gint _tmp20_ = 0;
						gint _tmp21_ = 0;
						gconstpointer _tmp22_ = NULL;
						CbTweet* _tmp23_ = NULL;
						_tmp19_ = self->priv->tweets;
						_tmp20_ = i;
						_tmp21_ = diff;
						_tmp22_ = g_ptr_array_index (_tmp19_, (guint) (_tmp20_ + _tmp21_));
						_tmp23_ = _g_object_ref0 ((CbTweet*) _tmp22_);
						result = _tmp23_;
						return result;
					}
					result = NULL;
					return result;
				}
			}
		}
	}
	result = NULL;
	return result;
}


gboolean tweet_model_delete_id (TweetModel* self, gint64 id, gboolean* seen) {
	gboolean _vala_seen = FALSE;
	gboolean result = FALSE;
	g_return_val_if_fail (IS_TWEET_MODEL (self), FALSE);
	{
		gint i = 0;
		i = 0;
		{
			gboolean _tmp0_ = FALSE;
			_tmp0_ = TRUE;
			while (TRUE) {
				gint _tmp2_ = 0;
				GPtrArray* _tmp3_ = NULL;
				gint _tmp4_ = 0;
				gint _tmp5_ = 0;
				CbTweet* t = NULL;
				GPtrArray* _tmp6_ = NULL;
				gint _tmp7_ = 0;
				gconstpointer _tmp8_ = NULL;
				CbTweet* _tmp9_ = NULL;
				CbTweet* _tmp10_ = NULL;
				gint64 _tmp11_ = 0LL;
				gint64 _tmp12_ = 0LL;
				if (!_tmp0_) {
					gint _tmp1_ = 0;
					_tmp1_ = i;
					i = _tmp1_ + 1;
				}
				_tmp0_ = FALSE;
				_tmp2_ = i;
				_tmp3_ = self->priv->tweets;
				_tmp4_ = g_ptr_array_get_length (_tmp3_);
				_tmp5_ = _tmp4_;
				if (!(_tmp2_ < _tmp5_)) {
					break;
				}
				_tmp6_ = self->priv->tweets;
				_tmp7_ = i;
				_tmp8_ = g_ptr_array_index (_tmp6_, (guint) _tmp7_);
				_tmp9_ = _g_object_ref0 ((CbTweet*) _tmp8_);
				t = _tmp9_;
				_tmp10_ = t;
				_tmp11_ = _tmp10_->id;
				_tmp12_ = id;
				if (_tmp11_ == _tmp12_) {
					CbTweet* _tmp13_ = NULL;
					gboolean _tmp14_ = FALSE;
					CbTweet* _tmp15_ = NULL;
					gboolean _tmp16_ = FALSE;
					_tmp13_ = t;
					_tmp14_ = cb_tweet_get_seen (_tmp13_);
					_vala_seen = _tmp14_;
					_tmp15_ = t;
					_tmp16_ = cb_tweet_is_hidden (_tmp15_);
					if (_tmp16_) {
						CbTweet* _tmp17_ = NULL;
						_tmp17_ = t;
						tweet_model_remove_tweet (self, _tmp17_);
					} else {
						CbTweet* _tmp18_ = NULL;
						_tmp18_ = t;
						cb_tweet_set_flag (_tmp18_, (guint) CB_TWEET_STATE_DELETED);
					}
					result = TRUE;
					_g_object_unref0 (t);
					if (seen) {
						*seen = _vala_seen;
					}
					return result;
				} else {
					gboolean _tmp19_ = FALSE;
					CbTweet* _tmp20_ = NULL;
					gboolean _tmp21_ = FALSE;
					_tmp20_ = t;
					_tmp21_ = cb_tweet_is_flag_set (_tmp20_, (guint) CB_TWEET_STATE_RETWEETED);
					if (_tmp21_) {
						CbTweet* _tmp22_ = NULL;
						gint64 _tmp23_ = 0LL;
						gint64 _tmp24_ = 0LL;
						_tmp22_ = t;
						_tmp23_ = _tmp22_->my_retweet;
						_tmp24_ = id;
						_tmp19_ = _tmp23_ == _tmp24_;
					} else {
						_tmp19_ = FALSE;
					}
					if (_tmp19_) {
						CbTweet* _tmp25_ = NULL;
						_tmp25_ = t;
						cb_tweet_unset_flag (_tmp25_, (guint) CB_TWEET_STATE_RETWEETED);
					}
				}
				_g_object_unref0 (t);
			}
		}
	}
	_vala_seen = FALSE;
	result = FALSE;
	if (seen) {
		*seen = _vala_seen;
	}
	return result;
}


TweetModel* tweet_model_construct (GType object_type) {
	TweetModel * self = NULL;
	self = (TweetModel*) g_object_new (object_type, NULL);
	return self;
}


TweetModel* tweet_model_new (void) {
	return tweet_model_construct (TYPE_TWEET_MODEL);
}


gint64 tweet_model_get_lowest_id (TweetModel* self) {
	gint64 result;
	gint64 _tmp0_ = 0LL;
	g_return_val_if_fail (IS_TWEET_MODEL (self), 0LL);
	_tmp0_ = self->priv->min_id;
	result = _tmp0_;
	return result;
}


gint64 tweet_model_get_greatest_id (TweetModel* self) {
	gint64 result;
	gint64 _tmp0_ = 0LL;
	g_return_val_if_fail (IS_TWEET_MODEL (self), 0LL);
	_tmp0_ = self->priv->max_id;
	result = _tmp0_;
	return result;
}


static void tweet_model_class_init (TweetModelClass * klass) {
	tweet_model_parent_class = g_type_class_peek_parent (klass);
	g_type_class_add_private (klass, sizeof (TweetModelPrivate));
	G_OBJECT_CLASS (klass)->get_property = _vala_tweet_model_get_property;
	G_OBJECT_CLASS (klass)->finalize = tweet_model_finalize;
	g_object_class_install_property (G_OBJECT_CLASS (klass), TWEET_MODEL_LOWEST_ID, g_param_spec_int64 ("lowest-id", "lowest-id", "lowest-id", G_MININT64, G_MAXINT64, 0, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), TWEET_MODEL_GREATEST_ID, g_param_spec_int64 ("greatest-id", "greatest-id", "greatest-id", G_MININT64, G_MAXINT64, 0, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE));
}


static void tweet_model_g_list_model_interface_init (GListModelInterface * iface) {
	tweet_model_g_list_model_parent_iface = g_type_interface_peek_parent (iface);
	iface->get_item_type = (GType (*)(GListModel*)) tweet_model_real_get_item_type;
	iface->get_item = (GObject* (*)(GListModel*, guint)) tweet_model_real_get_item;
	iface->get_n_items = (guint (*)(GListModel*)) tweet_model_real_get_n_items;
}


static void tweet_model_instance_init (TweetModel * self) {
	GPtrArray* _tmp0_ = NULL;
	GPtrArray* _tmp1_ = NULL;
	self->priv = TWEET_MODEL_GET_PRIVATE (self);
	_tmp0_ = g_ptr_array_new_full ((guint) 0, _g_object_unref0_);
	self->priv->tweets = _tmp0_;
	_tmp1_ = g_ptr_array_new_full ((guint) 0, _g_object_unref0_);
	self->hidden_tweets = _tmp1_;
	self->priv->min_id = G_MAXINT64;
	self->priv->max_id = G_MININT64;
}


static void tweet_model_finalize (GObject* obj) {
	TweetModel * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, TYPE_TWEET_MODEL, TweetModel);
	_g_ptr_array_unref0 (self->priv->tweets);
	_g_ptr_array_unref0 (self->hidden_tweets);
	G_OBJECT_CLASS (tweet_model_parent_class)->finalize (obj);
}


GType tweet_model_get_type (void) {
	static volatile gsize tweet_model_type_id__volatile = 0;
	if (g_once_init_enter (&tweet_model_type_id__volatile)) {
		static const GTypeInfo g_define_type_info = { sizeof (TweetModelClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) tweet_model_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (TweetModel), 0, (GInstanceInitFunc) tweet_model_instance_init, NULL };
		static const GInterfaceInfo g_list_model_info = { (GInterfaceInitFunc) tweet_model_g_list_model_interface_init, (GInterfaceFinalizeFunc) NULL, NULL};
		GType tweet_model_type_id;
		tweet_model_type_id = g_type_register_static (G_TYPE_OBJECT, "TweetModel", &g_define_type_info, 0);
		g_type_add_interface_static (tweet_model_type_id, g_list_model_get_type (), &g_list_model_info);
		g_once_init_leave (&tweet_model_type_id__volatile, tweet_model_type_id);
	}
	return tweet_model_type_id__volatile;
}


static void _vala_tweet_model_get_property (GObject * object, guint property_id, GValue * value, GParamSpec * pspec) {
	TweetModel * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, TYPE_TWEET_MODEL, TweetModel);
	switch (property_id) {
		case TWEET_MODEL_LOWEST_ID:
		g_value_set_int64 (value, tweet_model_get_lowest_id (self));
		break;
		case TWEET_MODEL_GREATEST_ID:
		g_value_set_int64 (value, tweet_model_get_greatest_id (self));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}



