; NOTE: Assertions have been autogenerated by utils/update_llc_test_checks.py
; RUN: llc < %s -mtriple=x86_64-unknown-unknown -mcpu=znver4 | FileCheck %s --check-prefixes=CHECK,AVX512VL-VNNI
; RUN: llc < %s -mtriple=x86_64-unknown-unknown -mcpu=znver5 | FileCheck %s --check-prefixes=CHECK,AVX-VNNI
; RUN: llc < %s -mtriple=x86_64-unknown-unknown -mattr=+avx512vnni,+fast-dpwssd | FileCheck %s --check-prefixes=CHECK,AVX512-VNNI
; RUN: llc < %s -mtriple=x86_64-unknown-unknown -mattr=+avx512vnni,+avx512vl,+fast-dpwssd | FileCheck %s --check-prefixes=CHECK,AVX512VL-VNNI

define <16 x i32> @vpdpwssd_test(<16 x i32> %0, <16 x i32> %1, <16 x i32> %2) {
; CHECK-LABEL: vpdpwssd_test:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vpdpwssd %zmm2, %zmm1, %zmm0
; CHECK-NEXT:    retq
  %4 = tail call <16 x i32> @llvm.x86.avx512.vpdpwssd.512(<16 x i32> %0, <16 x i32> %1, <16 x i32> %2)
  ret <16 x i32> %4
}

define <16 x i32> @vpdpwssd_v16i32_accumulate(<32 x i16> %a0, <32 x i16> %a1, <16 x i32> %a2) {
; CHECK-LABEL: vpdpwssd_v16i32_accumulate:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vpdpwssd %zmm1, %zmm0, %zmm2
; CHECK-NEXT:    vmovdqa64 %zmm2, %zmm0
; CHECK-NEXT:    retq
  %x0 = sext <32 x i16> %a0 to <32 x i32>
  %x1 = sext <32 x i16> %a1 to <32 x i32>
  %m = mul nsw <32 x i32> %x0, %x1
  %lo = shufflevector <32 x i32> %m, <32 x i32> poison, <16 x i32> <i32 0, i32 2, i32 4, i32 6, i32 8, i32 10, i32 12, i32 14, i32 16, i32 18, i32 20, i32 22, i32 24, i32 26, i32 28, i32 30>
  %hi = shufflevector <32 x i32> %m, <32 x i32> poison, <16 x i32> <i32 1, i32 3, i32 5, i32 7, i32 9, i32 11, i32 13, i32 15, i32 17, i32 19, i32 21, i32 23, i32 25, i32 27, i32 29, i32 31>
  %r0 = add <16 x i32> %lo, %a2
  %r1 = add <16 x i32> %r0, %hi
  ret <16 x i32> %r1
}

define <8 x i32> @vpdpwssd_v8i32_accumulate(<16 x i16> %a0, <16 x i16> %a1, <8 x i32> %a2) {
; AVX512VL-VNNI-LABEL: vpdpwssd_v8i32_accumulate:
; AVX512VL-VNNI:       # %bb.0:
; AVX512VL-VNNI-NEXT:    vpdpwssd %ymm1, %ymm0, %ymm2
; AVX512VL-VNNI-NEXT:    vmovdqa %ymm2, %ymm0
; AVX512VL-VNNI-NEXT:    retq
;
; AVX-VNNI-LABEL: vpdpwssd_v8i32_accumulate:
; AVX-VNNI:       # %bb.0:
; AVX-VNNI-NEXT:    {vex} vpdpwssd %ymm1, %ymm0, %ymm2
; AVX-VNNI-NEXT:    vmovdqa %ymm2, %ymm0
; AVX-VNNI-NEXT:    retq
;
; AVX512-VNNI-LABEL: vpdpwssd_v8i32_accumulate:
; AVX512-VNNI:       # %bb.0:
; AVX512-VNNI-NEXT:    vpmaddwd %ymm1, %ymm0, %ymm0
; AVX512-VNNI-NEXT:    vpaddd %ymm2, %ymm0, %ymm0
; AVX512-VNNI-NEXT:    retq
  %x0 = sext <16 x i16> %a0 to <16 x i32>
  %x1 = sext <16 x i16> %a1 to <16 x i32>
  %m = mul nsw <16 x i32> %x0, %x1
  %lo = shufflevector <16 x i32> %m, <16 x i32> poison, <8 x i32> <i32 0, i32 2, i32 4, i32 6, i32 8, i32 10, i32 12, i32 14>
  %hi = shufflevector <16 x i32> %m, <16 x i32> poison, <8 x i32> <i32 1, i32 3, i32 5, i32 7, i32 9, i32 11, i32 13, i32 15>
  %r0 = add <8 x i32> %hi, %a2
  %r1 = add <8 x i32> %lo, %r0
  ret <8 x i32> %r1
}

define <4 x i32> @vpdpwssd_v4i32_accumulate(<8 x i16> %a0, <8 x i16> %a1, <4 x i32> %a2) {
; AVX512VL-VNNI-LABEL: vpdpwssd_v4i32_accumulate:
; AVX512VL-VNNI:       # %bb.0:
; AVX512VL-VNNI-NEXT:    vpdpwssd %xmm1, %xmm0, %xmm2
; AVX512VL-VNNI-NEXT:    vmovdqa %xmm2, %xmm0
; AVX512VL-VNNI-NEXT:    retq
;
; AVX-VNNI-LABEL: vpdpwssd_v4i32_accumulate:
; AVX-VNNI:       # %bb.0:
; AVX-VNNI-NEXT:    {vex} vpdpwssd %xmm1, %xmm0, %xmm2
; AVX-VNNI-NEXT:    vmovdqa %xmm2, %xmm0
; AVX-VNNI-NEXT:    retq
;
; AVX512-VNNI-LABEL: vpdpwssd_v4i32_accumulate:
; AVX512-VNNI:       # %bb.0:
; AVX512-VNNI-NEXT:    vpmaddwd %xmm1, %xmm0, %xmm0
; AVX512-VNNI-NEXT:    vpaddd %xmm2, %xmm0, %xmm0
; AVX512-VNNI-NEXT:    retq
  %x0 = sext <8 x i16> %a0 to <8 x i32>
  %x1 = sext <8 x i16> %a1 to <8 x i32>
  %m = mul nsw <8 x i32> %x0, %x1
  %lo = shufflevector <8 x i32> %m, <8 x i32> poison, <4 x i32> <i32 0, i32 2, i32 4, i32 6>
  %hi = shufflevector <8 x i32> %m, <8 x i32> poison, <4 x i32> <i32 1, i32 3, i32 5, i32 7>
  %r0 = add <4 x i32> %lo, %a2
  %r1 = add <4 x i32> %hi, %r0
  ret <4 x i32> %r1
}
