/*   -*- buffer-read-only: t -*- vi: set ro:
 *
 *  DO NOT EDIT THIS FILE   (opts.h)
 *
 *  It has been AutoGen-ed
 *  From the definitions    /usr/src/ports/autogen/autogen-5.18.16-1.x86_64/src/autogen-5.18.16/getdefs/opts.def
 *  and the template file   options
 *
 * Generated from AutoOpts 42:1:17 templates.
 *
 *  AutoOpts is a copyrighted work.  This header file is not encumbered
 *  by AutoOpts licensing, but is provided under the licensing terms chosen
 *  by the getdefs author or copyright holder.  AutoOpts is
 *  licensed under the terms of the LGPL.  The redistributable library
 *  (``libopts'') is licensed under the terms of either the LGPL or, at the
 *  users discretion, the BSD license.  See the AutoOpts and/or libopts sources
 *  for details.
 *
 * The getdefs program is copyrighted and licensed
 * under the following terms:
 *
 *  Copyright (C) 1999-2018 Bruce Korb, all rights reserved.
 *  This is free software. It is licensed for use, modification and
 *  redistribution under the terms of the GNU General Public License,
 *  version 3 or later <http://gnu.org/licenses/gpl.html>
 *
 *  getdefs is free software: you can redistribute it and/or modify it
 *  under the terms of the GNU General Public License as published by the
 *  Free Software Foundation, either version 3 of the License, or
 *  (at your option) any later version.
 *
 *  getdefs is distributed in the hope that it will be useful, but
 *  WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
 *  See the GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License along
 *  with this program.  If not, see <http://www.gnu.org/licenses/>.
 */
/** \file opts.h
 *  \addtogroup getdefs
 *  @{
 */
/**
 *  This file contains the programmatic interface to the Automated
 *  Options generated for the getdefs program.
 *  These macros are documented in the AutoGen info file in the
 *  "AutoOpts" chapter.  Please refer to that doc for usage help.
 */
#ifndef AUTOOPTS_OPTS_H_GUARD
#define AUTOOPTS_OPTS_H_GUARD 1
#include <autoopts/options.h>
#include <stdarg.h>
#include <stdnoreturn.h>

/**
 *  Ensure that the library used for compiling this generated header is at
 *  least as new as the version current when the header template was released
 *  (not counting patch version increments).  Also ensure that the oldest
 *  tolerable version is at least as old as what was current when the header
 *  template was released.
 */
#define AO_TEMPLATE_VERSION 172033
#if (AO_TEMPLATE_VERSION < OPTIONS_MINIMUM_VERSION) \
 || (AO_TEMPLATE_VERSION > OPTIONS_STRUCT_VERSION)
# error option template version mismatches autoopts/options.h header
  Choke Me.
#endif

#if GCC_VERSION > 40400
#define NOT_REACHED __builtin_unreachable();
#else
#define NOT_REACHED
#endif

/**
 *  Enumeration of each option type for getdefs
 */
typedef enum {
    INDEX_OPT_DEFS_TO_GET    =  1,
    INDEX_OPT_SUBBLOCK       =  2,
    INDEX_OPT_LISTATTR       =  3,
    INDEX_OPT_ORDERING       =  5,
    INDEX_OPT_FIRST_INDEX    =  6,
    INDEX_OPT_FILELIST       =  8,
    INDEX_OPT_ASSIGN         =  9,
    INDEX_OPT_COMMON_ASSIGN  = 10,
    INDEX_OPT_COPY           = 11,
    INDEX_OPT_SRCFILE        = 12,
    INDEX_OPT_LINENUM        = 13,
    INDEX_OPT_INPUT          = 15,
    INDEX_OPT_OUTPUT         = 17,
    INDEX_OPT_AUTOGEN        = 18,
    INDEX_OPT_TEMPLATE       = 19,
    INDEX_OPT_AGARG          = 20,
    INDEX_OPT_BASE_NAME      = 21,
    INDEX_OPT_VERSION        = 22,
    INDEX_OPT_HELP           = 23,
    INDEX_OPT_MORE_HELP      = 24,
    INDEX_OPT_SAVE_OPTS      = 25,
    INDEX_OPT_LOAD_OPTS      = 26
} teOptIndex;
/** count of all options for getdefs */
#define OPTION_CT    27
/** getdefs version */
#define GETDEFS_VERSION       "1.5"
/** Full getdefs version text */
#define GETDEFS_FULL_VERSION  "getdefs (GNU AutoGen) 1.5"

/**
 *  Interface defines for all options.  Replace "n" with the UPPER_CASED
 *  option name (as in the teOptIndex enumeration above).
 *  e.g. HAVE_OPT(DEF_SELECTION)
 */
#define         DESC(n) (getdefsOptions.pOptDesc[INDEX_OPT_## n])
/** 'true' if an option has been specified in any way */
#define     HAVE_OPT(n) (! UNUSED_OPT(& DESC(n)))
/** The string argument to an option. The argument type must be \"string\". */
#define      OPT_ARG(n) (DESC(n).optArg.argString)
/** Mask the option state revealing how an option was specified.
 *  It will be one and only one of \a OPTST_SET, \a OPTST_PRESET,
 * \a OPTST_DEFINED, \a OPTST_RESET or zero.
 */
#define    STATE_OPT(n) (DESC(n).fOptState & OPTST_SET_MASK)
/** Count of option's occurrances *on the command line*. */
#define    COUNT_OPT(n) (DESC(n).optOccCt)
/** mask of \a OPTST_SET and \a OPTST_DEFINED. */
#define    ISSEL_OPT(n) (SELECTED_OPT(&DESC(n)))
/** 'true' if \a HAVE_OPT would yield 'false'. */
#define ISUNUSED_OPT(n) (UNUSED_OPT(& DESC(n)))
/** 'true' if OPTST_DISABLED bit not set. */
#define  ENABLED_OPT(n) (! DISABLED_OPT(& DESC(n)))
/** number of stacked option arguments.
 *  Valid only for stacked option arguments. */
#define  STACKCT_OPT(n) (((tArgList*)(DESC(n).optCookie))->useCt)
/** stacked argument vector.
 *  Valid only for stacked option arguments. */
#define STACKLST_OPT(n) (((tArgList*)(DESC(n).optCookie))->apzArgs)
/** Reset an option. */
#define    CLEAR_OPT(n) STMTS( \
                DESC(n).fOptState &= OPTST_PERSISTENT_MASK;   \
                if ((DESC(n).fOptState & OPTST_INITENABLED) == 0) \
                    DESC(n).fOptState |= OPTST_DISABLED; \
                DESC(n).optCookie = NULL )
/* * * * * * * * * * * * * * * * * * * * * * * * * * * * * * */
/**
 *  Enumeration of getdefs exit codes
 */
typedef enum {
    GETDEFS_EXIT_SUCCESS         = 0,
    GETDEFS_EXIT_FAILURE         = 1,
    GETDEFS_EXIT_INVALID_INPUT   = 2,
    GETDEFS_EXIT_NO_MEM          = 3,
    GETDEFS_EXIT_USAGE_ERROR     = 64,
    GETDEFS_EXIT_NO_CONFIG_INPUT = 66,
    GETDEFS_EXIT_LIBOPTS_FAILURE = 70
}   getdefs_exit_code_t;
/** @} */
/**
 *  Make sure there are no #define name conflicts with the option names
 */
#ifndef     NO_OPTION_NAME_WARNINGS
# ifdef    DEF_SELECTION
#  warning undefining DEF_SELECTION due to option name conflict
#  undef   DEF_SELECTION
# endif
# ifdef    DEFS_TO_GET
#  warning undefining DEFS_TO_GET due to option name conflict
#  undef   DEFS_TO_GET
# endif
# ifdef    SUBBLOCK
#  warning undefining SUBBLOCK due to option name conflict
#  undef   SUBBLOCK
# endif
# ifdef    LISTATTR
#  warning undefining LISTATTR due to option name conflict
#  undef   LISTATTR
# endif
# ifdef    ENUMERATING
#  warning undefining ENUMERATING due to option name conflict
#  undef   ENUMERATING
# endif
# ifdef    ORDERING
#  warning undefining ORDERING due to option name conflict
#  undef   ORDERING
# endif
# ifdef    FIRST_INDEX
#  warning undefining FIRST_INDEX due to option name conflict
#  undef   FIRST_INDEX
# endif
# ifdef    DOC_INSERT
#  warning undefining DOC_INSERT due to option name conflict
#  undef   DOC_INSERT
# endif
# ifdef    FILELIST
#  warning undefining FILELIST due to option name conflict
#  undef   FILELIST
# endif
# ifdef    ASSIGN
#  warning undefining ASSIGN due to option name conflict
#  undef   ASSIGN
# endif
# ifdef    COMMON_ASSIGN
#  warning undefining COMMON_ASSIGN due to option name conflict
#  undef   COMMON_ASSIGN
# endif
# ifdef    COPY
#  warning undefining COPY due to option name conflict
#  undef   COPY
# endif
# ifdef    SRCFILE
#  warning undefining SRCFILE due to option name conflict
#  undef   SRCFILE
# endif
# ifdef    LINENUM
#  warning undefining LINENUM due to option name conflict
#  undef   LINENUM
# endif
# ifdef    INPUT_FILES
#  warning undefining INPUT_FILES due to option name conflict
#  undef   INPUT_FILES
# endif
# ifdef    INPUT
#  warning undefining INPUT due to option name conflict
#  undef   INPUT
# endif
# ifdef    DOC_OUTPUT
#  warning undefining DOC_OUTPUT due to option name conflict
#  undef   DOC_OUTPUT
# endif
# ifdef    OUTPUT
#  warning undefining OUTPUT due to option name conflict
#  undef   OUTPUT
# endif
# ifdef    AUTOGEN
#  warning undefining AUTOGEN due to option name conflict
#  undef   AUTOGEN
# endif
# ifdef    TEMPLATE
#  warning undefining TEMPLATE due to option name conflict
#  undef   TEMPLATE
# endif
# ifdef    AGARG
#  warning undefining AGARG due to option name conflict
#  undef   AGARG
# endif
# ifdef    BASE_NAME
#  warning undefining BASE_NAME due to option name conflict
#  undef   BASE_NAME
# endif
#else  /* NO_OPTION_NAME_WARNINGS */
# undef DEF_SELECTION
# undef DEFS_TO_GET
# undef SUBBLOCK
# undef LISTATTR
# undef ENUMERATING
# undef ORDERING
# undef FIRST_INDEX
# undef DOC_INSERT
# undef FILELIST
# undef ASSIGN
# undef COMMON_ASSIGN
# undef COPY
# undef SRCFILE
# undef LINENUM
# undef INPUT_FILES
# undef INPUT
# undef DOC_OUTPUT
# undef OUTPUT
# undef AUTOGEN
# undef TEMPLATE
# undef AGARG
# undef BASE_NAME
#endif  /*  NO_OPTION_NAME_WARNINGS */

/**
 *  Interface defines for specific options.
 * @{
 */
#define VALUE_OPT_DEFS_TO_GET    0x1001
#define VALUE_OPT_SUBBLOCK       0x1002
#define VALUE_OPT_LISTATTR       0x1003
#define VALUE_OPT_ORDERING       0x1004
#define VALUE_OPT_FIRST_INDEX    0x1005

#define OPT_VALUE_FIRST_INDEX    (DESC(FIRST_INDEX).optArg.argInt)
#define VALUE_OPT_FILELIST       0x1006
#define VALUE_OPT_ASSIGN         0x1007
#define VALUE_OPT_COMMON_ASSIGN  0x1008
#define VALUE_OPT_COPY           0x1009
#define VALUE_OPT_SRCFILE        0x100A
#define VALUE_OPT_LINENUM        0x100B
#define VALUE_OPT_INPUT          0x100C

#define SET_OPT_INPUT(a)   STMTS( \
        DESC(INPUT).optActualIndex = 15; \
        DESC(INPUT).optActualValue = VALUE_OPT_INPUT; \
        DESC(INPUT).fOptState &= OPTST_PERSISTENT_MASK; \
        DESC(INPUT).fOptState |= OPTST_SET; \
        DESC(INPUT).optArg.argString = (a); \
        (*(DESC(INPUT).pOptProc))(&getdefsOptions, \
                getdefsOptions.pOptDesc + 15); )
#define VALUE_OPT_OUTPUT         0x100D
#define VALUE_OPT_AUTOGEN        0x100E

/** Define the option value autogen is equivalenced to */
#define WHICH_OPT_AUTOGEN        (DESC(AUTOGEN).optActualValue)
/** Define the index of the option autogen is equivalenced to */
#define WHICH_IDX_AUTOGEN        (DESC(AUTOGEN).optActualIndex)
#define VALUE_OPT_TEMPLATE       0x100F

#define SET_OPT_TEMPLATE(a)   STMTS( \
        DESC(TEMPLATE).optActualIndex = 19; \
        DESC(TEMPLATE).optActualValue = VALUE_OPT_TEMPLATE; \
        DESC(TEMPLATE).fOptState &= OPTST_PERSISTENT_MASK; \
        DESC(TEMPLATE).fOptState |= OPTST_SET; \
        DESC(TEMPLATE).optArg.argString = (a) )
#define VALUE_OPT_AGARG          0x1010
#define VALUE_OPT_BASE_NAME      0x1011

/** option value for version option */
#define VALUE_OPT_VERSION          0x1012
/** option value for help option */
#define VALUE_OPT_HELP             0x1013
/** option value for more_help option */
#define VALUE_OPT_MORE_HELP        0x1014
/** option value for save_opts option */
#define VALUE_OPT_SAVE_OPTS        0x1015
/** option value for load_opts option */
#define VALUE_OPT_LOAD_OPTS        0x1016
#define SET_OPT_SAVE_OPTS(a)   STMTS( \
        DESC(SAVE_OPTS).fOptState &= OPTST_PERSISTENT_MASK; \
        DESC(SAVE_OPTS).fOptState |= OPTST_SET; \
        DESC(SAVE_OPTS).optArg.argString = (char const*)(a))
/*
 *  Interface defines not associated with particular options
 */
#define ERRSKIP_OPTERR  STMTS(getdefsOptions.fOptSet &= ~OPTPROC_ERRSTOP)
#define ERRSTOP_OPTERR  STMTS(getdefsOptions.fOptSet |= OPTPROC_ERRSTOP)
#define RESTART_OPT(n)  STMTS( \
                getdefsOptions.curOptIdx = (n); \
                getdefsOptions.pzCurOpt  = NULL )
#define START_OPT       RESTART_OPT(1)
#define USAGE(c)        (*getdefsOptions.pUsageProc)(&getdefsOptions, c)

#ifdef  __cplusplus
extern "C" {
#endif


/* * * * * *
 *
 *  Declare the getdefs option descriptor.
 */
extern tOptions getdefsOptions;
# define OPT_NO_XLAT_CFG_NAMES
# define OPT_NO_XLAT_OPT_NAMES

# define OPT_XLAT_CFG_NAMES
# define OPT_XLAT_OPT_NAMES

# ifndef _
#   define _(_s)  _s
# endif


noreturn extern void
vdie( int exit_code, char const * fmt, va_list);
noreturn extern void
die(  int exit_code, char const * fmt, ...);
noreturn extern void
fserr(int exit_code, char const * op, char const * fn);

/**
 * Print a GETDEFS_EXIT_NO_MEM fatal error message and die.
 *
 * @param[in] sz     the object size that was not allocated
 * @param[in] what   what that object was going to be
 * @noreturn
 */
noreturn static inline void nomem_err(size_t sz, char const * what)
{
    char const * fmt = _("could not allocate %zu bytes for %s\n");
    die(GETDEFS_EXIT_NO_MEM, fmt, sz, what);
}
#ifdef  __cplusplus
}
#endif
#endif /* AUTOOPTS_OPTS_H_GUARD */

/** @} */
/* opts.h ends here */
