
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;;
;; make-apidoc-module.scm   (derived from build-glue.scm)
;; DESCRIPTION : generates the (texmacs-module (prog glue-symbols))
;;               which provides the scheme API symbols defined in glue
;;               for autocompletion, apidoc...
;; COPYRIGHT   : (C) 2016 the TeXmacs team
;;
;; This software falls under the GNU general public license version 3 or later.
;; It comes WITHOUT ANY WARRANTY WHATSOEVER. For details, see the file LICENSE
;; in the root directory or <http://www.gnu.org/licenses/gpl-3.0.html>.
;;
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;

(define glue-defs '("build-glue-basic.scm" "build-glue-server.scm" "build-glue-editor.scm"))

;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;; Convenient output routine
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;


(define output-sub
  (lambda (l)
    (if (not (null? l))
	(begin
	  (display (car l))
	  (output-sub (cdr l))))))

(define output
  (lambda l
    (output-sub l)))


(define (output-copyright from)
  noop)


;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;; Main build routines
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;

(define (build-routine l) ;; what exactly do we want to document?
  (let ((name (car l))
	(croutine (cadr l))
	(ret-type (caaddr l))
	(arg-type (cdaddr l)))
;;    (output "(" name " " croutine " " ret-type "  " arg-type ")\n")))
;; (output l "\n")) ;; everything
    (output "\"" name "\"\n")))

(define build-routines
  (lambda (l)
    (if (not (null? l))
	(begin
	  (build-routine (car l))
	  (build-routines (cdr l))))))


(define (build-main l)
   (build-routines (cddr l)))

(define-macro build
  (lambda l (build-main l)))


(begin
  (output "
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;;
;; MODULE      : glue-symbols.scm
;; DESCRIPTION : lists scheme symbols defined in glue 
;;               (for use in autocompletion & apidoc)
;; COPYRIGHT   : (C) 2016 the TeXmacs team
;;
;; This software falls under the GNU general public license version 3 or later.
;; It comes WITHOUT ANY WARRANTY WHATSOEVER. For details, see the file LICENSE
;; in the root directory or <http://www.gnu.org/licenses/gpl-3.0.html>.
;;
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;; 
;;        YOU SHOULD DO NOT EDIT THIS FILE
;;
;; This file was generated automatically by
;; /src/src/Scheme/Glue/build-glue/make-apidoc-module.scm
;; from the glue functions defined in
;; /src/src/Scheme/Glue/build-glue/build-glue-(basic|server|editor).scm
;;
;; It is updated automatically when running the script 
;; /src/src/Scheme/Glue/build-glue
;;
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;

")
  (output "(texmacs-module (prog glue-symbols))\n\n")
  (output "(tm-define (all-glued-symbols) '( \n")
  (map load glue-defs)
  (output "))\n")
)


