%%
%% This is file `cjs-rcs-article.cls',
%% generated with the docstrip utility.
%%
%% The original source files were:
%%
%% cjs-rcs-article.dtx  (with options: `class')
%% 
%% This is a generated file.
%% 
%% Copyright (C) 2023 Statistical Society of Canada | Société
%% canadienne de statistique
%% 
%% This file may be distributed and/or modified under the conditions
%% of the LaTeX Project Public License, either version 1.3c of this
%% license or (at your option) any later version. The latest version
%% of this license is in:
%% 
%%   https://www.latex-project.org/lppl.txt
%% 
%% and version 1.3c or later is part of all distributions of LaTeX
%% version 2006/05/20 or later.
%% 
%% This work has the LPPL maintenance status `maintained'.
%% 
%% The Current Maintainer of this work is Vincent Goulet
%% <vincent.goulet@act.ulaval.ca>.
%% 
%% This work consists of the file cjs-rcs-article.dtx and the derived
%% files cjs-rcs-article.cls, cjs-rcs-article-fr.tex, cjs-template.tex
%% and rcs-gabarit.tex.
%% 
\NeedsTeXFormat{LaTeX2e}[2009/09/24]
\ProvidesClass{cjs-rcs-article}%
  [2023/11/29 v1.0 Article class for The Canadian Journal of
  Statistics | La revue canadienne de statistique]
\newif\ifCJS@review        \CJS@reviewfalse        % review version?
\newif\ifCJS@supplement    \CJS@supplementfalse    % supplementary material?
\newif\ifCJS@nocjs         \CJS@nocjsfalse         % not a CJS article?
\newif\ifCJS@final         \CJS@finalfalse         % final version?
\newif\ifCJS@titlingfooter \CJS@titlingfooterfalse % footer on title page?
\newif\ifCJS@journalinfo   \CJS@journalinfotrue    % display journal info?
\newif\ifCJS@fancybreak    \CJS@fancybreaktrue     % display fancy break?
\newif\ifCJS@history       \CJS@historyfalse       % history present?
\newif\ifCJS@corrauth      \CJS@corrauthfalse      % corresponding author?
\newif\ifCJS@newauth       \CJS@newauthtrue        % internal; author blocks
\DeclareOption{review}{%
  \CJS@reviewtrue
  \CJS@titlingfootertrue}
\DeclareOption{supplement}{%
  \CJS@supplementtrue
  \CJS@titlingfootertrue}
\DeclareOption{nocjs}{%
  \CJS@nocjstrue
  \CJS@titlingfootertrue
  \CJS@journalinfofalse}
\DeclareOption{final}{%
  \CJS@finaltrue
  \CJS@reviewfalse}
\DeclareOption*{\PassOptionsToClass{\CurrentOption}{memoir}}
\ProcessOptions\relax
\LoadClass[letterpaper,10pt,article,twoside]{memoir}
\RequirePackage{iflang}
\RequirePackage[round,semicolon,authoryear,sectionbib]{natbib}
\RequirePackage{babel}
\RequirePackage[autolanguage]{numprint}
\AtEndPreamble{%
  \RequirePackage{bookmark}     % loads hyperref
  \hypersetup{%
    colorlinks = true,
    urlcolor = {CJSurl},
    linkcolor = {CJSlink},
    citecolor = {CJScitation}}
  \bookmarksetup{%
    open = true,
    depth = 3,
    numbered = true}
  \addto\extrasenglish{%
    \def\sectionautorefname{Section}%
    \def\subsectionautorefname{Section}%
    \def\subsubsectionautorefname{Section}%
    \def\figureautorefname{Figure}%
    \def\tableautorefname{Table}%
    \def\theoremautorefname{Theorem}%
    \def\lemmaautorefname{Lemma}%
    \def\propositionautorefname{Proposition}%
    \def\corollaryautorefname{Corollary}%
    \def\definitionautorefname{Definition}%
    \def\algorithmautorefname{Algorithm}%
    \def\remarkautorefname{Remark}}
  \addto\extrasfrench{%
    \def\sectionautorefname{section}%
    \def\subsectionautorefname{section}%
    \def\subsubsectionautorefname{section}%
    \def\figureautorefname{figure}%
    \def\tableautorefname{tableau}%
    \def\theoremautorefname{théorème}%
    \def\lemmaautorefname{lemme}%
    \def\propositionautorefname{proposition}%
    \def\corollaryautorefname{corollaire}%
    \def\definitionautorefname{définition}%
    \def\algorithmautorefname{algorithme}%
    \def\remarkautorefname{remarque}}}
\RequirePackage{keyval}
\RequirePackage[shortlabels]{enumitem}
\RequirePackage{environ}
\RequirePackage[useregional,french,en-GB]{datetime2}
\RequirePackage{xcolor}
\RequirePackage{paracol}
\RequirePackage{ragged2e}
\RequirePackage{url}
\RequirePackage{relsize}
\RequirePackage{fontawesome5}
\RequirePackage{graphicx}
\RequirePackage{amsmath}
\RequirePackage{amsthm}
\ifCJS@review
  \RequirePackage{lineno}
  \linenumbers
\fi
\AtBeginDocument{%
  \@ifpackageloaded{geometry}{%
    \ClassError{cjs-rcs-article}%
      {Package geometry is incompatible with this class}%
      {You should not change the page layout.\MessageBreak%
       If absolutely needed, use the memoir class facilities.}}{\relax}}
\iftutex
  \RequirePackage[babel=true]{microtype}
  \RequirePackage{fontspec}
  \RequirePackage{unicode-math}
  \setmainfont{STIXTwoText}
  [
    Extension = .otf,
    UprightFont = *-Regular,
    BoldFont = *-SemiBold,
    ItalicFont = *-Italic,
    BoldItalicFont = *-SemiBoldItalic,
    Scale = 1,
    Ligatures = TeX
  ]
  \setmathfont{STIXTwoMath-Regular}
  [
    Extension = .otf,
    Scale = 1,
    Ligatures = TeX
  ]
  \setmathfont{FiraMath-Regular}
  [
    version = titles,
    Extension = .otf,
    Scale = 0.92
  ]
\else
  \RequirePackage[babel=true]{microtype}
  \RequirePackage[utf8]{inputenc}
  \RequirePackage[T1]{fontenc}
  \RequirePackage{stix2}
\fi
\RequirePackage[book,medium,proportional,lining,scale=0.92]{FiraSans}
\RequirePackage[medium,lining,scale=0.90]{FiraMono}
\ifCJS@review
  \renewcommand*\linenumberfont{\normalfont\firalining\tiny}
  \setlength\linenumbersep{5pt}
\fi
\definecolor{CJSpink}{HTML}{E3038B}
\definecolor{CJSred}{HTML}{D10000}
\definecolor{CJSyellow}{HTML}{FEC70D}
\definecolor{CJSlink}{rgb}{0,0.4,0.6}   % internal links
\definecolor{CJSurl}{rgb}{0.6,0,0}      % external links
\definecolor{CJScitation}{rgb}{0,0.5,0} % citations
\definecolor{CJSorcid}{HTML}{A6CE39}
\setlrmarginsandblock{24mm}{30mm}{*}
\setulmarginsandblock{24mm}{26mm}{*}
\setheadfoot{13.5pt}{9mm}
\checkandfixthelayout[nearest]
\def\CJS@journalname@en{The Canadian Journal of Statistics}
\def\CJS@journalname@fr{La revue canadienne de statistique}
\def\CJS@journalname{\CJS@journalname@en~{\textbar}~\CJS@journalname@fr}
\setbox\z@=\vbox{\sffamily\hbox{\CJS@journalname}\hbox{\bfseries V,}}
\newsavebox\CJS@journalornament
\setbox\CJS@journalornament=\vbox{%
  \setbox\tw@\hbox{\vrule \@width4pt\@height\ht\z@\@depth\dp\z@}
  \hbox{\textcolor{CJSpink}{\copy\tw@}\kern2pt%
        \textcolor{CJSred}{\copy\tw@}\kern2pt%
        \textcolor{CJSyellow}{\copy\tw@}\kern6pt}}
\newcommand*\makejournalinfo{%
  \mbox{%
    \box\CJS@journalornament
    \vbox{%
      \sffamily
      \hbox{\CJS@journalname}
      \hbox{\bfseries Vol.~\CJS@vol, %
                      No.~\CJS@issue, %
                      \CJS@year, %
                      \CJS@firstpage--\thelastpage}}}}
\newcommand*\CJS@setheadfootfont{%
  \firalining\fontsize{9}{13}\selectfont}
\newlength\CJS@headdivheight
\settoheight\CJS@headdivheight{\CJS@setheadfootfont 1}
\setlength\CJS@headdivheight{0.9\CJS@headdivheight}
\newcommand*\CJS@headdivrule{%
  \rule[0.05\CJS@headdivheight]{0.75\normalrulethickness}{\CJS@headdivheight}}
\newlength\CJS@pagenumwidth
\settowidth\CJS@pagenumwidth{9\qquad}
\makepagestyle{cjs}
\makeevenhead{cjs}{%
  \CJS@setheadfootfont
  \begin{tabular*}{\textwidth}%
    {@{}p{\CJS@pagenumwidth}@{\CJS@headdivrule\qquad}l@{\extracolsep\fill}}
    \thepage & \ifCJS@review\else\MakeTextUppercase{\CJS@runningauthor}\fi \\ \hline
  \end{tabular*}}{}{}
\makeoddhead{cjs}{}{}{%
  \CJS@setheadfootfont
  \begin{tabular*}{\textwidth}%
    {l@{\extracolsep\fill}r@{\extracolsep{0pt}\qquad\CJS@headdivrule}p{\CJS@pagenumwidth}@{}}
    & \MakeTextUppercase{\CJS@shorttitle} & \hfill\thepage \\ \hline
  \end{tabular*}}
\makeevenfoot{cjs}{}{}{} \makeoddfoot{cjs}{}{}{}
\pagestyle{cjs}
\makepagestyle{cjsfirstpage}
\makeevenhead{cjsfirstpage}{}{}{} \makeoddhead{cjsfirstpage}{}{}{}
\ifCJS@titlingfooter
  \makeevenfoot{cjsfirstpage}{%
    \CJS@setheadfootfont
    \begin{tabular*}{\textwidth}%
      {@{}p{\CJS@pagenumwidth}@{\CJS@headdivrule\qquad}l@{\extracolsep\fill}}
      \hline \thepage &
      \ifCJS@nocjs\CJS@licence\fi
    \end{tabular*}}{}{}
  \makeoddfoot{cjsfirstpage}{}{}{%
    \CJS@setheadfootfont
    \begin{tabular*}{\textwidth}%
      {l@{\extracolsep\fill}r@{\extracolsep{0pt}\qquad\CJS@headdivrule}p{\CJS@pagenumwidth}@{}}
      \hline &
      \ifCJS@nocjs\CJS@licence\fi &
      \hfill\thepage
    \end{tabular*}}
\fi
\let\chapter\relax
\counterwithout{section}{chapter}
\setsecnumdepth{subsubsection}
\maxsecnumdepth{subsubsection}
\iftutex
  \setsecheadstyle{\normalfont\Large\sffamily\mathversion{titles}\bfseries\raggedright}
  \setsubsecheadstyle{\normalfont\large\sffamily\mathversion{titles}\bfseries\raggedright}
  \setsubsubsecheadstyle{\normalfont\sffamily\mathversion{titles}\bfseries\raggedright}
  \setparaheadstyle{\normalfont\sffamily\mathversion{titles}\bfseries}
  \setsubparaheadstyle{\normalfont\mathversion{titles}\bfseries}
\else
  \setsecheadstyle{\normalfont\Large\sffamily\bfseries\raggedright}
  \setsubsecheadstyle{\normalfont\large\sffamily\bfseries\raggedright}
  \setsubsubsecheadstyle{\normalfont\sffamily\bfseries\raggedright}
  \setparaheadstyle{\normalfont\sffamily\bfseries}
  \setsubparaheadstyle{\normalfont\bfseries}
\fi
\setbeforesecskip{-1.75ex plus -0.5ex minus -0.1ex}
\setaftersecskip{1.2ex plus 0.1ex}
\setbeforesubsecskip{-1.5ex plus -0.5ex minus -0.1ex}
\setaftersubsecskip{0.75ex plus 0.1ex}
\setbeforesubsubsecskip{-1.5ex plus -0.5ex minus -0.1ex}
\setaftersubsubsecskip{0.75ex plus 0.1ex}
\setbeforeparaskip{0pt}
\setafterparaskip{-0.5em}
\setbeforesubparaskip{0pt}
\setaftersubparaskip{-0.25em}
\ifCJS@review
  \OnehalfSpacing
\fi
\captionnamefont{\bfseries}
\frenchsetup{%
  SmallCapsFigTabCaptions=false,
  ThinSpaceInFrenchNumbers=true,
  og=«, fg=»}
\renewcommand*\frenchtablename{Tableau}
\renewcommand*\frenchfigurename{Figure}
\newlength\journalinfoskip
\setlength\journalinfoskip{-4ex}
\newlength\maintitleskip
\setlength\maintitleskip{6ex}
\newlength\supptitleskip
\setlength\supptitleskip{2ex}
\newlength\authorskip
\setlength\authorskip{5ex}
\newlength\titlingskip
\setlength\titlingskip{2pt plus2pt minus0.8pt}
\newlength\fancybreaksep
\setlength\fancybreaksep{6pt plus3pt minus1pt}
\def\CJS@supptitlename@en{supplementary material for the article}
\def\CJS@supptitlename@fr{matériel additionnel pour l'article}
\newcommand*\supplementfont{\normalfont\Large\scshape}
\newcommand*\maintitlefont{\raggedright\normalfont\huge\bfseries}
\renewcommand*\title[2][]{\gdef\CJS@shorttitle{#1}\gdef\@title{#2}}
\edef\title{\@nx\@dblarg
  \@xp\@nx\csname\string\title\endcsname}
\newcommand*\authfont{\normalfont\sffamily\bfseries\color{black}}
\newcommand*\affilfont{\normalfont\sffamily\color{gray}}
\newlength\affilsep \setlength\affilsep{\z@}
\newlength\authsep  \setlength\authsep{1ex}
\define@key{author}{orcid}{\def\CJS@orcid{#1}}
\define@key{author}{email}{\def\CJS@email{#1}}
\define@key{author}{corresponding}[true]{%
  \csname if#1\endcsname \CJS@corrauthtrue\fi}
\def\CJS@corrauthname@en{Corresponding author}
\def\CJS@corrauthname@fr{Auteur correspondant}
\newcommand*\CJS@corrauth{}
\newcommand*\CJS@orcidlist{}
\newcommand*\CJS@orcidname{ORCID}
\newcommand*\CJS@authsep{, }
\newcommand*\CJS@orcid@and{}
\newcommand*\CJS@blk@and{\protect\authfont}
\newcommand*\CJS@pand{\protect\\[\authsep] \protect\authfont}
\renewcommand\author{%
  \new@ifnextchar[{\author@}%
                  {\author@[]}}
\newcommand*\author@{}
\def\author@[#1]#2{%
  \begingroup
    \setkeys{author}{#1}
    \let\protect\@unexpandable@protect
    \ifCJS@newauth
      \xappto\@author{\CJS@blk@and#2}
    \else
      \xappto\@author{\CJS@authsep#2}
    \fi
    \ifCJS@corrauth
      \ifundef{\CJS@email}{\relax}{%
        \protected@xdef\CJS@corrauth{\protect\url{\CJS@email}}
        \xappto\@author{\;%
          \protect\href{mailto:\CJS@email}{\corrauthmark}}}
    \fi
    \ifundef{\CJS@orcid}{\relax}{%
      \xappto\@author{\;%
        \protect\href{https://orcid.org/\CJS@orcid}%
                     {\textcolor{CJSorcid}{\faOrcid}}}
      \xappto\CJS@orcidlist{\CJS@orcid@and#2: %
        \protect\href{https://orcid.org/\CJS@orcid}%
                     {\textcolor{CJSorcid}{\faOrcid}\, \protect\url{https://orcid.org/\CJS@orcid}}}
      \gdef\CJS@orcid@and{\protect\\}}
  \endgroup
  \CJS@newauthfalse
}
\newcommand*\affil[1]{%
  \CJS@newauthtrue
  \let\CJS@blk@and\CJS@pand
  \begingroup
    \let\protect\@unexpandable@protect
    \gappto\@author{\protect\\[\affilsep]\protect\affilfont #1}
  \endgroup
}
\newcommand*\CJS@runningauthor{}
\newcommand*\CJS@printsurname[1]{\MakeTextUppercase{#1}}
\newrobustcmd{\surname}[1]{%
  \ifdefempty{\CJS@runningauthor}{%
    \def\CJS@runningauthor@{#1}%
    \edef\CJS@runningauthor@and{\iflanguage{french}{ et }{ and }}%
    \gappto\CJS@runningauthor{#1}}{%
      \ifdefvoid{\CJS@runningauthor@and}{\relax}{%
        \global\let\CJS@runningauthor\CJS@runningauthor@
        \appto\CJS@runningauthor@{, #1}%
        \xappto\CJS@runningauthor{\CJS@runningauthor@and#1}%
        \edef\CJS@runningauthor@and{\iflanguage{french}{ et }{, and }}}}%
  \CJS@printsurname{#1}%
}
\newcommand*\corrauthmark{{\small\faAt}}
\newcommand*\runningauthor[1]{\renewcommand*\CJS@runningauthor{#1}}
\def\@author{}
\def\CJS@englishabstract{}
\def\CJS@frenchabstract{}
\NewEnviron{englishabstract}{\global\let\CJS@englishabstract\BODY}
\NewEnviron{frenchabstract}{\global\let\CJS@frenchabstract\BODY}
\def\CJS@keywords{}
\def\CJS@keywordsname@en{Keywords}
\def\CJS@keywordsname@fr{Mots-clés}
\NewEnviron{keywords}{\global\let\CJS@keywords\BODY}
\newlist{CJS@keywordslist}{itemize*}{1}
\setlist[CJS@keywordslist]{%
  mode=unboxed,
  label={},
  afterlabel={},
  itemjoin={{; }},
  after={.}
}
\def\CJS@classif{}
\def\CJS@classifname{}
\def\CJS@defclassifname{MSC2020}
\NewEnviron{classification}[1][%
  \CJS@defclassifname]{%
  \global\def\CJS@classifname{#1}
  \global\let\CJS@classif\BODY}
\newlist{CJS@classiflist}{itemize*}{1}
\setlist[CJS@classiflist]{%
  mode=unboxed,
  itemjoin={{; }},
  after={.}
}
\renewcommand\pfbreakdisplay{%
  \vskip\fancybreaksep\par%
  \rule[\z@]{\linewidth}{\normalrulethickness}\hskip-\linewidth
  \rule[4\normalrulethickness]{\linewidth}{\normalrulethickness}\hskip-\linewidth
  \rule[8\normalrulethickness]{\linewidth}{\normalrulethickness}\par%
  \vskip\fancybreaksep}
\newcommand*\suppressfancybreak{\CJS@fancybreakfalse}
\newcommand*\showfancybreak{\CJS@fancybreaktrue}
\renewcommand\maketitle{{%
  \SingleSpacing
  \suppressfloats[t]
  \setlength\parskip{\z@}
  \setlength\parindent{\z@}
  \setcounter{page}{\CJS@firstpage}
  \thispagestyle{cjsfirstpage}
  \ifCJS@journalinfo
    \vspace*{\journalinfoskip}
    \makejournalinfo\par
  \fi
  \vspace*{\maintitleskip}
  \setbox\z@=\vbox{\supplementfont%
    \iflanguage{french}{\CJS@supptitlename@fr}{\CJS@supptitlename@en}}
  \ifCJS@supplement
    \box\z@\par
  \else
    \rule{\z@}{\dimexpr\ht\z@}\par % strut
  \fi
  \vskip\supptitleskip
  \begin{minipage}{0.9\textwidth}
    \maintitlefont\@title\par
  \end{minipage}
  \vskip\authorskip
  \ifCJS@review\else
    \hrulefill
    \vskip\belowrulesep
    \begin{minipage}{0.9\textwidth}
      \@author
    \end{minipage}\par
    \vskip\aboverulesep
    \hrulefill\par
  \fi
  \ifCJS@supplement\else
    \vskip2\titlingskip
    \begin{paracol}{2}
      \RaggedRight
      \switchcolumn[\iflanguage{english}{0}{1}]
      \begingroup
        \selectlanguage{english}\paragraph{\abstractname}\CJS@englishabstract
      \endgroup
      \switchcolumn[\iflanguage{french}{0}{1}]
      \begingroup
        \selectlanguage{french}\paragraph{\abstractname}\CJS@frenchabstract
      \endgroup
    \end{paracol}\par
    \begingroup
      \sloppy\RaggedRight
      \ifdefempty{\CJS@keywords}{\relax}{%
        \vskip\titlingskip
        \paragraph{\iflanguage{french}{\CJS@keywordsname@fr}{\CJS@keywordsname@en}}
        \begin{CJS@keywordslist}
          \CJS@keywords
        \end{CJS@keywordslist}\par}
      \vskip\titlingskip
      \paragraph{{\CJS@classifname}}
      \ifdefempty{\CJS@classif}{\mbox{}}{%
        \begin{CJS@classiflist}
          \CJS@classif
        \end{CJS@classiflist}}\par
    \endgroup
  \fi
  \unless\ifCJS@review
    \ifdefempty{\CJS@corrauth}{\relax}{%
      \vskip\titlingskip
      \paragraph{\corrauthmark\;%
        \iflanguage{french}{\CJS@corrauthname@fr}{\CJS@corrauthname@en}}
      \CJS@corrauth\par}
  \fi
  \ifCJS@fancybreak
    \fancybreak{\pfbreakdisplay}
  \fi
  \unless\ifCJS@titlingfooter
    \CJS@measurelicence
    \setlength\textfloatsep{0pt}
    \def\CJS@notice{%
      \iflanguage{french}{Futur emplacement de la déclaration de licence.}%
                         {Licence statement to appear here.}}
    \begin{figure}[!b]
      \raisebox{0pt}[0pt][\footskip]{%
        \vbox{%
          \CJS@setlicencefont
          \rule{\textwidth}{\normalrulethickness}
          \parbox[t][\CJS@licenceht][t]{\textwidth}{%
            \ifCJS@final\CJS@licence \else\textit\CJS@notice \fi}}}
    \end{figure}
  \fi
}}
\def\CJS@supplement{}
\def\CJS@supplementname@en{Supplementary material}
\def\CJS@supplementname@fr{Matériel additionnel}
\NewEnviron{supplement}{\global\let\CJS@supplement\BODY}
\def\CJS@sharing{}
\def\CJS@sharingname@en{Data sharing}
\def\CJS@sharingname@fr{Partage des données}
\NewEnviron{sharing}{\global\let\CJS@sharing\BODY}
\def\CJS@ack{}
\def\CJS@ackname@en{Acknowledgements}
\def\CJS@ackname@fr{Remerciements}
\NewEnviron{acknowledgements}{\global\let\CJS@ack\BODY}
\let\acknowledgments\acknowledgements
\let\endacknowledgments\endacknowledgements
\def\CJS@funding{}
\def\CJS@fundingname{}
\def\CJS@fundingname@en{Funding information}
\def\CJS@fundingname@fr{Financement}
\NewEnviron{funding}[1][%
  \iflanguage{french}{\CJS@fundingname@fr}{\CJS@fundingname@en}]{%
    \global\def\CJS@fundingname{#1}
    \global\let\CJS@funding\BODY}
\newcommand\makebackmatter{%
  \ifCJS@supplement\else
    \ifdefempty{\CJS@supplement}{\relax}{%
      \section*{\iflanguage{french}{\CJS@supplementname@fr}{\CJS@supplementname@en}}
      \CJS@supplement}
    \ifdefempty{\CJS@sharing}{\relax}{%
      \section*{\iflanguage{french}{\CJS@sharingname@fr}{\CJS@sharingname@en}}
      \CJS@sharing}
    \ifCJS@review\else
      \ifdefempty{\CJS@ack}{\relax}{%
        \section*{\iflanguage{french}{\CJS@ackname@fr}{\CJS@ackname@en}}
        \CJS@ack}
      \ifdefempty{\CJS@funding}{\relax}{%
        \section*{\CJS@fundingname}
        \CJS@funding}
      \ifdefempty{\CJS@orcidlist}{\relax}{%
        \section*{\CJS@orcidname}
        \begingroup
          \let\surname\relax
          \let\corrauth\@gobble
          \CJS@orcidlist
        \endgroup}
    \fi
  \fi}
\newcommand*\CJS@setlicencefont{%
  \firalining\fontsize{8pt}{9pt}\selectfont}
\newlength\CJS@licenceht
\newcommand\CJS@licencesample{%
  {\ccbyncnd*} 2023 The Authors. The Canadian Journal of
  Statistics~{\textbar}~La revue canadienne de statistique published
  by Wiley Periodicals LLC on behalf of Statistical Society of
  Canada~{\textbar}~Société statistique du Canada. This is an open
  access article under the terms of the Creative Commons
  Attribution-NonCommercial-NoDerivs License, which permits use and
  distribution in any medium, provided the original work is properly
  cited, the use is non-commercial and no modifications or adaptations
  are made.}
\newsavebox\CJS@licencebox
\newcommand\CJS@measurelicence{%
  \setbox\CJS@licencebox=\vbox{%
    \CJS@setlicencefont
    \ifdefempty{\CJS@licence}{\CJS@licencesample}{\CJS@licence}}
  \setlength\CJS@licenceht{\dimexpr\ht\CJS@licencebox+\dp\CJS@licencebox}}
\def\CJS@licence{}
\newcommand\licence[1]{\renewcommand*\CJS@licence{#1}}
\let\license\licence
\newcommand*\ccby{\ccby@\@ifstar{~\faCopyright[regular]}\relax}
\newcommand*\ccby@{\mbox{%
    \faCreativeCommons\kern0.1em%
    \faCreativeCommonsBy\kern0.1em}}
\newcommand*\ccbysa{\ccbysa@\@ifstar{~\faCopyright[regular]}\relax}
\newcommand*\ccbysa@{\mbox{%
    \faCreativeCommons\kern0.1em%
    \faCreativeCommonsBy\kern0.1em%
    \faCreativeCommonsSa}}
\newcommand*\ccbync{\ccbync@\@ifstar{~\faCopyright[regular]}\relax}
\newcommand*\ccbync@{\mbox{%
    \faCreativeCommons\kern0.1em%
    \faCreativeCommonsBy\kern0.1em%
    \faCreativeCommonsNc}}
\newcommand*\ccbyncsa{\ccbyncsa@\@ifstar{~\faCopyright[regular]}\relax}
\newcommand*\ccbyncsa@{\mbox{%
    \faCreativeCommons\kern0.1em%
    \faCreativeCommonsBy\kern0.1em%
    \faCreativeCommonsNc\kern0.1em%
    \faCreativeCommonsSa}}
\newcommand*\ccbynd{\ccbynd@\@ifstar{~\faCopyright[regular]}\relax}
\newcommand*\ccbynd@{\mbox{%
    \faCreativeCommons\kern0.1em%
    \faCreativeCommonsBy\kern0.1em%
    \faCreativeCommonsNd}}
\newcommand*\ccbyncnd{\ccbyncnd@\@ifstar{~\faCopyright[regular]}\relax}
\newcommand*\ccbyncnd@{\mbox{%
    \faCreativeCommons\kern0.1em%
    \faCreativeCommonsBy\kern0.1em%
    \faCreativeCommonsNc\kern0.1em%
    \faCreativeCommonsNd}}
\let\Pr\relax
\DeclareMathOperator{\Pr}{P}
\DeclareMathOperator{\E}{E}
\DeclareMathOperator{\Var}{var}
\DeclareMathOperator{\Cov}{cov}
\DeclareMathOperator{\corr}{corr}
\iftutex
  \let\prdist\symcal
\else
  \let\prdist\mathcal
\fi
\iftutex
  \newcommand*\mat[1]{\symbf{#1}}
  \newcommand*\trsp{^{\mkern-1.5mu\symsfup{T}}}
\else
  \newcommand*\mat[1]{\mathbf{#1}}
  \newcommand*\trsp{^{\mkern-1.5mu\mathsf{T}}}
\fi
\DeclareMathOperator{\tr}{tr}
\DeclareMathOperator{\diag}{diag}
\iftutex
  \newcommand*\Nset{\symbb{N}}
  \newcommand*\Zset{\symbb{Z}}
  \newcommand*\Qset{\symbb{Q}}
  \newcommand*\Rset{\symbb{R}}
  \newcommand*\Cset{\symbb{C}}
\else
  \newcommand*\Nset{\mathbb{N}}
  \newcommand*\Zset{\mathbb{Z}}
  \newcommand*\Qset{\mathbb{Q}}
  \newcommand*\Rset{\mathbb{R}}
  \newcommand*\Cset{\mathbb{C}}
\fi
\def\CJS@theoremname@en{Theorem}
\def\CJS@theoremname@fr{Théorème}
\def\CJS@lemmaname@en{Lemma}
\def\CJS@lemmaname@fr{Lemme}
\def\CJS@propositionname@en{Proposition}
\def\CJS@propositionname@fr{Proposition}
\def\CJS@corollaryname@en{Corollary}
\def\CJS@corollaryname@fr{Corollaire}
\def\CJS@definitionname@en{Definition}
\def\CJS@definitionname@fr{Définition}
\def\CJS@algorithmname@en{Algorithm}
\def\CJS@algorithmname@fr{Algorithme}
\def\CJS@remarkname@en{Remark}
\def\CJS@remarkname@fr{Remarque}
\theoremstyle{plain}
\newtheorem{theorem}{\iflanguage{french}{\CJS@theoremname@fr}{\CJS@theoremname@en}}
\newtheorem{lemma}{\iflanguage{french}{\CJS@lemmaname@fr}{\CJS@lemmaname@en}}
\newtheorem{proposition}{\iflanguage{french}{\CJS@propositionname@fr}{\CJS@propositionname@en}}
\newtheorem{corollary}{\iflanguage{french}{\CJS@corollaryname@fr}{\CJS@corollaryname@en}}
\theoremstyle{definition}
\newtheorem{definition}{\iflanguage{french}{\CJS@definitionname@fr}{\CJS@definitionname@en}}
\newtheorem{algorithm}{\iflanguage{french}{\CJS@algorithmname@fr}{\CJS@algorithmname@en}}
\theoremstyle{remark}
\newtheorem{remark}{\iflanguage{french}{\CJS@remarkname@fr}{\CJS@remarkname@en}}
\renewcommand*\eqref[1]{\hyperref[{#1}]{\textup{(\ref*{#1})}}}
\newcommand*\proglang[1]{{\hyphenchar\font=-1 #1}}
\newcommand*\Rlang{\proglang{R}}
\newcommand*\SASlang{\proglang{SAS}}
\newcommand*\SPSSlang{\proglang{SPSS}}
\newcommand*\Statalang{\proglang{Stata}}
\newcommand*\Pylang{\proglang{Python}}
\newcommand*\Julialang{\proglang{Julia}}
\newcommand*\Clang{\proglang{C}}
\newcommand*\CJS@plus{%
  \ifx\f@family\sfdefault%
    \protect\hspace{-.04em}\protect\raisebox{-.125ex}{\larger+}%
  \else%
    \protect\hspace{-.03em}\protect\raisebox{.25ex}{\smaller+}%
  \fi}
\newcommand*\Cpplang{\proglang{C\CJS@plus\CJS@plus}}
\let\pkg\textbf
\newcommand\code{\bgroup\@makeother\_\@makeother\~\@makeother\$\code@}
\def\code@#1{{\normalfont\ttfamily\hyphenchar\font=-1 #1}\egroup}
\renewcommand*\appendix{\par
  \setcounter{section}{0}
  \gdef\thesection{\@Alph\c@section}}
\renewcommand{\@memb@bsec}{\section*{\bibname}\prebibhook}
\setlocalecaption{english}{bib}{References}
\setlocalecaption{french}{bib}{Références}
\bibliographystyle{\iflanguage{french}{cjs-rcs-fr}{cjs-rcs-en}}
\setlength{\bibsep}{\itemsep}
\def\CJS@suppprefix{S}          % required for the documentation
\ifCJS@supplement
  \renewcommand*\thesection{\CJS@suppprefix\arabic{section}}
  \renewcommand*\thefigure{\CJS@suppprefix\arabic{figure}}
  \renewcommand*\thetable{\CJS@suppprefix\arabic{table}}
  \renewcommand*\theequation{\CJS@suppprefix\arabic{equation}}
  \renewcommand*\thetheorem{\CJS@suppprefix\arabic{theorem}}
  \renewcommand*\thelemma{\CJS@suppprefix\arabic{lemma}}
  \renewcommand*\theproposition{\CJS@suppprefix\arabic{proposition}}
  \renewcommand*\thecorollary{\CJS@suppprefix\arabic{corollary}}
  \renewcommand*\thedefinition{\CJS@suppprefix\arabic{definition}}
  \renewcommand*\thealgorithm{\CJS@suppprefix\arabic{algorithm}}
  \renewcommand*\theremark{\CJS@suppprefix\arabic{remark}}
\fi
\AtEndDocument{%
  \ifCJS@final
    \ifdefempty{\CJS@vol}{%
      \ClassError{cjs-rcs-article}%
        {Unknown Journal volume}%
        {Use \string\jvol\space to specify the volume.}}{\relax}
    \ifdefempty{\CJS@issue}{%
      \ClassError{cjs-rcs-article}%
        {Unknown Journal issue}%
        {Use \string\jissue\space to specify the issue.}}{\relax}
    \ifdefempty{\CJS@year}{%
      \ClassError{cjs-rcs-article}%
        {Unknown Journal publication year}%
        {Use \string\jyear\space to specify the year.}}{\relax}
    \ifdefstring{\CJS@firstpage}{1}{%
      \ClassWarningNoLine{cjs-rcs-article}%
        {The first page number is not set.\MessageBreak%
         Using the default folio 1}}{\relax}
    \ifCJS@history\else
      \ClassError{cjs-rcs-article}%
        {Unknown article history}%
        {Use \string\received\space and \string\accepted\space to provide the article history.}
    \fi
  \fi}
\def\CJS@vol{}
\def\CJS@issue{}
\def\CJS@year{}
\def\CJS@firstpage{1}
\newcommand*\jvol[1]{\renewcommand*\CJS@vol{#1}}
\newcommand*\jissue[1]{\renewcommand*\CJS@issue{#1}}
\newcommand*\jyear[1]{\renewcommand*\CJS@year{#1}}
\newcommand*\firstpage[1]{\renewcommand*\CJS@firstpage{#1}}
\DTMlangsetup[en-GB]{ord=omit}
\def\CJS@receivedname@en{Received}
\def\CJS@receivedname@fr{Reçu le}
\def\CJS@acceptedname@en{Accepted}
\def\CJS@acceptedname@fr{Accepté le}
\newcommand*\received[1]{\CJS@historytrue\DTMsavedate{received}{#1}}
\newcommand*\accepted[1]{\DTMsavedate{accepted}{#1}}
\newlist{CJS@historylist}{itemize*}{1}
\setlist[CJS@historylist]{%
  mode=unboxed,
  font=\sffamily,
  itemjoin={{ --- }},
  after={}
}
\newcommand*\CJS@history{%
  \small\sffamily%
  \begin{CJS@historylist}
  \item[\iflanguage{french}{\CJS@receivedname@fr}{\CJS@receivedname@en}]
    \DTMusedate{received}%
  \DTMifsaveddate{accepted}{%
  \item[\iflanguage{french}{\CJS@acceptedname@fr}{\CJS@acceptedname@en}]
    \DTMusedate{accepted}}{\relax}%
  \end{CJS@historylist}\par}
\setbox\@ne=\vbox{\hbox{\firaoldstyle\small l4}}
\newsavebox\CJS@historyornament
\setbox\CJS@historyornament=\vbox{%
  \setbox\thr@@\hbox{\vrule \@width1.5pt\@height\ht\@ne\@depth\dp\@ne}
  \hbox{\textcolor{CJSpink}{\copy\thr@@}\kern.75pt%
        \textcolor{CJSred}{\copy\thr@@}\kern.75pt%
        \textcolor{CJSyellow}{\copy\thr@@}\kern3pt}}
\newcommand*\CJS@historybox{
  \par\addvspace{2\baselineskip}\noindent%
  \smash{\box\CJS@historyornament \CJS@history}\par%
  \vspace*{40pt}}
\AtEndDocument{\ifCJS@journalinfo\ifCJS@history\CJS@historybox\fi\fi}
