![The pagelayout LaTeX class](banner.svg)

The pagelayout class enables you to layout pages declaratively using simple macros for pages, covers, grids, templates, text, and graphics to create graphic rich, perfectly typeset, and print ready PDFs.

The integration of [Inkscape](https://inkscape.org) allows your to create box shadows. Text shadows and SVG filters are ideas for future releases.

The integration of [ImageMagick](https://imagemagick.org) allows you to configure compression and sharpening for bitmap graphics to export web, print or preview versions of your document. Parallelized image optimization, caching, and a draft mode enable fast PDF creation and a responsive workflow, even for large documents with lots of photos and graphics.

The pagelayout class also integrates the [TikZ](https://www.ctan.org/pkg/pgf) and [tcolorbox](https://www.ctan.org/pkg/tcolorbox) LaTeX packages.

## Quick Start

### Generic Templates

Generic templates are the easiest way to put content on a page. The template name describes the layout. You can arrange [l]andscape, [p]ortrait, [s]quare, [w]ide, [g]olden ratio, g[o]lden upright ratio or [f]lexible placeholders in rows [-]. A valid template name for example is `sg-ff`. Notice you cannot combine flexible with fixed aspect ratio placeholders within a row.

```latex
\template{ss}{
  \text{
    This text fills the first placeholder.
  }
}
```

![Generic template](quickstart-1.svg)

### Custom Templates

You can use the grid to layout content on a page. The grid has rows with cells. You can set width relations between cells and height relations between rows. You can give cells a explicit aspect ratio by adding a `!`.

```latex
\newtemplate{my template}{
  \setgrid{
    {[2]{3!}{2!}}
  }
  \placeholder{0 0 1 1}
}

\template{my template}{}
```

![Custom template](quickstart-2.svg)

You can set margin and gutter for a single grid, on document level, or on page level.

### Graphics

You can scale and position a graphic. And you can add borders and box shadows to graphics and text frames.

```latex
\newborder{my border}{width=2mm, color=white, radius=5mm}
\newshadow{my shadow}{size=8}

\template[margin=7mm]{s}{
  \graphic[
    scale=1.1,
    hpos=0.2,
    unsharp=3x1,
    shadow=my shadow,
    border=my border,
    border radius=0mm
  ]{kopi}
}
```

![Photo with border and shadow](quickstart-3.svg)

Have a look at the [examples](doc) to learn how to create double pages, covers, and more.

For a complete reference, read the [manual](pagelayout-manual.pdf).

## Installation

In general, you should use the package manager shipped with your TeX distribution to install the pagelayout package.

To install manually, copy the contents of [pagelayout.tds.zip](https://github.com/friedemannbartels/latex-pagelayout/releases/download/v1.0.4/pagelayout.tds.zip) to your local TeX directory tree and run the command `texhash`.

To enable image optimization, shadow creation, and preflight, perform these installation steps:

- Make sure that ImageMagick 7.0 or later and Inkscape 1.0 or later are installed.

- Find your top level _texmf.cnf_ with the command `kpsewhich texmf.cnf`, and add `pagelayoutapi` to the list of `shell_escape_commands`.
  ```
  shell_escape_commands = pagelayoutapi
  ```
- When installing manually, add the directory _scripts/pagelayout_ to your `PATH`.

## Development

Run visual regression tests inside the _tests_ directory with the command `textestvis`.
