###############################################################################
# Name: conftags.py                                                           #
# Purpose: Generate Tags for Confinguration/Ini Files                         #
# Author: Cody Precord <cprecord@editra.org>                                  #
# Copyright: (c) 2008 Cody Precord <staff@editra.org>                         #
# License: wxWindows License                                                  #
###############################################################################

"""
FILE: conftags.py
AUTHOR: Cody Precord
LANGUAGE: Python
SUMMARY:
  Generate a DocStruct object that captures the structure of a Configuration
file in the INI format.

"""

__author__ = "Cody Precord <cprecord@editra.org>"
__svnid__ = "$Id: conftags.py 51872 2008-02-18 07:50:56Z CJP $"
__revision__ = "$Revision: 51872 $"

#--------------------------------------------------------------------------#
# Dependancies
import taglib

#--------------------------------------------------------------------------#

def GenerateTags(buff):
    """Create a DocStruct object that represents a Configuration File
    @param buff: a file like buffer object (StringIO)

    """
    rtags = taglib.DocStruct()
    rtags.SetElementDescription('section', "Sections")
    section = None

    for lnum, line in enumerate(buff):
        line = line.strip()

        # Skip comment and empty lines
        if line.startswith(u"#") or line.startswith(u";") or not line:
            continue

        # Check for a section
        if line.startswith(u"["):
            secend = line.find(u"]")
            if secend != -1:
                section = taglib.Section(line[1:secend], lnum)
                rtags.AddElement('section', section)
            continue # Go to next line

        # Look for keys
        if u"=" in line and section is not None:
            key = taglib.Variable(line.split(u"=")[0], lnum)
            section.AddElement('key', key)

    return rtags

#-----------------------------------------------------------------------------#
# Test
if __name__ == '__main__':
    import sys
    import StringIO
    fhandle = open(sys.argv[1])
    txt = fhandle.read()
    fhandle.close()
    tags = GenerateTags(StringIO.StringIO(txt))
    print "\n\nElements:"
    for element in tags.GetElements():
        print "\n%s:" % element.keys()[0]
        for val in element.values()[0]:
            print "%s [%d]" % (val.GetName(), val.GetLine())
    print "END"
